/*
 * Decompiled with CFR 0.152.
 */
package accuweather;

import accuweather.AccuController;
import accuweather.AccuRMS;
import accuweather.AccuweatherMain;
import accuweather.LocationManager;
import com.emb.handler.StoreManager;
import java.util.Vector;

public class PreferencesManager {
    public void saveDefaultPreferences() {
        try {
            if (!StoreManager.isRSExists("preferences")) {
                Vector<String> vector = new Vector<String>();
                vector.addElement("0");
                vector.addElement("0");
                vector.addElement("0");
                vector.addElement("0");
                vector.addElement("0");
                AccuRMS.saveAllPreferences(vector);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getDefaultStartupSettings() {
        this.saveDefaultPreferences();
        PreferencesManager.loadPreferences();
        PreferencesManager.getPrefParameters();
    }

    public static void loadPreferences() {
        try {
            int[] nArray = null;
            nArray = AccuRMS.getAllPreferences();
            if (nArray != null && nArray.length == 5) {
                AccuController.preferences.tempPref = nArray[0];
                AccuController.preferences.windPref = nArray[1];
                AccuController.preferences.otherPref = nArray[2];
                AccuController.preferences.datePref = nArray[3];
                AccuController.preferences.langPref = nArray[4];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPrefernces(int n, int n2) {
        if (AccuRMS.updatePreference(n, n2)) {
            if (n == 1) {
                AccuController.preferences.tempPref = n2;
            } else if (n == 2) {
                AccuController.preferences.windPref = n2;
            } else if (n == 3) {
                AccuController.preferences.otherPref = n2;
            } else if (n == 4) {
                AccuController.preferences.datePref = n2;
            } else if (n == 5) {
                AccuController.preferences.langPref = n2;
            }
        }
    }

    public static String getPrefParameters() {
        String string = "";
        String string2 = "";
        String string3 = "";
        LocationManager locationManager = new LocationManager();
        locationManager.loadDefaultLocation();
        if (AccuController.preferences.langPref == 0) {
            string2 = AccuController.locations.city;
            string3 = AccuController.locations.country;
        } else if (AccuController.preferences.langPref == 1) {
            string2 = AccuController.locations.city_sp;
            string3 = AccuController.locations.country_sp;
        } else if (AccuController.preferences.langPref == 2) {
            string2 = AccuController.locations.city_de;
            string3 = AccuController.locations.country_de;
        } else if (AccuController.preferences.langPref == 3) {
            string2 = AccuController.locations.city_fr;
            string3 = AccuController.locations.country_fr;
        } else if (AccuController.preferences.langPref == 4) {
            string2 = AccuController.locations.city_it;
            string3 = AccuController.locations.country_it;
        }
        string = string + "&region_code=" + AccuController.locations.region_code + "&city_name=" + string2 + "&country_name=" + string3 + "&lang_id=" + AccuController.preferences.langPref + "&wind_units=" + AccuController.preferences.windPref + "&temp_units=" + AccuController.preferences.tempPref + "&other_units=" + AccuController.preferences.otherPref + "&dtfrmt=" + AccuController.preferences.datePref + "&dev_id=" + AccuweatherMain.DEV_ID + "&accu_xid=" + AccuRMS.getAccuXID() + "&app_ver=" + AccuweatherMain.VERSION_NO + "&app_type=" + AccuweatherMain.APP_TYPE + "&tic_ver=" + AccuRMS.getTickerId() + "&lang_support=" + AccuweatherMain.LANG_SUPPORT_ID + "&3SK=" + AccuweatherMain.SK_CODE + "&";
        return string;
    }
}

