/*
 * Decompiled with CFR 0.152.
 */
package com.emb.widget;

import com.emb.widget.Widget;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Cell
extends Widget {
    static int LAST_TICKER_LOOP = 2;
    static final int TICKER_CHARACTER_STEP = 1;
    public static final int TICKER_PERIOD = 200;
    static final int TICKER_WAIT = 100;
    static final int TICKER_DELAY = 1200;
    static final int TICKER_MARGIN = 10;
    static final int BLACK = 0;
    static final int DEFAULT_X_OFFSET = 2;
    static final int DEFAULT_Y_OFFSET = 0;
    public String label;
    boolean paint_box = true;
    int p_col;
    int text_color;
    int backg_color;
    int cellxoff = 2;
    int cellyoff = 0;
    static final int HEIGHT_MARGIN = 2;
    static final int WIDTH_MARGIN = 2;
    Font font;
    public String fit_label;
    public int last_visible_char;
    static Timer ticker_timer;
    TickerTask ticker_task;
    boolean position_changed = false;
    static final boolean LABEL_FITS = true;
    static final boolean NO_FIT = false;
    int begin_char;
    int end_char;
    static final int MIN_TICKING = 0;
    static final int MIN_TICKING_CHAR = 0;
    public int ticker_state;
    int length_missing = 0;
    public static final int TICKER_INIT = 0;
    static final int TICKER_RUNNING = 1;
    static final int TICKER_STOPPED = 2;
    boolean fill_focus = true;
    boolean ticker_cell = false;
    private static Cell ticker_instance;

    public Cell(String string, int n, int n2, int n3, int n4, Font font, Canvas canvas) {
        this.label = string;
        this.x_origin = n;
        this.y_origin = n2;
        this.paint_box = true;
        this.p_col = n3;
        this.text_color = n4;
        this.font = font;
        this.fit_label = null;
        this.ticker_task = null;
        this.can = canvas;
        this.width = this.font.stringWidth(this.label) + this.cellxoff + 2;
        this.height = this.font.getHeight() + 3 + this.cellyoff + 2;
    }

    public static Cell getTickerCellInstance(String string, int n, int n2, int n3, int n4, Font font, Canvas canvas) {
        if (ticker_instance == null) {
            ticker_instance = new Cell(string, n, n2, n3, n4, font, canvas);
            Cell.ticker_instance.width = canvas.getWidth();
        } else {
            Cell.ticker_instance.label = string;
        }
        return ticker_instance;
    }

    public void setText(String string) {
        this.label = string;
        this.fit_label = null;
        this.last_visible_char = 0;
        this.stopTicker();
        this.ticker_state = 0;
        this.fit_label = null;
    }

    public void setTickerCell(int n) {
        this.ticker_cell = true;
        this.width = this.can.getWidth();
        LAST_TICKER_LOOP = n;
        int n2 = this.font.stringWidth(" ");
        this.last_visible_char = (this.width - this.cellxoff - 10) / n2;
        int n3 = this.last_visible_char + 1;
        String string = "";
        for (int i = 0; i < n3; ++i) {
            string = string + " ";
        }
        this.label = string + this.label + string;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setPosition(int n, int n2) {
        this.x_origin = n;
        this.y_origin = n2;
    }

    public void setTextColor(int n) {
        this.text_color = n;
    }

    public void setNoBox() {
        this.paint_box = false;
    }

    public void setTransparent(int n) {
        this.paint_box = false;
        this.p_col = n;
        this.backg_color = n;
    }

    public void setCellColor(int n) {
        this.p_col = n;
    }

    public void setCellProperties(String string, boolean bl, int n, int n2, Font font) {
        this.label = string;
        this.paint_box = bl;
        this.p_col = n;
        this.text_color = n2;
        this.font = font;
    }

    public void setTextOffset(int n, int n2) {
        this.cellxoff = n;
        this.cellyoff = n2;
    }

    private boolean checkLabelFits() {
        if (!this.ticker_cell) {
            return true;
        }
        int n = this.font.stringWidth(this.label);
        if (this.cellxoff + n < this.width) {
            return true;
        }
        this.fit_label = new String(this.label.substring(0, this.last_visible_char));
        return false;
    }

    private void paintBackground(Graphics graphics) {
        graphics.setColor(this.p_col);
        graphics.fillRect(this.x_origin, this.y_origin, this.width, this.height);
        if (this.paint_box) {
            graphics.setColor(0);
            graphics.setFont(this.font);
            graphics.drawRect(this.x_origin, this.y_origin, this.width, this.height);
        }
    }

    public void show(Graphics graphics) {
        if (this.ticker_cell) {
            this.paintFocus(graphics, this.p_col, this.text_color);
            return;
        }
        if (this.font != null) {
            this.cellyoff = (this.height - this.font.getHeight()) / 2;
        }
        this.stopTicker();
        this.ticker_state = 0;
        this.paintBackground(graphics);
        int n = this.cellxoff;
        graphics.setColor(this.text_color);
        graphics.setFont(this.font);
        if (this.checkLabelFits() | !this.paint_box) {
            graphics.drawString(this.label, this.x_origin + n, this.y_origin + this.cellyoff, 20);
        } else {
            graphics.drawString(this.fit_label, this.x_origin + n, this.y_origin + this.cellyoff, 20);
        }
    }

    public void paintFocus(Graphics graphics, int n, int n2) {
        if (this.font != null) {
            this.cellyoff = (this.height - this.font.getHeight()) / 2;
        }
        if (!this.fill_focus) {
            this.show(graphics);
            if (this.paint_box) {
                graphics.setColor(n);
                graphics.drawRect(this.x_origin, this.y_origin, this.width, this.height);
                return;
            }
        }
        graphics.setColor(n);
        graphics.fillRect(this.x_origin + 1, this.y_origin + 1, this.width - 1, this.height - 1);
        if (this.paint_box) {
            graphics.setColor(0);
        }
        int n3 = this.cellxoff;
        graphics.setColor(n2);
        graphics.setFont(this.font);
        if (!(this.ticker_cell && this.ticker_task != null || this.ticker_cell && !this.checkLabelFits())) {
            graphics.drawString(this.label, this.x_origin + n3, this.y_origin + this.cellyoff, 20);
            return;
        }
        if (this.ticker_state != 1 && this.ticker_state != 2) {
            graphics.drawString(this.fit_label, this.x_origin + n3, this.y_origin + this.cellyoff, 20);
            this.startTicker();
        } else {
            String string = null;
            string = this.begin_char < 0 ? new String(this.label.substring(this.begin_char + 1, this.end_char + 1)) : new String(this.label.substring(this.begin_char, this.end_char));
            graphics.drawString(this.getStrip(string, this.can.getWidth() - this.x_origin), this.x_origin + n3, this.y_origin + this.cellyoff, 20);
            string = null;
        }
    }

    private String getStrip(String string, int n) {
        if (string == null || string.trim().length() < 1) {
            return string;
        }
        if (this.font.stringWidth(string) > n) {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (this.font.stringWidth(stringBuffer.toString()) > n) {
                stringBuffer.deleteCharAt(0);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static Timer getTimer() {
        if (ticker_timer == null) {
            ticker_timer = new Timer();
        }
        return ticker_timer;
    }

    public void stopTicker() {
        this.ticker_state = 2;
        if (this.ticker_task != null) {
            this.ticker_task.cancel();
            this.ticker_task = null;
        }
    }

    public boolean tickerRunning() {
        if (this.ticker_state == 1) {
            // empty if block
        }
        return this.ticker_state == 1;
    }

    private void startTicker() {
        if (this.ticker_state == 1 || this.ticker_state == 2) {
            return;
        }
        this.ticker_state = 1;
        this.ticker_task = new TickerTask(this);
        Cell.getTimer().schedule((TimerTask)this.ticker_task, 1200L, 200L);
    }

    public void keyReleased(int n) {
    }

    public boolean isKeyEvtRequired(int n) {
        return true;
    }

    static {
        ticker_instance = null;
    }

    private class TickerTask
    extends TimerTask {
        int loop_count;
        Cell ticker_cell = null;
        long prev = 0L;
        long pres = 0L;

        public TickerTask(Cell cell2) {
            Cell.this.begin_char = -1;
            Cell.this.end_char = Cell.this.last_visible_char - 1;
            this.loop_count = 1;
            this.ticker_cell = cell2;
        }

        public void resetTickerTask(Cell cell) {
            Cell.this.begin_char = -1;
            Cell.this.end_char = Cell.this.last_visible_char - 1;
            this.loop_count = 1;
            this.ticker_cell = cell;
        }

        public void run() {
            this.pres = System.currentTimeMillis();
            if (Cell.this.end_char < Cell.this.label.length()) {
                ++Cell.this.begin_char;
                ++Cell.this.end_char;
                if (Cell.this.end_char > Cell.this.label.length()) {
                    Cell.this.end_char = Cell.this.label.length();
                }
            } else {
                if (LAST_TICKER_LOOP > 0 && this.loop_count == LAST_TICKER_LOOP) {
                    Cell.this.begin_char = Cell.this.last_visible_char + 1;
                    Cell.this.end_char = Cell.this.begin_char + Cell.this.last_visible_char;
                    Cell.this.ticker_state = 2;
                    Cell.this.can.repaint(Cell.this.x_origin, Cell.this.y_origin, Cell.this.width, Cell.this.height);
                    Cell.this.can.serviceRepaints();
                    Cell.this.stopTicker();
                    return;
                }
                Cell.this.begin_char = 0;
                Cell.this.end_char = Cell.this.last_visible_char;
                ++this.loop_count;
            }
            Cell.this.can.repaint(Cell.this.x_origin + Cell.this.cellxoff, Cell.this.y_origin + Cell.this.cellyoff, Cell.this.width, Cell.this.height);
            Cell.this.can.serviceRepaints();
            if (Cell.this.begin_char == 0 | Cell.this.end_char == Cell.this.label.length()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.prev = this.pres;
        }
    }
}

