/*
 * Decompiled with CFR 0.152.
 */
package com.emb.widget;

import accuweather.AccuController;
import accuweather.DataUtility;
import com.emb.widget.Widget;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class RadioWidget
extends Widget {
    public Font font;
    public Canvas can = null;
    private int mode = 0;
    private int radSize;
    public int LBL_CLR = 0x8088F8;
    public int OPT_LBL_CLR = 0xFFFFFF;
    public int OPT_CLR = 3061817;
    public int OPT_BG_CLR = 0xF5F5F5;
    public int OPT_SEL_CLR = 16738740;
    public int BOX_CLR = 14423100;
    private String label = null;
    public int selIndex = 0;
    private int focusIndex;
    public String[] options = null;
    private int endYpos = 0;

    public RadioWidget(int n, int n2, String string, String[] stringArray, int n3, Canvas canvas) {
        this.x_origin = n;
        this.y_origin = n2;
        this.label = string;
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            stringArray[i] = "";
        }
        this.options = stringArray;
        this.mode = n3;
        this.can = canvas;
        this.font = DataUtility.FONT;
        this.focusIndex = this.selIndex;
    }

    public void show(Graphics graphics) {
        int n = this.y_origin;
        int n2 = this.x_origin;
        if (graphics != null) {
            graphics.setFont(this.font);
            this.radSize = this.font.getHeight();
            if (this.label != null) {
                graphics.setColor(this.LBL_CLR);
                graphics.drawString(this.label, n2, n, 0);
                n2 += this.font.stringWidth(this.label) + 4;
            }
            if (this.options != null) {
                if (n2 + this.font.stringWidth(this.options[0]) + this.radSize + 10 > this.can.getWidth()) {
                    n2 = this.x_origin;
                    n += this.font.getHeight() + 4;
                }
                for (int i = 0; i < this.options.length; ++i) {
                    boolean bl = false;
                    boolean bl2 = false;
                    if (i == this.selIndex) {
                        bl2 = true;
                        bl = true;
                        this.focusIndex = this.selIndex = i;
                    }
                    this.drawOption(graphics, n2, n, this.options[i], bl2, bl);
                    if (this.mode == 0) {
                        if (i < this.options.length - 1 && (n2 += this.font.stringWidth(this.options[i]) + this.radSize + 10) + this.font.stringWidth(this.options[i + 1]) + this.radSize + 10 > this.can.getWidth()) {
                            n2 = this.x_origin;
                            n += this.font.getHeight() + 4;
                        }
                    } else {
                        n2 = this.x_origin;
                        n += this.font.getHeight() + 4;
                    }
                    this.endYpos = n;
                }
                this.height = this.endYpos - this.y_origin;
            }
        }
    }

    public String getSelected() {
        if (this.options == null) {
            return null;
        }
        return this.options[this.selIndex].trim();
    }

    public void setMode(int n) {
        this.mode = n;
    }

    private void drawOption(Graphics graphics, int n, int n2, String string, boolean bl, boolean bl2) {
        if (string == null) {
            return;
        }
        graphics.setColor(this.OPT_CLR);
        graphics.fillArc(n, n2, this.radSize, this.radSize, 1, 360);
        graphics.setColor(this.OPT_BG_CLR);
        graphics.fillArc(n + 2, n2 + 2, this.radSize - 4, this.radSize - 4, 1, 360);
        graphics.setColor(this.OPT_SEL_CLR);
        if (bl) {
            graphics.fillArc(n + 3, n2 + 3, this.radSize - 6, this.radSize - 6, 1, 360);
        }
        if (bl2) {
            graphics.setColor(this.BOX_CLR);
            graphics.drawRoundRect(n + this.radSize + 3, n2, this.font.stringWidth(string) + 7, this.font.getHeight() + 2, 2, 2);
        }
        graphics.setColor(this.OPT_LBL_CLR);
        graphics.drawString(string, n + this.radSize + 7, n2, 0);
    }

    public boolean isKeyEvtRequired(int n) {
        boolean bl = true;
        if (this.inFocus) {
            // empty if block
        }
        return bl;
    }

    public void keyReleased(int n) {
        n = this.can.getGameAction(n);
        if (this.options != null && this.inFocus) {
            switch (n) {
                case 1: 
                case 2: {
                    --this.focusIndex;
                    if (this.focusIndex < 0) {
                        this.focusIndex = this.options.length - 1;
                    }
                    this.selIndex = this.focusIndex;
                    break;
                }
                case 5: 
                case 6: {
                    ++this.focusIndex;
                    if (this.focusIndex >= this.options.length) {
                        this.focusIndex = 0;
                    }
                    this.selIndex = this.focusIndex;
                    break;
                }
                case 8: {
                    AccuController.controller.handleCommandEvents(19);
                }
            }
        }
    }
}

