/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.application;

import com.sonyericsson.audiopostcard.controller.Controller;
import com.sonyericsson.audiopostcard.controller.InputControl;
import com.sonyericsson.audiopostcard.model.InteractionModel;
import com.sonyericsson.audiopostcard.model.ModelInterface;
import com.sonyericsson.audiopostcard.util.SettingsManager;
import com.sonyericsson.audiopostcard.view.LayeredCanvas;
import com.sonyericsson.audiopostcard.view.ViewEventInterface;
import com.sonyericsson.ui.UIExitDialog;
import com.sonyericsson.ui.UIListHighlightChangedListener;
import com.sonyericsson.ui.UIListStateChangedListener;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Invocation;
import javax.microedition.content.Registry;
import javax.microedition.content.RequestListener;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.media.MediaException;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class AudioPostcard
extends MIDlet
implements Controller,
ViewEventInterface,
RequestListener {
    private LayeredCanvas canvas;
    private InputControl controller;
    private InteractionModel interactionModel;
    private Display display = null;
    private Displayable lastDisplayable = null;
    private Invocation invocation;
    private ContentHandlerServer contentHandler;
    private Object pauseResumeLock = new Object();
    private boolean isPaused;
    private boolean isStarted = false;
    private boolean isInvokedBefore = false;
    private boolean isInvocationActive = false;

    public AudioPostcard() {
        UIExitDialog.setEndKeyBehavior((int)2);
        this.init();
    }

    private void init() {
        this.isPaused = false;
        this.interactionModel = new InteractionModel();
        this.controller = new InputControl(this, this.interactionModel);
        ModelInterface modelInterface = this.interactionModel.getModelInterface();
        this.canvas = new LayeredCanvas(this, this.controller, modelInterface);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
        this.lastDisplayable = this.canvas;
        this.interactionModel.addView(this.canvas);
    }

    public void destroyApp(boolean unconditionalFlag) throws MIDletStateChangeException {
        if (unconditionalFlag) {
            this.notifyDestroyed();
        } else {
            boolean doExit = this.controller.confirmExit();
            if (doExit) {
                boolean doExitNow = this.controller.requestExit();
                if (!doExitNow) {
                    throw new MIDletStateChangeException();
                }
            } else {
                throw new MIDletStateChangeException();
            }
        }
    }

    protected void pauseApp() {
        this.pause();
    }

    protected void startApp() throws MIDletStateChangeException {
        Display midletDisplay = Display.getDisplay((MIDlet)this);
        if (!this.isInvocationActive) {
            this.start(midletDisplay);
        } else {
            this.isPaused = false;
        }
    }

    private void reset() {
        if (this.isInvokedBefore) {
            this.canvas.initialize();
            this.controller.initialize();
            this.controller.cancelCloseAfterTransfers();
        }
        if (this.isInvokedBefore) {
            Display.getDisplay((MIDlet)this).setCurrent(null);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
        }
        this.lastDisplayable = this.canvas;
        if (this.isInvokedBefore) {
            this.showStartupScreen();
        }
        try {
            this.setupUI();
        }
        catch (IllegalStateException e) {
            this.shutdown();
        }
    }

    private void setupUI() throws IllegalStateException {
        if (this.canvas == null) {
            throw new IllegalStateException();
        }
        try {
            this.canvas.setCommandListener(this.controller);
            this.controller.setUpStartState();
        }
        catch (MediaException e) {
            this.shutdown();
        }
    }

    private void registerContactInfo() {
        try {
            if (this.invocation != null) {
                String invokedURL = this.invocation.getURL();
                if (!invokedURL.startsWith("aupoto:")) {
                    this.destroyApp(true);
                } else {
                    invokedURL = invokedURL.substring(invokedURL.indexOf(":") + 1, invokedURL.length());
                    String[] contactData = this.splitString(invokedURL, "|");
                    String contactPhoneNbr = contactData[0];
                    String contactName = contactData[1];
                    String contactImageUrl = contactData[2];
                    this.interactionModel.setContactInfo(contactPhoneNbr, contactName, contactImageUrl);
                }
            }
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private String[] splitString(String data, String delimeter) {
        String[] result = new String[]{};
        String splittedString = data;
        boolean flag = true;
        while (flag) {
            int index = splittedString.indexOf(delimeter);
            String tempData = index >= 0 ? splittedString.substring(0, index) : splittedString;
            String[] tempResult = new String[result.length + 1];
            int k = 0;
            while (k < result.length) {
                tempResult[k] = result[k];
                ++k;
            }
            tempResult[tempResult.length - 1] = tempData;
            result = tempResult;
            if ((splittedString = splittedString.substring(index + delimeter.length(), splittedString.length())).length() > 0 && index >= 0) continue;
            flag = false;
        }
        return result;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void requestViewSwitch(Displayable displayable) {
        if (displayable != null) {
            this.lastDisplayable = displayable;
        }
        this.display.setCurrent(displayable);
    }

    private void showStartupScreen() {
        this.interactionModel.setupLoadingState();
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    private void initializeApp() {
        this.canvas.initialize();
        this.interactionModel.initialize();
        this.controller.initialize();
        SettingsManager.initialize();
        this.getContentHandlerAccess();
    }

    public void start(Display display) {
        this.display = display;
        if (this.isPaused) {
            this.resume();
        } else if (!this.isStarted) {
            this.isStarted = true;
            this.showStartupScreen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.pauseResumeLock;
        synchronized (object) {
            if (!this.isPaused) {
                this.isPaused = true;
                this.controller.pause();
            }
            this.pauseResumeLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.pauseResumeLock;
        synchronized (object) {
            if (this.isPaused) {
                this.isPaused = false;
                this.display.setCurrent(this.lastDisplayable);
                this.controller.resume();
            }
            this.pauseResumeLock.notifyAll();
        }
    }

    public boolean isApplicationPaused() {
        return this.isPaused;
    }

    public void shutdown() {
        if (this.contentHandler != null) {
            this.contentHandler.setListener(null);
        }
        if (!this.isInvocationActive) {
            this.notifyDestroyed();
        }
    }

    public void requestExit() {
        this.controller.requestExit();
    }

    public CommandListener getCommandListener() {
        return this.controller;
    }

    private void getContentHandlerAccess() {
        try {
            this.contentHandler = Registry.getServer((String)this.getClass().getName());
        }
        catch (ContentHandlerException contentHandlerException) {
            // empty catch block
        }
        if (this.contentHandler != null) {
            this.contentHandler.setListener((RequestListener)this);
        }
    }

    public void invocationRequestNotify(ContentHandlerServer contentHandlerServer) {
        this.isInvocationActive = true;
        if (this.invocation != null) {
            this.contentHandler.finish(this.invocation, 5);
        }
        Thread startThread = new Thread(){

            public void run() {
                try {
                    AudioPostcard.this.invocation = AudioPostcard.this.contentHandler.getRequest(false);
                    if (AudioPostcard.this.isStarted) {
                        AudioPostcard.this.reset();
                    }
                    AudioPostcard.this.registerContactInfo();
                    AudioPostcard.this.isInvokedBefore = true;
                    AudioPostcard.this.isInvocationActive = false;
                }
                catch (Exception e) {
                    AudioPostcard.this.shutdown();
                }
            }
        };
        startThread.start();
    }

    public UIListStateChangedListener getUIListStateChangedListener() {
        return this.controller;
    }

    public UIListHighlightChangedListener getUIListHighlightChangedListener() {
        return this.controller;
    }

    public void setUpDisplayScreen() {
        Thread initApp = new Thread(){

            public void run() {
                AudioPostcard.this.initializeApp();
            }
        };
        initApp.start();
    }
}

