/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.model.ActionManagerListener;
import com.sonyericsson.audiopostcard.model.AudioFramework;
import com.sonyericsson.audiopostcard.model.FreezeStateInterface;
import com.sonyericsson.audiopostcard.model.PresentationManager;
import com.sonyericsson.ui.TextId;
import com.sonyericsson.ui.UIIcon;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

class FreezeMode {
    private AudioFramework audioFramework;
    private PresentationManager presentationManager;
    private ActionManagerListener actionManagerListener;
    private FreezeStateInterface stateHandler;
    private int nextStateAfterAudioSession;
    private static final int PROGRESS_BAR_UPDATE_MS = 25;
    private static final int BACKLIGHT_UPDATE_MS = 5000;

    public FreezeMode(PresentationManager presentationManager, FreezeStateInterface stateHandler, ActionManagerListener actionManagerListener) {
        this.presentationManager = presentationManager;
        this.stateHandler = stateHandler;
        this.actionManagerListener = actionManagerListener;
        this.audioFramework = new AudioFramework();
    }

    public void pause() {
        this.audioFramework.pause();
    }

    public void resume() {
        this.audioFramework.resume();
    }

    public void shutdown() throws MediaException {
        if (this.audioFramework != null) {
            this.audioFramework.shutdown();
        }
    }

    void handleStateAddVoiceOrSend() {
        this.stateHandler.setAudioData(null);
        this.stateHandler.setRecordedTimeMs(0L);
        try {
            this.audioFramework.prepareAudioCapture();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    void handleStateRecordVoice() {
        try {
            this.nextStateAfterAudioSession = 4;
            this.audioFramework.captureAudio();
            this.presentationManager.showAudioStatusBar(TextId.getString((int)5813), true, 60000L, true);
            this.handleAudioLoop(true);
            this.presentationManager.hideAudioStatusBar(true);
            this.audioFramework.handleStopRecord(true);
            this.stateHandler.setAudioData(this.audioFramework.getAudioData());
            this.stateHandler.setRecordedTimeMs(this.audioFramework.getRecordedTimeMs());
            this.actionManagerListener.transit(this.nextStateAfterAudioSession);
        }
        catch (MediaException e) {
            try {
                this.actionManagerListener.transit(2);
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    void handleStatePlayVoice() {
        long durationMs = this.audioFramework.getRecordedTimeMs();
        if (durationMs > 60000L) {
            durationMs = 60000L;
        }
        String[] text = new String[]{String.valueOf(TextId.getString((int)5811)) + " " + this.presentationManager.getTimeText(durationMs)};
        UIIcon icon = UIIcon.createUIIcon((int)60835);
        this.presentationManager.showText(text, (Image)icon, false);
        try {
            this.nextStateAfterAudioSession = 4;
            durationMs = this.audioFramework.playCapturedAudio();
            this.presentationManager.showAudioStatusBar(null, false, durationMs, true);
            this.handleAudioLoop(false);
            this.presentationManager.hideAudioStatusBar(true);
            this.audioFramework.handleStopPlayback();
            this.actionManagerListener.transit(this.nextStateAfterAudioSession);
        }
        catch (MediaException e) {
            try {
                this.actionManagerListener.transit(4);
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    void handleStateDiscardRecPrompt() {
        String prompt = TextId.getString((int)5812);
        String question = "";
        int[] commands = new int[]{10, 11};
        this.presentationManager.showAlert(prompt, question, commands, true);
    }

    void handleStateSendAudioVideo() {
        this.presentationManager.setTextToPersistent(false);
        long time = this.audioFramework.getRecordedTimeMs();
        if (time > 60000L) {
            time = 60000L;
        }
        String[] text = new String[]{String.valueOf(TextId.getString((int)5811)) + " " + this.presentationManager.getTimeText(time)};
        UIIcon icon = UIIcon.createUIIcon((int)60835);
        this.presentationManager.showText(text, (Image)icon, true);
    }

    void handleKeyAddVoiceOrSend(int key) throws MediaException {
        if (3 == key) {
            try {
                this.actionManagerListener.transit(5);
            }
            catch (MediaException e) {
                this.actionManagerListener.transit(2);
            }
        } else if (1 == key) {
            try {
                this.actionManagerListener.transit(3);
            }
            catch (MediaException e) {
                this.actionManagerListener.transit(2);
            }
        } else if (key == 0) {
            this.actionManagerListener.transit(1);
        }
    }

    void handleKeyRecordVoice(int key) throws IllegalStateException, MediaException, OutOfMemoryError {
        if (4 == key) {
            this.presentationManager.hideAudioStatusBar(true);
            this.audioFramework.handleStopRecord(true);
            this.stateHandler.setAudioData(this.audioFramework.getAudioData());
            this.stateHandler.setRecordedTimeMs(this.audioFramework.getRecordedTimeMs());
            this.nextStateAfterAudioSession = 4;
        } else if (key == 0) {
            this.audioFramework.handleStopRecord(false);
            this.nextStateAfterAudioSession = 1;
        }
    }

    void handleKeyPlayVoice(int key) throws IllegalStateException, MediaException, OutOfMemoryError {
        if (4 == key) {
            this.presentationManager.hideAudioStatusBar(true);
            this.presentationManager.setTextToPersistent(true);
            this.audioFramework.handleStopPlayback();
            this.nextStateAfterAudioSession = 4;
        } else if (key == 0) {
            this.presentationManager.hideAudioStatusBar(true);
            this.presentationManager.setTextToPersistent(true);
            this.audioFramework.handleStopPlayback();
            this.nextStateAfterAudioSession = 4;
        }
    }

    void handleKeyDiscardRecPrompt(int key) throws MediaException {
        if (10 == key) {
            this.dialogPromptAnswered(true);
            try {
                this.actionManagerListener.transit(1);
            }
            catch (MediaException e) {
                this.actionManagerListener.transit(1);
            }
        } else if (11 == key) {
            this.dialogPromptAnswered(true);
            try {
                this.actionManagerListener.transit(4);
            }
            catch (MediaException e) {
                this.actionManagerListener.transit(1);
            }
        }
    }

    void handleKeySendAudioVideo(int key) throws MediaException {
        if (5 == key) {
            try {
                this.actionManagerListener.transit(6);
            }
            catch (MediaException e) {
                this.actionManagerListener.transit(4);
            }
        } else if (6 == key) {
            try {
                this.actionManagerListener.transit(3);
            }
            catch (MediaException e) {
                this.actionManagerListener.transit(4);
            }
        } else if (2 == key) {
            try {
                this.actionManagerListener.transit(5);
            }
            catch (MediaException e) {
                this.actionManagerListener.transit(4);
            }
        } else if (key == 0) {
            try {
                this.actionManagerListener.transit(7);
            }
            catch (MediaException e) {
                this.actionManagerListener.transit(4);
            }
        }
    }

    public void handleAudioLoop(boolean isRecording) throws MediaException {
        long elapsedTime = 0L;
        boolean finished = false;
        long iterationTimeMs = 0L;
        while (!finished) {
            try {
                elapsedTime = isRecording ? this.audioFramework.getRecordedTimeMs() : this.audioFramework.getMediaTimeMs();
                this.presentationManager.updateStatusBarTime(elapsedTime, true);
                Thread.sleep(25L);
                if ((iterationTimeMs += 25L) > 5000L) {
                    this.presentationManager.setBacklightVisible(true);
                    iterationTimeMs = 0L;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.audioFramework.isStopRequested()) {
                finished = true;
            }
            if (isRecording) {
                if (!this.audioFramework.isRecording()) {
                    finished = true;
                }
                if (elapsedTime < 60000L) continue;
                finished = true;
                continue;
            }
            if (this.audioFramework.isPlaying()) continue;
            finished = true;
        }
    }

    public void dialogPromptAnswered(boolean doViewUpdate) {
        this.presentationManager.hideAlert(doViewUpdate);
    }
}

