/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.util.SettingsManager;
import com.sonyericsson.ui.TextId;
import com.sonyericsson.wma.extension.NativeMMSSendRegister;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.microedition.io.Connector;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessagePart;
import javax.wireless.messaging.MultipartMessage;
import javax.wireless.messaging.SizeExceededException;

class MMSHandler {
    private static String SEMC_MMS_TAG = "semcmms://";
    static /* synthetic */ Class class$0;

    MMSHandler() {
    }

    public static void sendMMS(String phoneNbr, byte[] imageData, byte[] audioData, long recordingDuration) throws IllegalArgumentException, SizeExceededException, IOException {
        MessageConnection conn = null;
        MultipartMessage msg = null;
        if (imageData == null) {
            throw new IllegalArgumentException();
        }
        NativeMMSSendRegister sendRegister = NativeMMSSendRegister.getInstance();
        try {
            try {
                sendRegister.addNativeSendingApplication("AudioPostcard");
                String connectionURL = String.valueOf(SEMC_MMS_TAG) + phoneNbr + ":" + "AudioPostcard";
                conn = (MessageConnection)Connector.open((String)connectionURL);
                msg = (MultipartMessage)conn.newMessage("multipart");
                MMSHandler.createMMS(msg, imageData, audioData, recordingDuration);
                conn.send((Message)msg);
            }
            catch (InterruptedIOException interruptedIOException) {
                sendRegister.removeNativeSendingApplication("AudioPostcard");
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (IOException iOException) {
                sendRegister.removeNativeSendingApplication("AudioPostcard");
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (IOException iOException2) {
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                sendRegister.removeNativeSendingApplication("AudioPostcard");
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            sendRegister.removeNativeSendingApplication("AudioPostcard");
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected static void createMMS(MultipartMessage msg, byte[] imageData, byte[] audioData, long recordingDuration) throws IllegalArgumentException, IOException, SizeExceededException {
        if (imageData == null) {
            throw new IllegalArgumentException();
        }
        msg.setSubject(TextId.getString((int)5817));
        StringBuffer smilTemplate = MMSHandler.readSmilContent();
        byte[] smilContent = MMSHandler.adaptSmilTemplate(smilTemplate, audioData != null, true, recordingDuration);
        MMSHandler.addSmilTemplate(msg, smilContent);
        String imageType = SettingsManager.getImageType();
        MMSHandler.addImage(msg, imageType, imageData);
        if (audioData != null) {
            String audioType = SettingsManager.getAudioType();
            MMSHandler.addAudio(msg, audioType, audioData);
        }
        msg.setStartContentId("main.smil");
    }

    protected static StringBuffer readSmilContent() throws IOException {
        StringBuffer smilContent = new StringBuffer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Class");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream is = clazz.getResourceAsStream("/main.smil");
        try {
            int content;
            while ((content = is.read()) != -1) {
                smilContent.append((char)content);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return smilContent;
    }

    protected static byte[] adaptSmilTemplate(StringBuffer smilContent, boolean audioAvailable, boolean imageAvailable, long recordingDuration) {
        StringBuffer attachments = new StringBuffer();
        if (audioAvailable && recordingDuration > 4L) {
            attachments.append("<par dur=\"" + recordingDuration + "ms\">");
        } else {
            attachments.append("<par dur=\"4ms\">");
        }
        if (imageAvailable) {
            attachments.append("\r\n<img src=\"image.jpg\" region=\"Image\"></img>");
        }
        if (audioAvailable) {
            attachments.append("\r\n<audio src=\"audio.amr\"></audio>");
        }
        attachments.append("\r\n</par>");
        smilContent = MMSHandler.replaceString(smilContent.toString(), "<attachments></attachments>", attachments.toString());
        return smilContent.toString().getBytes();
    }

    protected static void addSmilTemplate(MultipartMessage msg, byte[] smilContentData) throws SizeExceededException {
        String mimeType = "application/smil";
        MessagePart msgPart = new MessagePart(smilContentData, mimeType, "main.smil", "main.smil", null);
        msg.addMessagePart(msgPart);
    }

    protected static void addImage(MultipartMessage msg, String imageType, byte[] imageData) throws SizeExceededException {
        String mimeType = "image/raw";
        if (imageType.length() > 0) {
            mimeType = "image/" + imageType;
        }
        MessagePart msgPart = new MessagePart(imageData, mimeType, "image.jpg", "image.jpg", null);
        msg.addMessagePart(msgPart);
    }

    protected static void addAudio(MultipartMessage msg, String audioType, byte[] audioData) throws SizeExceededException {
        String mimeType = "audio/raw";
        if (audioType.length() > 0) {
            mimeType = "audio/" + audioType;
        }
        MessagePart msgPart = new MessagePart(audioData, mimeType, "audio.amr", "audio.amr", null);
        msg.addMessagePart(msgPart);
    }

    protected static StringBuffer replaceString(String text, String searchStr, String replacementStr) {
        StringBuffer replacedString = new StringBuffer();
        int searchStringPos = text.indexOf(searchStr);
        int startPos = 0;
        int searchStringLength = searchStr.length();
        while (searchStringPos != -1) {
            replacedString.append(text.substring(startPos, searchStringPos)).append(replacementStr);
            startPos = searchStringPos + searchStringLength;
            searchStringPos = text.indexOf(searchStr, startPos);
        }
        replacedString.append(text.substring(startPos, text.length()));
        return replacedString;
    }
}

