/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.model.FileHandler;
import com.sonyericsson.audiopostcard.model.ImageHandler;
import com.sonyericsson.file.URLOperation;
import com.sonyericsson.ui.UIIcon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.ImageFormatControl;
import javax.microedition.amms.control.imageeffect.ImageEffectControl;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

class PictureHandler {
    PictureHandler() {
    }

    public static byte[] addEffect(byte[] imageData, int effect, int pictureQuality) throws MediaException, IOException {
        String effectName;
        switch (effect) {
            case 0: {
                effectName = null;
                break;
            }
            case 1: {
                effectName = "monochrome";
                break;
            }
            case 2: {
                effectName = "negative";
                break;
            }
            default: {
                effectName = null;
            }
        }
        if (effectName == null) {
            return imageData;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(imageData);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MediaProcessor mp = GlobalManager.createMediaProcessor((String)"image/jpeg");
        mp.setInput((InputStream)in, imageData.length);
        ImageFormatControl fc = (ImageFormatControl)mp.getControl("javax.microedition.amms.control.ImageFormatControl");
        ImageEffectControl ec = (ImageEffectControl)mp.getControl("javax.microedition.amms.control.imageeffect.ImageEffectControl");
        fc.setFormat("image/jpeg");
        fc.setParameter("quality", pictureQuality);
        ec.setPreset(effectName);
        ec.setEnabled(true);
        mp.setOutput((OutputStream)out);
        mp.complete();
        return out.toByteArray();
    }

    public static Image getContactPicture(String url) {
        Image image = null;
        try {
            try {
                String contactImageLocation = URLOperation.reverseURL((String)url);
                byte[] imageData = FileHandler.readData(contactImageLocation);
                Image contactImage = Image.createImage((byte[])imageData, (int)0, (int)imageData.length);
                image = ImageHandler.rescaleTransparentImage(contactImage, 94, 94);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (image == null) {
                    UIIcon iconImage = UIIcon.createUIIcon((int)61003);
                    image = ImageHandler.rescaleTransparentImage((Image)iconImage, 94, 94);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (image == null) {
                    UIIcon iconImage = UIIcon.createUIIcon((int)61003);
                    image = ImageHandler.rescaleTransparentImage((Image)iconImage, 94, 94);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (image == null) {
                    UIIcon iconImage = UIIcon.createUIIcon((int)61003);
                    image = ImageHandler.rescaleTransparentImage((Image)iconImage, 94, 94);
                }
            }
            catch (IOException iOException) {
                if (image == null) {
                    UIIcon iconImage = UIIcon.createUIIcon((int)61003);
                    image = ImageHandler.rescaleTransparentImage((Image)iconImage, 94, 94);
                }
            }
            catch (SecurityException securityException) {
                if (image == null) {
                    UIIcon iconImage = UIIcon.createUIIcon((int)61003);
                    image = ImageHandler.rescaleTransparentImage((Image)iconImage, 94, 94);
                }
            }
        }
        finally {
            if (image == null) {
                UIIcon iconImage = UIIcon.createUIIcon((int)61003);
                image = ImageHandler.rescaleTransparentImage((Image)iconImage, 94, 94);
            }
        }
        return image;
    }
}

