/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.model.ModelInterface;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.media.control.VideoControl;

class PresentationBase
implements ModelInterface {
    protected Vector viewVector;
    protected boolean maximizeRequested = false;
    protected boolean minimizeRequested = false;
    protected boolean textVisible = false;
    protected boolean textTimeoutActive = false;
    protected boolean isTextPersistent = false;
    protected boolean panelVisible = false;
    protected boolean videoPanelVisible = false;
    protected boolean arrowsVisible = false;
    protected boolean textIconVisible = false;
    protected boolean selfTimerIconVisible = false;
    protected boolean nightModeIconVisible = false;
    protected boolean isStatusBarCountingUp = false;
    protected boolean statusBarVisible = false;
    protected String[] textMessage;
    protected String statusBarMessage;
    protected long elapsedTime = 0L;
    protected long maxTime = 0L;
    protected Image smallFrame;
    protected Image snapshot;
    protected Image textIcon;
    protected boolean dialogVisible = false;
    protected String[] dialogTextMessage;
    protected Image dialogIcon;
    protected int dialogTimeoutMode;
    protected int dialogTimeoutMs;
    protected boolean exitAfterDialogEnabled = false;
    protected boolean alertVisible = false;
    protected String alertTextMessage;
    protected String alertTextQuestion;
    protected int[] alertCommands = null;
    protected boolean cameraListVisible = false;
    protected int[] cameraListCommands = null;
    protected int[] cameraListOptions = null;
    protected String cameraListTitle;
    protected int cameraListSelectedOption;
    protected boolean softkeysVisible = false;
    protected int[] softkeysArray = null;
    protected boolean paintOnlyProgressBar = false;
    protected VideoControl videoControl = null;
    protected boolean isVideoControlUpdated = false;
    protected boolean cameraListUpdater = false;
    protected boolean backlightVisible = false;
    protected boolean snapshotWaitScreenVisible = false;
    protected Object textMessageChangeLock;

    PresentationBase() {
    }

    public boolean updateSmallAreaOnly() {
        return this.paintOnlyProgressBar;
    }

    public boolean isPanelVisible() {
        return this.panelVisible;
    }

    public boolean areArrowsVisible() {
        return this.arrowsVisible;
    }

    public int getZoomLevel() {
        return 0;
    }

    public boolean isVideoPanelVisible() {
        return this.videoPanelVisible;
    }

    public boolean isNightModeIconVisible() {
        return this.nightModeIconVisible;
    }

    public boolean isSelfTimerIconVisible() {
        return this.selfTimerIconVisible;
    }

    public Image getSnapshot() {
        return this.snapshot;
    }

    public Image getSmallFrame() {
        return this.smallFrame;
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public String[] getTextMessage() {
        return this.textMessage;
    }

    public boolean isTextIconVisible() {
        return this.textIconVisible;
    }

    public Image getTextIcon() {
        return this.textIcon;
    }

    public boolean isStatusBarVisible() {
        return this.statusBarVisible;
    }

    public long getStatusBarProgressInPercent() {
        long progress = 100L * this.elapsedTime / this.maxTime;
        return progress;
    }

    public String getStatusBarTextTime() {
        long time = this.isStatusBarCountingUp ? this.elapsedTime : this.maxTime;
        return this.getTimeText(time);
    }

    public String getStatusBarMessage() {
        return this.statusBarMessage;
    }

    public boolean isDialogVisible() {
        boolean flag = this.dialogVisible;
        this.dialogVisible = false;
        return flag;
    }

    public int getDialogTimeoutMode() {
        return this.dialogTimeoutMode;
    }

    public int getDialogTimeoutMs() {
        return this.dialogTimeoutMs;
    }

    public String[] getDialogMessage() {
        return this.dialogTextMessage;
    }

    public Image getDialogIcon() {
        return this.dialogIcon;
    }

    public boolean isExitAfterDialogEnabled() {
        return this.exitAfterDialogEnabled;
    }

    public void setExitAfterDialogEnabled(boolean enabled) {
        this.exitAfterDialogEnabled = enabled;
    }

    public boolean isMaximizeRequested() {
        boolean flag = this.maximizeRequested;
        this.maximizeRequested = false;
        return flag;
    }

    public boolean isMinimizeRequested() {
        boolean flag = this.minimizeRequested;
        this.minimizeRequested = false;
        return flag;
    }

    public boolean areSoftkeysVisible() {
        return this.softkeysVisible;
    }

    public int[] getSoftkeys() {
        return this.softkeysArray;
    }

    public boolean isCameraListVisible() {
        return this.cameraListVisible;
    }

    public int[] getCameraListCommands() {
        return this.cameraListCommands;
    }

    public int[] getCameraListOptions() {
        return this.cameraListOptions;
    }

    public String getCameraListTitle() {
        return this.cameraListTitle;
    }

    public int getCameraListSelectedOption() {
        return this.cameraListSelectedOption;
    }

    public boolean isAlertVisible() {
        boolean flag = this.alertVisible;
        return flag;
    }

    public String getAlertTextMessage() {
        return this.alertTextMessage;
    }

    public String getAlertTextQuestion() {
        return this.alertTextQuestion;
    }

    public int[] getAlertCommands() {
        return this.alertCommands;
    }

    public boolean isVideoControlUpdated() {
        boolean flag = this.isVideoControlUpdated;
        this.isVideoControlUpdated = false;
        return flag;
    }

    public VideoControl getVideoControl() {
        return this.videoControl;
    }

    public boolean isBacklightVisible() {
        boolean flag = this.backlightVisible;
        this.backlightVisible = false;
        return flag;
    }

    public boolean isCameraListUpdated() {
        boolean flag = this.cameraListUpdater;
        this.cameraListUpdater = false;
        return flag;
    }

    public void setBacklightVisible(boolean backlightVisible) {
        this.backlightVisible = backlightVisible;
    }

    public boolean isSnapshotWaitScreenVisible() {
        return this.snapshotWaitScreenVisible;
    }

    public String getTimeText(long time) {
        String seconds;
        long value = time / 60000L;
        String minutes = "0" + String.valueOf(time / 60000L);
        if (minutes.length() > 2) {
            minutes = minutes.substring(minutes.length() - 2, minutes.length());
        }
        if ((seconds = "0" + String.valueOf((time - value * 60000L) / 1000L)).length() > 2) {
            seconds = seconds.substring(seconds.length() - 2, seconds.length());
        }
        return String.valueOf(minutes) + ":" + seconds;
    }
}

