/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.model.FrameHandler;
import com.sonyericsson.audiopostcard.model.ModelListenerInterface;
import com.sonyericsson.audiopostcard.model.PresentationBase;
import com.sonyericsson.audiopostcard.util.TextManager;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.media.control.VideoControl;

class PresentationManager
extends PresentationBase {
    public PresentationManager() {
        this.viewVector = new Vector();
        this.textMessageChangeLock = new Object();
        this.elapsedTime = 0L;
    }

    public void reset() {
        this.cameraListVisible = false;
        this.alertVisible = false;
        this.nightModeIconVisible = false;
        this.selfTimerIconVisible = false;
        this.selectFrame(0);
    }

    public void addView(ModelListenerInterface view) {
        this.viewVector.addElement(view);
    }

    public void show(boolean doViewUpdate) {
        this.maximizeRequested = true;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void hide(boolean doViewUpdate) {
        this.minimizeRequested = true;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void updateVideoControl(VideoControl videoControl, boolean doViewUpdate) {
        this.videoControl = videoControl;
        this.isVideoControlUpdated = true;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public boolean isImageVisible() {
        return this.snapshot != null;
    }

    public void showImage(Image image, boolean doViewUpdate) {
        this.snapshot = image != null ? image : null;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void showFrame(Image image, boolean doViewUpdate) {
        this.smallFrame = image != null ? image : null;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void showAudioStatusBar(String message, boolean countTime, long endTime, boolean doViewUpdate) {
        this.statusBarMessage = message;
        this.maxTime = endTime;
        this.isStatusBarCountingUp = countTime;
        this.statusBarVisible = true;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void hideAudioStatusBar(boolean doViewUpdate) {
        this.statusBarMessage = null;
        this.statusBarVisible = false;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void showPanel(boolean doViewUpdate) {
        this.panelVisible = true;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void hidePanel(boolean doViewUpdate) {
        this.panelVisible = false;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void showVideoPanel(boolean doViewUpdate) {
        this.videoPanelVisible = true;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void hideVideoPanel(boolean doViewUpdate) {
        this.videoPanelVisible = false;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void showArrows(boolean doViewUpdate) {
        this.arrowsVisible = true;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void hideArrows(boolean doViewUpdate) {
        this.arrowsVisible = false;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void setTimerIconVisible(boolean flag, boolean doViewUpdate) {
        if (flag && !this.selfTimerIconVisible) {
            this.showTimerIcon(false);
        } else if (!flag && this.selfTimerIconVisible) {
            this.hideTimerIcon(false);
        }
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void showTimerIcon(boolean doViewUpdate) {
        this.selfTimerIconVisible = true;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void hideTimerIcon(boolean doViewUpdate) {
        this.selfTimerIconVisible = false;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void setNightModeIconVisible(boolean flag, boolean doViewUpdate) {
        if (flag && !this.nightModeIconVisible) {
            this.showNightModeIcon(false);
        } else if (!flag && this.nightModeIconVisible) {
            this.hideNightModeIcon(false);
        }
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void showNightModeIcon(boolean doViewUpdate) {
        this.nightModeIconVisible = true;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void hideNightModeIcon(boolean doViewUpdate) {
        this.nightModeIconVisible = false;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void setZoom(int zoom) {
    }

    public void setBrightness(int brightness) {
    }

    public void updateStatusBarTime(long time, boolean doViewUpdate) {
        this.elapsedTime = time;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public boolean isTextTimeoutActive() {
        return this.textTimeoutActive;
    }

    private void setTextTimeoutActive(boolean active) {
        this.textTimeoutActive = active;
    }

    public void showText(String[] msg, boolean doViewUpdate) {
        this.showText(msg, null, doViewUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showText(String[] msg, Image icon, boolean doViewUpdate) {
        if (!this.textTimeoutActive) {
            Object object = this.textMessageChangeLock;
            synchronized (object) {
                this.textVisible = true;
                this.textMessage = msg;
                if (icon != null) {
                    this.textIcon = icon;
                    this.textIconVisible = true;
                }
                if (doViewUpdate) {
                    this.requestUpdateViews();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideText(boolean doViewUpdate) {
        if (this.textVisible && !this.textTimeoutActive) {
            Object object = this.textMessageChangeLock;
            synchronized (object) {
                this.textVisible = false;
                this.textIconVisible = false;
                this.textIcon = null;
                if (doViewUpdate) {
                    this.requestUpdateViews();
                }
            }
        }
    }

    public void setTextToPersistent(boolean active) {
        this.isTextPersistent = active;
    }

    public boolean isTextPersistent() {
        return this.isTextPersistent;
    }

    public void showDialog(String[] msg, Image icon, boolean useTimeout, boolean doViewUpdate) {
        this.dialogVisible = true;
        this.dialogTextMessage = msg;
        this.dialogIcon = icon;
        this.dialogTimeoutMode = useTimeout ? 0 : 2;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void showDialog(String[] msg, Image icon, int timeoutMs, boolean doViewUpdate) {
        this.dialogVisible = true;
        this.dialogTextMessage = msg;
        this.dialogIcon = icon;
        this.dialogTimeoutMode = 1;
        this.dialogTimeoutMs = timeoutMs;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void showDialogInfo(String[] msg, boolean useTimeout, boolean doViewUpdate) {
        this.dialogVisible = true;
        this.dialogTextMessage = msg;
        this.dialogTimeoutMode = useTimeout ? 0 : 2;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void showTextAndWait(String[] msg, boolean doViewUpdate) {
        if (!this.isTextTimeoutActive()) {
            this.showText(msg, doViewUpdate);
            this.setTextTimeoutActive(true);
            int timeout = TextManager.getTextTimeoutMs(msg.length);
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.setTextTimeoutActive(false);
            this.hideText(doViewUpdate);
        }
    }

    public void showAlert(String prompt, String question, int[] commands, boolean doViewUpdate) {
        this.alertVisible = true;
        this.alertTextMessage = prompt;
        this.alertTextQuestion = question;
        this.alertCommands = commands;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void hideAlert(boolean doViewUpdate) {
        this.alertVisible = false;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void showCameraList(String title, int[] options, int[] commands, int selected, boolean doViewUpdate) {
        this.cameraListVisible = true;
        this.cameraListTitle = title;
        this.cameraListOptions = options;
        this.cameraListCommands = commands;
        this.cameraListSelectedOption = selected;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void hideCameraList(boolean doViewUpdate) {
        this.cameraListVisible = false;
        this.cameraListTitle = null;
        this.cameraListOptions = null;
        this.cameraListCommands = null;
        this.cameraListSelectedOption = 0;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void modifyCameraList(boolean infoMsgEnabled, boolean doViewUpdate) {
        this.cameraListUpdater = infoMsgEnabled;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public boolean selectFrame(int frameIndex) {
        boolean result = true;
        Image image = null;
        try {
            image = frameIndex != 0 ? FrameHandler.loadSmallFrame(String.valueOf(frameIndex) + ".png") : null;
            this.showFrame(image, true);
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    public void addKeys(int[] keySet, boolean doViewUpdate) {
        this.softkeysVisible = true;
        this.softkeysArray = keySet;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void removeKeys(boolean doViewUpdate) {
        this.softkeysVisible = false;
        this.softkeysArray = null;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }

    public void requestUpdateViews() {
        int index = 0;
        while (index < this.viewVector.size()) {
            ((ModelListenerInterface)this.viewVector.elementAt(index)).modelUpdate();
            ++index;
        }
    }

    public void setPaintOnlyProgressBar(boolean flag) {
        this.paintOnlyProgressBar = flag;
    }

    public void setSnapshotWaitScreenVisible(boolean waitScreenVisible, boolean doViewUpdate) {
        this.snapshotWaitScreenVisible = waitScreenVisible;
        if (doViewUpdate) {
            this.requestUpdateViews();
        }
    }
}

