/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.view;

import com.nokia.mid.ui.DeviceControl;
import com.sonyericsson.audiopostcard.model.ModelInterface;
import com.sonyericsson.audiopostcard.model.ModelListenerInterface;
import com.sonyericsson.audiopostcard.util.TextManager;
import com.sonyericsson.audiopostcard.view.KeySetInterface;
import com.sonyericsson.audiopostcard.view.ViewEventInterface;
import com.sonyericsson.ui.TextId;
import com.sonyericsson.ui.UIAlert;
import com.sonyericsson.ui.UIIcon;
import com.sonyericsson.ui.UIList;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.control.VideoControl;

public class LayeredCanvas
extends Canvas
implements ModelListenerInterface {
    private KeySetInterface keySetManager;
    private ViewEventInterface viewEventManager;
    private ModelInterface model;
    private int screenWidth;
    private int screenHeight;
    private int[] statusBarBackgroundData;
    private Image backgroundPanel;
    private Image leftArrowIcon;
    private Image rightArrowIcon;
    private Image selfTimerIcon;
    private Image nightModeIcon;
    private boolean softkeysVisible = false;
    private boolean cameraListVisible = false;
    private boolean alertVisible = false;
    private boolean paintOnlyProgressBar = false;
    private int progressBar_X;
    private int progressBar_Y;
    private int progressBar_Width;
    private int progressBar_Height;
    private UIList cameraList = null;
    private int[] cameraListCommands = null;
    private int[] currentSoftkeys = null;
    private boolean snapshotWaitScreenActive = false;
    private Object paintLock = new Object();
    private int[] alertCommands;
    private String alertQuestion;
    private String alertMessage;
    UIAlert dialog;
    private boolean setUpVideo = true;

    public LayeredCanvas(ViewEventInterface viewEventManager, KeySetInterface keySetManager, ModelInterface model) {
        this.keySetManager = keySetManager;
        this.viewEventManager = viewEventManager;
        this.model = model;
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelUpdate() {
        Object object = this.paintLock;
        synchronized (object) {
            try {
                this.getState();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.paintOnlyProgressBar) {
            this.repaint(this.progressBar_X, this.progressBar_Y, this.progressBar_Width, this.progressBar_Height);
        } else {
            this.repaint();
        }
    }

    private void registerVideoComponent(VideoControl videoControl) {
        int overlay = 1;
        try {
            try {
                videoControl.initDisplayMode(1 | overlay << 8, (Object)this);
            }
            catch (IllegalArgumentException e) {
                videoControl.initDisplayMode(1, (Object)this);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void getState() {
        this.paintOnlyProgressBar = this.model.updateSmallAreaOnly();
        if (this.model.isVideoControlUpdated()) {
            this.registerVideoComponent(this.model.getVideoControl());
        }
        if (this.model.isMaximizeRequested()) {
            this.maximize();
        }
        if (this.model.isMinimizeRequested()) {
            this.minimize();
        }
        if (this.model.isPanelVisible() && this.backgroundPanel == null) {
            this.getBackgroundPanel();
        }
        if (this.model.areArrowsVisible()) {
            if (this.leftArrowIcon == null) {
                this.leftArrowIcon = UIIcon.createUIIcon((int)60834);
            }
            if (this.rightArrowIcon == null) {
                this.rightArrowIcon = UIIcon.createUIIcon((int)60836);
            }
        }
        if (this.model.isNightModeIconVisible() && this.nightModeIcon == null) {
            this.nightModeIcon = UIIcon.createUIIcon((int)60476);
        }
        if (this.model.isSelfTimerIconVisible() && this.selfTimerIcon == null) {
            this.selfTimerIcon = UIIcon.createUIIcon((int)60524);
        }
        this.updateSoftkeys();
        this.updateCameraList();
        if (this.model.isDialogVisible()) {
            this.showDialog();
        }
        this.updateAlert();
        if (this.model.isBacklightVisible()) {
            DeviceControl.setLights((int)0, (int)100);
        }
        this.updateSnapshotWaitScreen();
    }

    private void updateCameraList() {
        if (this.model.isCameraListVisible()) {
            if (!this.cameraListVisible) {
                this.showCameraList();
            } else {
                this.modifyCameraList();
            }
        } else if (this.cameraListVisible) {
            this.hideCameraList();
            this.cameraListVisible = false;
        }
    }

    private void showCameraList() {
        if (!this.cameraListVisible) {
            String title = this.model.getCameraListTitle();
            this.cameraListCommands = this.model.getCameraListCommands();
            int selected = this.model.getCameraListSelectedOption();
            int[] options = this.model.getCameraListOptions();
            this.cameraList = new UIList(title, 1);
            int i = 0;
            while (i < options.length) {
                this.cameraList.append(TextId.getString((int)options[i]), null);
                ++i;
            }
            this.cameraList.setSelectedIndex(selected, true);
            int index = 0;
            while (index < this.cameraListCommands.length) {
                this.cameraList.addCommand(this.keySetManager.translateKeyToCommand(this.cameraListCommands[index]));
                ++index;
            }
            this.cameraList.setCommandListener(this.viewEventManager.getCommandListener());
            this.cameraList.setListStateListener(this.viewEventManager.getUIListStateChangedListener());
            this.cameraList.setListHighlightListener(this.viewEventManager.getUIListHighlightChangedListener());
            this.viewEventManager.requestViewSwitch((Displayable)this.cameraList);
            this.cameraListVisible = true;
        }
    }

    private void modifyCameraList() {
        int[] newCommands = this.model.getCameraListCommands();
        int[] removeCommands = this.getCameraListKeys(newCommands, this.cameraListCommands);
        int[] addCommands = this.getCameraListKeys(this.cameraListCommands, newCommands);
        int index = 0;
        while (index < removeCommands.length) {
            this.cameraList.removeCommand(this.keySetManager.translateKeyToCommand(removeCommands[index]));
            ++index;
        }
        index = 0;
        while (index < addCommands.length) {
            this.cameraList.addCommand(this.keySetManager.translateKeyToCommand(addCommands[index]));
            ++index;
        }
        this.cameraListCommands = newCommands;
    }

    private void hideCameraList() {
        this.viewEventManager.requestViewSwitch((Displayable)this);
    }

    private void updateSoftkeys() {
        if (this.model.areSoftkeysVisible()) {
            if (!this.softkeysVisible) {
                try {
                    this.addKeys(this.model.getSoftkeys());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else if (this.softkeysVisible) {
            this.removeCurrentKeys();
            this.softkeysVisible = false;
        }
    }

    private void showDialog() {
        Image icon = this.model.getDialogIcon();
        String[] text = this.model.getDialogMessage();
        int timeout = this.model.getDialogTimeoutMs();
        int timeoutMode = this.model.getDialogTimeoutMode();
        if (icon != null) {
            if (2 == timeoutMode) {
                this.showDialog(text, icon, false);
            } else if (timeoutMode == 0) {
                this.showDialog(text, icon, true);
            } else if (1 == timeoutMode) {
                this.showDialog(text, icon, timeout);
            }
        } else if (timeoutMode == 0) {
            this.showDialogInfo(text, true);
        } else if (2 == timeoutMode) {
            this.showDialogInfo(text, false);
        }
    }

    private void updateAlert() {
        if (this.model.isAlertVisible()) {
            this.showAlert();
            this.alertVisible = true;
        } else if (this.alertVisible) {
            this.hideAlert();
            this.alertVisible = false;
        }
    }

    private void showAlert() {
        int[] commands = this.model.getAlertCommands();
        String question = this.model.getAlertTextQuestion();
        String message = this.model.getAlertTextMessage();
        boolean updatedList = false;
        if (this.alertCommands == null) {
            updatedList = true;
        }
        int index = 0;
        while (index < commands.length && !updatedList) {
            if (!this.containsInList(commands[index], this.alertCommands)) {
                updatedList = true;
            }
            ++index;
        }
        if (!updatedList && question.equals(this.alertQuestion) && message.equals(this.alertMessage)) {
            this.viewEventManager.requestViewSwitch((Displayable)this.dialog);
        } else {
            if (question.length() > 0) {
                message = String.valueOf(message) + "\n\n" + question;
            }
            this.dialog = new UIAlert(message, 4);
            index = 0;
            while (index < commands.length) {
                this.dialog.addCommand(this.keySetManager.translateKeyToCommand(commands[index]));
                ++index;
            }
            this.dialog.setCommandListener(this.viewEventManager.getCommandListener());
            this.viewEventManager.requestViewSwitch((Displayable)this.dialog);
        }
        this.alertCommands = commands;
        this.alertQuestion = question;
        this.alertMessage = message;
    }

    private void hideAlert() {
        this.viewEventManager.requestViewSwitch((Displayable)this);
    }

    private void updateSnapshotWaitScreen() {
        if (this.model.isSnapshotWaitScreenVisible() != this.snapshotWaitScreenActive) {
            if (this.snapshotWaitScreenActive) {
                this.setFullScreenMode(false);
                this.snapshotWaitScreenActive = false;
            } else {
                this.setFullScreenMode(true);
                this.snapshotWaitScreenActive = true;
            }
        }
    }

    private void removeCurrentKeys() {
        int[] keySet = this.currentSoftkeys;
        if (keySet != null) {
            int index = keySet.length - 1;
            while (index >= 0) {
                Command command = this.keySetManager.translateKeyToCommand(keySet[index]);
                if (command != null) {
                    this.removeCommand(command);
                }
                --index;
            }
        }
        this.softkeysVisible = false;
    }

    private void addKeys(int[] keySet) throws IllegalArgumentException {
        if (keySet == null) {
            throw new IllegalArgumentException();
        }
        this.currentSoftkeys = new int[keySet.length];
        int index = 0;
        while (index < keySet.length) {
            this.currentSoftkeys[index] = keySet[index];
            Command command = this.keySetManager.translateKeyToCommand(keySet[index]);
            if (command != null) {
                this.addCommand(command);
            }
            ++index;
        }
        this.softkeysVisible = true;
    }

    public void initialize() {
        this.backgroundPanel = null;
        this.leftArrowIcon = null;
        this.rightArrowIcon = null;
        this.selfTimerIcon = null;
        this.nightModeIcon = null;
        this.softkeysVisible = false;
        this.cameraListVisible = false;
        this.alertVisible = false;
        this.paintOnlyProgressBar = false;
        this.progressBar_X = 0;
        this.progressBar_Y = 0;
        this.progressBar_Width = 0;
        this.progressBar_Height = 0;
        this.cameraList = null;
        this.cameraListCommands = null;
        this.statusBarBackgroundData = new int[this.screenWidth];
        int i = 0;
        while (i < this.screenWidth) {
            this.statusBarBackgroundData[i] = 0x70000000;
            ++i;
        }
        this.removeCurrentKeys();
        this.currentSoftkeys = null;
    }

    private void minimize() {
        this.viewEventManager.requestViewSwitch(null);
    }

    private void maximize() {
        this.viewEventManager.requestViewSwitch((Displayable)this);
    }

    private void getBackgroundPanel() {
        if (this.backgroundPanel == null) {
            this.backgroundPanel = UIIcon.createUIIcon((int)60833);
        }
    }

    private void showDialog(String[] msg, Image icon, boolean useTimeout) {
        int timeout = useTimeout ? (icon != null ? this.getTimeoutMsForText(msg, true) : this.getTimeoutMsForText(msg, false)) : -2;
        if (useTimeout && this.model.isExitAfterDialogEnabled()) {
            this.showDialog(msg, icon, Integer.MAX_VALUE);
            this.requestExitAfterTimeout(timeout);
        } else {
            this.showDialog(msg, icon, timeout);
        }
    }

    private void showDialog(String[] msg, Image icon, int timeoutMs) {
        String text = msg[0];
        int index = 1;
        while (index < msg.length) {
            text = String.valueOf(text) + "\n" + msg[index];
            ++index;
        }
        UIAlert dialog = new UIAlert(text, null, 4);
        dialog.setImage(icon);
        dialog.setTimeout(timeoutMs);
        try {
            this.viewEventManager.requestViewSwitch((Displayable)dialog);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void showDialogInfo(String[] msg, boolean useTimeout) {
        String text = msg[0];
        int index = 1;
        while (index < msg.length) {
            text = String.valueOf(text) + "\n" + msg[index];
            ++index;
        }
        UIAlert dialog = new UIAlert(text, AlertType.INFO, 4);
        int timeout = useTimeout ? this.getTimeoutMsForText(msg, false) : -2;
        dialog.setTimeout(timeout);
        try {
            this.viewEventManager.requestViewSwitch((Displayable)dialog);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics gf) {
        Object object = this.paintLock;
        synchronized (object) {
            try {
                if (this.snapshotWaitScreenActive) {
                    this.drawWaitScreen(gf);
                } else {
                    this.drawCanvas(gf);
                }
                if (this.setUpVideo) {
                    this.viewEventManager.setUpDisplayScreen();
                    this.setUpVideo = false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void drawWaitScreen(Graphics gf) {
        String[] textMessage;
        gf.setColor(93, 93, 93);
        gf.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.model.isTextVisible() && (textMessage = this.model.getTextMessage()) != null) {
            if (this.model.isTextIconVisible()) {
                this.drawText(textMessage, this.model.getTextIcon(), gf);
            } else {
                this.drawText(textMessage, null, gf);
            }
        }
    }

    private void drawCanvas(Graphics gf) {
        String[] textMessage;
        Image snapshot = this.model.getSnapshot();
        Image smallFrame = this.model.getSmallFrame();
        Font font = Font.getFont((int)0);
        gf.setColor(0xFFFFFF);
        gf.setFont(font);
        if (this.model.isPanelVisible()) {
            if (this.backgroundPanel != null) {
                gf.drawImage(this.backgroundPanel, 0, 0, 20);
            }
            gf.setColor(93, 93, 93);
            gf.fillRect(0, 37, this.screenWidth, 4);
        } else {
            gf.setColor(93, 93, 93);
            gf.fillRect(0, 0, this.screenWidth, 41);
        }
        if (this.model.isVideoPanelVisible()) {
            gf.setColor(93, 93, 93);
            gf.fillRect(0, 41, 240, 180);
        }
        gf.setColor(93, 93, 93);
        gf.fillRect(0, 221, this.screenWidth, this.screenHeight - 221);
        if (this.model.isNightModeIconVisible() && this.nightModeIcon != null) {
            gf.drawImage(this.nightModeIcon, 212, 241, 20);
        }
        if (this.model.isSelfTimerIconVisible() && this.selfTimerIcon != null) {
            gf.drawImage(this.selfTimerIcon, 188, 241, 20);
        }
        if (snapshot != null) {
            gf.drawImage(snapshot, 0, 41, 20);
        }
        if (smallFrame != null) {
            gf.drawImage(smallFrame, 0, 41, 20);
        }
        if (this.model.isStatusBarVisible()) {
            this.drawStatusBar(gf);
        }
        if (this.model.isTextVisible() && (textMessage = this.model.getTextMessage()) != null) {
            if (this.model.isTextIconVisible()) {
                this.drawText(textMessage, this.model.getTextIcon(), gf);
            } else {
                this.drawText(textMessage, null, gf);
            }
        }
        if (this.model.areArrowsVisible()) {
            if (this.leftArrowIcon != null) {
                gf.drawImage(this.leftArrowIcon, 4, 114, 20);
            }
            if (this.rightArrowIcon != null) {
                gf.drawImage(this.rightArrowIcon, 236, 114, 24);
            }
        }
    }

    private void drawStatusBar(Graphics gf) {
        try {
            String textMessage;
            Font font = Font.getFont((int)0);
            gf.setFont(font);
            int fontHeight = font.getHeight();
            int dialogSizeX = this.screenWidth;
            int barWidth = this.screenWidth - 8;
            String textTime = this.model.getStatusBarTextTime();
            long audioProgress = this.model.getStatusBarProgressInPercent();
            if (audioProgress < 0L) {
                audioProgress = 0L;
            }
            if (audioProgress > 100L) {
                audioProgress = 100L;
            }
            if ((textMessage = this.model.getStatusBarMessage()) != null) {
                gf.drawRGB(this.statusBarBackgroundData, 0, 0, 0, 197, dialogSizeX, 69, true);
            }
            gf.setColor(0xFFFFFF);
            int currentPosition = 203;
            if (textMessage != null) {
                gf.drawString(textMessage, dialogSizeX / 2, currentPosition, 17);
            }
            currentPosition += fontHeight;
            if (textMessage != null) {
                gf.drawString(textTime, dialogSizeX / 2, currentPosition, 17);
            }
            this.progressBar_X = 0;
            this.progressBar_Y = currentPosition;
            this.progressBar_Width = dialogSizeX - this.progressBar_X;
            gf.drawRect(4, currentPosition += fontHeight, barWidth, 12);
            int progressX = (int)((long)(barWidth - 1) * audioProgress / 100L);
            gf.setColor(255, 128, 0);
            gf.fillRect(5, ++currentPosition, progressX, 11);
            gf.setColor(0);
            gf.fillRect(5 + progressX + 1, currentPosition, barWidth - progressX - 2, 11);
            this.progressBar_Height = this.screenHeight - this.progressBar_Y;
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    private void drawText(String[] msg, Image icon, Graphics gf) {
        Font font = Font.getFont((int)0);
        int textHeight = font.getHeight();
        gf.setColor(0xFFFFFF);
        gf.setFont(font);
        try {
            int currentPosition = this.screenHeight - 20 - textHeight * msg.length;
            int index = 0;
            while (index < msg.length) {
                if (msg[index] != null) {
                    if (index == 0 && icon != null) {
                        int width = font.charsWidth(msg[index].toCharArray(), 0, msg[index].length()) + icon.getWidth();
                        int iconSpace = 4;
                        gf.drawImage(icon, (this.screenWidth - width) / 2, currentPosition, 20);
                        gf.drawString(msg[index], (this.screenWidth - width) / 2 + icon.getWidth() + iconSpace, currentPosition, 20);
                    } else {
                        gf.drawString(msg[index], this.screenWidth / 2, currentPosition, 17);
                    }
                }
                currentPosition += textHeight;
                ++index;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void processKeys(int keyCode) {
        if (-5 == keyCode) {
            this.keySetManager.handleKeyPressed(8);
        } else if (-7 == keyCode) {
            this.keySetManager.handleKeyPressed(9);
        } else if (this.getKeyCode(2) == keyCode) {
            this.keySetManager.handleKeyPressed(0);
        } else if (this.getKeyCode(5) == keyCode) {
            this.keySetManager.handleKeyPressed(1);
        } else if (49 == keyCode) {
            this.keySetManager.handleKeyPressed(4);
        } else if (50 == keyCode) {
            this.keySetManager.handleKeyPressed(5);
        }
    }

    private void processRepeatedKeys(int keyCode) {
        if (this.getKeyCode(1) == keyCode) {
            this.keySetManager.handleKeyPressed(2);
        } else if (this.getKeyCode(6) == keyCode) {
            this.keySetManager.handleKeyPressed(3);
        } else if (-36 == keyCode) {
            this.keySetManager.handleKeyPressed(6);
        } else if (-37 == keyCode) {
            this.keySetManager.handleKeyPressed(7);
        }
    }

    protected void keyPressed(int keyCode) {
        this.processKeys(keyCode);
        this.processRepeatedKeys(keyCode);
    }

    protected void keyRepeated(int keyCode) {
        this.processRepeatedKeys(keyCode);
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    private void requestExitAfterTimeout(int timeoutMs) {
        try {
            Thread.sleep(timeoutMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.viewEventManager.requestExit();
    }

    private int[] getCameraListKeys(int[] oldCommands, int[] newCommands) {
        int[] cameraListKeys = new int[]{};
        int newCommandIndex = 0;
        while (newCommandIndex < newCommands.length) {
            if (!this.containsInList(newCommands[newCommandIndex], oldCommands)) {
                int[] temp = new int[cameraListKeys.length + 1];
                int fill = 0;
                while (fill < cameraListKeys.length) {
                    temp[fill] = cameraListKeys[fill];
                    ++fill;
                }
                temp[temp.length - 1] = newCommands[newCommandIndex];
                cameraListKeys = temp;
            }
            ++newCommandIndex;
        }
        return cameraListKeys;
    }

    protected boolean containsInList(int item, int[] list) {
        int index = 0;
        boolean containsInList = false;
        while (index < list.length && !containsInList) {
            if (item == list[index]) {
                containsInList = true;
            }
            ++index;
        }
        return containsInList;
    }

    protected int getTimeoutMsForText(String[] pictureText, boolean iconVisible) {
        int estimateNbrOfRows = 0;
        if (iconVisible) {
            ++estimateNbrOfRows;
        }
        if (pictureText != null) {
            estimateNbrOfRows += pictureText.length;
            Font font = Font.getFont((int)0);
            int index = 0;
            while (index < pictureText.length) {
                if (pictureText[index] != null) {
                    int width = font.charsWidth(pictureText[index].toCharArray(), 0, pictureText[index].length());
                    estimateNbrOfRows += width / this.screenWidth;
                }
                ++index;
            }
        }
        int estimateTimeMs = TextManager.getTextTimeoutMs(estimateNbrOfRows);
        return estimateTimeMs;
    }
}

