/*
 * Decompiled with CFR 0.152.
 */
import com.sonyericsson.capuchin.FlashCanvas;
import com.sonyericsson.capuchin.FlashDataRequest;
import com.sonyericsson.capuchin.FlashDataRequestListener;
import com.sonyericsson.capuchin.FlashImage;
import com.sonyericsson.capuchin.FlashPlayer;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

public class Quadrapop
extends MIDlet
implements FlashDataRequestListener {
    private FlashPlayer flashPlayer;
    private FlashImage flashImage;
    private myFlashCanvas flashCanvas;
    private PlayerInterface playerInterface;
    private boolean hasAppStarted;

    public Quadrapop() {
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/quadrapop.swf");
            this.flashImage = FlashImage.createImage((InputStream)is, null);
            this.flashImage.setFlashDataRequestListener((FlashDataRequestListener)this);
            this.flashCanvas = new myFlashCanvas(this.flashImage);
            this.flashPlayer = FlashPlayer.createFlashPlayer((FlashImage)this.flashImage, (FlashCanvas)this.flashCanvas);
            this.flashCanvas.setFullScreenMode(true);
            this.playerInterface = new PlayerInterface();
            this.hasAppStarted = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void dataRequested(FlashDataRequest request) {
        String[] args = request.getArgs();
        String commandName = args[0];
        String error = "";
        if (commandName.equals("quit")) {
            this.destroyApp(true);
        } else if (commandName.equals("collectMusic")) {
            this.playerInterface.collectTracks();
        } else if (commandName.equals("downloadTheme")) {
            String themeID = args[1];
            String themeName = args[2];
            request.setProperty("status", Theme.downloadTheme(themeID, themeName));
        } else if (commandName.equals("getAllThemes")) {
            Theme.collectAllThemes();
            request.setProperty("themes", Theme.getThemes());
            request.setProperty("themeTypes", Theme.getThemeTypes());
            request.setProperty("themePaths", Theme.getThemePaths());
            request.setProperty("numThemes", Theme.getNumThemes());
            Theme.initThemeCollection();
        } else if (commandName.equals("installTheme")) {
            String url = args[1];
            request.setProperty("response", Theme.installTheme(url));
        } else if (commandName.equals("clearTheme")) {
            String isInstalled = args[1];
            String theme = args[2];
            if (isInstalled.equals("true")) {
                Theme.deleteInstalledTheme(theme);
                request.setProperty("response", String.valueOf(theme) + " deleted");
            } else {
                Theme.deleteuninstalledTheme(theme);
                request.setProperty("response", String.valueOf(theme) + " deleted");
            }
        } else if (commandName.equals("getThemeExist")) {
            String theme = args[1];
            if (Theme.verifyTheme(theme)) {
                request.setProperty("themeExists", "1");
            } else {
                request.setProperty("themeExists", "0");
            }
        } else if (commandName.equals("isPlaying")) {
            if (this.playerInterface.getIsPlaylistInitialised()) {
                request.setProperty("isPlaying", "true");
            } else {
                request.setProperty("isPlaying", "false");
            }
        } else if (commandName.equals("trackCount")) {
            int trackCount = this.playerInterface.getTrackCount();
            request.setProperty("trackCount", trackCount);
        } else if (commandName.equals("play")) {
            int number = Integer.parseInt(args[1]);
            error = this.playerInterface.playTrack(number);
        } else if (commandName.equals("playQuadrapop")) {
            this.playerInterface.playQuadrapop();
        } else if (commandName.equals("stop")) {
            error = this.playerInterface.stop();
        } else if (commandName.equals("pause")) {
            error = this.playerInterface.pause();
        } else if (commandName.equals("info")) {
            String url = args[1];
            String[] info = this.playerInterface.getInfo(url);
            request.setProperty("url", info[0]);
            request.setProperty("title", info[1]);
            request.setProperty("album", info[2]);
            request.setProperty("artist", info[3]);
        } else if (commandName.equals("artists")) {
            if (args.length == 1) {
                request.setProperty("returnString", this.playerInterface.getArtists());
                request.setProperty("count", this.playerInterface.getArtistCount());
            } else if (args.length == 3) {
                int startIndex = Integer.parseInt(args[1]);
                int count = Integer.parseInt(args[2]);
                request.setProperty("returnString", this.playerInterface.getArtists(startIndex, count));
                request.setProperty("count", this.playerInterface.getArtistCount());
            } else {
                error = "command syntax: artists [startIndex count]";
            }
        } else if (commandName.equals("albums")) {
            String returnString = "";
            int returnCount = 0;
            if (args.length == 1) {
                returnString = this.playerInterface.getAlbums();
                returnCount = this.playerInterface.getAlbumCount();
            } else if (args.length == 2) {
                String artist = args[1];
                returnString = this.playerInterface.getAlbums(artist);
                returnCount = this.playerInterface.getAlbumCount(artist);
            } else if (args.length == 3) {
                int startIndex = Integer.parseInt(args[1]);
                int count = Integer.parseInt(args[2]);
                returnString = this.playerInterface.getAlbums(startIndex, count);
                returnCount = this.playerInterface.getAlbumCount();
            } else if (args.length == 4) {
                String artist = args[1];
                int startIndex = Integer.parseInt(args[2]);
                int count = Integer.parseInt(args[3]);
                returnString = this.playerInterface.getAlbums(artist, startIndex, count);
                returnCount = this.playerInterface.getAlbumCount(artist);
            }
            request.setProperty("returnString", returnString);
            request.setProperty("count", returnCount);
        } else if (commandName.equals("tracks")) {
            String returnString = "";
            String filePaths = "";
            int returnCount = 0;
            switch (args.length) {
                case 1: {
                    returnString = this.playerInterface.getTracks();
                    break;
                }
                case 2: {
                    String filter = args[1];
                    if (filter.startsWith("album:")) {
                        String album = filter.substring("album:".length());
                        returnString = this.playerInterface.getTracksByAlbum(album);
                        break;
                    }
                    if (filter.startsWith("artist:")) {
                        String artist = filter.substring("artist:".length());
                        returnString = this.playerInterface.getTracksByArtist(artist);
                        break;
                    }
                    error = "Filter must start with album: or artist:";
                    break;
                }
                case 3: {
                    int startIndex = Integer.parseInt(args[1]);
                    int count = Integer.parseInt(args[2]);
                    returnString = this.playerInterface.getTracks(startIndex, count);
                    break;
                }
                case 4: {
                    String filter = args[1];
                    int startIndex = Integer.parseInt(args[2]);
                    int count = Integer.parseInt(args[3]);
                    if (filter.startsWith("album:")) {
                        String album = filter.substring("album:".length());
                        returnString = this.playerInterface.getTracksByAlbum(album, startIndex, count);
                        break;
                    }
                    if (filter.startsWith("artist:")) {
                        String artist = filter.substring("artist:".length());
                        returnString = this.playerInterface.getTracksByArtist(artist, startIndex, count);
                        break;
                    }
                    error = "Filter must start with album: or artist:";
                    break;
                }
                default: {
                    error = "command syntax: tracks [startIndex count]";
                }
            }
            returnCount = this.playerInterface.getPlaylistLength();
            filePaths = this.playerInterface.getPlaylistUrls();
            request.setProperty("returnString", returnString);
            request.setProperty("filePath", filePaths);
            request.setProperty("count", returnCount);
        }
        if (error.length() > 0) {
            request.setProperty("error", error);
        }
        request.complete();
    }

    protected void startApp() {
        if (!this.hasAppStarted) {
            Theme.checkThemeFolder();
            if (this.flashPlayer != null) {
                Display.getDisplay((MIDlet)this).setCurrent(this.flashPlayer.getDisplayable());
            }
            this.hasAppStarted = true;
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean arg0) {
        this.notifyDestroyed();
    }

    public class myFlashCanvas
    extends FlashCanvas {
        public myFlashCanvas(FlashImage image) {
            super(image);
        }

        protected void hideNotify() {
            if (Quadrapop.this.playerInterface.isTrackPlaying()) {
                Quadrapop.this.playerInterface.pause();
                Quadrapop.this.playerInterface.setTrackSleeping(true);
            }
        }

        protected void showNotify() {
            if (Quadrapop.this.playerInterface.getTrackSleeping()) {
                Quadrapop.this.playerInterface.pause();
                Quadrapop.this.playerInterface.setTrackSleeping(false);
            }
        }
    }
}

