/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;

public class Theme {
    private static final String INSTALLED_THEMES_FOLDER = "file:///c:/other/quadrapop/";
    private static String themesStr;
    private static String themesTypeStr;
    private static String themesPathStr;
    private static int themeCounter;

    public static void initThemeCollection() {
        themesStr = "";
        themesTypeStr = "";
        themesPathStr = "";
        themeCounter = 0;
    }

    public static void collectAllThemes() {
        Theme.initThemeCollection();
        Theme.collectInstalledThemes();
        Theme.collectuninstalledThemes();
    }

    private static void collectInstalledThemes() {
        String dirName = "file:///c:/other/quadrapop/themes/";
        try {
            FileConnection dir = (FileConnection)Connector.open((String)dirName);
            if (!dir.exists()) {
                return;
            }
            Enumeration children = dir.list();
            while (children.hasMoreElements()) {
                String currentElement = Theme.removeLastChars((String)children.nextElement(), 1);
                if (!Theme.verifyTheme(currentElement)) continue;
                themesStr = String.valueOf(themesStr) + currentElement + "|";
                themesTypeStr = String.valueOf(themesTypeStr) + "true|";
                themesPathStr = String.valueOf(themesPathStr) + "|";
                ++themeCounter;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private static void collectuninstalledThemes() {
        Enumeration roots = FileSystemRegistry.listRoots();
        while (roots.hasMoreElements()) {
            String root = (String)roots.nextElement();
            String dirName = "file:///" + root;
            Theme.collectChildFiles(dirName);
        }
    }

    private static void collectChildFiles(String dirUrl) {
        if (!dirUrl.equals(INSTALLED_THEMES_FOLDER)) {
            try {
                FileConnection dir = (FileConnection)Connector.open((String)dirUrl);
                if (!dir.exists()) {
                    return;
                }
                Enumeration children = dir.list();
                while (children.hasMoreElements()) {
                    String childName = (String)children.nextElement();
                    String childUrl = String.valueOf(dirUrl) + childName;
                    if (childName.endsWith("/")) {
                        Theme.collectChildFiles(childUrl);
                        continue;
                    }
                    if (!childName.endsWith(".qth")) continue;
                    themesStr = String.valueOf(themesStr) + Theme.removeLastChars(childName, 4) + "|";
                    themesTypeStr = String.valueOf(themesTypeStr) + "false|";
                    themesPathStr = String.valueOf(themesPathStr) + Theme.removeFirstChars(childUrl, 8) + "|";
                    ++themeCounter;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public static void checkThemeFolder() {
        block4: {
            String newDirName = INSTALLED_THEMES_FOLDER;
            try {
                FileConnection newDir = (FileConnection)Connector.open((String)newDirName);
                if (newDir.exists()) break block4;
                newDir.mkdir();
                newDirName = String.valueOf(newDirName) + "themes/";
                try {
                    newDir = (FileConnection)Connector.open((String)newDirName);
                    newDir.mkdir();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public static String installTheme(String url) {
        int lastFolderSymbolIndex = url.lastIndexOf(47) + 1;
        String themeName = Theme.removeLastChars(url, 4);
        themeName = Theme.removeFirstChars(themeName, lastFolderSymbolIndex);
        String newDirName = "file:///c:/other/quadrapop/themes/" + themeName + "/";
        try {
            FileConnection newDir = (FileConnection)Connector.open((String)newDirName);
            FileConnection originalFile = (FileConnection)Connector.open((String)("file:///" + url));
            if (newDir.exists()) {
                newDirName = Theme.validateFolderExistence(Theme.removeLastChars(newDirName, 1));
                newDir = (FileConnection)Connector.open((String)newDirName);
                lastFolderSymbolIndex = newDirName.lastIndexOf(47) + 1;
                themeName = Theme.removeFirstChars(newDirName, lastFolderSymbolIndex);
            }
            newDir.mkdir();
            Theme.copyFile("file:///" + url, String.valueOf(newDirName) + "/theme.qth");
            originalFile.delete();
            return themeName;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "error";
        }
    }

    public static void deleteInstalledTheme(String theme) {
        block5: {
            String themeFile = "file:///c:/other/quadrapop/themes/" + theme + "/theme.qth";
            String themeDir = "file:///c:/other/quadrapop/themes/" + theme + "/";
            try {
                FileConnection themeFiles = (FileConnection)Connector.open((String)themeFile);
                if (!themeFiles.exists()) break block5;
                themeFiles.delete();
                try {
                    themeFiles = (FileConnection)Connector.open((String)themeDir);
                    if (themeFiles.exists()) {
                        themeFiles.delete();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public static void deleteuninstalledTheme(String path) {
        String url = "file:///" + path;
        try {
            FileConnection uninstalledTheme = (FileConnection)Connector.open((String)url);
            if (uninstalledTheme.exists()) {
                uninstalledTheme.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static boolean verifyTheme(String theme) {
        String themeFile = "file:///c:/other/quadrapop/themes/" + theme + "/theme.qth";
        try {
            FileConnection themeFiles = (FileConnection)Connector.open((String)themeFile);
            return themeFiles.exists();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void copyFile(String oldFile, String newFile) {
        try {
            int ch;
            FileConnection fci = (FileConnection)Connector.open((String)oldFile);
            FileConnection fco = (FileConnection)Connector.open((String)newFile);
            fco.create();
            InputStream is = fci.openInputStream();
            OutputStream os = fco.openOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            os.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private static String removeFirstChars(String a, int numChars) {
        int lastCharIndex = a.length();
        return a.substring(numChars, lastCharIndex);
    }

    private static String removeLastChars(String a, int numChars) {
        int lastCharIndex = a.length() - numChars;
        return a.substring(0, lastCharIndex);
    }

    public static String getThemes() {
        if (themesStr.equals("")) {
            return themesStr;
        }
        return Theme.removeLastChars(themesStr, 1);
    }

    public static String getThemeTypes() {
        if (themesTypeStr.equals("")) {
            return themesTypeStr;
        }
        return Theme.removeLastChars(themesTypeStr, 1);
    }

    public static String getThemePaths() {
        if (themesPathStr.equals("")) {
            return themesPathStr;
        }
        return Theme.removeLastChars(themesPathStr, 1);
    }

    public static int getNumThemes() {
        return themeCounter;
    }

    private static String validateFileExistence(String themeName) {
        String validFile = "Error";
        try {
            FileConnection tempFco = (FileConnection)Connector.open((String)(String.valueOf(themeName) + ".qth"));
            boolean doesFileExist = true;
            int counter = 1;
            do {
                String copyIncrement = "(" + counter + ")";
                tempFco = (FileConnection)Connector.open((String)(String.valueOf(themeName) + copyIncrement + ".qth"));
                if (!tempFco.exists()) {
                    doesFileExist = false;
                    validFile = String.valueOf(themeName) + copyIncrement + ".qth";
                }
                ++counter;
            } while (doesFileExist);
            return validFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return validFile;
        }
    }

    private static String validateFolderExistence(String url) {
        String validFolder = "Error";
        try {
            boolean doesFolderExist = true;
            int counter = 1;
            do {
                String copyIncrement = "(" + counter + ")";
                FileConnection tempFco = (FileConnection)Connector.open((String)(String.valueOf(url) + copyIncrement + "/"));
                if (!tempFco.exists()) {
                    doesFolderExist = false;
                    validFolder = String.valueOf(url) + copyIncrement;
                }
                ++counter;
            } while (doesFolderExist);
            return validFolder;
        }
        catch (IOException e) {
            e.printStackTrace();
            return validFolder;
        }
    }

    public static String downloadTheme(String id, String name) {
        HttpConnection http = null;
        InputStream iStrm = null;
        OutputStream os = null;
        String url = "http://www.blueskynorth.com/sonyericsson/Quadrapop/theme_browser/themes/theme" + id + ".qth";
        String newFile = "file:///c:/other/" + name;
        String returnedData = "error";
        try {
            http = (HttpConnection)Connector.open((String)url);
            http.setRequestMethod("GET");
            http.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Configuration/CLDC-1.0");
            if (http.getResponseCode() == 200) {
                int ch;
                FileConnection fco = (FileConnection)Connector.open((String)(String.valueOf(newFile) + ".qth"));
                if (fco.exists()) {
                    newFile = Theme.validateFileExistence(newFile);
                    fco = (FileConnection)Connector.open((String)newFile);
                }
                fco.create();
                iStrm = http.openInputStream();
                os = fco.openOutputStream();
                while ((ch = iStrm.read()) != -1) {
                    os.write(ch);
                }
                returnedData = "success";
            }
            String string = returnedData;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = returnedData = e.getMessage();
            return string;
        }
        finally {
            try {
                http.close();
                iStrm.close();
                os.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

