;---------------------------------------------------------------------
;                      ::::::: CGSN v1.0 :::::::
;---------------------------------------------------------------------
;                      ::::::: E200XEGD6 :::::::
;---------------------------------------------------------------------
;  Samsung SGH-E200: (c) 2007 dimastyj
; (d900): (c) 2007 AlexeyK
;---------------------------------------------------------------------
.patchname "CGSN"
.group ""
.ver 1.0
;---------------------------------------------------------------------

.binid E200XEGD6
.baseload 0x20000000
.little
.include d:\samsung_mobile_phone\e200\firmwares\E200XEGD6\E200XEGD6_api.h

.equ atp6_7CGSNCommand 0x20D9BA9C
.equ j_atp3_200SendDataReq 0x2118BB54
.equ s_atp_CurrentCommandInfo 0x304D87D4
.equ a_atp_Result 0x304D7734

;---------------------------------------------------------------------

.patchinfo "CGSN .      ,    RAM,    HEX ,    MCC."
.patchinfo ""
.patchinfo "  :"
.patchinfo "AT+CGSN -  IMEI ;"
.patchinfo "AT+CGSN=0,XXXXXXXX,YYYY -     XXXXXXXX  YYYY;"
.patchinfo "AT+CGSN=1,XXXXXXXX,YYYYYYY... -   YYYYYYYY...   XXXXXXXX;"
.patchinfo "AT+CGSN=2,XXXXXXXX,YYYYYYYY,ZZZZZZZZ -   ZZZZZ...   XXXXXXXX    YYYYYYYY;"
.patchinfo "AT+CGSN=3 -    MCC ."

.start 0x2031B030
	.word StartMyCGSN+1

.start 0x2031F4F8
	.byte 29 ;    

.start 0x204F4818 ; 0x1051D640
	b 0x204F4842 ;    

.start 0x2162B2EA ; 0x111C65AA
	b 0x2162B306 ;      ,     

.start 0x210763A8
StartMyCGSN:
	push {R1-R4,R7,LR}
	ldr r4,=s_atp_CurrentCommandInfo
	ldrb r0,[R4,3]
	cmp r0,0
	bne MyCGSN1
	bl atp6_7CGSNCommand
	b MyCGSNExit
MyCGSN1:
	ldr r7,[r4,16]
	ldrb r7,[r7]
	sub r7,'0'
	ldr r0,[r4,24]
	ldrb r1,[r4,20]
	bl HextoLong
	.caseb r7,MyCGSNExit1,ReadMem,WriteMem,FindMem,GetMccAdrr
ReadMem:
	mov r3,r0
	ldrb r1,[r4,28]
	ldr r0,[r4,32]
	bl HextoLong
	mov r2,r0
	mov r0,r3
	ldr r1,=a_atp_Result
	ldr r1,[r1]
	bl BinaryToHexString
	lsl r0,r2,1
	blx j_atp3_200SendDataReq
	b MyCGSNExit1
WriteMem:
	ldrb r2,[r4,28]
	sub r2,1
	lsr r2,1
	ldr r1,[r4,32]
	bl HexStringToBinary
	b MyCGSN2
FindMem:
	bl FindData
	b MyCGSN2
GetMccAdrr:
	ldr r0,=gs_look
	ldr r0,r0,16
MyCGSN2:
	ldr r1,=a_atp_Result
	ldr r1,[r1]
	bl LongtoHex
	mov r0,8
	blx j_atp3_200SendDataReq
MyCGSNExit1:
	mov R0,0 ;       R0  ,    R0=0
MyCGSNExit:
	pop {R1-R4,R7,Pc}

BinaryToHexString:	;    hex 
; R0 -   , R1 -   , R2 -  
	push {R0-R5}
	add r2,1
bhs_do:
	ldrb r4,[r0]
	lsr r5,r4,4
	cmp r5,10
	blt bhs_1
	add r5,7
bhs_1:
	add r5,'0'
	strb r5,[r1]
	lsl r5,r4,28
	lsr r5,r5,28
	cmp r5,10
	blt bhs_2
	add r5,7
bhs_2:
	add r5,'0'
	strb r5,[r1,1]
	add r0,1
	add r1,2
	sub r2,1
	cmp r2,0
	bhi bhs_do
	pop {R0-R5}
	bx lr

HexStringToBinary: ; Hex   
;R0 -  , R1 -    Hex , R2 -  
	push {R1-R5}
	add r2,1
hsb_do:
	ldrb r3,[r1]
	cmp r3,'?' ;   ?
	bne hsb_next1
	strb r3,[r0]
	lsr r3,4
	b hsb1
hsb_next1:
	cmp r3,64
	blt hsb1 ;   "0"-"9"
	add r3,9
hsb1:
	lsl r3,28
	lsr r4,r3,24
	ldrb r3,[r1,1]
	cmp r3,'?' ;       ?
	bne hsb_next2
	strb r3,[r0]
	b hsb2
hsb_next2:
	cmp r3,64
	blt hsb2 ;   "0"-"9"
	add r3,9
hsb2:
	lsl r3,28
	lsr r3,28
	orr r4,r3
	strb r4,[r0]
	add r0,1
	add r1,2
	sub r2,1
	cmp r2,0
	bhi hsb_do
	pop {R1-R5}
	bx lr

FindData:
	push 	{r1-r7,lr}
	mov 	r7, r0	; r7 -    
	ldr		R4, =s_atp_CurrentCommandInfo
	ldrb 	R1,[R4,28]
	ldr 	R0,[R4,32]
	bl		HextoLong
	mov 	r2, r0	; r2 -  
	add		r4,36	; r4+4 -      
	ldr		r1,[r4,4] ; r1 -   
	ldrb 	r3,[r4]	; r3 -      
	lsr 	r3,1
	sub		r2,r3
fd_1:	
	mov		r3,0
fd_2:
	lsr 	r6,r3,1
	ldrb 	r5,[r7,r6]
	bcs 	fd_3;   not C
	lsr 	r5,4;   
fd_3:
	ldrb 	r6,[r1,r3]
	cmp 	r6,'?';       ?
	beq 	fd_next
	cmp 	r6,64
	blt 	fd_4 ;   "0"-"9"
	add 	r6, 9
fd_4:
	lsl 	r6,28
;	lsr 	r6,28
	lsl 	r5,28
;	lsr 	r5,28
	cmp 	r5,r6 
	bne		fd_5
fd_next:	
	ldrb 	r6,[r4]	; r3 -      
	sub		r6,1
	cmp		r3,r6
	beq 		fd_exit ;     R7
	add		r3,1
	b 	fd_2;  ,    
fd_5:
	add		r7,1		
	sub 	r2,1
	cmp 	r2,0
	bpl 	fd_1
	mov 	r7,0
fd_exit:	
	mov		r0,r7
	pop {r1-r7,pc}

HextoLong: ;    
; R0-   , R1- .
;  R0- 
	push {r2,r3,lr}
	mov r2,r0
	mov r0,0
htl1:
	cmp r1,0
	beq ExitHextoLong
	ldrb r3,[r2]
	cmp R3,0
	beq ExitHextoLong ;    
	cmp r3,64
	blt metka_htl ;   "0"-"9"
	add r3, 9
metka_htl:
	lsl r3,28
	lsr r3,28
	lsl r0,4
	orr r0,r3
	sub r1,1
	add r2,1
	b htl1
ExitHextoLong:
	pop {r2,r3,pc}

LongtoHex: ;   Hex 
; R0 - , R1 -     Hex .
	push 	{r2-r3}
	mov 	r2,7
lth2:
	lsl 	r3,r0,28
	lsr 	r3,r3,28
	cmp 	r3,10
	blt 	lth1
	add 	r3,7
lth1:
	add 	r3,'0'
	strb 	r3,[r1,r2]
	cmp 	r2,0
	beq 	lth3
	sub 	r2,1
	lsr 	r0,4
	b 		lth2
lth3:
	pop 	{r2-r3}
	bx 		lr
 .data

;---------------------------------------------------------------------
