#!/sbin/ash

DEVICE="/dev/stl10"
DIR="/efs"
SD_PATH="/sdcard"
BACKUP_DIR=${SD_PATH}"/samdroid"
BACKUP_FILE=${BACKUP_DIR}"/efs_restore.tar"

# Make sure SD card is mounted
grep ${SD_PATH} /proc/mounts
if [ $? -ne 0 ]; then
	echo "SD card is not mounted. Aborting. (Is SD card present?)"
	exit 1
fi

# Make sure backup directory is present
mkdir ${BACKUP_DIR}

# Mount EFS if not mounted
grep ${DIR} /proc/mounts
if [ $? -ne 0 ]; then
	mount -t rfs -o rw,nosuid,nodev,codepage=utf8,xattr,check=no ${DEVICE} ${DIR}
	if [ $? -ne 0 ]; then
		mount -t ext4 -o rw,nosuid,nodev,noatime,nodiratime,barrier=1,data=ordered ${DEVICE} ${DIR}
	fi
	if [ $? -ne 0 ]; then
		mount -t ext2 -o rw,noatime,nodiratime,nodev,nosuid ${DEVICE} ${DIR}
	fi
	if [ $? -ne 0 ]; then
		echo "Failed to mount EFS partition. Aborting. (EFS broken?)"
		exit 1
	fi
fi

# Remove old backup if present
if [ -e ${BACKUP_FILE} ]; then
	rm -f ${BACKUP_FILE}
fi;

# Create EFS backup
tar -cpf ${BACKUP_FILE} -C ${DIR} . --exclude ?RFS_LOG.LO?
if [ $? -ne 0 ]; then
	echo "Failed to create EFS backup. (Not enough space on card?)"
	exit 1
fi

# Unmount EFS partition
umount $DIR

# Sync file systems
sync
