// DumpDialog.cpp : implementation file
//

#include "stdafx.h"
#include "cabrio_downloaderv01.h"
#include "DumpDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDumpDialog dialog


CDumpDialog::CDumpDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CDumpDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDumpDialog)
	m_tOffset = 0;
	m_tBlocknum = 0;
	m_tPagenum = 0;
	m_fPagenum = 0;
	m_fOffset = 0;
	m_fBlocknum = 0;
	//}}AFX_DATA_INIT
}


void CDumpDialog::DoDataExchange(CDataExchange* pDX)
{
	
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDumpDialog)


	DDX_Control(pDX, IDC_EDIT_FHEX, m_editfHex);
	DDX_Control(pDX, IDC_EDIT_THEX, m_edittHex);
	
	DDX_Text(pDX, IDC_EDIT_FBLOCKNUM, m_fBlocknum);
	DDV_MinMaxUInt(pDX, m_fBlocknum, 0, 4015);

	DDX_Text(pDX, IDC_EDIT_FPAGENUM, m_fPagenum);
	DDV_MinMaxUInt(pDX, m_fPagenum, 0, 31);
	DDX_Text(pDX, IDC_EDIT_FOFFSET, m_fOffset);
	DDV_MinMaxUInt(pDX, m_fOffset,0, 511);


	


	DDX_Text(pDX, IDC_EDIT_TBLOCKNUM, m_tBlocknum);
	DDV_MinMaxUInt(pDX, m_tBlocknum, m_fBlocknum, 4015);

	//   ó
	if (m_tBlocknum==m_fBlocknum)
	{
		//BLOCK PAGE  
	    //  O    X      
		DDX_Text(pDX, IDC_EDIT_TPAGENUM, m_tPagenum);
		DDV_MinMaxUInt(pDX, m_tPagenum, m_fPagenum, 31);
	
		if (m_tPagenum==m_fPagenum)
		{
			//BLOCK PAGE  OFFSET 
			//  O    O      X
			DDX_Text(pDX, IDC_EDIT_TOFFSET, m_tOffset);
			DDV_MinMaxUInt(pDX, m_tOffset, m_fOffset+1, 511);
		}
		else 
		{	
			//BLOCK PAGE  OFFSET 
		    //  O    X      X
			DDX_Text(pDX, IDC_EDIT_TOFFSET, m_tOffset);
			DDV_MinMaxUInt(pDX, m_tOffset, 0 , 511);
		}
	}
	else
	{
		//BLOCK PAGE  OFFSET 
		//  X    X      X
		DDX_Text(pDX, IDC_EDIT_TPAGENUM, m_tPagenum);
		DDV_MinMaxUInt(pDX, m_tPagenum, 0, 31);
		DDX_Text(pDX, IDC_EDIT_TOFFSET, m_tOffset);
		DDV_MinMaxUInt(pDX, m_tOffset, 0, 511);
	}
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDumpDialog, CDialog)
	//{{AFX_MSG_MAP(CDumpDialog)
	ON_EN_CHANGE(IDC_EDIT_FBLOCKNUM, OnChangeEditFblocknum)
	ON_EN_CHANGE(IDC_EDIT_FPAGENUM, OnChangeEditFpagenum)
	ON_EN_CHANGE(IDC_EDIT_FOFFSET, OnChangeEditFoffset)
	ON_EN_CHANGE(IDC_EDIT_TBLOCKNUM, OnChangeEditTblocknum)
	ON_EN_CHANGE(IDC_EDIT_TPAGENUM, OnChangeEditTpagenum)
	ON_EN_CHANGE(IDC_EDIT_TOFFSET, OnChangeEditToffset)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDumpDialog message handlers

void CDumpDialog::OnChangeEditFblocknum() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here


	m_fBlocknum = GetDlgItemInt(IDC_EDIT_FBLOCKNUM);
	if (m_fBlocknum>4015)
		m_fBlocknum=4015;

	m_fPagenum = GetDlgItemInt(IDC_EDIT_FPAGENUM);
	if (m_fPagenum>31)
		m_fPagenum=31;

	m_fOffset = GetDlgItemInt(IDC_EDIT_FOFFSET);
	if (m_fOffset>511)
		m_fOffset=511;

	CString str;
	str.Format("0x%lx",m_fBlocknum*512*32+m_fPagenum*512+m_fOffset);
	Show(str,1);




	
}

void CDumpDialog::OnChangeEditFpagenum() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
//	UpdateData(true);
	
	m_fBlocknum = GetDlgItemInt(IDC_EDIT_FBLOCKNUM);
	if (m_fBlocknum>4015)
		m_fBlocknum=4015;

	m_fPagenum = GetDlgItemInt(IDC_EDIT_FPAGENUM);
	if (m_fPagenum>31)
		m_fPagenum=31;

	m_fOffset = GetDlgItemInt(IDC_EDIT_FOFFSET);
	if (m_fOffset>511)
		m_fOffset=511;

	CString str;
	str.Format("0x%lx",m_fBlocknum*512*32+m_fPagenum*512+m_fOffset);
	Show(str,1);
	
}

void CDumpDialog::OnChangeEditFoffset() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here

	m_fBlocknum = GetDlgItemInt(IDC_EDIT_FBLOCKNUM);
	if (m_fBlocknum>4015)
		m_fBlocknum=4015;

	m_fPagenum = GetDlgItemInt(IDC_EDIT_FPAGENUM);
	if (m_fPagenum>31)
		m_fPagenum=31;

	m_fOffset = GetDlgItemInt(IDC_EDIT_FOFFSET);
	if (m_fOffset>511)
		m_fOffset=511;

	CString str;
	str.Format("0x%lx",m_fBlocknum*512*32+m_fPagenum*512+m_fOffset);
	Show(str,1);
	
}

void CDumpDialog::OnChangeEditTblocknum() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	//	UpdateData(true);

	m_tBlocknum = GetDlgItemInt(IDC_EDIT_TBLOCKNUM);
	if (m_tBlocknum>4015)
		m_tBlocknum=4015;

	m_tPagenum = GetDlgItemInt(IDC_EDIT_TPAGENUM);
	if (m_tPagenum>31)
		m_tPagenum=31;

	m_tOffset = GetDlgItemInt(IDC_EDIT_TOFFSET);
	if (m_tOffset>511)
		m_tOffset=511;

	CString str;
	str.Format("0x%lx",m_tBlocknum*512*32+m_tPagenum*512+m_tOffset);
	Show(str,2);
	
}

void CDumpDialog::OnChangeEditTpagenum() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here

	m_tBlocknum = GetDlgItemInt(IDC_EDIT_TBLOCKNUM);
	if (m_tBlocknum>4015)
		m_tBlocknum=4015;

	m_tPagenum = GetDlgItemInt(IDC_EDIT_TPAGENUM);
	if (m_tPagenum>31)
		m_tPagenum=31;

	m_tOffset = GetDlgItemInt(IDC_EDIT_TOFFSET);
	if (m_tOffset>511)
		m_tOffset=511;

	CString str;
	str.Format("0x%lx",m_tBlocknum*512*32+m_tPagenum*512+m_tOffset);
	Show(str,2);
	
}

void CDumpDialog::OnChangeEditToffset() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here

	m_tBlocknum = GetDlgItemInt(IDC_EDIT_TBLOCKNUM);
	if (m_tBlocknum>4015)
		m_tBlocknum=4015;

	m_tPagenum = GetDlgItemInt(IDC_EDIT_TPAGENUM);
	if (m_tPagenum>31)
		m_tPagenum=31;

	m_tOffset = GetDlgItemInt(IDC_EDIT_TOFFSET);
	if (m_tOffset>511)
		m_tOffset=511;

	CString str;
	str.Format("0x%lx",m_tBlocknum*512*32+m_tPagenum*512+m_tOffset);
	Show(str,2);
	
}

void CDumpDialog::Show(CString str,int i)
{
	CString temp;

	if (i==1)
	{
		m_editfHex.SetFocus();

		str=str+"\r";
		m_editfHex.SetSel(0, -1);
		m_editfHex.ReplaceSel( str );
	}
	if (i==2)
	{
			m_editfHex.SetFocus();

		str=str+"\r";
		m_edittHex.SetSel(0, -1);
		m_edittHex.ReplaceSel( str );
	}
}
