//
#define MYBUFF_SIZE	256
#define NUM_NOR_SECTOR	262+1
#define SIZE_OF_SMALL_SECTOR (32*1024)
#define SIZE_OF_LARGE_SECTOR (2*64*1024)
#define SIZE_OF_PAGE		 512

#define ENTIRE_FLASH_SIZE	0x2A69000

#define LOADER_SRAM_ADDRESS		0x6200000
#define BLOCK_LENGTH			0x8000

//NOR component
#define DWL_IMGSET		0x10
#define DWL_RSRC2		0x13
#define DWL_FACTORYFS	0x14
#define DWL_CALSET		0x11
#define DWL_MANUAL		0x16

//NAND component
#define DWL_RSRC1		0x12
#define DWL_RSRC2		0x13
#define DWL_FACTORYFS	0x14
#define DWL_ALL			0x15
#define DWL_ALL2			0x74
#define DWL_FLASHALL		0x1A
#define DWL_MANUAL_NAND	0x30
#define DWL_BOOT1		0x71
#define DWL_BOOT2		0x72
#define DWL_BOOT3		0x73
#define DWL_BOOT4		0x74

#define OP_FORMAT		0x17
#define OP_NAND_ERASE		0x18
#define OP_ERASE_BOOTLOADER	0x19
#define OP_NOR_ERASE		0x20
#define OP_NOR_DUMP			0x1B
#define OP_NAND_DUMP		0x1C

//Driver type
#define DRV_NAND		0x20
#define DRV_PREBOOT     0x21
#define DRV_NOR			0x22
#define DRV_BOOTLOADER	0x23


/*Nadia

#define IMGSET_START_ADDR		0x10000
#define	IMGSET_END_ADDR			0x1EFFFFF
#define CALSET_START_ADDR		0x1F40000
#define CALSET_END_ADDR			0x1F5FFFF


#define RSRC1_START_ADDR		0x0
#define RSRC1_END_ADDR			0x117FFFF
#define RSRC2_START_ADDR		0x1180000
#define RSRC2_END_ADDR			0x137FFFF
#define FACTORYFS_START_ADDR	0x1380000
#define FACTORYFS_END_ADDR		0x147FFFF
#define TFS_START_ADDR			0x1540000
#define TFS_END_ADDR			0x3E5FFFF

Nadia*/

#define IMGSET_ONLY				0x0
#define IMGSET_RSRC				0x1
#define IMGSET_RSRC_CALSET		0x2
#define RSRC_ONLY				0x3
#define RSRC_CALSET				0x4
#define CALSET_ONLY				0x5
#define RSRC2_ONLY				0x6
#define FFS_ONLY				0x7

#define IMGSET_START_ADDR		0x04A0000
#define	IMGSET_END_ADDR			0x36DFFFF
#define RSRC2_START_ADDR		0x04600000
#define RSRC2_END_ADDR			0x05000000
#define FACTORYFS_START_ADDR	0xCC0000
#define FACTORYFS_END_ADDR		0xDBFFFF
#define CALSET_START_ADDR		0x0240000
#define CALSET_END_ADDR			0x025ffff
#define TFSCHECK_START_ADDR		0x36E0000
#define	TFSCHECK_END_ADDR		0x36FFFFF

#define NAND_SIZE				0x7FFFFFF

#define RSRC1_START_ADDR		0x02000000
#define RSRC1_END_ADDR			0x04600000

#define TFS_START_ADDR			0x05000000
//#define TFS_START_ADDR			0
#define TFS_END_ADDR			0x08000000

//#define IMGSET_SIZE		IMGSET_END_ADDR - IMGSET_START_ADDR + 0x80000
#define IMGSET_SIZE		IMGSET_END_ADDR - IMGSET_START_ADDR 
#define CALSET_SIZE		CALSET_END_ADDR - CALSET_START_ADDR
#define RSRC1_SIZE		RSRC1_END_ADDR - RSRC1_START_ADDR
#define RSRC2_SIZE		RSRC2_END_ADDR - RSRC2_START_ADDR
#define FACTORYFS_SIZE	FACTORYFS_END_ADDR - FACTORYFS_START_ADDR


#define UART_MODE		0xC9
#define USB_MODE		0x55


#define CMD_USB_ACK 0x99

int	Mode3;


#define CON_SUCCESS				0
#define CON_TIMEOUT				1
#define CON_SPEED_SET_ERROR		2
#define CON_COMM_ERROR			-1
#define CON_WRONG_BOOTCHAR		-2
#define CON_ENV_ERROR			-3
#define CON_OVERTRY				-4

#define TIMEOUT_SEC 6

#define BOOT_CHAR		0xa5

#define USB_DWL_CHAR	0x36
#define USB_MODE_CHAR	0x75
#define FACTORY_MODE_CHAR	0xBB
#define DWL_START_CHAR	0xB9

#define DWL_START_CHAR_USB	0xCA

#define USB_START_SIGNAL	0x55
#define USB_START_ACK_SIGNAL	0x5A

//NAND Flash ID
#define K9F5616D0C_ID	0x55
#define K9K1216D0C_ID	0x56

//ONENAND FLASH ID
#define KAP29WN00M_ONENAND_ADIE		0x26

//NOR Flash ID
#define LRS1896SHARPTB	0x10
#define LRS1896SHARPBB	0x11

#if 0
char ErrorMessage[35][100]={
	

	//------ Result code for Tools
	"INVALID_ARG",
	"FILE_OPEN_ERROR",  //104
	"FILE_CREATE_ERROR",
	"FILE_READ_ERROR",
	"FILE_WRITE_ERROR",
	"INTERNAL_ERROR",
	"INCFILE_ERROR",
	"INVALID_KEYWORD",   //110
	"WRONG_NUM_OF_PARMS",
	"INVALID_VALUE",
	"COMPORT_ERROR",
	"SYNC_ERROR",
	"TIMEOUT",
	"ADDRESS_INVALID",
	"INVALID_IMEI",
	"INVALID_MCC_MNC",
	"WRONG_ORDER_SIMLOCK_CODES",
	"INVALID_IMSI",
	"SYSPARM_WARNING",
	"TOOL_SYSPARM_ERROR",

		//------ secure bootloader tools
	"SECBOOT_CMD_INVALID",
	"SECBOOT_FORMAT_INVALID",
	"SECBOOT_BAUDRATE_INVALID",
	"SECBOOT_CRC_ERROR",
	"SECBOOT_MEMALIGN_ERROR",
	"SECBOOT_FLASHPRGM_ERROR",
	"SECBOOT_OTHER_ERROR",
	"SECBOOT_PROTOCOL_ERROR",
	"SECBOOT_BUFSIZE_ERROR",
	"SECBOOT_FILEOPEN_ERROR",

		//------ flash driver errors
	"FLASHDRV_TIMEOUT",
	"FLASHDRV_MEMALIGN_ERROR",
	"FLASHDRV_ADDRESS_ERROR",
	"FLASHDRV_DEVICE_UNKNOWN",

	"UNKNOWN_ERROR"};
#endif

#define TOPBOOT		0x0;
#define BOTTOMBOOT	0x1;
#define BOTTOMTOP	0x2;

typedef struct
{
	unsigned long FlashID;
	unsigned long FlashEntireSize;
	unsigned long LargeBlockSize;
	unsigned long SmallBlockSize;
	unsigned short Boot;		
	unsigned short TopBlkNum;
	unsigned short MiddleBlkNum;
	unsigned short BottomBlkNum;
} NorFlashConfiguration_t;

typedef struct
{
	unsigned long FlashID;
	unsigned long FlashEntireSize;
	unsigned long BlockSize;
	unsigned short BlockNum;
	unsigned short RsrvBlkNum;
} NandFlashConfiguration_t;

//static const

static const NorFlashConfiguration_t aNorFlashTable[]=
{
	//KCAA0AA00M MCP NOR Flash 256Mb
	{0x00EC2206,	0x2000000,	0x20000,	0x8000,	0x01,	0,	255,	4}
};

static const NandFlashConfiguration_t aNandFlashTable[] =
{
	//KCAA0AA00M MCP OneNand Flash 1Gb
	{0xB1,	0x8000000,	0x20000,	1024,	26},
	{0xBA,	0x8000000,	0x40000,	2048,	26}
};
