// NandDump.cpp : implementation file
//

#include "stdafx.h"
#include "cabrio_downloaderv01.h"
#include "NandDump.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNandDump dialog


CNandDump::CNandDump(CWnd* pParent /*=NULL*/)
	: CDialog(CNandDump::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNandDump)
	m_boolErase = FALSE;
	//}}AFX_DATA_INIT
}


void CNandDump::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNandDump)
	DDX_Check(pDX, IDC_CHECK_ERASE, m_boolErase);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNandDump, CDialog)
	//{{AFX_MSG_MAP(CNandDump)
	ON_BN_CLICKED(IDC_RADIO_RSRC1, OnRadioRsrc1)
	ON_BN_CLICKED(IDC_RADIO_RSRC2, OnRadioRsrc2)
	ON_BN_CLICKED(IDC_RADIO_FACTORYFS, OnRadioFactoryfs)
	ON_BN_CLICKED(IDC_RADIO_NV, OnRadioNv)
	ON_BN_CLICKED(IDC_RADIO_ENGINEER, OnRadioEngineer)
	ON_BN_CLICKED(IDC_RADIO_TFS, OnRadioTfs)
	ON_EN_CHANGE(IDC_EDIT_NAND_FROM, OnChangeEditNandFrom)
	ON_EN_CHANGE(IDC_EDIT_NAND_TO, OnChangeEditNandTo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNandDump message handlers
int CNandDump::ConvHex(const CString & str)
{
	int total=0;
	int len=str.GetLength();
	int len2=len-1;

	char * ss=LPSTR(LPCTSTR(str));

	for (int i=0;i<len;i++)
	{
		if (ss[i]=='a' || ss[i]=='A')
		{
			total+=10*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='b' || ss[i]=='B')
		{
			total+=11*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='c' || ss[i]=='C')
		{
			total+=12*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='d' || ss[i]=='D')
		{
			total+=13*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='e' || ss[i]=='E')
		{
			total+=14*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='f' || ss[i]=='F')
		{
			total+=15*pow(16,len2);
			len2--;
			continue;
		}
	
		total+=(ss[i]-48)*pow(16,len2);
		len2--;

	}
	return total;
}

int CNandDump::IsNum(const CString &st)
{
	int total=0;
	int len=st.GetLength();
	int len2=len-1;

	char * ss=LPSTR(LPCTSTR(st));

	for (int i=0;i<len;i++)
	{
		if (ss[i]>='0' && ss[i]<='9')
			continue;
		return 0;
	}
	return 1;
}

int CNandDump::IsHex(const CString &st)
{
	int total=0;
	int len=st.GetLength();
	int len2=len-1;

		char * ss=LPSTR(LPCTSTR(st));

	
	
	for (int i=0;i<len;i++)
	{
		if (ss[i]>='0' && ss[i]<='9')
			continue;
		if (ss[i]=='a' || ss[i]=='A')
			continue;
		if (ss[i]=='b' || ss[i]=='B')
			continue;
		if (ss[i]=='c' || ss[i]=='C')
			continue;
		if (ss[i]=='d' || ss[i]=='D')
			continue;
		if (ss[i]=='e' || ss[i]=='E')
			continue;
		if (ss[i]=='f' || ss[i]=='F')
			continue;
		return 0;
	}
	return 1;

}

void CNandDump::OnRadioRsrc1() 
{
	// TODO: Add your control notification handler code here
	CString str;

	m_fAddress=0x0;
	m_tAddress=0xABffff;

	SetDlgItemText(IDC_EDIT_NAND_FROM,"0");
	SetDlgItemText(IDC_EDIT_NAND_TO,"ABffff");

	UpdateData(FALSE);
}

void CNandDump::OnRadioRsrc2() 
{
	// TODO: Add your control notification handler code here
	CString str;

	m_fAddress=0xAC0000;
	m_tAddress=0xCBFFFF;

	SetDlgItemText(IDC_EDIT_NAND_FROM,"AC0000");
	SetDlgItemText(IDC_EDIT_NAND_TO,"CBFFFF");

	UpdateData(FALSE);
}

void CNandDump::OnRadioFactoryfs() 
{
	// TODO: Add your control notification handler code here
	CString str;

	m_fAddress=0xCC0000;
	m_tAddress=0xDBFFFF;

	SetDlgItemText(IDC_EDIT_NAND_FROM,"CC0000");
	SetDlgItemText(IDC_EDIT_NAND_TO,"DBFFFF");

	UpdateData(FALSE);
}

void CNandDump::OnRadioNv() 
{
	// TODO: Add your control notification handler code here
	CString str;

	m_fAddress=0xDE0000;
	m_tAddress=0xDFFFFF;

	SetDlgItemText(IDC_EDIT_NAND_FROM,"DE0000");
	SetDlgItemText(IDC_EDIT_NAND_TO,"DFFFFF");
	UpdateData(FALSE);
}

void CNandDump::OnRadioEngineer() 
{
	// TODO: Add your control notification handler code here
	CString str;

	m_fAddress=0xDC0000;
	m_tAddress=0xDDFFFF;

	SetDlgItemText(IDC_EDIT_NAND_FROM,"DC0000");
	SetDlgItemText(IDC_EDIT_NAND_TO,"DDFFFF");

	UpdateData(FALSE);
}

void CNandDump::OnRadioTfs() 
{
	// TODO: Add your control notification handler code here
	CString str;

	m_fAddress=0xE20000;
	m_tAddress=0x1EFFFFF;

	SetDlgItemText(IDC_EDIT_NAND_FROM,"E20000");
	SetDlgItemText(IDC_EDIT_NAND_TO,"1EFFFFF");

	UpdateData(FALSE);
}

void CNandDump::OnChangeEditNandFrom() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
		UpdateData(true);



	CString str,str2;	
	int tempBlock,tempPagenum,tempOffset;

//	str.GetLength
	GetDlgItemText(IDC_EDIT_NAND_FROM,str);
	GetDlgItemText(IDC_EDIT_NAND_TO,str2);

	//Է¹߿ 16   ð üũ
	if (!IsHex(str))
	{
		MessageBox("Wrong value","WARNING");
		SetDlgItemText(IDC_EDIT_NAND_FROM,"0");
		UpdateData(true);
		return;
	}

	//Է¹ 16(ڿ) 16()· ȯ
	m_fAddress=ConvHex(str);
	m_tAddress=ConvHex(str2);
	
	//Է¹   Ѿ MAX ڵ 
	//MAX 1   1byte ĸİ ʿ2
	
	if (m_fAddress>0x7FFFFFE)
	{
		m_fAddress=0x7FFFFFE;
		SetDlgItemText(IDC_EDIT_NAND_FROM,"7EFFFFE");
		UpdateData(true);
		return;
	}
	

	// ּҺ  ּҰ  ū,  ּҸ ּ +1   
	if (m_fAddress>m_tAddress)
	{
		str2.Format("%lX",m_fAddress+1);
		SetDlgItemText(IDC_EDIT_NAND_TO,str2);
	}
}

void CNandDump::OnChangeEditNandTo() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
		UpdateData(true);

	CString str,str2;	
	int tempBlock,tempPagenum,tempOffset;

	GetDlgItemText(IDC_EDIT_NAND_TO,str);
	GetDlgItemText(IDC_EDIT_NAND_FROM,str2);   //To  From ۵Ǿ ϱ⋚ 
	
	//Է¹߿ 16   ð üũ
	if (!IsHex(str))
	{
		MessageBox("Wrong value","WARNING");
		SetDlgItemText(IDC_EDIT_NAND_TO,"0");
		UpdateData(true);
		return;
	}

	m_tAddress=ConvHex(str);
	m_fAddress=ConvHex(str2);

	if (m_tAddress>0x7FFFFFF)
	{
		m_tAddress=0x7FFFFFF;
		SetDlgItemText(IDC_EDIT_NAND_TO,"7FFFFFF");
		UpdateData(true);
		return;
	}
}
