// NorDumpDialog.cpp : implementation file
//

#include "stdafx.h"
#include "cabrio_downloaderv01.h"
#include "NorDumpDialog.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNorDumpDialog dialog


CNorDumpDialog::CNorDumpDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CNorDumpDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNorDumpDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CNorDumpDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNorDumpDialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNorDumpDialog, CDialog)
	//{{AFX_MSG_MAP(CNorDumpDialog)
	ON_BN_CLICKED(IDC_RADIO_WEDGE, OnRadioWedge)
	ON_BN_CLICKED(IDC_RADIO_DSP, OnRadioDsp)
	ON_BN_CLICKED(IDC_RADIO_SYSPARM_IND, OnRadioSysparmInd)
	ON_BN_CLICKED(IDC_RADIO_SYSPARM_IND2, OnRadioSysparmInd2)
	ON_BN_CLICKED(IDC_RADIO_WCDMA_CAL, OnRadioWcdmaCal)
	ON_BN_CLICKED(IDC_RADIO_WCDMA_CAL2, OnRadioWcdmaCal2)
	ON_BN_CLICKED(IDC_RADIO_BOOTLOADER, OnRadioBootloader)
	ON_EN_CHANGE(IDC_EDIT_FROM, OnChangeEditFrom)
	ON_EN_CHANGE(IDC_EDIT_TO, OnChangeEditTo)
	ON_BN_CLICKED(IDC_RADIO_RSRC2, OnRadioRsrc2)
	ON_BN_CLICKED(IDC_RADIO_FACTORYFS, OnRadioFactoryfs)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNorDumpDialog message handlers


int CNorDumpDialog::ConvHex(const CString & str)
{
	int total=0;
	int len=str.GetLength();
	int len2=len-1;

	char * ss=LPSTR(LPCTSTR(str));

	for (int i=0;i<len;i++)
	{
		if (ss[i]=='a' || ss[i]=='A')
		{
			total+=10*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='b' || ss[i]=='B')
		{
			total+=11*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='c' || ss[i]=='C')
		{
			total+=12*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='d' || ss[i]=='D')
		{
			total+=13*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='e' || ss[i]=='E')
		{
			total+=14*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='f' || ss[i]=='F')
		{
			total+=15*pow(16,len2);
			len2--;
			continue;
		}
	
		total+=(ss[i]-48)*pow(16,len2);
		len2--;

	}
	return total;
}

int CNorDumpDialog::IsNum(const CString &st)
{
	int total=0;
	int len=st.GetLength();
	int len2=len-1;

	char * ss=LPSTR(LPCTSTR(st));

	for (int i=0;i<len;i++)
	{
		if (ss[i]>='0' && ss[i]<='9')
			continue;
		return 0;
	}
	return 1;
}

int CNorDumpDialog::IsHex(const CString &st)
{
	int total=0;
	int len=st.GetLength();
	int len2=len-1;

		char * ss=LPSTR(LPCTSTR(st));

	
	
	for (int i=0;i<len;i++)
	{
		if (ss[i]>='0' && ss[i]<='9')
			continue;
		if (ss[i]=='a' || ss[i]=='A')
			continue;
		if (ss[i]=='b' || ss[i]=='B')
			continue;
		if (ss[i]=='c' || ss[i]=='C')
			continue;
		if (ss[i]=='d' || ss[i]=='D')
			continue;
		if (ss[i]=='e' || ss[i]=='E')
			continue;
		if (ss[i]=='f' || ss[i]=='F')
			continue;
		return 0;
	}
	return 1;

}

void CNorDumpDialog::OnRadioWedge() 
{
	// TODO: Add your control notification handler code here
	CString str;

	m_fAddress=0x20000;
	m_tAddress=0x1EAFFFF;

	SetDlgItemText(IDC_EDIT_FROM,"20000");
	SetDlgItemText(IDC_EDIT_TO,"1EAFFFF");

	UpdateData(FALSE);
}

void CNorDumpDialog::OnRadioDsp() 
{
	// TODO: Add your control notification handler code here
	m_fAddress=0x1F00000;
	m_tAddress=0x1F1FFFF;

	SetDlgItemText(IDC_EDIT_FROM,"1F00000");
	SetDlgItemText(IDC_EDIT_TO,"1F1FFFF");

	UpdateData(FALSE);
}

void CNorDumpDialog::OnRadioSysparmInd() 
{
	// TODO: Add your control notification handler code here
	m_fAddress=0x1F20000;;
	m_tAddress=0x1F3FFFF;

	SetDlgItemText(IDC_EDIT_FROM,"1F20000");
	SetDlgItemText(IDC_EDIT_TO,"1F3FFFF");

	UpdateData(FALSE);
}

void CNorDumpDialog::OnRadioSysparmInd2() 
{
	// TODO: Add your control notification handler code here
	m_fAddress=0x1F40000;
	m_tAddress=0x1F5FFFF;

	SetDlgItemText(IDC_EDIT_FROM,"1F40000");
	SetDlgItemText(IDC_EDIT_TO,"1F5FFFF");

	UpdateData(FALSE);
}

void CNorDumpDialog::OnRadioWcdmaCal() 
{
	// TODO: Add your control notification handler code here
	m_fAddress=0x1F60000;
	m_tAddress=0x1F7FFFF;

	SetDlgItemText(IDC_EDIT_FROM,"1F60000");
	SetDlgItemText(IDC_EDIT_TO,"1F7FFFF");

	UpdateData(FALSE);
}

void CNorDumpDialog::OnRadioWcdmaCal2() 
{
	// TODO: Add your control notification handler code here
	m_fAddress=0x1F80000;
	m_tAddress=0x1FFFFFF;
	SetDlgItemText(IDC_EDIT_FROM,"1F80000");
	SetDlgItemText(IDC_EDIT_TO,"1FFFFFF");
	UpdateData(FALSE);
}

void CNorDumpDialog::OnRadioBootloader() 
{
	// TODO: Add your control notification handler code here
	m_fAddress=0x0;
	m_tAddress=0xFFFF;
	SetDlgItemText(IDC_EDIT_FROM,"0");
	SetDlgItemText(IDC_EDIT_TO,"FFFF");
	UpdateData(FALSE);
}

void CNorDumpDialog::OnChangeEditFrom() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);



	CString str,str2;	
	int tempBlock,tempPagenum,tempOffset;

//	str.GetLength
	GetDlgItemText(IDC_EDIT_FROM,str);
	GetDlgItemText(IDC_EDIT_TO,str2);

	//Է¹߿ 16   ð üũ
	if (!IsHex(str))
	{
		MessageBox("Wrong value","WARNING");
		SetDlgItemText(IDC_EDIT_FROM,"0");
		UpdateData(true);
		return;
	}

	//Է¹ 16(ڿ) 16()· ȯ
	m_fAddress=ConvHex(str);
	m_tAddress=ConvHex(str2);
	
	//Է¹   Ѿ MAX ڵ 
	//MAX 1   1byte ĸİ ʿ2
	
	if (m_fAddress>0x1FFFFFE)
	{
		m_fAddress=0x1FFFFFE;
		SetDlgItemText(IDC_EDIT_FROM,"1FFFFFE");
		UpdateData(true);
		return;
	}
	

	// ּҺ  ּҰ  ū,  ּҸ ּ +1   
	if (m_fAddress>m_tAddress)
	{
		str2.Format("%lX",m_fAddress+1);
		SetDlgItemText(IDC_EDIT_TO,str2);
	}
}

void CNorDumpDialog::OnChangeEditTo() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);

	CString str,str2;	

	GetDlgItemText(IDC_EDIT_TO,str);
	GetDlgItemText(IDC_EDIT_FROM,str2);   //To  From ۵Ǿ ϱ⋚ 
	
	//Է¹߿ 16   ð üũ
	if (!IsHex(str))
	{
		MessageBox("Wrong value","WARNING");
		SetDlgItemText(IDC_EDIT_TO,"0");
		UpdateData(true);
		return;
	}

	m_tAddress=ConvHex(str);
	m_fAddress=ConvHex(str2);

	if (m_tAddress>0x1FFFFFFF)
	{
		m_tAddress=0x1FFFFFFF;
		SetDlgItemText(IDC_EDIT_TO,"1FFFFFFF");
		UpdateData(true);
		return;
	}

	
}

void CNorDumpDialog::OnRadioRsrc2() 
{
	// TODO: Add your control notification handler code here

	m_fAddress=0x1B90000;
	m_tAddress=0x1D8FFFF;

	SetDlgItemText(IDC_EDIT_FROM,"1B90000");
	SetDlgItemText(IDC_EDIT_TO,"1d8FFFF");

	UpdateData(FALSE);
	
}

void CNorDumpDialog::OnRadioFactoryfs() 
{
	// TODO: Add your control notification handler code here

	m_fAddress=0x1D90000;
	m_tAddress=0x1E8FFFF;

	SetDlgItemText(IDC_EDIT_FROM,"1D90000");
	SetDlgItemText(IDC_EDIT_TO,"1E8FFFF");

	UpdateData(FALSE);
	
}
