                                          // cabrio_downloaderv01Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "cabrio_downloaderv01.h"
#include "cabrio_downloaderv01Dlg.h"
#include "norflashdrv.h"
#include "windows.h"
#include "OKDialog.h"
#include "TFSDialog.h"
#include "VerDialog.h"
#include "DumpDialog.h"
#include "DescriptionSaveCheck.h"
#include "BootloaderDlg.h"
#include "NorDumpDialog.h"
#include "NandDump.h"
#include "math.h"
#include "flashloader_USB.h"
#include "bootloader2.h"
//#include "TfsExplorer.h"
//#define _CUSTOMER_
//#define _INCLUDE_CALSET_
#define _MULTI_DOWNLOADER_
#define _DWL_BOOTLOADER_
#define _RSRC2_

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "tool_api.h"
#include "Env.h"

//#define _USB_BLOCK_

ToolProgressCb_t ToolProgressCb;
ToolProgressCbDump_t ToolProgressCbDump;
ToolFileHandleCb_t ToolFileHandleCb;

int check=0;

//HWND hCommWnd;
//CCommThread gSerialPort;

const UINT gComPort[] = { 1, 2, 3, 4, 5, 6, 7, 8 ,9,10,11,12,13,14,15,16,17,18,19,20};
const UINT gComSpeed[] = { CBR_115200, 230400, 460800, 921600 };

int g_nProgressCounter =0;
int g_nDownloadedSector = 0;

//FEATURE_EUR
BOOL IsPrebootDL=FALSE;
BOOL IsBootloaderDL=FALSE;

int checkRC2;
int checkER;
int checkPARAM;
int checkRC1;
int checkCALSET;
int checkBOOT2;

BYTE g_BaudRate[3] = {
	COMPORT_BAUDRATE_115K,
	COMPORT_BAUDRATE_460K,
	COMPORT_BAUDRATE_921K

};

static UInt8 cActionType;   // κ ٿε 
static UInt8 cDriverStatus;

#define BUFF_SIZE		8192

#ifndef __TFS4__  // moo_20070201
BYTE buffer[BUFF_SIZE];
char *TFsCfgBuffer;
DWORD TfsCfgBufferLen;
char file_name[500];

int history_index = 0 ;
DWORD TFS_FileSize;
DWORD file_size;

enum  { RX_NONE, 
		RX_WAIT_CREQ,
        RX_WAIT_CCON,
        RX_WAIT_16BYTES,
        RX_WAIT_16BYTES_CON,
        RX_WAIT_PRE_LOADER_CONTINUE,
        RX_WAIT_PRE_LOADER_COMPLETE,
        RX_WAIT_START_PRE_LOADER,
        RX_WAIT_PRE_LOADER_CON,
        RX_WAIT_SET_EBI_ADDR,
        RX_WAIT_SET_EBI_DATA,
        RX_WAIT_SET_LOADING_ADDR,
        RX_WAIT_LOADER_CONTINUE,
        RX_WAIT_LOADER_COMPLETE,
        RX_WAIT_SET_ENDIAN,
        RX_WAIT_START_LOADER,
        RX_WAIT_LOADER_CON,
        RX_WAIT_SEND_BASEADDR,
        RX_WAIT_FLASHID,
        RX_WAIT_CHANGE_UART_SPEED,
        RX_WAIT_FILESIZE,
        RX_WAIT_WRITE_ADDRESS,
        RX_WAIT_ERASE_SECTOR,
        RX_WAIT_WRITE_WORD,
        RX_WAIT_DUMP_SECTOR,
		RX_WAIT_TFS_MOUNT,
		RX_WAIT_TFS_DIR_NAME_RECEIVED,
		RX_WAIT_TFS_DIR_CREATED,
		RX_WAIT_TFS_VERSION_CREATED,
		RX_WAIT_TFS_FILE_NAME_RECEIVED,
		RX_WAIT_TFS_FILE_TRANSFER,
		RX_WAIT_TFS_FILE_WRITING,
		RX_WAIT_TFS_FILE_CREATED,
		RX_WAIT_TFS_FORMAT,
		RX_WAIT_TFS_STATUS,
		RX_WAIT_READ_TFS_STATUS,
		RX_WAIT_TFS_UNMOUNT,
		RX_WAIT_TFS_READ_FILE,
		RX_WAIT_DELETE_TFS_FILE,
		RX_WAIT_TFS_FORMAT_ERROR,
		RX_WAIT_TFS_STATUS_ERROR,/*SHKIM Add*/
		RX_WAIT_TFS_INIT_ERROR,/*SHKIM Add*/
		RX_WAIT_TFS_FILE_STATUS_READ,  /*sdhong for file status read*/
		RX_WAIT_TFS_FILE_STATUS_READ_CONT,
		RX_WAIT_TFS_RELEASE_VERSION_CREATED, /*SHKIM.ADD.040717*/
		RX_WAIT_TFS_START_DUMP, /*20040917 sdhong for nand dump*/
		RX_WAIT_TFS_DUMPING,
		RX_WAIT_TFS_DUMP_END,
		
		RX_WAIT_DMA_SETUP,
		RX_WAIT_DOWNLOAD_SECTOR,
		RX_WAIT_DOWNLOAD_SECTOR_COMPLETE,
		/*sdhong 20041012 for write checksum in NOR AREA*/		
 		RX_WAIT_WRITE_NORCHECKSUM,
 		RX_WAIT_WRITE_NANDCHECKSUM,

		/*sdhong 20041015 for change time out*/
		RX_WAIT_BOOT_TIMEOUT,
		 /*sdhong 20041019 tfs system time set*/
		RX_WAIT_TFSTIME_SET,
		/* sdhong_20041025_multibytechar */
        	RX_WAIT_TFSFILENAME_SIZE,
        	RX_WAIT_RECEIVE_TFSFILENAME,
        	RX_WAIT_RECEIVE_FILENAME_CNT,
        	/*sdhong_20041116_tfsfileCompleteCheck */
		RX_WAIT_WRITE_COMPLETE_NAND,
		RX_WAIT_WRITE_COMPLETE_NOR,
		/*sdhong_20041227_chipversion_check*/
		RX_READ_CHIP_ID,
		RX_TEST,
        RX_END };

enum { OP_DOWNLOAD,
       OP_ERASE,
       OP_DUMP,
       OP_NAND_DOWNLOAD,
       OP_NAND_CREATE_DIR,
       OP_NAND_FORMAT,
       OP_NAND_EXPLORER,
	   OP_NAND_STATUS,
       OP_BOTH_DOWNLOAD
};

#endif

UINT AutoDownloadThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;
	CString str;
	int nResult;
	pDlg->m_nMainPercent = 0;
	g_nDownloadedSector=0;

	nResult=pDlg->ConnectWithMS();
	pDlg->ShowMessage_ConnectWithMS(nResult);
	if (nResult!=CON_SUCCESS)
		return true;

	switch (cActionType)
	{
		case DWL_ALL:
			g_nDownloadedSector = pDlg->GetSectorNum(IMGSET_START_ADDR,pDlg->m_nImageSize)
				+pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->m_nRscrSize) 
				+pDlg->GetSectorNum2(RSRC2_START_ADDR,pDlg->m_nRscr2Size)
				+pDlg->GetSectorNum2(FACTORYFS_START_ADDR,pDlg->m_nFactoryFSSize);
			//case including calset file
			if (pDlg->m_boolCalset==TRUE)
			{
				g_nDownloadedSector+=pDlg->GetSectorNum(CALSET_START_ADDR,pDlg->m_nParamDepSize);
			}
			
			g_nProgressCounter = 0;

			if (pDlg->NorDownload(DWL_IMGSET,1)==false)	return true;

			//Calset ϴ üũ
			if (pDlg->m_boolCalset==TRUE)
			{
				if (pDlg->NorDownload(DWL_CALSET,1)==false) return true;
			}


			pDlg->DisconnectMS();
			
			if (pDlg->Erase(cActionType)==false) return true;

			if (pDlg->NandDownload(DWL_RSRC1,1)==false)	return true;
			if (pDlg->NandDownload(DWL_RSRC2,1)==false) return true;
			if (pDlg->NandDownload(DWL_FACTORYFS,1)==false) return true;

			pDlg->ShowTotalTime();
			
			return true;
			break;
		default:
			break;
	}
	return true;

}

UINT RamdumpThreadFunc(LPVOID pParam)
{	
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;
	CString str;

	pDlg->Ramdump();
	return 0;
	

}

UINT AllDownloadThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;
	CString str;

	
	pDlg->m_nMainPercent = 0;
	g_nDownloadedSector=0;
	switch (cActionType)
	{
		case DWL_ALL:
			g_nDownloadedSector = pDlg->GetSectorNum2(IMGSET_START_ADDR,pDlg->m_nImageSize)
								+pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->m_nRscrSize)
								+pDlg->GetSectorNum2(RSRC2_START_ADDR,pDlg->m_nRscr2Size)
								+pDlg->GetSectorNum2(FACTORYFS_START_ADDR,pDlg->m_nFactoryFSSize)+145;
								
			//case including calset file
#if 1
//			if (pDlg->m_boolCalset==TRUE)
			if (pDlg->m_ckCal==TRUE)
			{
				g_nDownloadedSector+= pDlg->GetSectorNum2(CALSET_START_ADDR,pDlg->m_nParamDepSize);
			}

			
#endif		
			g_nProgressCounter = 0;
			if (pDlg->Erase(cActionType)==false) return true;
			pDlg->DisplayButton(CURRENT_NAND_DRIVER,1,IMGSET_START_ADDR);
			
			checkER=1;
			checkPARAM=1;
			checkRC1=0;
			checkRC2=0;
			checkCALSET=0;
			checkBOOT2=0;

			if (pDlg->NandDownload(DWL_IMGSET,2)==false) return true;
			pDlg->DisplayButton(CURRENT_NAND_DRIVER,1,IMGSET_START_ADDR);

//			if (pDlg->m_boolCalset==TRUE)
			if (pDlg->m_ckCal==TRUE)
			{
				Sleep(1000);
				checkER=0;
				checkPARAM=0;
				checkRC1=0;
				checkRC2=0;
				checkCALSET=1;
				checkBOOT2=0;
				if (pDlg->NandDownload(DWL_CALSET,2)==false) return true;
				pDlg->DisplayButton(CURRENT_NAND_DRIVER,1,CALSET_START_ADDR);
			}


			pDlg->DisplayButton(CURRENT_NAND_DRIVER,1,IMGSET_START_ADDR);

//			if (pDlg->m_boolCalset==TRUE)
			if (pDlg->m_ckCal==TRUE)
			{
				pDlg->DisplayButton(CURRENT_NAND_DRIVER,1,CALSET_START_ADDR);
			}
			
			checkER=0;
			checkPARAM=0;
			checkRC1=1;
			checkRC2=0;
			checkCALSET=0;
			checkBOOT2=0;
			if (pDlg->NandDownload(DWL_RSRC1,2)==false)	return true;
			pDlg->DisplayButton(CURRENT_NAND_DRIVER,1,RSRC1_START_ADDR);

			
			checkER=0;
			checkPARAM=0;
			checkRC1=0;
			checkRC2=1;
			checkCALSET=0;
			checkBOOT2=0;
			if (pDlg->NandDownload(DWL_RSRC2,2)==false)	return true;
			pDlg->DisplayButton(CURRENT_NAND_DRIVER,1,RSRC2_START_ADDR);

			Sleep(1000);

			if (pDlg->NandDownload(DWL_FACTORYFS,2)==false)	return true;


			pDlg->ShowTotalTime();
			
			return true;
			break;
		default:
			break;
	}

	return true;

}

UINT DlbootloaderThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;

	//int result;
	//pDlg->ShowStatus("\n  * Change to Download ready state",4);
	if (pDlg->Dlbootloader(DWL_BOOT1)==false) return true;
		//Sleep(1000); JUN0612
	if (pDlg->Dlbootloader(DWL_BOOT2)==false) return true;
		//Sleep(1000); JUN0612
	if (pDlg->Dlbootloader(DWL_BOOT3)==false) return true;
	g_nProgressCounter = 0;
	g_nDownloadedSector=2;
	if (pDlg->NandDownload(DWL_BOOT4,2)==false) return true;

	return true;
}

UINT DisconnectThread(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;

	pDlg->ShowStatus("\n  * Change to Download ready state",4);
	pDlg->DisconnectMS();
	return true;
}

UINT ConnectionThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;
	
	pDlg->ShowStatus("\n  * Connecting to target phone",4);
	pDlg->st.Format("\n     Try to open COM%d\t>",pDlg->m_ComPort+1);
	pDlg->ShowStatus(pDlg->st,3);
//	pDlg->ShowStatus("\n    Listen for the Download Mode signal of target phone.....");
	pDlg->nCon_Result=pDlg->ConnectWithMS();
	pDlg->ShowMessage_ConnectWithMS(pDlg->nCon_Result);
	return true;

}

UINT NorDownloadThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;
	CString str;
	
	pDlg->m_nMainPercent = 0;
	g_nDownloadedSector=0;

	switch (cActionType)
	{
		case DWL_ALL:
			g_nDownloadedSector = pDlg->GetSectorNum(IMGSET_START_ADDR,pDlg->m_nImageSize);
	
			if (pDlg->m_boolCalset==TRUE)
				g_nDownloadedSector+=(pDlg->GetSectorNum(CALSET_START_ADDR,pDlg->m_nParamDepSize));

			g_nProgressCounter = 0;

			
			if (pDlg->NorDownload(DWL_IMGSET,1)==false) return true;

			if (pDlg->m_boolCalset==TRUE)
			{
				if(pDlg->NorDownload(DWL_CALSET,1)==false) return true;
			}


			pDlg->ShowTotalTime();
			return true;
			break;

		case DWL_IMGSET:
			g_nDownloadedSector = (pDlg->GetSectorNum(IMGSET_START_ADDR,pDlg->m_nImageSize));
			break;

		case DWL_CALSET:
			g_nDownloadedSector = (pDlg->GetSectorNum(CALSET_START_ADDR,pDlg->m_nParamDepSize));
			break;

		case DWL_MANUAL:
			g_nDownloadedSector = (pDlg->GetSectorNum(pDlg->m_fAddress,pDlg->m_nManulImageSize));
			break;

		default:
			break;
	}

	g_nProgressCounter = 0;

	//Driver Downloading
	pDlg->NorDownload(cActionType,0);
	

	return true;
}


UINT EraseThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;

	pDlg->Erase(cActionType);

	return true;
}

UINT NorEraseThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;

	pDlg->m_nMainPercent = 0;
	g_nProgressCounter = 0;

	if (cActionType==OP_ERASE_BOOTLOADER)
	
		g_nDownloadedSector = pDlg->GetSectorNum(0,0x10000);
	else
		g_nDownloadedSector = pDlg->GetSectorNum(TFSCHECK_START_ADDR,0x20000);


	pDlg->NorErase(cActionType);

	return true;
}

UINT NorDumpThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;

	pDlg->m_nMainPercent = 0;
	g_nProgressCounter = 0;
	pDlg->NorDump(cActionType);

	return true;
}

UINT NandDumpThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;

	pDlg->m_nMainPercent = 0;
	g_nProgressCounter = 0;
	pDlg->NandDump(cActionType);

	return true;
}

UINT TFSFormatThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;

	pDlg->TFS_Format(0);

	return true;
}


UINT BML_FORMATThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;

	pDlg->BML_Format();

	return true;
}




UINT NandDownloadThreadFunc(LPVOID pParam)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)pParam;
	CString str;
	
	pDlg->m_nMainPercent = 0;
	switch (cActionType)
	{
		case DWL_ALL:

			if (checkER==1)
			{
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[0]);
			}
			if (checkPARAM==1)
			{
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[1]);
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[2]);
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[3]);
			}
			if (checkRC1==1)
			{
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[4]);
			}
			if (checkCALSET==1)
			{
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[5]);
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[6]);
			}
			if (checkBOOT2==1)
			{
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[7]);
			}
			
			g_nDownloadedSector+=pDlg->GetSectorNum2(FACTORYFS_START_ADDR,pDlg->m_nFactoryFSSize);
			g_nProgressCounter = 0;
	

			if (pDlg->NandDownload(DWL_RSRC1,1)==false) return true;
			Sleep(1000);
			if (pDlg->NandDownload(DWL_FACTORYFS,1)==false) return true;

			pDlg->ShowTotalTime();

			return true;
			break;
		//case DWL_TFLASH:
		case DWL_IMGSET:
				
			checkER=1;
			checkPARAM=1;
			checkRC1=0;
			checkRC2=0;
			checkCALSET=0;
			checkBOOT2=0;
			
			
		
			g_nDownloadedSector = pDlg->GetSectorNum2(IMGSET_START_ADDR,pDlg->m_nImageSize);
		
			

#if 0
			if (checkER==1)
			{
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[0]);
			}
			if (checkPARAM==1)
			{
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[1]);
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[2]);
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[3]);
			}

			if (checkRC1==1)
			{
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[4]);
			}
			if (checkCALSET==1)
			{
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[5]);
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[6]);
			}
			if (checkBOOT2==1)
			{
				g_nDownloadedSector+=pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->imageSize[7]);
			}
#endif
	
			break;

		case DWL_CALSET:

			checkER=0;
			checkPARAM=0;
			checkRC1=0;
			checkRC2=0;
			checkCALSET=1;
			checkBOOT2=0;

			g_nDownloadedSector = pDlg->GetSectorNum2(CALSET_START_ADDR,pDlg->m_nParamDepSize);
			break;

		case DWL_RSRC1:

			checkER=0;
			checkPARAM=0;
			checkRC1=1;
			checkRC2=0;
			checkCALSET=0;
			checkBOOT2=0;

			g_nDownloadedSector = pDlg->GetSectorNum2(RSRC1_START_ADDR,pDlg->m_nRscrSize);
			break;

		case DWL_RSRC2:

			checkER=0;
			checkPARAM=0;
			checkRC1=0;
			checkRC2=1;
			checkCALSET=0;
			checkBOOT2=0;

			g_nDownloadedSector = pDlg->GetSectorNum2(RSRC2_START_ADDR,pDlg->m_nRscr2Size);
		break;

		case DWL_FACTORYFS:
			g_nDownloadedSector = pDlg->GetSectorNum2(FACTORYFS_START_ADDR,pDlg->m_nFactoryFSSize)+145;
				break;

		case DWL_FLASHALL:
			g_nDownloadedSector = pDlg->GetSectorNum2(TFS_START_ADDR,pDlg->m_nEntireFlashSize);
			break;
		case DWL_MANUAL_NAND:
			g_nDownloadedSector = pDlg->GetSectorNum2(pDlg->m_fAddress,pDlg->m_nManualNandImageSize);
			break;

		default:
			break;
	}
	
	g_nProgressCounter = 0;
	pDlg->NandDownload(cActionType,0);

	return true;
}

void FileHandleCallBackFunc(UInt8 * m,unsigned long nSize)
{
	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)AfxGetApp()->m_pMainWnd;

	if( pDlg == NULL )
	{
		AfxMessageBox("ProgressCallBackFunc Error :");
	}
	pDlg->m_DumpFile.Write(m,nSize);


}

void DumpProgressCallBackFunc( Boolean endOfSector, UInt8 * m,unsigned long addr)
{

	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)AfxGetApp()->m_pMainWnd;

	int i=0;
	CString test;
	unsigned long temp;
	pDlg->m_ctrCN.EnableWindow(true);

	if( pDlg == NULL )
	{
		AfxMessageBox("ProgressCallBackFunc Error :");
	}

	if( endOfSector )
	{
		g_nProgressCounter++;
		pDlg->m_nMainPercent = (g_nProgressCounter * 100) / g_nDownloadedSector;
		pDlg->m_progressMain.SetPos(pDlg->m_nMainPercent);


		temp=pDlg->temp_nfrom;

		test.Format(" %d / %d ",g_nProgressCounter,g_nDownloadedSector);
		pDlg->m_editSubStatus.SetWindowText(test);

		if (temp==0)
			test.Format("   0x0000 : \t");
		else
			test.Format("\n   0x%x : \t",addr);
		pDlg->ShowStatus(test);
		
		if (cActionType==OP_NAND_DUMP)
		{

			pDlg->temp_nfrom+=(long)aNandFlashTable[0].BlockSize;

		}
		if (cActionType==OP_NOR_DUMP)
		{
			pDlg->temp_nfrom+=(long)aNorFlashTable[0].LargeBlockSize;

		}
					
		test.Format("   Dump   >>>   OK");
			pDlg->ShowStatus(test,3);
	

	}
}

void ProgressCallBackFunc( Boolean endOfSector,Boolean bChecksum, unsigned long lAddr,unsigned int nWrite,Boolean bErase)
{

	CCabrio_downloaderv01Dlg *pDlg = (CCabrio_downloaderv01Dlg*)AfxGetApp()->m_pMainWnd;
	CString test;
	pDlg->m_ctrCN.EnableWindow(true);
	if( pDlg == NULL )
	{
		AfxMessageBox("ProgressCallBackFunc Error : hCommWnd");
	}

	if (bChecksum)
	{
		//bChecksum TRUEϰ Ű lAddr Erroró  
		switch(lAddr)
		{
#ifdef _CUSTOMER_
			case 0:
				//pDlg->ShowStatus(" checksum : ");
				test.Format("\n");
				pDlg->ShowStatus(test,4);
				break;
			case 1:
				pDlg->ShowStatus(" checksum ");
				pDlg->ShowStatus(" Error\n",4);
				break;
#else
			case 0:
				pDlg->ShowStatus(" checksum : ");
				test.Format("0x%X\n",nWrite);
				pDlg->ShowStatus(test,4);
				break;
			case 1:
				pDlg->ShowStatus(" checksum ");
				pDlg->ShowStatus(" Error\n",4);
				break;
#endif
			case 2:
				//imgset, calset ߰  ٲ  ֱ
				pDlg->ShowStatus("\n");
				break;
			case 3:
				pDlg->ShowStatus(" Fail -> Resend data\n",4);
				break;
			case 4:
				pDlg->ShowStatus(" Sync error\n",4);
				break;
			case 5:
				pDlg->ShowStatus(" Invalid ACK received\n",4);
				break;
			case 6:
				pDlg->ShowStatus(" Not response at the target phone\n",4);
				break;
			default:
				// ü 
				pDlg->ShowStatus(" Unknown error\n",4);
				break;
		}
			
		return;
	}
	if( endOfSector )
	{
		g_nProgressCounter++;
		pDlg->m_nMainPercent = (g_nProgressCounter * 100) / g_nDownloadedSector;
		if(pDlg->m_nMainPercent>=100)
			pDlg->m_nMainPercent=100;
		pDlg->m_progressMain.SetPos(pDlg->m_nMainPercent);
		
		test.Format(" %d / %d ",g_nProgressCounter,g_nDownloadedSector);
		pDlg->m_editSubStatus.SetWindowText(test);
		pDlg->st.Format("%d",pDlg->m_nMainPercent);
		pDlg->m_btnPer.SetWindowText(pDlg->st);
#ifdef _CUSTOMER_
		if (lAddr==0x0)
			//ּҰ 0x0϶ \t  ѹ  ش.
		{
			if (bErase)
				pDlg->st.Format("\r\n    Erase   %d bytes\t. . . .    OK ",nWrite);
			else
			pDlg->st.Format("    Download   %d bytes\t. . . .  ",nWrite);
		}
		else
		{	if (bErase)
				pDlg->st.Format("\r\n    Erase   %d bytes\t. . . .    OK ",nWrite);
		else
			pDlg->st.Format("    Download   %d bytes\t. . . .  ",nWrite);
		}
#else
		if (lAddr==0x0)
			//ּҰ 0x0϶ \t  ѹ  ش.
		{
			if (bErase)
				pDlg->st.Format("\r\n    0 x %X\t\t Erase   %d bytes\t. . . .    OK ",lAddr,nWrite);
			else
			pDlg->st.Format("    0 x %X\t\t Download   %d bytes\t. . . .  ",lAddr,nWrite);
		}
		else
		{	if (bErase)
				pDlg->st.Format("\r\n    0 x %X\t Erase   %d bytes\t. . . .    OK ",lAddr,nWrite);
		else
			pDlg->st.Format("    0 x %X\t Download   %d bytes\t. . . .  ",lAddr,nWrite);
		}
#endif

		pDlg->ShowStatus(pDlg->st);
		pDlg->DisplayButton(cDriverStatus,g_nProgressCounter%2,lAddr);
		//for USB_DOWNLOAD
//		if (Mode3==USB_MODE){
//			test.Format("\n");
//			pDlg->ShowStatus(test,4);
//		}

	}

}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCabrio_downloaderv01Dlg dialog

CCabrio_downloaderv01Dlg::CCabrio_downloaderv01Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCabrio_downloaderv01Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCabrio_downloaderv01Dlg)
	m_radio = -1;
	m_boolECC = FALSE;
	m_boolAuto = FALSE;
	m_boolAutoReboot = FALSE;
	m_boolCalset = FALSE;
	m_radioMode = -1;
	m_boolBootloader = FALSE;
	m_boolImage = FALSE;
	m_boolRsrc = FALSE;
	m_ckBoot = FALSE;
	m_ckCal = FALSE;
	m_ckER = FALSE;
	m_ckParam = FALSE;
	m_ckRc1 = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCabrio_downloaderv01Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCabrio_downloaderv01Dlg)
	DDX_Control(pDX, IDC_BUTTON_PER, m_btnPer);
	DDX_Control(pDX, IDC_BML_FORMAT, m_ctrBMLFORMAT);
	DDX_Control(pDX, IDC_RICHEDIT_FLASHTYPE2, m_ctrlNandFlash);
	DDX_Control(pDX, IDC_BUTTON_MANUAL_NAND_IMAGE, m_btnManualNand);
	DDX_Control(pDX, IDC_BUTTON_MANUAL_IMAGE, m_btnManualNor);
	DDX_Control(pDX, IDC_EDIT_MANUAL_NAND_IMAGE_PATH, m_editManualNandImagePath);
	DDX_Control(pDX, IDC_EDIT_MANUAL_NAND, m_editManualNandAddress);
	DDX_Control(pDX, IDC_EDIT_DN, m_editDN);
	DDX_Control(pDX, IDC_EDIT_TIME, m_editTime);
	DDX_Control(pDX, IDC_EDIT_MANUAL_IMAGE_PATH, m_editManualImagePath);
	DDX_Control(pDX, IDC_EDIT_MANUAL, m_editManualAddress);
	DDX_Control(pDX, IDC_BUTTON_NOR_DUMP, m_ctrNorDump);
	DDX_Control(pDX, IDC_BUTTON_NOR_ALLERASE, m_ctrNorErase);
	DDX_Control(pDX, IDC_BUTTON_NAND_DUMP, m_ctrNandDump);
	DDX_Control(pDX, IDC_BUTTON_BOOTLOADER_ERASE, m_ctrBootloaderErase);
	DDX_Control(pDX, IDC_EDIT_ENTIRE_FLASH_PATH, m_editEntireFlashPath);
	DDX_Control(pDX, IDC_BUTTON_NAND_ENTIRE_FLASH, m_ctrEntireFlash);
	DDX_Control(pDX, IDC_BUTTON_BCHK, m_ctrlBChk);
	DDX_Control(pDX, IDC_BUTTON_INFO, m_btnInfo);
	DDX_Control(pDX, IDC_EDIT_SUBSTATUS, m_editSubStatus);
	DDX_Control(pDX, IDOK, m_idok);
	DDX_Control(pDX, IDC_BUTTON_DLBOOTLOADER, m_ctrlDlbootloader);
	DDX_Control(pDX, IDC_BUTTON_DISCONNECT, m_ctrlDisconnect);
	DDX_Control(pDX, IDC_RICHEDIT_CONNECT, m_ctrlConnect);
	DDX_Control(pDX, IDC_RICHEDIT_FLASHTYPE, m_ctrlNFlash);
	DDX_Control(pDX, IDC_BUTTON_START, m_ctrlStart);
	DDX_Control(pDX, IDC_EDIT_FILENAME, m_editFileName);
	DDX_Control(pDX, IDC_EDIT_CHECKSUM, m_editCheckSum);
	DDX_Control(pDX, IDC_EDIT_FILESIZE, m_editFileSize);
	DDX_Control(pDX, IDC_BUTTON_TFS_FORMAT, m_ctrTFSFormat);
	DDX_Control(pDX, IDC_BUTTON_CABRIO, m_ctrCabrio);
	DDX_Control(pDX, IDC_BUTTON_TITLE, m_ctrTitle);
	DDX_Control(pDX, IDC_BUTTON_CN, m_ctrCN);
	DDX_Control(pDX, IDC_BUTTON_SYSPARM_DEP, m_ctrSysDep);
	//DDX_Control(pDX, IDC_BUTTON_CAP, m_ctrCap);
	DDX_Control(pDX, IDC_BUTTON_NAND_FACTORYFS, m_ctrFactoryFS);
	DDX_Control(pDX, IDC_BUTTON_NAND_RSCR2, m_ctrRscr2);
	DDX_Control(pDX, IDC_BUTTON_NAND_RSCR, m_ctrRscr);
	DDX_Control(pDX, IDC_PROGRESS_MAIN, m_progressMain);
	DDX_Control(pDX, IDC_BUTTON_DOWNLOAD2, m_ctrDownloadButton);
	DDX_Control(pDX, IDC_EDIT_RSCR2_PATH, m_editRscr2Path);
	DDX_Control(pDX, IDC_EDIT_RSCR_PATH, m_editRscrPath);
	DDX_Control(pDX, IDC_EDIT_PARAM_DEP_PATH, m_editParamDepPath);
	DDX_Control(pDX, IDC_EDIT_FACTORYFS_PATH, m_editFactoryFSPath);
	DDX_Control(pDX, IDC_RICHEDIT_STATUS, m_editStatus);
	DDX_Control(pDX, IDC_BUTTON_PHONE_IMAGE, m_ctrPhoneImage);
	DDX_Control(pDX, IDC_COMBO_BAUDRATE, m_cbxBaudRate);
	DDX_Control(pDX, IDC_EDIT_IMAGE_PATH, m_editImagePath);
	DDX_Control(pDX, IDC_COMBO_COMPORT, m_ctrlComPort);
	DDX_Radio(pDX, IDC_RADIO3, m_radio);
	DDX_Check(pDX, IDC_CHECK_ECC, m_boolECC);
	DDX_Check(pDX, IDC_CHECK_AUTO, m_boolAuto);
	DDX_Check(pDX, IDC_CHECK_AUTO_REBOOT, m_boolAutoReboot);
	DDX_Check(pDX, IDC_CHECK_CALSET, m_boolCalset);
	DDX_Radio(pDX, IDC_RADIO_UART, m_radioMode);
	DDX_Check(pDX, IDC_CHECK_BOOTLOADER, m_boolBootloader);
	DDX_Check(pDX, IDC_CHECK_IMAGE, m_boolImage);
	DDX_Check(pDX, IDC_CHECK_RSRC, m_boolRsrc);
	DDX_Check(pDX, IDC_CHECK_BOOT, m_ckBoot);
	DDX_Check(pDX, IDC_CHECK_CAL, m_ckCal);
	DDX_Check(pDX, IDC_CHECK_ER, m_ckER);
	DDX_Check(pDX, IDC_CHECK_PARM, m_ckParam);
	DDX_Check(pDX, IDC_CHECK_RC1, m_ckRc1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCabrio_downloaderv01Dlg, CDialog)
	//{{AFX_MSG_MAP(CCabrio_downloaderv01Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_CBN_SELCHANGE(IDC_COMBO_COMPORT, OnSelchangeComboComport)
	ON_BN_CLICKED(IDC_BUTTON_PHONE_IMAGE, OnButtonPhoneImage)
	ON_CBN_SELCHANGE(IDC_COMBO_BAUDRATE, OnSelchangeComboBaudrate)
	ON_BN_CLICKED(IDC_BUTTON_NAND_RSCR, OnButtonNandRscr)
	ON_BN_CLICKED(IDC_BUTTON_NAND_RSCR2, OnButtonNandRscr2)
	ON_BN_CLICKED(IDC_BUTTON_NAND_FACTORYFS, OnButtonNandFactoryfs)
	ON_BN_CLICKED(IDC_BUTTON_SYSPARM_DEP, OnButtonSysparmDep)
	ON_BN_CLICKED(IDC_BUTTON_DOWNLOAD2, OnButtonDownload2)
	ON_BN_CLICKED(IDC_BUTTON_CAP, OnButtonCap)
	ON_BN_CLICKED(IDC_BUTTON2, OnButtonCN)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BUTTON_TITLE, OnButtonTitle)
	ON_BN_CLICKED(IDC_BUTTON_TFS_FORMAT, OnButtonTfsFormat)
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_DISCONNECT, OnButtonDisconnect)
	ON_BN_CLICKED(IDC_BUTTON_DLBOOTLOADER, OnButtonDlbootloader)
	ON_BN_CLICKED(IDC_BUTTON_CABRIO, OnButtonCabrio)
	ON_BN_CLICKED(IDC_BUTTON_INFO, OnButtonInfo)
	ON_BN_CLICKED(IDC_BUTTON_BCHK, OnButtonBchk)
	ON_BN_CLICKED(IDC_BUTTON_NOR_DUMP, OnButtonNorDump)
	ON_BN_CLICKED(IDC_BUTTON_NAND_DUMP, OnButtonNandDump)
	ON_BN_CLICKED(IDC_BUTTON_BOOTLOADER_ERASE, OnButtonBootloaderErase)
	ON_BN_CLICKED(IDC_BUTTON_NOR_ALLERASE, OnButtonNorAllerase)
	ON_BN_CLICKED(IDC_BUTTON_NAND_ENTIRE_FLASH, OnButtonNandEntireFlash)
	ON_EN_CHANGE(IDC_EDIT_MANUAL, OnChangeEditManual)
	ON_BN_CLICKED(IDC_BUTTON_MANUAL_IMAGE, OnButtonManualImage)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_MANUAL_NAND_IMAGE, OnButtonManualNandImage)
	ON_EN_CHANGE(IDC_EDIT_MANUAL_NAND, OnChangeEditManualNand)
	ON_BN_CLICKED(IDC_RADIO_UART, OnRadioUart)
	ON_BN_CLICKED(IDC_RADIO_USB, OnRadioUsb)
	ON_BN_CLICKED(IDC_BUTTON_CAL_INFO, OnButtonCalInfo)
	ON_BN_CLICKED(IDC_BUTTON_RSRC_INFO, OnButtonRsrcInfo)
	ON_BN_CLICKED(IDC_BUTTON_RSRC2_INFO, OnButtonRsrc2Info)
	ON_BN_CLICKED(IDC_BUTTON_FAC_INFO, OnButtonFacInfo)
	ON_BN_CLICKED(IDC_BML_FORMAT, OnBmlFormat)
	ON_BN_CLICKED(IDC_CHECK_ER, OnCheckEr)
	ON_BN_CLICKED(IDC_CHECK_PARM, OnCheckParm)
	ON_BN_CLICKED(IDC_CHECK_RC1, OnCheckRc1)
	ON_BN_CLICKED(IDC_CHECK_CAL, OnCheckCal)
	ON_BN_CLICKED(IDC_CHECK_BOOT, OnCheckBoot)
	ON_BN_CLICKED(IDC_BUTTON3, OnButtonRamdump)
	ON_WM_CANCELMODE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCabrio_downloaderv01Dlg message handlers

BOOL CCabrio_downloaderv01Dlg::OnInitDialog()
{
	

	CDialog::OnInitDialog();
    CString str;
	// Add "About..." menu item to system menu.
	
	VERIFY(m_ctrCap.AutoLoad(IDC_BUTTON_CAP, this));
	
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	ToolProgressCb = ProgressCallBackFunc;
	ToolProgressCbDump = DumpProgressCallBackFunc;
	ToolFileHandleCb = FileHandleCallBackFunc;
//	hCommWnd = this->m_hWnd;

	m_ComPort = AfxGetApp()->GetProfileInt("CabrioDL", "UartPort", m_ComPort);
	m_ctrlComPort.SetCurSel(m_ComPort);

	m_ComPort = AfxGetApp()->GetProfileInt("CabrioDL", "UsbPort", m_ComPort);
	m_ctrlComPort.SetCurSel(m_ComPort);

	m_nBaudRate = AfxGetApp()->GetProfileInt("CabrioDL", "m_nBaudRate", m_nBaudRate);
	m_cbxBaudRate.SetCurSel(m_nBaudRate);
	


	m_nDownloadNum=AfxGetApp()->GetProfileInt("CabrioDL","m_nDownloadNum",m_nDownloadNum);

	if(m_nDownloadNum<0 || m_nDownloadNum>10000)
		m_nDownloadNum=0;

	str.Format("%d",m_nDownloadNum);
	m_editDN.SetWindowText(str);


	m_boolECC = FALSE; //ECC 
	
	bConnect=false;
	m_editStatus.EnableWindow(true);
	m_editSubStatus.EnableWindow(true);
	m_ctrCN.EnableWindow(false);

	str.Format("  Disconnect");
	ShowEnv(str,4);

	str.Format("  Disconnect");
	ShowEnv(str,3);
	
	totaltime=0;

	m_fAddress=0;
	SetDlgItemText(IDC_EDIT_MANUAL,"0");
	SetDlgItemText(IDC_EDIT_MANUAL_NAND,"0");

	nOnline=false;
	
  //  m_my_brush.CreateSolidBrush(RGB(0,0,255)); // Brush Ӽ Ѵ.



	
	InitVariables();
//	LockControls();

	
	pThread=NULL;
	RestoreProgramSetting();


	 m_font.CreateFont( // m_font  Ŭ   ִٰ 
        35, // nHeight 
         10, // nWidth 
         1, // nEscapement 
         5, // nOrientation 
         1, // nWeight 
         0, // bItalic 
         0, // bUnderline 
         0, // cStrikeOut 
         0, // nCharSet 
         OUT_DEFAULT_PRECIS, // nOutPrecision 
         0, // nClipPrecision 
         DEFAULT_QUALITY, // nQuality 
         DEFAULT_PITCH | FF_DONTCARE, // nPitchAndFamily 
   //      "Fixedsys" // lpszFacename 
		   "Arial Black"
    ); 
    //
	 
	 m_font2.CreateFont( // m_font  Ŭ   ִٰ 
        27, // nHeight 
        10, // nWidth 
         1, // nEscapement 
         2, // nOrientation 
         1, // nWeight 
         0, // bItalic 
         0, // bUnderline 
         0, // cStrikeOut 
         0, // nCharSet 
         OUT_DEFAULT_PRECIS, // nOutPrecision 
         0, // nClipPrecision 
         DEFAULT_QUALITY, // nQuality 
         DEFAULT_PITCH | FF_DONTCARE, // nPitchAndFamily 
        "Arial Black" // lpszFacename 
//		   "Tahoma"
    ); 

	 m_font3.CreateFont( // m_font  Ŭ   ִٰ 
        15, // nHeight 
        7, // nWidth 
         1, // nEscapement 
         0, // nOrientation 
         0, // nWeight 
         0, // bItalic 
         0, // bUnderline 
         0, // cStrikeOut 
         0, // nCharSet 
         OUT_DEFAULT_PRECIS, // nOutPrecision 
         0, // nClipPrecision 
         DEFAULT_QUALITY, // nQuality 
         DEFAULT_PITCH | FF_DONTCARE, // nPitchAndFamily 
        "Arial" // lpszFacename 
//		   "Tahoma"
    ); 

	 m_font4.CreateFont( // m_font  Ŭ   ִٰ 
        16, // nHeight 
        6, // nWidth 
         1, // nEscapement 
         0, // nOrientation 
         0, // nWeight 
         0, // bItalic 
         0, // bUnderline 
         0, // cStrikeOut 
         0, // nCharSet 
         OUT_DEFAULT_PRECIS, // nOutPrecision 
         0, // nClipPrecision 
         DEFAULT_QUALITY, // nQuality 
         DEFAULT_PITCH | FF_DONTCARE, // nPitchAndFamily 
        "Verdana Black" // lpszFacename 
//		   "Tahoma"
    );

	 m_font5.CreateFont( // m_font  Ŭ   ִٰ 
        20, // nHeight 
        7, // nWidth 
         1, // nEscapement 
         0, // nOrientation 
         90, // nWeight 
         0, // bItalic 
         0, // bUnderline 
         0, // cStrikeOut 
         0, // nCharSet 
         OUT_DEFAULT_PRECIS, // nOutPrecision 
         0, // nClipPrecision 
         DEFAULT_QUALITY, // nQuality 
         DEFAULT_PITCH | FF_DONTCARE, // nPitchAndFamily 
        "Arial Black" // lpszFacename 
//		   "Tahoma"
    );

	m_font6.CreateFont( // m_font  Ŭ   ִٰ 
        14, // nHeight 
        5, // nWidth 
         0, // nEscapement 
         0, // nOrientation 
         0, // nWeight 
         0, // bItalic 
         0, // bUnderline 
         0, // cStrikeOut 
         0, // nCharSet 
         OUT_DEFAULT_PRECIS, // nOutPrecision 
         0, // nClipPrecision 
         DEFAULT_QUALITY, // nQuality 
         DEFAULT_PITCH | FF_DONTCARE, // nPitchAndFamily 
        "Arial" // lpszFacename 
//		   "Tahoma"
    );

	m_font7.CreateFont( // m_font  Ŭ   ִٰ 
        15, // nHeight 
        6, // nWidth 
         0, // nEscapement 
         0, // nOrientation 
         0, // nWeight 
         0, // bItalic 
         0, // bUnderline 
         0, // cStrikeOut 
         0, // nCharSet 
         OUT_DEFAULT_PRECIS, // nOutPrecision 
         0, // nClipPrecision 
         DEFAULT_QUALITY, // nQuality 
         DEFAULT_PITCH | FF_DONTCARE, // nPitchAndFamily 
        "Arial" // lpszFacename 
//		   "Tahoma"
    ); 

	//ư Ʈ 
	 m_ctrCabrio.SetFont(&m_font, TRUE);
	m_ctrlStart.SetFont(&m_font3,TRUE);
	m_editTime.SetFont(&m_font7, TRUE);
	m_btnPer.SetFont(&m_font2,TRUE);
	SetTimer(0,1000,NULL);
	m_radioMode=1;
	m_boolImage=TRUE;
	m_ckER=1;
	UpdateData(FALSE);
	ReadyControls();
	vImageFile=0;
	vTfsFile=0;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCabrio_downloaderv01Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCabrio_downloaderv01Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCabrio_downloaderv01Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/*
void CCabrio_downloaderv01Dlg::OnCommRead(WPARAM wParam, LPARAM lParam)
{
	BYTE ch;
	static DWORD TFSsize;
	CString strTemp;
	int count = 0;

#if 0
	while ( gSerialPort.m_QueueRead.GetByte( &ch ) )
	{
		if( ch != '\r' )
		{
			if( count % 10 == 0 )
			{
			strTemp.Format("%c",ch);
		m_ctrlRichEditBox.SetSel(-1,-1);
		m_ctrlRichEditBox.ReplaceSel(strTemp);
			}
			count++;
		}

	}
	#endif
}
*/

void CCabrio_downloaderv01Dlg::OnSelchangeComboComport() 
{
	// TODO: Add your control notification handler code here
	m_ComPort = m_ctrlComPort.GetCurSel();

	if (m_radioMode==0)
		AfxGetApp()->WriteProfileInt("CabrioDL", "UartPort", m_ComPort );
	if (m_radioMode==1)
		AfxGetApp()->WriteProfileInt("CabrioDL", "UsbPort", m_ComPort );

	
}

void CCabrio_downloaderv01Dlg::OnButtonPhoneImage() 
{
	// TODO: Add your control notification handler code here
		// TODO: Add your control notification handler code here
	char szFilter[] = "Image File(*.img)|*.img|*.*|*.*||";
	CFile File;
//	UInt32	startAddr[8],imageSize[8],rslt;
	UInt8 * v_code=new UInt8[4];
	CFileDialog dlg(TRUE, NULL, m_strImageFileName, OFN_HIDEREADONLY,szFilter);
	
//	vImageFile=0;

	if(dlg.DoModal() == IDOK)
	{	
		m_strImageFileName = dlg.GetPathName();
		
		if(File.Open(m_strImageFileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
		{
			
			//Check imgset file   address 0x88 0xcc 0xae 0xce 0xaa
			File.Seek(40,CFile::begin);
			File.Read(v_code,4);

//			if (v_code[0]==0xba && v_code[1]==0xbe && v_code[2]==0xfa && v_code[3]==0xce)
			if(1)
			{
				//Check OK				
				m_editImagePath.SetWindowText((LPCTSTR) dlg.GetPathName());	
				File.Close();
			}
			else
			{
				AfxMessageBox("Invalid imgset file");
				File.Close();
				delete v_code;
				return;
			}	

			

	
		}
		else
		{
			AfxMessageBox("Image File Size Error");
			delete v_code;
			return;
		}

		AfxGetApp()->WriteProfileString("CabrioDL", "m_strImageFileName",m_strImageFileName);
	}
	else
	{
		delete v_code;
		return;
	}

	delete v_code;

	
	//μ
	
	int i=0,j=0,cnt=0,bResult,bResult2;
//	int t=0,q=0;
        int t=0;
	int length=0;
	CString tPath,tStr;
	CString tCalset,tRsrc1,tRsrc2,tFactory,nRsrc1,nRsrc2,nCalset,nFactory;

	
	tPath=m_strImageFileName;

	GetFileName(tPath);
	
	//õ z220_imgset.img θ ̿Ͽ δܰ  丮 
	//ڿ . 
	while(1)
	{
		i = tPath.Find("\\",j+1);
		if (i!=-1)
		{
//			q=t;
			t=j;
			j=i;
		//	depth[cnt]=i;
		}
		else
			break;
		cnt++;
	}

	length=tPath.GetLength();
	tStr=tPath.Right(length-j-1);

	
	bResult=tStr.Find("A627");
	bResult2=tStr.Find("A627_");


	
	if (bResult2==-1 && bResult==0)
	{
		//Ĺ    
		tPath.Delete(j,length-j);

		//  ý 
		// ڵ鸵
		bResult=tStr.Find(".");  // '_'  ã´.
		length=tStr.GetLength(); 
		tStr.Delete(bResult,length-bResult) ;   // '_' պκ  ܵΰ .
		
		tStr="\\"+tStr;
		
		tCalset=tPath;
		tRsrc1=tPath;
		tRsrc2=tPath;
		tFactory=tPath;

		nRsrc1=tStr;
		nRsrc2=tStr;
		nCalset=tStr;
		nFactory=tStr;
	
	
		nCalset=nCalset+".img";
		tCalset.Insert(j,nCalset);
		m_editParamDepPath.SetWindowText(tCalset);
		m_strParamDepFileName=tCalset;
		
		AfxGetApp()->WriteProfileString("CabrioDl","m_strParamDepFileName",m_strParamDepFileName);


		
		nRsrc1=nRsrc1+".rc1";
		tRsrc1.Insert(j,nRsrc1);
		m_editRscrPath.SetWindowText(tRsrc1);
		m_strRscrFileName=tRsrc1;
		AfxGetApp()->WriteProfileString("CabrioDL", "m_strRscrFileName",m_strRscrFileName);

		nRsrc2=nRsrc2+".rc2";
		tRsrc2.Insert(j,nRsrc2);
		m_editRscr2Path.SetWindowText(tRsrc2);
		m_strRscr2FileName=tRsrc2;
		AfxGetApp()->WriteProfileString("CabrioDL", "m_strRscr2FileName",m_strRscr2FileName);

		nFactory=nFactory+".tfs";
		tFactory.Insert(j,nFactory);
		m_editFactoryFSPath.SetWindowText(tFactory);
		m_strFactoryFSFileName=tFactory;
		AfxGetApp()->WriteProfileString("CabrioDL", "m_strFactoryFSFileName",m_strFactoryFSFileName);
	}
	else
	{
		//Ϲ ̳ʸ  μ 
//		tPath.Delete(q,length-q);
                tPath.Delete(t,length-t);
		tCalset=tPath;
		tRsrc1=tPath;
		tRsrc2=tPath;
		tFactory=tPath;

		tCalset.Insert(t,"\\build\\bcom_bin\\A627_calset.img");
		m_editParamDepPath.SetWindowText(tCalset);
		m_strParamDepFileName=tCalset;
		AfxGetApp()->WriteProfileString("CabrioDl","m_strParamDepFileName",m_strParamDepFileName);

		//tRsrc1.Insert(t,"\\build\\nand_img\\Rsrc_J210_Generic.rc1");	
		tRsrc1.Insert(t,"\\build\\shp_bin\\A627.rc1");
		m_editRscrPath.SetWindowText(tRsrc1);
		m_strRscrFileName=tRsrc1;
		AfxGetApp()->WriteProfileString("CabrioDL", "m_strRscrFileName",m_strRscrFileName);

		tRsrc2.Insert(t,"\\build\\nand_img\\A627.rc2");
		m_editRscr2Path.SetWindowText(tRsrc2);
		m_strRscr2FileName=tRsrc2;
		AfxGetApp()->WriteProfileString("CabrioDL", "m_strRscr2FileName",m_strRscr2FileName);

		tFactory.Insert(t,"\\build\\shp_bin\\A627.tfs");
		m_editFactoryFSPath.SetWindowText(tFactory);
		m_strFactoryFSFileName=tFactory;
		AfxGetApp()->WriteProfileString("CabrioDL", "m_strFactoryFSFileName",m_strFactoryFSFileName);
	

	}
}



void CCabrio_downloaderv01Dlg::InitVariables()
{

}

void CCabrio_downloaderv01Dlg::RestoreProgramSetting()
{
	//NAND flash ڵ 
	m_strImageFileName = AfxGetApp()->GetProfileString("CabrioDL", "m_strImageFileName", "");
	m_editImagePath.SetWindowText(m_strImageFileName);
}



//Ű 
//-------------------------------------------------------------------
//1. download type
//2. driver  : CURRENT_WITHOUT_DRIVER ϰ ش ̹ ٿε
//3.  ޼  ǥ : 0 ->ǥ
//					    	 1 ->ǥ
bool CCabrio_downloaderv01Dlg::NorDownload(UInt8 cActionType,int prompt)
{

//	void * comPort;
	UInt8 initBaudRate,dnldBaudRate;
	CString str,str2;
	UInt32 startAddr;
	Result_t result;
	char buf[20];
	double duration;
//	UpdateData(true);
	bool rslt;
	int type2;
	char cTime[8];
//	char * timeinfo=LPSTR(LPCTSTR(str_time));  //ð ´.
	char * timeinfo;

	LockControls();


	clock_t StartTime, FinishTime;

	
	str.Format("COM%d",m_ComPort+1);
	char * arg_device=LPSTR(LPCTSTR(str));

	if (nConnectMode==UART_MODE)
	{
		if (cDriverStatus==CURRENT_WITHOUT_DRIVER || cDriverStatus==CURRENT_NAND_DRIVER)
		{
			rslt=NorDriverDownload(&comPortCfg,1);
			if (rslt==false) goto _cleanup;
		}
	}
	

	type2=cActionType;

	switch(cActionType)
	{
		case DWL_IMGSET:
			str2.Format("\n  * NOR : Imgset Download");
			ShowStatus(str2,4);
			break;
		case DWL_CALSET:
			str2.Format("\n  * NOR : Calset Download");
			ShowStatus(str2,4);
			break;
		case DWL_MANUAL:
			str2.Format("\n  * NOR : Manual Download");
			ShowStatus(str2,4);
			break;
		default:
			rslt=false;
			break;
	}


	initBaudRate=g_BaudRate[0];
	dnldBaudRate=g_BaudRate[m_cbxBaudRate.GetCurSel()];


	if( (!initBaudRate ) || (!dnldBaudRate ))
	{
		AfxMessageBox("BaudRate Error");
		return false;
	}

	

	StartTime = clock();


	str2.Format("\n    Open Comport\t\t\t\t> > > ");
	ShowStatus(str2);
        if (nConnectMode==UART_MODE)
	{

		Sleep(1000*1);

		comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , initBaudRate ) ;

		if (comPort==0)
		{
			str2.Format("FAIL");
			ShowStatus(str2,4);
			rslt=false;
			goto _cleanup;	
		}
		else
		{
			str2.Format("OK");
			ShowStatus(str2,3);
		}

		
		
		if( initBaudRate != dnldBaudRate ) 
		{
			str2.Format("\n    Set Target Phone BaudRate\t\t> > > ");
			ShowStatus(str2);
			
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
		else
		{
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
	}
        else
        {
	        comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , dnldBaudRate ) ;

        	if (comPort==0)
        	{
        		str2.Format("FAIL");
        		ShowStatus(str2,4);
        		rslt=false;
        		goto _cleanup;
         	}
        	else
        	{
         		str2.Format("OK");
	        	ShowStatus(str2,3);
        	}
        }

	switch(type2)
	{
		case DWL_IMGSET:

			if (m_boolBootloader==TRUE)	// without Bootloader
				startAddr = 0xABCDEFAB;
			if (m_boolBootloader==FALSE)		// include Bootloader
				startAddr = 0xBABEFACE;

			itoa(m_nImageSize,buf,10);
			str2.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str2);
			GetCheckSum(m_strImageFileName);
			GetFileName(m_strImageFileName);
			str2.Format("\n    imgset Download start!!\n");
			ShowStatus(str2);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
			
			result = TOOL_NorFlashDownload(nConnectMode,comPort,(UInt8*)m_strImageFileName.GetBuffer(MYBUFF_SIZE),startAddr,0,ToolProgressCb ) ;
            timeinfo=LPSTR(LPCTSTR(str_time));  //ð ´.
			memcpy(cTime,timeinfo,strlen(timeinfo));
			
			result = TOOL_SetTime(comPort,cTime,nConnectMode);
			FinishTime=clock();
			break;

		case DWL_CALSET:
			startAddr = 0xBABEFACE;
			itoa(m_nParamDepSize,buf,10);
			str2.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str2);
			GetCheckSum(m_strParamDepFileName);
			GetFileName(m_strParamDepFileName);
			str2.Format("\n    Now Z220_calset Downloading start!!\n");
			ShowStatus(str2);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
			result = TOOL_NorFlashDownload(nConnectMode,comPort,(UInt8*)m_strParamDepFileName.GetBuffer(MYBUFF_SIZE),startAddr,0,ToolProgressCb ) ;
			FinishTime=clock();
			break;

		case DWL_MANUAL:
			startAddr = m_fAddress;
			itoa(m_nManulImageSize,buf,10);
			str2.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str2);
			GetCheckSum(m_strManualImage);
			GetFileName(m_strManualImage);
			str2.Format("\n    Now Manual Download start!!( Start address : 0x%x File Size : %d\n",startAddr,m_nManulImageSize);
			ShowStatus(str2);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
			result = TOOL_NorFlashDownload(nConnectMode,comPort,(UInt8*)m_strManualImage.GetBuffer(MYBUFF_SIZE),startAddr,m_nManulImageSize,ToolProgressCb ) ;
			FinishTime=clock();

		default:
			rslt=false;
			break;
	}
	
	ShowStatus("\n      Download");

	if( RESULT_OK != result ) 
	{
		str.Format("  Failed");
		ShowStatus(str,4);
		str.Format( "Error flashing image set : %s\n",TOOL_GetResultStr( result ));
		AfxMessageBox(str);
		rslt=false;
		goto _cleanup;
	}
	else
	{
		str.Format("  Completed");
		ShowStatus(str,3);
	}


	if (nConnectMode==UART_MODE)
	{
		if( initBaudRate != dnldBaudRate ) 
		{
			result = TOOL_SetTargetBaudRate( comPort, initBaudRate,0 ) ;
			if( RESULT_OK != result ) 
			{
				str.Format( "Error  changing target baud rate : %s\n",TOOL_GetResultStr( result ));
				AfxMessageBox(str);
				rslt=false;
				goto _cleanup;
			}

			TOOL_ChangeComPortBaudRate( comPort, initBaudRate ) ;
		}
	}
	
	//
	if (prompt==0 && m_boolAutoReboot==true)
	{
		result = TOOL_PhoneReset(comPort);
		if( RESULT_OK != result )
		{
			str.Format( "Error  changing target baud rate : %s\n",TOOL_GetResultStr( result ));
			AfxMessageBox(str);
			rslt=false;
	
			goto _cleanup;
		}

	}

	
	rslt=true;
	
_cleanup:
	
	TOOL_CloseDnldPort( comPort ) ;

	duration = (double)(FinishTime - StartTime) / CLOCKS_PER_SEC;
	totaltime+=duration;
	str.Format("  ( Elapsed Time : %5.1fs)\n", duration);
	ShowStatus(str,4);
	

	if (m_boolAuto==false || m_boolAutoReboot==true)
	{
		if (prompt==0 && result==RESULT_OK)
			MessageBox("Download Finished","  NOTICE  ");
	}
	if (m_boolAutoReboot==true)
		ReadyControls();

	if ((m_radio==7) && rslt==true)
		return rslt;

	InitControls();
	return rslt;
	
}

bool CCabrio_downloaderv01Dlg::Dlbootloader(UInt8 cActionType)
{
	Result_t		result;
	UInt32			startAddr;
//	ComPortCfg_t	comPortCfg;
	CString str;
	double duration;

	if (cActionType==DWL_BOOT1)
	{
		AfxMessageBox("Bootloader Download available in UART Comport");
	}
	LockControls();
	str.Format("COM%d",m_ComPort+1);


	//
	// set up the COM configuration structure - zero the structure
	// so that  default values will be supplied by the API
	//
	memset( (char*)&comPortCfg,0,sizeof(ComPortCfg_t) );
	strcpy( (char*)comPortCfg.comPortName,str ) ;  // COM port name
	comPortCfg.baudRate = g_BaudRate[m_cbxBaudRate.GetCurSel()];//COMPORT_BAUDRATE_115K;

	//
	// download the flash driver
	// flashdrv_all.img
	
	if (cActionType==DWL_BOOT1)
	{
	
		str.Format("\n-----------------------------------------------------------------------------\n  Bootloader Download mode ");
		ShowStatus(str,3);
		if (m_cbxBaudRate.GetCurSel()==0)
		{
			str.Format("( COM%d  BaudRate : 115k )\n-----------------------------------------------------------------------------\n",m_ComPort+1);
		}
		if (m_cbxBaudRate.GetCurSel()==1)
		{
			str.Format("( COM%d  BaudRate : 460k )\n-----------------------------------------------------------------------------\n",m_ComPort+1);
		}
		if (m_cbxBaudRate.GetCurSel()==2)
		{
			str.Format("( COM%d  BaudRate : 921k )\n-----------------------------------------------------------------------------\n",m_ComPort+1);
		}
		ShowStatus(str,3);
	}

	
	
	//ð
	clock_t StartTime, FinishTime;

	str.Format("  SDRAM initializing...........");
	ShowStatus(str);

	StartTime = clock();
	//result = TOOL_DownloadDriver_Itcm(&comPortCfg);  //preloader 
	result = TOOL_DownloadDriver_Itcm_set_Baudrate(&comPortCfg);  //preloader 
	
	result = TOOL_DownloadDriver(&comPortCfg);
	str.Format("  OK \n");
	ShowStatus(str,1);
	str.Format("  FlashLoader download & running...........");
	ShowStatus(str);
	result = TOOL_DownloadBoot(&comPortCfg,DRV_BOOTLOADER);
	
//	Sleep(1000*2);
	
	if( result != RESULT_OK ) 
	{
		if( result == RESULT_TOOL_FILE_OPEN_ERROR )
		{
			str.Format("Make sure whether flashdrv_all.img file is in same folder");
			MessageBox(str,"Downloading Failure");
		}
		else
		{
			CString str;
			str.Format("%s",TOOL_GetResultStr(result));
			MessageBox(str,"Downloading Failure");
		}
		str.Format("FAIL\n");
		ShowStatus(str,4);
		str.Format("\n  Turn On/Off the target phone!!!\n");
		ShowStatus(str,4);
		ReadyControls();
		return false;
	}

		//flashdrv_nandimg downloading successfully..
	str.Format("  OK\n");
	ShowStatus(str,1);

	SetOffset(0); //offset_s=0;
	Sleep(1000*1);
	CString tempname="bootloader.img";
#ifdef _CUSTOMER_
	if(cActionType==DWL_BOOT1)
		str.Format("  Now BOOTa Downloading........ ");
	else if(cActionType==DWL_BOOT2)
		str.Format("  Now BOOTb Downloading........ ");
	else
		str.Format("  Now BOOTc Downloading........ ");
#else
	if(cActionType==DWL_BOOT1)
		str.Format("  Now SEC_BOOT Downloading........ ");
	else if(cActionType==DWL_BOOT2)
		str.Format("  Now BOOT1a Downloading........ ");
	else
		str.Format("  Now BOOT1b Downloading........ ");
#endif
	ShowStatus(str);
	//Sleep(1000*1);JUN0612

//	result = TOOL_DownloadBootloader(&comPortCfg,0xbabeface);
//	result = TOOL_DownloadImage((UInt8*)m_strImageFileName.GetBuffer(MYBUFF_SIZE),&comPortCfg,0x0,ToolProgressCb);
	if(cActionType==DWL_BOOT1)
	{
		startAddr = 0x0000000;
		result = TOOL_DownloadBootDL(&comPortCfg, startAddr, ToolProgressCb, cActionType) ;
	}
	else if(cActionType==DWL_BOOT2)
	{
		startAddr = 0x1000;
		result = TOOL_DownloadBootDL(&comPortCfg, startAddr, ToolProgressCb, cActionType) ;
	}
	else
	{
		startAddr = 0x4000;
		result = TOOL_DownloadBootDL(&comPortCfg, startAddr, ToolProgressCb, cActionType) ;
	}


	if( result != RESULT_OK ) 
	{
		CString str;
		str.Format("FAIL\n");
		ShowStatus(str,4);
		str.Format("%s",TOOL_GetResultStr(result));
		MessageBox(str,"Downloading Failure");
		str.Format("\n  Turn On/Off the target phone!!!\n");
		ShowStatus(str,4);

		goto init;
	}
	
	str.Format("OK\n\n");
	ShowStatus(str,3);

#if 0
	FinishTime = clock();
	str.Format("OK\n");
	ShowStatus(str,3);
//	MessageBox("Bootloader Download finished\nYou Must Turn","Download Completed");

	duration = (double)(FinishTime - StartTime) / CLOCKS_PER_SEC;

	str.Format("\n (Total Elapsed Time : %5.1fs)\n\n", duration);
	ShowStatus(str,4);
#endif
	cDriverStatus=CURRENT_WITHOUT_DRIVER;

init:
//	ReadyControls();
	return true;
	

}

bool CCabrio_downloaderv01Dlg::Erase(UInt8 cActionType)
{

//	void * comPort;
	UInt8 initBaudRate,dnldBaudRate;
	CString str,str2;
	Result_t result;
	bool rslt;


	str.Format("COM%d",m_ComPort+1);
	char * arg_device=LPSTR(LPCTSTR(str));


	initBaudRate=g_BaudRate[0];
	dnldBaudRate=g_BaudRate[m_cbxBaudRate.GetCurSel()];

	if (cActionType==OP_ERASE_BOOTLOADER)
	{
		str2.Format("\n  * Bootloader area erase");
		ShowStatus(str2,4);
	}
	else
	{
		str2.Format("\n  * NAND Flash all erase");
		ShowStatus(str2,4);
	}



	
	if( (!initBaudRate ) || (!dnldBaudRate ))
	{
		AfxMessageBox("BaudRate Error");
		rslt=false;
		goto _cleanup;
	}

        str2.Format("\n    Open Comport\t\t\t\t> > > ");
        ShowStatus(str2);


	if(cActionType != OP_ERASE_BOOTLOADER)	//JUN_comm_test___
	{

		comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , initBaudRate ) ;

		if (comPort==0)
		{
			str2.Format("FAIL");
			ShowStatus(str2,4);
			rslt=false;
			goto _cleanup;	
		}
		else
		{
			str2.Format("OK");
			ShowStatus(str2,3);
		}

		

		if( initBaudRate != dnldBaudRate ) 
		{
			str2.Format("\n    Set Target Phone BaudRate\t\t> > > ");
			ShowStatus(str2);
			
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
		else
		{
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
		
	}
        else
        {
	        comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , initBaudRate ) ;

        	if (comPort==0)
        	{
        		str2.Format("FAIL");
        		ShowStatus(str2,4);
        		rslt=false;
        		goto _cleanup;
         	}
        	else
        	{
         		str2.Format("OK");
	        	ShowStatus(str2,3);
        	}
        }
#if 0		
	if (cActionType==OP_ERASE_BOOTLOADER)	//JUN_comm_init
			comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , initBaudRate ) ;
	else
	        comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , dnldBaudRate ) ;


        	if (comPort==0)
        	{
        		str2.Format("FAIL");
        		ShowStatus(str2,4);
        		rslt=false;
        		goto _cleanup;
         	}
        	else
        	{
         		str2.Format("OK");
	        	ShowStatus(str2,3);
        	}
#endif
	str.Format("\n    Now NAND All blocks erasing\t\t> > > ");
	ShowStatus(str);
	
	result=TOOL_FlashErase(comPort,cActionType,nConnectMode);
	
	if( RESULT_OK != result ) 
	{
		str.Format("Fail");
		ShowStatus(str,4);
		str.Format( "Error flashing erase : %s\n",TOOL_GetResultStr( result ));
		AfxMessageBox(str);
		rslt=false;
		
		goto _cleanup;
	}
	else
	{
	//	Sleep(1000*20);
		str.Format("OK\n");
		ShowStatus(str,3);
	}



#if 0
	if (nConnectMode==UART_MODE)
	{
		//flashdrv_nandimg downloading successfully..
		if( initBaudRate != dnldBaudRate ) 
		{
			result = TOOL_SetTargetBaudRate( comPort, initBaudRate,0 ) ;
			if( RESULT_OK != result ) 
			{
				str.Format( "Error  changing target baud rate : %s\n",TOOL_GetResultStr( result ));
				AfxMessageBox(str);	
				rslt=false;
				goto _cleanup;
			}

			TOOL_ChangeComPortBaudRate( comPort, initBaudRate ) ;
		}
	}
#endif
	rslt=true;
	cDriverStatus=CURRENT_NAND_DRIVER;
_cleanup:
	TOOL_CloseDnldPort( comPort );
	
	if (result==RESULT_OK && m_boolAuto==false && cActionType!=DWL_ALL)
		MessageBox("All Erase complete","NOTICE");
	InitControls();
	m_ctrCN.EnableWindow(true);
	return rslt;
}

bool CCabrio_downloaderv01Dlg::NorErase(UInt8 cActionType)
{

//	void * comPort;
	UInt8 initBaudRate,dnldBaudRate;
	CString str,str2;
	Result_t result;
	bool rslt;


	str.Format("COM%d",m_ComPort+1);
	char * arg_device=LPSTR(LPCTSTR(str));

	if (nConnectMode==UART_MODE)
	{
		if ( (cDriverStatus==CURRENT_WITHOUT_DRIVER) || (cDriverStatus==CURRENT_NAND_DRIVER)|| 
			(cActionType==DWL_ALL))
		{
			rslt=NorDriverDownload(&comPortCfg,1);
			if (rslt==false)
				goto _cleanup;
		}
	}


	initBaudRate=g_BaudRate[0];
	dnldBaudRate=g_BaudRate[m_cbxBaudRate.GetCurSel()];

	if (cActionType==OP_ERASE_BOOTLOADER)
	{
		str2.Format("\n  * Bootloader erase");
		ShowStatus(str2,4);
	}
	else
	{
//		str2.Format("\n  * NOR Flash all erase");
		str2.Format("\n  * TFS FORMAT ");
		ShowStatus(str2,4);
	}



	
	if( (!initBaudRate ) || (!dnldBaudRate ))
	{
		AfxMessageBox("BaudRate Error");
		rslt=false;
		goto _cleanup;
	}

	str2.Format("\n    Open Comport\t\t\t\t> > > ");
	ShowStatus(str2);

	if (nConnectMode==UART_MODE)
	{

		Sleep(1000*1);

		comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , initBaudRate ) ;

		if (comPort==0)
		{
			str2.Format("FAIL");
			ShowStatus(str2,4);
			rslt=false;
			goto _cleanup;	
		}
		else
		{
			str2.Format("OK");
			ShowStatus(str2,3);
		}

		Sleep(1000*1);
		if( initBaudRate != dnldBaudRate ) 
		{
			str2.Format("\n    Set Target Phone BaudRate\t\t> > > ");
			ShowStatus(str2);
			
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
		else
		{
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
	}
        else
        {
	        comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , dnldBaudRate ) ;

        	if (comPort==0)
        	{
        		str2.Format("FAIL");
        		ShowStatus(str2,4);
        		rslt=false;
        		goto _cleanup;
         	}
        	else
        	{
         		str2.Format("OK");
	        	ShowStatus(str2,3);
        	}
        }

	Sleep(1000*1);


	if (cActionType==OP_ERASE_BOOTLOADER)
	{
		str.Format("\n    Now erasing start!!\n");
		ShowStatus(str);
		str2.Format("-----------------------------------------------------------------------------------------------\n");
		ShowStatus(str2);
	}
	else
	{
		str.Format("\n    TFS Format start!!\n");
		ShowStatus(str);
		str2.Format("-----------------------------------------------------------------------------------------------\n");
		ShowStatus(str2);
	}
	
	
	
	if (cActionType==OP_ERASE_BOOTLOADER)
		result=TOOL_NorErase(comPort,0,ToolProgressCb);
	if (cActionType==OP_NOR_ERASE)
		
		result=TOOL_NorErase(comPort,0x1E90000,ToolProgressCb);
	


	if( RESULT_OK != result ) 
	{
		str.Format("Fail");
		ShowStatus(str,4);
		str.Format( "Error flashing erase : %s\n",TOOL_GetResultStr( result ));
		AfxMessageBox(str);
		rslt=false;
		
		goto _cleanup;
	}
		
	if (nConnectMode==UART_MODE)
	{
		//flashdrv_nandimg downloading successfully..
		if( initBaudRate != dnldBaudRate ) 
		{
			result = TOOL_SetTargetBaudRate( comPort, initBaudRate,0 ) ;
			if( RESULT_OK != result ) 
			{
				str.Format( "Error  changing target baud rate : %s\n",TOOL_GetResultStr( result ));
				AfxMessageBox(str);	
				rslt=false;
				goto _cleanup;
			}

			TOOL_ChangeComPortBaudRate( comPort, initBaudRate ) ;
		}
	}
	if (cActionType==OP_ERASE_BOOTLOADER)
	ShowStatus("\n      Erase");
	else
	ShowStatus("\n      Format");
	str.Format("  Completed!!!\n\n");
	ShowStatus(str,3);

	TOOL_PhoneReset(comPort);

	rslt=true;
	cDriverStatus=CURRENT_NOR_DRIVER;
_cleanup:

	TOOL_CloseDnldPort( comPort );
	
	if (result==RESULT_OK)
		if (cActionType==OP_ERASE_BOOTLOADER)
		MessageBox("All Erase complete","NOTICE");
		else
		MessageBox("TFS Format complete","NOTICE");
	ReadyControls();
	m_ctrCN.EnableWindow(true);
	return rslt;
}

void CCabrio_downloaderv01Dlg::DisplayButton(UInt8 type,int a,unsigned long addr)
{
	switch(type)
	{
		case CURRENT_NAND_DRIVER:
			if ((addr>=0x3700000 && addr<0x4FBFFFF))
			{
				if (a==0)
					//GetDlgItem(IDC_BUTTON_NAND_RSCR)->SetFont(&m_font4);
					m_ctrRscr.SetFont(&m_font4, TRUE);
				if (a==1)
					//GetDlgItem(IDC_BUTTON_NAND_RSCR)->SetFont(&m_font5);
					m_ctrRscr.SetFont(&m_font5, TRUE);
				break;
			}
			if ((addr>=0xAC0000 && addr<0xCC0000))
			{
				if (a==0)
					//GetDlgItem(IDC_BUTTON_NAND_RSCR2)->SetFont(&m_font4);
					m_ctrRscr2.SetFont(&m_font4, TRUE);
				if (a==1)
					//GetDlgItem(IDC_BUTTON_NAND_RSCR2)->SetFont(&m_font5);
					m_ctrRscr2.SetFont(&m_font5, TRUE);

				break;
			}
#if 0
			if ((addr>=0xCC0000 && addr<0xDC0000))
			{
				if (a==0)
					//GetDlgItem(IDC_BUTTON_NAND_FACTORYFS)->SetFont(&m_font4);
					m_ctrFactoryFS.SetFont(&m_font4, TRUE);
				if (a==1)
					//GetDlgItem(IDC_BUTTON_NAND_FACTORYFS)->SetFont(&m_font5);
					m_ctrFactoryFS.SetFont(&m_font5, TRUE);
				break;
			}
#endif
			if ((addr>=0x04A0000 && addr<0x36DFFFF))
			{
				if (a==0)
					//GetDlgItem(IDC_BUTTON_PHONE_IMAGE)->SetFont(&m_font4);
					m_ctrPhoneImage.SetFont(&m_font4,TRUE);
				if (a==1)
					//GetDlgItem(IDC_BUTTON_PHONE_IMAGE)->SetFont(&m_font5);
					m_ctrPhoneImage.SetFont(&m_font5,TRUE);
				break;
			}
			if ((addr>=0x0260000 && addr<=0x027FFFF))
			{
				if (a==0)
					//GetDlgItem(IDC_BUTTON_SYSPARM_DEP)->SetFont(&m_font4);
					m_ctrSysDep.SetFont(&m_font4,TRUE);
				if (a==1)
					//GetDlgItem(IDC_BUTTON_SYSPARM_DEP)->SetFont(&m_font5);
					m_ctrSysDep.SetFont(&m_font5,TRUE);
				break;
			}
			break;
		case CURRENT_NOR_DRIVER:
#if 0
			if ((addr>=0x04A0000 && addr<0x36DFFFF))
			{
				if (a==0)
					//GetDlgItem(IDC_BUTTON_PHONE_IMAGE)->SetFont(&m_font4);
					m_ctrPhoneImage.SetFont(&m_font4,TRUE);
				if (a==1)
					//GetDlgItem(IDC_BUTTON_PHONE_IMAGE)->SetFont(&m_font5);
					m_ctrPhoneImage.SetFont(&m_font5,TRUE);
				break;
			}
			if ((addr>=0x0240000 && addr<=0x027FFFF))
			{
				if (a==0)
					//GetDlgItem(IDC_BUTTON_SYSPARM_DEP)->SetFont(&m_font4);
					m_ctrSysDep.SetFont(&m_font4,TRUE);
				if (a==1)
					//GetDlgItem(IDC_BUTTON_SYSPARM_DEP)->SetFont(&m_font5);
					m_ctrSysDep.SetFont(&m_font5,TRUE);
				break;
			}
#endif
			break;
		default:
			break;
	}
	


}

bool CCabrio_downloaderv01Dlg::TFS_Format(UInt8 temp)
{
	

	CTFSDialog hDialog;
	
	if(hDialog.DoModal() == IDCANCEL)
	{
		InitControls();
		return false;
	}


//	void * comPort;
	UInt8 initBaudRate,dnldBaudRate;
	CString str,str2;
	Result_t result;
	bool rslt;


	str.Format("COM%d",m_ComPort+1);
	char * arg_device=LPSTR(LPCTSTR(str));




	if (nConnectMode==UART_MODE)
	{
		if (cDriverStatus==CURRENT_WITHOUT_DRIVER || cDriverStatus==CURRENT_NOR_DRIVER)
		{
			rslt=NandDriverDownload(&comPortCfg,1);
			if (rslt==false)
				goto _cleanup;
		}
	}




	initBaudRate=g_BaudRate[0];
	dnldBaudRate=g_BaudRate[m_cbxBaudRate.GetCurSel()];

	str2.Format("\n  * TFS Format");
	ShowStatus(str2,4);


	
	if( (!initBaudRate ) || (!dnldBaudRate ))
	{
		AfxMessageBox("BaudRate Error");

			goto _cleanup;
	}

	
	str2.Format("\n    Open Comport\t\t\t\t> > > ");
        ShowStatus(str2);
	if (nConnectMode==UART_MODE)
	{

	//	Sleep(1000*1);

		comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , initBaudRate ) ;

		if (comPort==0)
		{
			str2.Format("FAIL");
			ShowStatus(str2,4);
			rslt=false;
			goto _cleanup;	
		}
		else
		{
			str2.Format("OK");
			ShowStatus(str2,3);
		}

		
		
		if( initBaudRate != dnldBaudRate ) 
		{
			str2.Format("\n    Set Target Phone BaudRate\t\t> > > ");
			ShowStatus(str2);
			
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
		else
		{
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
	}
        else
        {
	        comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , dnldBaudRate ) ;

        	if (comPort==0)
        	{
        		str2.Format("FAIL");
        		ShowStatus(str2,4);
        		rslt=false;
        		goto _cleanup;
         	}
        	else
        	{
         		str2.Format("OK");
	        	ShowStatus(str2,3);
        	}
        }

	Sleep(1000*1);

	str.Format("\n    Now NAND TFS Format Setting\t\t> > > ");

//	str.Format("\n    Now NOR TFS Format Setting\t\t> > > ");

	ShowStatus(str);

	result=TOOL_TFSformat(comPort,nConnectMode);
	if( RESULT_OK != result ) 
	{
		str.Format("Fail");
		ShowStatus(str,4);
		str.Format( "Error flashing erase : %s\n",TOOL_GetResultStr( result ));
		AfxMessageBox(str);
		rslt=false;
		goto _cleanup;
	}
	else
	{
		str.Format("OK\n");
		ShowStatus(str,3);
	}
	



	//flashdrv_nandimg downloading successfully..

	if (nConnectMode==UART_MODE)
	{
		if( initBaudRate != dnldBaudRate ) 
		{
			result = TOOL_SetTargetBaudRate( comPort, initBaudRate,0 ) ;
			if( RESULT_OK != result ) 
			{
				str.Format( "Error  changing target baud rate : %s\n",TOOL_GetResultStr( result ));
				AfxMessageBox(str);	
				rslt=false;
				goto _cleanup;
			}

			TOOL_ChangeComPortBaudRate( comPort, initBaudRate ) ;
		}
	}
	
	rslt=true;
	cDriverStatus=CURRENT_NAND_DRIVER;
//	cDriverStatus=CURRENT_NOR_DRIVER;
_cleanup:
	TOOL_CloseDnldPort( comPort );
	MessageBox("TFS All Erased. Turn On/Off","  NOTICE  ");
	InitControls();
	return rslt;
}

static void CbFunc( UInt32 downloadedBytes )
{
	;

}


bool CCabrio_downloaderv01Dlg::NandDownload(UInt8 cActionType,int prompt)
{

//	void * comPort;
	UInt8 initBaudRate,dnldBaudRate;
	CString str,str2;
	UInt32 startAddr;
	Result_t result;
	char buf[20];
	double duration;
	bool rslt;
//	UpdateData(true);
	char cTime2[8];
	char * timeinfo2; 

	LockControls();

	clock_t StartTime, FinishTime;
	
	str.Format("COM%d",m_ComPort+1);
		char * arg_device=LPSTR(LPCTSTR(str));

	if (cActionType==DWL_BOOT4)
	{
		nConnectMode=UART_MODE;
		prompt=0;
		cDriverStatus=CURRENT_WITHOUT_DRIVER;
	}
	

	// UART Mode  loader ٿε Ѵ.
	if (cActionType==DWL_BOOT4)
	{
		if (cDriverStatus==CURRENT_WITHOUT_DRIVER)
		{
			rslt=NandDriverDownload(&comPortCfg,1);
			if (rslt==false) goto _cleanup;
		}
	}

	
	switch(cActionType)
	{
		case DWL_IMGSET:
			str2.Format("\n  * NAND : Imgset Download");
			ShowStatus(str2,4);
			break;
		case DWL_CALSET:
			str2.Format("\n  * NAND : Calset Download");
			ShowStatus(str2,4);
			break;
#if 0
		case DWL_TFLASH:
			str2.Format("\n  * NAND : Imgset Download via TFLASH");
			ShowStatus(str2,4);
			break;
#endif
		case DWL_RSRC1:
			str2.Format("\n  * NAND : Rsrc1 Download");
			ShowStatus(str2,4);
			break;
		case DWL_RSRC2:
			str2.Format("\n  * NAND : Rsrc2 Download");
			ShowStatus(str2,4);
			break;
		case DWL_FACTORYFS:
			str2.Format("\n  * NAND : TFS Format & Download");
			ShowStatus(str2,4);
			break;
			
		case DWL_FLASHALL:
			str2.Format("\n  * NAND : Entire Flash Download");
			ShowStatus(str2,4);
			break;

		case DWL_MANUAL_NAND:
			str2.Format("\n  * NAND : Manual Download");
			ShowStatus(str2,4);
			break;
		case DWL_BOOT4:
#ifdef _CUSTOMER_
			str2.Format("\n  * Bootd Download");
#else
			str2.Format("\n  * Boot2 Download");
#endif
			ShowStatus(str2,4);
			break;

		default:
			break;
	}


	initBaudRate=g_BaudRate[0];
	dnldBaudRate=g_BaudRate[m_cbxBaudRate.GetCurSel()];

	if( (!initBaudRate ) || (!dnldBaudRate ))
	{
		AfxMessageBox("BaudRate Error");
		return false;

	}// 



	StartTime = clock();

	
	str2.Format("\n    Open Comport\t\t\t\t> > > ");
        ShowStatus(str2);
	if ((cActionType==DWL_BOOT4) || (nConnectMode==UART_MODE))	//JUN_comm_test___
	{

		Sleep(1000*1);

		comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , initBaudRate ) ;

		if (comPort==0)
		{
			str2.Format("FAIL");
			ShowStatus(str2,4);
			rslt=false;
			goto _cleanup;	
		}
		else
		{
			str2.Format("OK");
			ShowStatus(str2,3);
		}

		

		if( initBaudRate != dnldBaudRate ) 
		{
			str2.Format("\n    Set Target Phone BaudRate\t\t> > > ");
			ShowStatus(str2);
			
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
		else
		{
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
		
	}
        else
        {
	        comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , dnldBaudRate ) ;

        	if (comPort==0)
        	{
        		str2.Format("FAIL");
        		ShowStatus(str2,4);
        		rslt=false;
        		goto _cleanup;
         	}
        	else
        	{
         		str2.Format("OK");
	        	ShowStatus(str2,3);
        	}
        }
	Mode3 = nConnectMode;	//for usb_download
	switch(cActionType)
	{
		case DWL_BOOT4:
			startAddr = 0x20000;
			itoa(hBootloader2Size[0],buf,10);
			str2.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str2);
		//	GetCheckSum(m_strManualNandImage);
			GetFileName("boot2.img");
#ifdef _CUSTOMER_
			str2.Format("\n    Now Boot2 Download start!!\n");
#else
			str2.Format("\n    Now Boot2 Download start!! ( Start address : 0x%x File Size : %d )\n",startAddr,hBootloader2Size[0]);
#endif
			ShowStatus(str2);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
			m_strManualNandImage="boot2";
			result = TOOL_NandFlashDownload_Tflash(nConnectMode,comPort,(UInt8*)m_strManualNandImage.GetBuffer(MYBUFF_SIZE),startAddr,ToolProgressCb ) ;
			FinishTime=clock();
			break;

		case DWL_IMGSET:
//			startAddr = IMGSET_START_ADDR;
			startAddr = IMGSET_ONLY;
			itoa(m_nImageSize,buf,10);
			str.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str);
			GetCheckSum(m_strImageFileName);
			GetFileName(m_strImageFileName);
			str.Format("\n    imgset Download start!!\n");
			ShowStatus(str);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
#if 0
			if (m_boolImage==TRUE && m_boolRsrc==FALSE && m_boolCalset==FALSE)
				startAddr=IMGSET_ONLY;
			if (m_boolImage==TRUE && m_boolRsrc==TRUE && m_boolCalset==FALSE)
				startAddr=IMGSET_RSRC;
			if (m_boolImage==TRUE && m_boolRsrc==TRUE && m_boolCalset==TRUE)
				startAddr=IMGSET_RSRC_CALSET;
			if (m_boolImage==FALSE && m_boolRsrc==TRUE && m_boolCalset==FALSE)
				startAddr=RSRC_ONLY;
			if (m_boolImage==FALSE && m_boolRsrc==TRUE && m_boolCalset==TRUE)
				startAddr=RSRC_CALSET;
			if (m_boolImage==FALSE && m_boolRsrc==FALSE && m_boolCalset==TRUE)
				startAddr=CALSET_ONLY;
#endif
			if (nConnectMode==USB_MODE)
				result = TOOL_USBDownloadImage(nConnectMode,(UInt8*)m_strImageFileName.GetBuffer(MYBUFF_SIZE),comPort,startAddr,ToolProgressCb );
			else
			    result = TOOL_NandFlashDownload(nConnectMode,comPort,(UInt8*)m_strImageFileName.GetBuffer(MYBUFF_SIZE),startAddr,ToolProgressCb ) ;
	
			
			//	result = TOOL_DownloadImage((UInt8*)m_strImageFileName.GetBuffer(MYBUFF_SIZE),&comPortCfg,startAddr,ToolProgressCb);
		

			timeinfo2=LPSTR(LPCTSTR(str_time));  //ð ´.
			memcpy(cTime2,timeinfo2,strlen(timeinfo2));
			result = TOOL_SetTime(comPort,cTime2,nConnectMode);
			FinishTime=clock();
			break;

		case DWL_CALSET:
//			startAddr = CALSET_START_ADDR;
			startAddr = CALSET_ONLY;
			itoa(m_nParamDepSize,buf,10);
			str.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str);
			GetCheckSum(m_strParamDepFileName);
			GetFileName(m_strParamDepFileName);
			str.Format("\n    Now calset Download start!!\n");
			ShowStatus(str);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
			if (nConnectMode==USB_MODE)
				result = TOOL_USBDownloadImage(nConnectMode,(UInt8*)m_strParamDepFileName.GetBuffer(MYBUFF_SIZE),comPort,startAddr,ToolProgressCb );
			else
				result = TOOL_NandFlashDownload(nConnectMode,comPort,(UInt8*)m_strParamDepFileName.GetBuffer(MYBUFF_SIZE),startAddr,ToolProgressCb ) ;
		
			FinishTime=clock();
			break;
			
		case DWL_RSRC1:
//			startAddr = RSRC1_START_ADDR;
			startAddr = RSRC_ONLY;
			itoa(m_nRscrSize,buf,10);
			str.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str);
			GetCheckSum(m_strRscrFileName);
			GetFileName(m_strRscrFileName);
			str.Format("\n    Now Rsrc1 Download start!!\n");
			ShowStatus(str);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
			if (nConnectMode==USB_MODE)
				result = TOOL_USBDownloadImage(nConnectMode,(UInt8*)m_strRscrFileName.GetBuffer(MYBUFF_SIZE),comPort,startAddr,ToolProgressCb );
			else
				result = TOOL_NandFlashDownload(nConnectMode,comPort,(UInt8*)m_strRscrFileName.GetBuffer(MYBUFF_SIZE),startAddr,ToolProgressCb ) ;

			FinishTime=clock();
			break;

		case DWL_RSRC2:
//			startAddr = RSRC2_START_ADDR;
			startAddr = RSRC2_ONLY;
			itoa(m_nRscr2Size,buf,10);
			str.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str);
			GetCheckSum(m_strRscr2FileName);
			GetFileName(m_strRscr2FileName);
			str.Format("\n    Now Rsrc2 Download start!!\n");
			ShowStatus(str);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
			if (nConnectMode==USB_MODE)
				result = TOOL_USBDownloadImage(nConnectMode,(UInt8*)m_strRscr2FileName.GetBuffer(MYBUFF_SIZE),comPort,startAddr,ToolProgressCb );
			else
				result = TOOL_NandFlashDownload(nConnectMode,comPort,(UInt8*)m_strRscr2FileName.GetBuffer(MYBUFF_SIZE),startAddr,ToolProgressCb ) ;

//			result = TOOL_NandFlashDownload(nConnectMode,comPort,(UInt8*)m_strRscr2FileName.GetBuffer(MYBUFF_SIZE),startAddr,ToolProgressCb ) ;
			FinishTime=clock();
			break;


		case DWL_FACTORYFS:
			startAddr = FFS_ONLY;;
			itoa(m_nFactoryFSSize,buf,10);
			str.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str);
			GetCheckSum(m_strFactoryFSFileName);
			GetFileName(m_strFactoryFSFileName);
			str.Format("\n    Now TFS Download start!!\n");
			ShowStatus(str);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
			//rslt=TFS_Download(comPort,nConnectMode);
			if (nConnectMode==USB_MODE)
				result = TOOL_USBDownloadImage(nConnectMode,(UInt8*)m_strFactoryFSFileName.GetBuffer(MYBUFF_SIZE),comPort,startAddr,ToolProgressCb );
			else
				result = TOOL_NandFlashDownload(nConnectMode,comPort,(UInt8*)m_strFactoryFSFileName.GetBuffer(MYBUFF_SIZE),startAddr,ToolProgressCb ) ;

			//if (rslt==true)
			//	result=RESULT_OK;
			//else
			//	result=RESULT_ERROR;
	
			FinishTime=clock();
			break;

		case DWL_FLASHALL:
			startAddr = TFS_START_ADDR;
			itoa(m_nEntireFlashSize,buf,10);
			str.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str);
			GetCheckSum(m_strEntireFlashFileName);
			GetFileName(m_strEntireFlashFileName);
			str.Format("\n    Now TFS Flash Download start!!\n");
			ShowStatus(str);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
			result = TOOL_NandFlashDownload(nConnectMode,comPort,(UInt8*)m_strEntireFlashFileName.GetBuffer(MYBUFF_SIZE),startAddr,ToolProgressCb ) ;		
			FinishTime=clock();
			break;
		case DWL_MANUAL_NAND:
			startAddr = m_fAddress;
			itoa(m_nManualNandImageSize,buf,10);
			str2.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str2);
			GetCheckSum(m_strManualNandImage);
			GetFileName(m_strManualNandImage);
			str2.Format("\n    Now Manual Download start!!( Start address : 0x%x File Size : %d )\n",startAddr,m_nManualNandImageSize);
			ShowStatus(str2);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
			if (nConnectMode==USB_MODE)
			result = TOOL_USBDownloadImage_MANUAL(nConnectMode,(UInt8*)m_strManualNandImage.GetBuffer(MYBUFF_SIZE),comPort,startAddr,ToolProgressCb );
			else
			result = TOOL_NandFlashDownload_Tflash(nConnectMode,comPort,(UInt8*)m_strManualNandImage.GetBuffer(MYBUFF_SIZE),startAddr,ToolProgressCb ) ;
			FinishTime=clock();
			break;
#if 0
		case DWL_TFLASH:
			startAddr = 0x60000;
			itoa(m_nImageSize,buf,10);
			str2.Format("%s bytes",buf);
			m_editFileSize.SetWindowText(str2);
			GetCheckSum(m_strImageFileName);
			GetFileName(m_strImageFileName);
			str2.Format("\n    Now T-Flash Download start!!( Start address : 0x%x File Size : %d )\n",startAddr,m_nImageSize);
			ShowStatus(str2);
			str2.Format("-----------------------------------------------------------------------------------------------\n");
			ShowStatus(str2);
			result = TOOL_NandFlashDownload_Tflash(nConnectMode,comPort,(UInt8*)m_strImageFileName.GetBuffer(MYBUFF_SIZE),startAddr,ToolProgressCb ) ;
			FinishTime=clock();
			break;
#endif
		default:
			rslt=false;
			break;
	}
	
	ShowStatus("\n      Download");

	if( RESULT_OK != result ) 
	{
		str.Format("  Failed");
		ShowStatus(str,4);
		str.Format( "Error flashing image set : %s\n",TOOL_GetResultStr( result ));
		AfxMessageBox(str);
		
		rslt=false;
		goto _cleanup;
	}
	else
	{
		str.Format("  Completed");
		ShowStatus(str,3);
	}

	// for IRINA : this code doesn't work
#if 0
	if (nConnectMode==UART_MODE)
	{
		Sleep(1000*2);
		if( initBaudRate != dnldBaudRate ) 
		{
			result = TOOL_SetTargetBaudRate( comPort, initBaudRate,0 ) ;
			if( RESULT_OK != result )
			{
				str.Format( "Error  changing target baud rate : %s\n",TOOL_GetResultStr( result ));
				AfxMessageBox(str);
				rslt=false;
				goto _cleanup;
			}

			TOOL_ChangeComPortBaudRate( comPort, initBaudRate ) ;
		}
	}
#endif
	Sleep(1000*1);
	
	//
	if ((cActionType==DWL_FACTORYFS && m_boolAutoReboot==true))
	{
		result = TOOL_PhoneReset(comPort);
		
		if( RESULT_OK != result )
		{
			str.Format( "Error  changing target baud rate : %s\n",TOOL_GetResultStr( result ));
			AfxMessageBox(str);	
		}
		rslt=false;
		goto _cleanup;

	}

	
	rslt=true;
	
_cleanup:

	TOOL_CloseDnldPort( comPort ) ;

	duration = (double)(FinishTime - StartTime) / CLOCKS_PER_SEC;
	totaltime+=duration;
	str.Format(" ( Elapsed Time : %5.1fs)\n", duration);
	ShowStatus(str,4);

	if (cActionType==DWL_BOOT4)
	{
		MessageBox("Download Finished","  NOTICE  ");
		cDriverStatus=CURRENT_WITHOUT_DRIVER;
		ReadyControls();
		return rslt;
	}
	if (prompt==0 && result==RESULT_OK)
		MessageBox("Download Finished","  NOTICE  ");
	

	if (cActionType==DWL_FACTORYFS || cActionType==DWL_RSRC1)
		InitControls();

	if ((m_radio==1 || m_radio==7) && rslt==true)
		return rslt;

	InitControls();
	return rslt;
}


bool CCabrio_downloaderv01Dlg::NorDriverDownload(ComPortCfg_t *comPortCfg,int cActionType)
{
	CString str;
	Result_t result;
	double duration;
	clock_t StartTime, FinishTime;

	
	str.Format("\n\n  * NOR Flash Driver Download"); 
	ShowStatus(str,4);

	StartTime=clock();

	//flashdrv_nand.img downloading.....

	str.Format("\n     NOR Flash driver Downloading\t\t> > > ");
	ShowStatus(str);

	result = TOOL_DownloadFlashDriver(comPortCfg,DRV_NOR);


	//ó 
	if( result != RESULT_OK ) 
	{
		if( result == RESULT_TOOL_FILE_OPEN_ERROR )
		{
			str.Format("Make sure whether flashdrv_nand.img file is in same folder");
			MessageBox(str,"Downloading Failure");
		}
		else
		{
			CString str;
			str.Format("%s",TOOL_GetResultStr(result));
			MessageBox(str,"Downloading Failure");
			
		}
		str.Format("FAIL\n");
		ShowStatus(str,4);
		str.Format("\n   Turn On/Off the target phone!!!\n");
		ShowStatus(str,4);
		
		ReadyControls();
		return false;
	}

	str.Format("OK\n");
	ShowStatus(str,1);


	str.Format("     Flash type Checking\t\t\t> > > ");
	ShowStatus(str);
	Sleep(1000*1);

	if (!FlashCheck(*(GetIDType())))
	{
		str.Format("FAIL\n");
		ShowStatus(str,4);
	/*
		str.Format("\n  Turn On/Off the target phone!!!\n");
		ShowStatus(str,4);
		InitControls();
		return false;*/
	}
	else
	{
		str.Format("OK\n");
		ShowStatus(str,1);
	}
	FinishTime=clock();

	duration = (double)(FinishTime - StartTime) / CLOCKS_PER_SEC;
	totaltime+=duration;
	
	str.Format("    ( Elapsed Time : %5.1fs)\n", duration);
	ShowStatus(str,4);
	cDriverStatus=CURRENT_NOR_DRIVER;
	//flashdrv_nandimg downloading successfully..
	return true;
	
}

bool CCabrio_downloaderv01Dlg::NandDriverDownload(ComPortCfg_t *comPortCfg,int cActionType)
{
	
	CString str;
	Result_t result;
	double duration;
	clock_t StartTime, FinishTime;
	int *return_type;

	

#if 1	
	str.Format("\n\n  * NAND Flash Driver Download"); 
	ShowStatus(str,4);
	str.Format("\n     preboot downloading\t\t\t> > > "); 
	ShowStatus(str);
	StartTime=clock();
	
       if(cActionType==OP_NOR_ERASE)
	result = TOOL_DownloadDriver_Itcm(comPortCfg);  //preloader 
	else
	result = TOOL_DownloadDriver_Itcm_set_Baudrate(comPortCfg);  //preloader 
	
	
	result = TOOL_DownloadDriver(comPortCfg);
	
	if( result != RESULT_OK ) 
	{
		if( result == RESULT_TOOL_FILE_OPEN_ERROR )
		{
			str.Format("Make sure whether preboot.img file is in same folder");
			MessageBox(str,"Downloading Failure");
		}
		else
		{
			CString str;
			str.Format("%s",TOOL_GetResultStr(result));
			MessageBox(str,"Downloading Failure");
			
		}
		
		str.Format("FAIL\n");
		ShowStatus(str,4);
		str.Format("\n  Turn On/Off the target phone!!!\n");
		ShowStatus(str,4);
		InitControls();
		return false;
	}
	
	str.Format("OK\n");
	ShowStatus(str,1);
	//preboot downloading successfully..
#endif
	//preboot.img ٿε Ŀ  ӵ ٽ  ӵ 
	comPortCfg->baudRate = g_BaudRate[m_cbxBaudRate.GetCurSel()];//COMPORT_BAUDRATE_115K;

	//flashdrv_nand.img downloading.....
	
	str.Format("     NAND Flash driver downloading\t\t> > > ");
	ShowStatus(str);

	result = TOOL_DownloadFlashDriver(comPortCfg,DRV_NAND);


	
	//ó 
	if( result != RESULT_OK ) 
	{
		if( result == RESULT_TOOL_FILE_OPEN_ERROR )
		{
			str.Format("Make sure whether flashdrv_nand.img file is in same folder");
			MessageBox(str,"Downloading Failure");
		}
		else
		{
			CString str;
			str.Format("%s",TOOL_GetResultStr(result));
			MessageBox(str,"Downloading Failure");
			
		}
		str.Format("FAIL\n");
		ShowStatus(str,4);
		str.Format("\n  Turn On/Off the target phone!!!\n");
		ShowStatus(str,4);
		
		InitControls();
		return false;
	}

	str.Format("OK\n");
	ShowStatus(str,1);


	str.Format("     Flash Type Checking\t\t\t> > > ");
	ShowStatus(str);
//	Sleep(1000*6);

	return_type = GetIDType();

	if (!FlashCheck(*return_type))
	{	
		str.Format("device_id=%d FAIL\n",*return_type);
		ShowStatus(str,4);
	/*	str.Format("\n  Turn On/Off the target phone!!!\n");
		ShowStatus(str,4);
		InitControls();
		return false;*/
	}
	else
	{
		str.Format("OK\n");
		ShowStatus(str,1);
	}

	FinishTime=clock();

	duration = (double)(FinishTime - StartTime) / CLOCKS_PER_SEC;
	totaltime+=duration;
	
	str.Format("    ( Elapsed Time : %5.1fs)\n", duration);
	ShowStatus(str,4);
	cDriverStatus=CURRENT_NAND_DRIVER;
	//flashdrv_nandimg downloading successfully..
	return true;
	
}

int CCabrio_downloaderv01Dlg::FlashCheck(unsigned char t)
{
	if (t== K9K1216D0C_ID)
	{
		m_ctrlNandFlash.SetWindowText("K9K1216D0C 512");
		return 1;
	}
	if (t== K9F5616D0C_ID)
	{
		m_ctrlNandFlash.SetWindowText("K9F5616D0C 256");
		return 1;
	}
	if (t==LRS1896SHARPTB)
	{
		m_ctrlNFlash.SetWindowText("LRS1896TB 256");
		return 1;
	}
	if (t==LRS1896SHARPBB)
	{
		m_ctrlNFlash.SetWindowText("LRS1896BB 256");
		return 1;
	}

	if (t==KAP29WN00M_ONENAND_ADIE)
	{
		m_ctrlNFlash.SetWindowText("MLC NOR 512");
		return 1;
	}

	if (t==0x34)
	{
		m_ctrlNandFlash.SetWindowText("EC34");
		return 1;
	}

	if (t==0x24)
	{
		m_ctrlNandFlash.SetWindowText("EC24");
		return 1;
	}

	if (t==0x14)
	{
		m_ctrlNandFlash.SetWindowText("EC14");
		return 1;
	}
	if (t==0xB1)
	{
		m_ctrlNandFlash.SetWindowText("ECB1");
		return 1;
	}
	if (t==0xBA)
	{
		m_ctrlNandFlash.SetWindowText("ECBA");
		return 1;
	}
       	

	return 0;
}





/**********************************************************************/
/* InitControls()													  */
/**********************************************************************/
/*  control ҵ鿡  ʱȭ ۾                       */
/**********************************************************************/
void CCabrio_downloaderv01Dlg::InitControls()
{
	CString str;
	m_ctrDownloadButton.EnableWindow(true);
	m_ctrCap.EnableWindow(true);
	m_ctrBootloaderErase.EnableWindow(true);
	m_ctrNorErase.EnableWindow(true);
	m_ctrNorDump.EnableWindow(true);
	m_ctrNandDump.EnableWindow(true);
	m_ctrCN.EnableWindow(false);   //ÿ ȰȭǾ Ѵ.
	m_ctrTFSFormat.EnableWindow(true);
	m_ctrBMLFORMAT.EnableWindow(true);
	m_ctrlDisconnect.EnableWindow(true);
	m_ctrlDlbootloader.EnableWindow(false);
	m_ctrlBChk.EnableWindow(true);
	m_btnManualNor.EnableWindow(true);
	m_btnManualNand.EnableWindow(true);
	m_editManualAddress.EnableWindow(true);
	m_editManualNandAddress.EnableWindow(true);
	


	m_ctrlComPort.EnableWindow(false);
	m_cbxBaudRate.EnableWindow(false);
//	m_editStatus.EnableWindow(true);
	m_ctrlStart.EnableWindow(false);



	m_ctrPhoneImage.EnableWindow(true);
	m_ctrSysDep.EnableWindow(true);
	m_ctrRscr.EnableWindow(true);
	m_ctrRscr2.EnableWindow(true);
	m_ctrFactoryFS.EnableWindow(true);

	m_ctrPhoneImage.SetFont(&m_font6);
	m_ctrSysDep.SetFont(&m_font6);
	m_ctrRscr.SetFont(&m_font6);
	m_ctrRscr2.SetFont(&m_font6);
	m_ctrFactoryFS.SetFont(&m_font6);
	m_ctrEntireFlash.EnableWindow(true);

	m_nMainPercent = 0;
	m_progressMain.SetRange(0, 100);
	m_progressMain.SetPos(m_nMainPercent);

	m_editFileSize.SetWindowText(" ");;
	m_editFileName.SetWindowText(" ");;
	m_editCheckSum.SetWindowText(" ");;

//	m_font4.CreatePointFont(8, "Arial");
	
	ShowStatus(" ",5);
	str.Format("Ready");
	m_btnPer.SetWindowText(str);

//	UpdateData(TRUE);
//	checkER=m_ckER;
//	checkPARAM=m_ckParam;
//	checkRC1=m_ckRc1;
//	checkCALSET=m_ckCal;
//	checkBOOT2=m_ckBoot;

}

void CCabrio_downloaderv01Dlg::LockControls()
{
	m_ctrDownloadButton.EnableWindow(false);
	m_ctrCap.EnableWindow(false);
	m_ctrBootloaderErase.EnableWindow(false);
	m_ctrNorErase.EnableWindow(false);
	m_ctrNorDump.EnableWindow(false);
	m_ctrNandDump.EnableWindow(false);
	m_ctrCN.EnableWindow(false);
	m_ctrTFSFormat.EnableWindow(false);
	m_ctrBMLFORMAT.EnableWindow(false);
	m_ctrlDlbootloader.EnableWindow(false);
	m_ctrlBChk.EnableWindow(false);
	m_ctrEntireFlash.EnableWindow(false);
	m_btnManualNor.EnableWindow(false);
	m_btnManualNand.EnableWindow(false);
	m_editManualAddress.EnableWindow(false);
	m_editManualNandAddress.EnableWindow(false);


	m_ctrlComPort.EnableWindow(false);
	m_cbxBaudRate.EnableWindow(false);
//	m_editStatus.EnableWindow(true);
	m_ctrlStart.EnableWindow(false);
	m_ctrlDisconnect.EnableWindow(false);




	m_ctrPhoneImage.EnableWindow(false);
	m_ctrSysDep.EnableWindow(false);



	m_ctrRscr.EnableWindow(false);
	m_ctrRscr2.EnableWindow(false);
	m_ctrFactoryFS.EnableWindow(false);

}

void CCabrio_downloaderv01Dlg::ReadyControls()
{
	CString str;
	//button
	m_ctrDownloadButton.EnableWindow(false);
//	m_ctrDownloadButton.EnableWindow(true);
	m_ctrCap.EnableWindow(false);
	m_ctrBootloaderErase.EnableWindow(false);
	m_ctrNorErase.EnableWindow(false);
	m_ctrNorDump.EnableWindow(false);
	m_ctrNandDump.EnableWindow(false);
	m_ctrCN.EnableWindow(false);
	m_ctrTFSFormat.EnableWindow(false);
	m_ctrBMLFORMAT.EnableWindow(false);
	m_ctrlDisconnect.EnableWindow(false);
	m_ctrlBChk.EnableWindow(false);
	m_btnManualNor.EnableWindow(false);
	m_btnManualNand.EnableWindow(false);
	m_editManualAddress.EnableWindow(false);
	m_editManualNandAddress.EnableWindow(false);
#ifdef _DWL_BOOTLOADER_
	m_ctrlDlbootloader.EnableWindow(true);
#else
	m_ctrlDlbootloader.EnableWindow(false);
#endif

	//env
	m_ctrlComPort.EnableWindow(true);
	m_cbxBaudRate.EnableWindow(true);
	m_ctrlStart.EnableWindow(true);

	
	//Data type
	m_ctrPhoneImage.EnableWindow(true);
	m_ctrSysDep.EnableWindow(true);
	m_ctrRscr.EnableWindow(true);
	m_ctrRscr2.EnableWindow(true);
	m_ctrFactoryFS.EnableWindow(true);
	m_ctrEntireFlash.EnableWindow(true);

	m_ctrPhoneImage.SetFont(&m_font6,TRUE);
	m_ctrSysDep.SetFont(&m_font6,TRUE);
	m_ctrRscr.SetFont(&m_font6,TRUE);
	m_ctrRscr2.SetFont(&m_font6,TRUE);
	m_ctrFactoryFS.SetFont(&m_font6,TRUE);

	str.Format("Disconnect");
	ShowEnv(str,4);

	str.Format("Disconnect");
	ShowEnv(str,2);
	
	m_nMainPercent = 0;
	m_progressMain.SetRange(0, 100);
	m_progressMain.SetPos(m_nMainPercent);

	m_editFileSize.SetWindowText(" ");;
	m_editFileName.SetWindowText(" ");;
	m_editCheckSum.SetWindowText(" ");;


	str.Format("\n * How to use Download Mode");
	ShowStatus(str,4);
#ifdef _INCLUDE_CALSET_
	ShowStatus("  (Include Calset)",3);
#endif

	str.Format("\n    1. Turn off the target phone!!!");
	ShowStatus(str);
	str.Format("\n    2. Select COM Port(USB or UART) , Baud Rate.");
	ShowStatus(str);
	str.Format("\n    3. Push the Start Button.");
	ShowStatus(str);
	str.Format("\n    4. Turn on the target phone!!!\n");
	ShowStatus(str);


	str.Format("Off");
	m_btnPer.SetWindowText(str);


}


/**********************************************************************/
/* InitControls()													  */
/**********************************************************************/
/*  control ҵ鿡  ʱȭ ۾                       */
/**********************************************************************/
unsigned long CCabrio_downloaderv01Dlg::GetFileSize(CString filename)
{
	CFile File;

	
	if(File.Open(filename,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
	{
	
		DWORD FileLength = File.GetLength(); 
		File.Close();

		return FileLength;

	}
	else
	{
		
	}

	return 0;
}

int CCabrio_downloaderv01Dlg::GetSectorNum(unsigned long startAddr, unsigned long filesize)
{
	int result;
	unsigned int s,t,u;
	unsigned long tSize=0;
	unsigned int blocknum=0;
	unsigned long nFrom=0, nTo=0;
	result = 0;
	s = t = u = 0;
	
	tSize=startAddr;

	// 0x0 small block ϴ  
	nFrom=aNorFlashTable[0].TopBlkNum * aNorFlashTable[0].SmallBlockSize;

	// ÷ ʺ small block ϴ 
	nTo=aNorFlashTable[0].FlashEntireSize 
		- (aNorFlashTable[0].BottomBlkNum * aNorFlashTable[0].SmallBlockSize);

	while(1)
	{
		if (tSize>=(startAddr+filesize))
			break;
		
		if (tSize<nFrom)
		{
			tSize=tSize+aNorFlashTable[0].SmallBlockSize;
			blocknum++;
			continue;
		}
		
		if (tSize>=nFrom && tSize<nTo)
		{
			tSize=tSize+aNorFlashTable[0].LargeBlockSize;
			blocknum++;
			continue;
		}
		if (tSize>=nTo)
		{
			tSize=tSize+aNorFlashTable[0].SmallBlockSize;
			blocknum++;
			continue;
		}
	}
	return blocknum;
}

int CCabrio_downloaderv01Dlg::GetSectorNum2(unsigned long startAddr, unsigned long filesize)
{
	int result;
	unsigned int s,t,u;
	unsigned long tSize=0;
	unsigned int blocknum=0;
	result = 0;
	s = t = u = 0;


	tSize=startAddr;
	while(1)
	{
		if (tSize>=(startAddr+filesize))
			break;

		tSize=tSize+aNandFlashTable[0].BlockSize;
		blocknum++;
		continue;

	}
	return blocknum;
}


void CCabrio_downloaderv01Dlg::OnSelchangeComboBaudrate() 
{
	// TODO: Add your control notification handler code here
	m_nBaudRate = m_cbxBaudRate.GetCurSel();
	AfxGetApp()->WriteProfileInt("CabrioDL", "m_nBaudRate", m_nBaudRate );	
}


void CCabrio_downloaderv01Dlg::OnButtonNandRscr() 
{
	// TODO: Add your control notification handler code here
	char szFilter[] = "Rscr.cnt File(*.rc1)|*.rc1|*.*|*.*||";
	CFile File;

	CFileDialog dlg(TRUE, NULL, m_strRscrFileName, OFN_HIDEREADONLY,szFilter);
	
	if(dlg.DoModal() == IDOK)
	{
		m_strRscrFileName = dlg.GetPathName();
		if(File.Open(m_strRscrFileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
		{	
			m_editRscrPath.SetWindowText((LPCTSTR) dlg.GetPathName());
			File.Close();
		}
		else
		{
			AfxMessageBox("File open failed");
		}

		AfxGetApp()->WriteProfileString("CabrioDL", "m_strRscrFileName",m_strRscrFileName);
	}		
}

void CCabrio_downloaderv01Dlg::OnButtonNandRscr2() 
{
	// TODO: Add your control notification handler code here
	char szFilter[] = "Rscr2.cnt File(*.rc2)|*.rc2|*.*|*.*||";
	CFile File;

	CFileDialog dlg(TRUE, NULL, m_strRscr2FileName, OFN_HIDEREADONLY,szFilter);
	
	if(dlg.DoModal() == IDOK)
	{
		m_strRscr2FileName = dlg.GetPathName();
		if(File.Open(m_strRscr2FileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
		{	
			m_editRscr2Path.SetWindowText((LPCTSTR) dlg.GetPathName());
			File.Close();
		}
		else
		{
			AfxMessageBox("File open failed");
		}

		AfxGetApp()->WriteProfileString("CabrioDL", "m_strRscr2FileName",m_strRscr2FileName);
	}		


}

#if 0
void CCabrio_downloaderv01Dlg::OnButtonNandFactoryfs() 
{
	// TODO: Add your control notification handler code here
	char BASED_CODE szFilter[] = "TFS Files (*.tfs)|*.tfs|All Files (*.*)|*.*||";
	CFile File;
	CString fname;
	BOOL Success;
	int idx,i,flag = 0, j;

	CFileDialog tTFSFileDlg(	TRUE, NULL, NULL, 
                        OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
                        OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
                        szFilter, NULL );

	tTFSFileDlg.m_ofn.lpstrInitialDir = m_strAfxOgmPath[0];
	tTFSFileDlg.m_ofn.lpstrInitialDir = m_strOgmPath;
	
	if(tTFSFileDlg.DoModal() == IDOK)
	{	
		fname=tTFSFileDlg.GetPathName();
		m_sTFSPath = tTFSFileDlg.GetPathName();	

		m_strOgmPath = fname;
		for(i = 0 ; i < 3; i ++ )
		{
			if(fname == m_strAfxOgmPath[i])
			{
				flag = 1;
				j	= i;
			}
		}

		
		idx = m_strOgmPath.ReverseFind( '.' );
		m_strOgmCfgPath = m_strOgmPath.Left( idx );
		m_strOgmCfgPath += ".cfg";

		
		Success = m_OgmFile.Open( m_strOgmPath, CFile::modeRead | CFile::shareDenyWrite );
		if ( !Success )
		{
			AfxMessageBox("Fail to open OGM file!");
			return;
		}

		/*check sum calcuation**/
//		FileLen = m_OgmFile.GetLength();
		m_editFactoryFSPath.SetWindowText((LPCTSTR) tTFSFileDlg.GetPathName());
		m_OgmFile.Close();


		AfxGetApp()->WriteProfileString("CabrioDL", "m_strOgmPath",m_strOgmPath);
	}

	
}
#endif


#if 1
void CCabrio_downloaderv01Dlg::OnButtonNandFactoryfs() 
{
	// TODO: Add your control notification handler code here
	char BASED_CODE szFilter[] = "TFS Files (*.tfs)|*.tfs|All Files (*.*)|*.*||";
	CFile File;
	CString fname;
	BOOL Success;
	int idx,i,flag = 0, j;

		
	vTfsFile=0;

	CFileDialog tTFSFileDlg(	TRUE, NULL, m_strFactoryFSFileName, 
                        OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
                        OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
                        szFilter, NULL );

	tTFSFileDlg.m_ofn.lpstrInitialDir = m_strAfxOgmPath[0];
	tTFSFileDlg.m_ofn.lpstrInitialDir = m_strOgmPath;
	
	if(tTFSFileDlg.DoModal() == IDOK)
	{	
		fname=tTFSFileDlg.GetPathName();
		m_strFactoryFSFileName=tTFSFileDlg.GetPathName();
		m_sTFSPath = tTFSFileDlg.GetPathName();	

		m_strOgmPath = fname;
		for(i = 0 ; i < 3; i ++ )
		{
			if(fname == m_strAfxOgmPath[i])
			{
				flag = 1;
				j	= i;
			}
		}

		
		idx = m_strOgmPath.ReverseFind( '.' );
		m_strOgmCfgPath = m_strOgmPath.Left( idx );
		m_strOgmCfgPath += ".cfg";

		
		Success = m_OgmFile.Open( m_strOgmPath, CFile::modeRead | CFile::shareDenyWrite );
		if ( !Success )
		{
			AfxMessageBox("Fail to open OGM file!");
			return;
		}

		/*check sum calcuation**/
//		FileLen = m_OgmFile.GetLength();
		m_editFactoryFSPath.SetWindowText((LPCTSTR) tTFSFileDlg.GetPathName());
		m_OgmFile.Close();

		vTfsFile=1;
		AfxGetApp()->WriteProfileString("CabrioDL", "m_strOgmPath",m_strOgmPath);

	}

	
}

#else
void CCabrio_downloaderv01Dlg::OnButtonNandFactoryfs() 
{
	// TODO: Add your control notification handler code here
	char szFilter[] = "FactoryFS.bin File(*.bin)|*.bin|*.*|*.*||";
	CFile File;

	CFileDialog dlg(TRUE, NULL, m_strFactoryFSFileName, OFN_HIDEREADONLY,szFilter);
	
	if(dlg.DoModal() == IDOK)
	{
		m_strFactoryFSFileName = dlg.GetPathName();	
		if(File.Open(m_strFactoryFSFileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
		{
			m_editFactoryFSPath.SetWindowText((LPCTSTR) dlg.GetPathName());
			File.Close();
		}
		else
		{
			AfxMessageBox("File open failed");
		}

		AfxGetApp()->WriteProfileString("CabrioDL", "m_strFactoryFSFileName",m_strFactoryFSFileName);
	}

	
}

#endif


void CCabrio_downloaderv01Dlg::OnButtonSysparmDep() 
{
	// TODO: Add your control notification handler code here
	char szFilter[] = "sysparm_dep.img File(*.img)|*.img|*.*|*.*||";
	CFile File;

	CFileDialog dlg(TRUE, NULL, m_strParamDepFileName, OFN_HIDEREADONLY,szFilter);
	
	if(dlg.DoModal() == IDOK)
	{
		m_strParamDepFileName = dlg.GetPathName();
		if(File.Open(m_strParamDepFileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
		{	
			m_editParamDepPath.SetWindowText((LPCTSTR) dlg.GetPathName());
			File.Close();
		}
		else
		{
			AfxMessageBox("Image File Size Error");
		}

		AfxGetApp()->WriteProfileString("CabrioDL", "m_strParamDepFileName",m_strParamDepFileName);
	}		
	
}

void CCabrio_downloaderv01Dlg::ShowHead()
{
	CString str;
	str.Format("\n-----------------------------------------------------------------------------\n  NAND Flash Download mode ");
	ShowStatus(str,3);
	if (m_cbxBaudRate.GetCurSel()==0)
	{
		str.Format("( COM%d  BaudRate : 115k )\n-----------------------------------------------------------------------------\n",m_ComPort+1);
	}
	if (m_cbxBaudRate.GetCurSel()==1)
	{
		str.Format("( COM%d  BaudRate : 460k )\n-----------------------------------------------------------------------------\n",m_ComPort+1);
	}
	if (m_cbxBaudRate.GetCurSel()==2)
	{
		str.Format("( COM%d  BaudRate : 921k )\n-----------------------------------------------------------------------------\n",m_ComPort+1);
	}
	ShowStatus(str,3);
}


void CCabrio_downloaderv01Dlg::OnButtonDownload2() 
{
	
	// TODO: Add your control notification handler code here
	LockControls();
	UpdateData(true);
	CString str;

	totaltime=0;

	//COM, SPEED   ó
	if (m_ComPort==-1 && m_cbxBaudRate.GetCurSel()==NULL)
		goto init;

	//RADIO   б
	switch(m_radio)
	{
		case 0:
			//***********************//
			//*RSRC.CNT ٿε*//
			//***********************//
			m_nRscrSize = GetFileSize(m_strRscrFileName);

			if(!m_nRscrSize)
			{
				AfxMessageBox("Check the file location");
				goto error;
			}
			if(m_nRscrSize>RSRC1_SIZE)
			{
				AfxMessageBox("File size error");
				goto error;
			}


			cActionType=DWL_RSRC1;
			
			pThread=AfxBeginThread(NandDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);
			

			goto init;
			break;
		case 1:
			//***********************//
			//*NAND ALL     ٿε*//
			//***********************//
			m_nRscrSize = GetFileSize(m_strRscrFileName);

			if(!m_nRscrSize)
			{
				AfxMessageBox("Rscr file not existed");
				AfxMessageBox("Verify a path of Rscr file");
				goto error;
			}
			if(m_nRscrSize>RSRC1_SIZE)
			{
				AfxMessageBox("File size error");
				goto error;
			}

			m_nFactoryFSSize = GetFileSize(m_strOgmPath);

			if(!m_nFactoryFSSize)
			{
				AfxMessageBox("FactoryFS file not existed");
				AfxMessageBox("Verify a path of FactoryFS file");
				goto error;
			}
			if(m_nFactoryFSSize>FACTORYFS_SIZE)
			{
				AfxMessageBox("File size error");
				goto error;
			}

			cActionType=DWL_ALL;
			//  ̹ NOR flashϰ 
			//¸ ´. 
			if (cDriverStatus==CURRENT_NOR_DRIVER)
			{
				DisconnectMS();
				cDriverStatus=CURRENT_WITHOUT_DRIVER;
			}

			pThread=AfxBeginThread(NandDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);

			goto init;
			break;
		case 2:
			//************************//
			//*RSRC2.CNT ٿε*//
			//************************//
			m_nRscr2Size = GetFileSize(m_strRscr2FileName);

			if(!m_nRscr2Size)
			{
				AfxMessageBox("Check the file location");
				goto error;
			}
			if(m_nRscr2Size>RSRC2_SIZE)
			{
				AfxMessageBox("File size error");
				goto error;
			}
			cActionType=DWL_RSRC2;


			
			
		pThread=AfxBeginThread(NandDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);

		
			
			goto init;
			break;
		case 3:
			//****************************//
			//*FactoryFS.bin ٿε*//
			//****************************//
			if (vTfsFile!=1)
			{
				AfxMessageBox("Please check tfs file(Push the 'File system' button.\n");
				goto error;
			}

			m_nFactoryFSSize = GetFileSize(m_strOgmPath);

			if(!m_nFactoryFSSize)
			{
				AfxMessageBox("Check the file location");
				goto error;
			}

			cActionType=DWL_FACTORYFS;
			

			pThread=AfxBeginThread(NandDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);

		
			
			goto init;
			break;
#if 0
		case 4:
			//****************************//
			//*TFLASH image      ٿε*//
			//****************************//
			m_nImageSize = GetFileSize(m_strImageFileName);

			if(!m_nImageSize)
			{
				AfxMessageBox("Check the file location");
				AfxMessageBox("Verify a path of Imgset file");
				goto error;
			}
			
			cActionType=DWL_TFLASH;

			pThread=AfxBeginThread(NandDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);
			
			goto init;
			break;
#endif
			//all nor
		case 5:

//			if (vImageFile!=1)
			if(0)
			{
				AfxMessageBox("Please check image_set file(Push the 'Info' button.\n");
				goto error;
			}
			//****************************//
			//*Z220_imgset.img ٿε    *//
			//****************************//
			m_nImageSize = GetFileSize(m_strImageFileName);

			if(!m_nImageSize)
			{
				AfxMessageBox("Check the file location");
				AfxMessageBox("Verify a path of Imgset file");
				goto error;
			}
#if 1
			if(m_nImageSize>IMGSET_SIZE)
			{
				AfxMessageBox("File size error");
				goto error;
			}
#endif
			cActionType=DWL_IMGSET;

			pThread=AfxBeginThread(NandDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);
			
			goto init;

			break;

		
		case 6:
			//****************************//
			//*Z220_calset.img  ٿε*//
			//****************************//
			m_nParamDepSize = GetFileSize(m_strParamDepFileName);

			if(!m_nParamDepSize)
			{
				AfxMessageBox("Check the file location");
				AfxMessageBox("Verify a path of Z220_calset file");
				goto error;
			}
			if(m_nParamDepSize>CALSET_SIZE)
			{
				AfxMessageBox("File size error");
				goto error;
			}

			cActionType=DWL_CALSET;

			pThread=AfxBeginThread(NandDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);
			
			goto init;
			break;

		
		case 7:
			//****************************//
			//*NAND+NOR ALL  ٿε*//
			//****************************//
			m_nImageSize = GetFileSize(m_strImageFileName);
			if(!m_nImageSize)
			{
				AfxMessageBox("Check the file location");
				AfxMessageBox("Verify a path of Z220_imgset file");
				goto error;
			}
			if(m_nImageSize>IMGSET_SIZE)
			{
				AfxMessageBox("File size error");
				goto error;
			}			
#if 1
			m_nParamDepSize = GetFileSize(m_strParamDepFileName);
			if (m_boolCalset==TRUE)
			{
				if(!m_nParamDepSize)
				{
					AfxMessageBox("Check the file location");
					AfxMessageBox("Verify a path of Z220_calset file");
					goto error;
				}
				if(m_nParamDepSize>CALSET_SIZE)
				{
					AfxMessageBox("File size error");
					goto error;
				}
			}

			m_nRscrSize = GetFileSize(m_strRscrFileName);
			if(!m_nRscrSize)
			{
				AfxMessageBox("Rscr file not existed");
				AfxMessageBox("Verify a path of Rscr file");
				goto error;
			}
			if(m_nRscrSize>RSRC1_SIZE)
			{
				AfxMessageBox("File size error");
				goto error;
			}

			m_nRscr2Size = GetFileSize(m_strRscr2FileName);
			if(!m_nRscr2Size)
			{
				AfxMessageBox("Rscr2 file not existed");
				AfxMessageBox("Verify a path of Rscr2 file");
				goto error;
			}
			if(m_nRscr2Size>RSRC2_SIZE)
			{
				AfxMessageBox("File size error");
				goto error;
			}
#endif

			m_nFactoryFSSize = GetFileSize(m_strOgmPath);

			if(!m_nFactoryFSSize)
			{
				AfxMessageBox("Check the file location");
				goto error;
			}
			
			cActionType=DWL_ALL;
			pThread=AfxBeginThread(AllDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);
			
			goto init;
			break;

		case 8:
			//****************************//
			//*ü ÷       ٿε*//
			//****************************//
			m_nEntireFlashSize = GetFileSize(m_strEntireFlashFileName);

			if(!m_nEntireFlashSize)
			{
				AfxMessageBox("Check the file location");
				goto error;
			}
			if(m_nEntireFlashSize!=ENTIRE_FLASH_SIZE)
			{
				AfxMessageBox("File size error");
				goto error;
			}


			cActionType=DWL_FLASHALL;

			pThread=AfxBeginThread(NandDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);
			
			
			goto init;
			break;
		
		case 9:
			//****************************//
			//*NOR Flash κ    ٿε*//
			//****************************//
			m_nManulImageSize = GetFileSize(m_strManualImage);

#define NOR_BLOCKSIZE		128*1024
			m_fAddress = m_fAddress - (m_fAddress % NOR_BLOCKSIZE);
			if(!m_nManulImageSize)
			{
				AfxMessageBox("Check the file location");
				goto error;
			}

			if (m_nManulImageSize + m_fAddress > 0x1FFFFFF)
			{
				AfxMessageBox("Image file size too big");
				goto error;
			}

			str.Format("Start Address check OK!!\r\nCheck start block Address : 0x%x",m_fAddress);
			AfxMessageBox(str);


			cActionType=DWL_MANUAL;

			pThread=AfxBeginThread(NorDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);
			
			goto init;
			break;

		case 10:
			//****************************//
			//*NAND Flash κ    ٿε*//
			//****************************//
			m_nManualNandImageSize = GetFileSize(m_strManualNandImage);

#define NAND_BLOCKSIZE			0x20000
#define NAND_BLOCKNUM			998
#define NAND_PROTECT_BLOCK1		0x0
#define NAND_PROTECT_BLOCK2		0x20000
#define NAND_FLASH_SIZE			NAND_BLOCKSIZE * NAND_BLOCKNUM
			

			m_fAddress = m_fAddress - (m_fAddress % NAND_BLOCKSIZE);

			if(!m_nManualNandImageSize)
			{
				AfxMessageBox("Check the file location");
				goto error;
			}
			
			// check Protect area
#if 1
			if (m_fAddress>=NAND_PROTECT_BLOCK1 && m_fAddress<NAND_PROTECT_BLOCK2)
			{
				AfxMessageBox("start address -> PROTECT AREA\r\nCheck the start adress!!!!");
				goto error;
			}
#endif
			if (m_nManualNandImageSize + m_fAddress > NAND_FLASH_SIZE)
			{
				AfxMessageBox("Image file size too big");
				goto error;
			}

			str.Format("Start Address check OK!!\r\nCheck start block Address : 0x%x",m_fAddress);
			AfxMessageBox(str);



			cActionType=DWL_MANUAL_NAND;

			pThread=AfxBeginThread(NandDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);
			
			goto init;
			
		default:
			break;
	}


	AfxMessageBox("Please select download item");

error:
	InitControls();
	return;

init:
	bConnect=true;
	++m_nDownloadNum;
	AfxGetApp()->WriteProfileInt("CabrioDL","m_nDownloadNum",m_nDownloadNum);
	str.Format("%d",m_nDownloadNum);
	m_editDN.SetWindowText(str);
	UpdateData(TRUE);
	UpdateData(FALSE);
}



void CCabrio_downloaderv01Dlg::ShowMessage_ConnectWithMS(int a)
{
	switch(a)
	{
		case 0:
			ShowStatus("Available\n\n",3);
			InitControls();
			break;

		case 1:
			MessageBox("Timeout : No Response at the target phone","Failure");
	//		ShowStatus("Failure\n\n",4);
			bConnect=false;
			ReadyControls();
			break;

		case 2:
			MessageBox("Wrong BaudRate","Failure");
	//		ShowStatus("Failure\n\n",4);
			bConnect=false;
			ReadyControls();
			break;

		case -1:
			MessageBox("Comm Error","Failure");
		//	ShowStatus("Failure\n\n",4);
			bConnect=false;
			ReadyControls();
			break;

		case -2:
			MessageBox("Received Wrong Char from MS","Failure");
		//	ShowStatus("Failure\n\n",4);
			bConnect=false;
			ReadyControls();
			break;
			
		case -3:
			MessageBox("Invalid Env","Failure");
		//	ShowStatus("Failure\n\n",4);
			bConnect=false;
			ReadyControls();
			break;
		case -4:
			MessageBox("USB not detected","Failure");

		default:
			break;
	
	}
}

/* ShowEnv(str,1) --> FlashEdit		Blue
   ShowEnv(str,2)     ConnectEdit	Blue
   ShowEnv(str,3)     FlashEdit		Red
   ShowEnv(str,4)	  ConnectEdit	Red */

void CCabrio_downloaderv01Dlg::ShowEnv(CString str,int a)
{



	CString temp;
	CHARFORMAT cf ;
	
	cf.cbSize = sizeof(CHARFORMAT);
	cf.dwMask = CFM_COLOR|CFM_BOLD;
	cf.dwEffects = ~CFE_AUTOCOLOR|CFE_BOLD;

	switch (a)
	{
	case 1:

		m_ctrlNFlash.SetFocus();
		cf.crTextColor = RGB(0, 0, 255);
		m_ctrlNFlash.SetSelectionCharFormat(cf);

		m_ctrlNFlash.SetSel(0,-1);
		m_ctrlNFlash.ReplaceSel( str );
		m_ctrlNFlash.SetFocus();

		break;
	case 2:
		m_ctrlNandFlash.SetFocus();
		cf.crTextColor = RGB(0, 0, 255);
		m_ctrlNandFlash.SetSelectionCharFormat(cf);
		
		m_ctrlNandFlash.SetSel(0,-1);
		m_ctrlNandFlash.ReplaceSel( str );
		m_ctrlNandFlash.SetFocus();

		break;
	case 3:
		m_ctrlNFlash.SetFocus();
		cf.crTextColor = RGB(255, 0, 0);
		m_ctrlNFlash.SetSelectionCharFormat(cf);
		
		m_ctrlNFlash.SetSel(0,-1);
		m_ctrlNFlash.ReplaceSel( str );
		m_ctrlNFlash.SetFocus();
		
		break;
	case 4:
		m_ctrlNandFlash.SetFocus();
		cf.crTextColor = RGB(255, 0, 0);
		m_ctrlNandFlash.SetSelectionCharFormat(cf);
		
		m_ctrlNandFlash.SetSel(0,-1);
		m_ctrlNandFlash.ReplaceSel( str );
		m_ctrlNandFlash.SetFocus();
		
		break;
	
	default:
		break;
		return;

		
	}
	
}

void CCabrio_downloaderv01Dlg::ShowStatus(CString str)
{

	m_editStatus.LineScroll( m_editStatus.GetLineCount(), -1 );
	
	CHARFORMAT cf ;
	//int total_ch;
	m_editStatus.SetFocus();


	cf.cbSize = sizeof(CHARFORMAT);
	cf.dwMask = CFM_COLOR;
	cf.dwEffects = ~CFE_AUTOCOLOR|~CFE_BOLD;


	cf.crTextColor = RGB(255, 255, 255);
	m_editStatus.SetSelectionCharFormat(cf);

	m_editStatus.SetSel(-1,-1);
	m_editStatus.ReplaceSel( str );
	m_editStatus.SetFocus();


}

void CCabrio_downloaderv01Dlg::ShowTotalTime()
{
	CString str;
	str.Format("\n  * TOTAL Elapsed Time : %5.1fs\n", totaltime);
	ShowStatus(str,4);
	MessageBox("All Download Finished","NOTICE");
}

void CCabrio_downloaderv01Dlg::ShowStatus(CString str,int a)
{



	CString temp;
	CHARFORMAT cf ;
	m_editStatus.SetFocus();

	
	cf.cbSize = sizeof(CHARFORMAT);


	if (a==0 || a==5)
	{
			cf.dwMask = CFM_COLOR;//|CFM_BOLD;;
			cf.dwEffects = ~CFE_AUTOCOLOR;//|CFE_BOLD;
	}
	else
	{

		if (a==3 || a==4)
		{
			cf.dwMask = CFM_COLOR;//|CFM_BOLD;
			cf.dwEffects = ~CFE_AUTOCOLOR;//|CFE_BOLD;
		}
		else
		{
			cf.dwMask = CFM_COLOR;//|CFM_BOLD;
			cf.dwEffects = ~CFE_AUTOCOLOR;//|CFE_BOLD;
		}
	}

	if (a==5)
		cf.crTextColor = RGB(255,255,255);
	if (a==0)
		cf.crTextColor = RGB(0, 0, 0);
	if (a==1 || a==3)
		cf.crTextColor = RGB(0, 0, 255);
	if (a==2 || a==4)
		cf.crTextColor = RGB(255, 0, 0);

	m_editStatus.SetSelectionCharFormat(cf);
	
	if (a==5)
	{
		str=str+"\r";
		m_editSubStatus.SetSel(0, -1);
		m_editSubStatus.ReplaceSel( str );
		m_editSubStatus.SetFocus();
	}
	else
	{
		m_editStatus.SetSel(-1,-1);
		m_editStatus.ReplaceSel( str );
		m_editStatus.SetFocus();
	}


}


void CCabrio_downloaderv01Dlg::OnButtonCap() 
{

	COKDialog hDialog;
	

	if (cActionType!=DWL_ALL)
	{
		if(hDialog.DoModal() == IDCANCEL)
		{
			InitControls();
			return;
		}
	}
	
	LockControls();
	UpdateData(true);
	if (m_ComPort==-1 && m_cbxBaudRate.GetCurSel()==NULL)
		goto init;
	
	cActionType=OP_NAND_ERASE;

	if (cDriverStatus==CURRENT_NOR_DRIVER)
	{
		DisconnectMS();
		cDriverStatus=CURRENT_WITHOUT_DRIVER;
	}
	


	pThread=AfxBeginThread(EraseThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST  );
init:
	;
}




char * CCabrio_downloaderv01Dlg::PathMake(CString str)
{
	CString temp;
	char * ss=LPSTR(LPCTSTR(str));
	char * m;
	char t[1000];
	char q[1000];
	int n=0;


	//̸ ϰ, θ Ѵ.
	m=strrchr(ss,92);
	strncpy(t,ss,m-ss+1);
	*(m+1)='\0';
	*(ss+strlen(ss)-1)='\0';

	m=strrchr(ss,92);
	strncpy(q,ss,m-ss+1);
	*(m+1)='\0';
	*(ss+strlen(ss)-1)='\0';
	
	return ss;
}




// Cancel 
void CCabrio_downloaderv01Dlg::OnButtonCN() 
{
	// TODO: Add your control notification handler code here
	Result_t		result;

	CString str;

	TOOL_CloseFP();

	HANDLE hThread = pThread->m_hThread;

	DWORD dwExitCode =0;

	TerminateThread(hThread, dwExitCode);
        
 
    result=TOOL_CloseComPort(&comPortCfg);
    if (result!=0)
    {
       	str.Format("  There is not Downloading Thread\n\n");
       	MessageBox(str,"Erase Failure");
   	}
    else
   	{
      	str.Format("  CANCELED\n\n  Turn Off the target phone!!!!!\n");
      	ShowStatus(str,4);
    }

	TOOL_CloseDnldPort(comPort);

	str.Format("  CANCELED\n\n  Turn Off the target phone!!!!!\n");
	ShowStatus(str,4);


	m_progressMain.SetPos(0);
	CString test;

	test.Format(" ");
	//	pDlg->m_editSubStatus.SetWindowText(test);
		
	ShowStatus(test,5);

	cDriverStatus=CURRENT_WITHOUT_DRIVER;

	ReadyControls();
	nOnline=false;
	

}

HBRUSH CCabrio_downloaderv01Dlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
//	HBRUSH hbr = CCabrio_downloaderv01Dlg::OnCtlColor(pDC, pWnd, nCtlColor);
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	// TODO: Change any attributes of the DC here

	HBRUSH brush;
#define COLOR_BLACK RGB( 0, 0, 0)
#define COLOR_BLUE RGB( 0, 0,128)
#define COLOR_GREEN RGB( 0,128, 0)
#define COLOR_CYAN RGB( 0,128,128)
#define COLOR_RED RGB(128, 0, 0)
#define COLOR_MAGENTA RGB(128, 0,128)
#define COLOR_BROWN RGB(128,128, 0)
#define COLOR_DARKGRAY RGB(128,128,128)
#define COLOR_LIGHTGRAY RGB(192,192,192)
#define COLOR_LIGHTBLUE RGB( 0, 0,255)
#define COLOR_LIGHTGREEN RGB( 0,255, 0)
#define COLOR_LIGHTCYAN RGB( 0,255,255)
#define COLOR_LIGHTRED RGB(255, 0, 0)
#define COLOR_LIGHTMAGENTA RGB(255, 0,255)
#define COLOR_YELLOW RGB(255,255, 0)
#define COLOR_WHITE RGB(255,255,255)

	if (pWnd->GetDlgCtrlID()==IDC_BUTTON_TITLE)
	{
	brush=CreateSolidBrush(COLOR_RED);
	pDC->SetBkColor(RGB(0, 0, 255));
	hbr=brush;
	}
	return hbr;
}



void CCabrio_downloaderv01Dlg::OnButtonTitle() 
{
	// TODO: Add your control notification handler code here
	CVerDialog hDialog;
	int a;
	
	a=hDialog.DoModal();

	if (a==IDOK)
	{
		return;
	}
//	ReadyControls();
}

void CCabrio_downloaderv01Dlg::GetFileName(CString path)
{
	CString tPath;
	CString tStr;

	int n=0,length=0,cnt=0,i=0,t=0,j=0;;

#if 0
	//̸ ϰ, θ Ѵ.
	m=strrchr(ss,92);
	strncpy(t,m+1,strlen(ss)-strlen(m));
	temp.Format("%s",t);
	strcpy(v_FileName,t);
#endif

	tPath=path;

	while(1)
	{
		i = tPath.Find("\\",j+1);
		if (i!=-1)
		{
			t=j;
			j=i;
		//	depth[cnt]=i;
		}
		else
			break;
		cnt++;
	}
	
	length=path.GetLength();
	tStr=tPath.Right(length-j-1);

	m_editFileName.SetWindowText(tStr);

}

void CCabrio_downloaderv01Dlg::GetCheckSum(CString Filename)
{
	CFile File;
	DWORD Checksum = 0;
	BYTE * buffer;
	
	if(File.Open(Filename,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
	{
		DWORD i;
		DWORD FileLength = File.GetLength(); 
		

		buffer = new BYTE[FileLength];
		File.ReadHuge(buffer,FileLength);
		File.Close();
		for( i=0; i < FileLength; i++ )
		{
			
			Checksum += buffer[i];
		}

		CString str;
		str.Format("0x%lX",Checksum);

		m_editCheckSum.SetWindowText(str);
		

	
		delete buffer;
	}
	else
	{
		;
	}
}


void CCabrio_downloaderv01Dlg::OnButtonTfsFormat() 
{
	// TODO: Add your control notification handler code here

	LockControls();
	UpdateData(true);
	if (m_ComPort==-1 && m_cbxBaudRate.GetCurSel()==NULL)
		goto init;


	
	if (cDriverStatus==CURRENT_NOR_DRIVER)
	{
		DisconnectMS();
		cDriverStatus=CURRENT_WITHOUT_DRIVER;
	}

	

	pThread=AfxBeginThread(TFSFormatThreadFunc, (LPVOID)this, THREAD_PRIORITY_HIGHEST  );
	
	init:
	;
//	InitControls();


}


void CCabrio_downloaderv01Dlg::OnButtonStart() 
{
	// TODO: Add your control notification handler code here
	CString str;
	bool	tst;
	
	LockControls();

	
	UpdateData(true);

	if (m_radioMode==0)
		nConnectMode=UART_MODE;

	if (m_radioMode==1)
		nConnectMode=USB_MODE;



	if (m_radioMode==-1)
	{
		AfxMessageBox("Select a comm type by USB or by UART.\r\nTry again!!");
		ReadyControls();
		return;
	}




	//if (strcmp("1","1")==


	if (m_boolAuto==true)
	{
		m_nImageSize = GetFileSize(m_strImageFileName);
		if(!m_nImageSize)
		{
			AfxMessageBox("NOR : imgset - not existed");
			AfxMessageBox("Verify a path of Z220_imgset file");
			goto init;
		}
		if (m_boolCalset==TRUE)
		{
			m_nParamDepSize = GetFileSize(m_strParamDepFileName);

			if(!m_nParamDepSize)
			{
				AfxMessageBox("NOR: calset - not existed");
				AfxMessageBox("Verify a path of Z220_calset file");
				goto init;
			}
		}
		
		m_nRscrSize = GetFileSize(m_strRscrFileName);

		if(!m_nRscrSize)
		{
			AfxMessageBox("NAND : Rscr1 file not existed");
			AfxMessageBox("Verify a path of Rscr file");
			goto init;
		}
		m_nRscr2Size = GetFileSize(m_strRscr2FileName);

		if(!m_nRscr2Size)
		{
			AfxMessageBox("NAND : Rscr2 file not existed");
			AfxMessageBox("Verify a path of Rscr2 file");
			goto init;
		}
		m_nFactoryFSSize = GetFileSize(m_strFactoryFSFileName);

		if(!m_nFactoryFSSize)
		{
			AfxMessageBox("NAND : FactoryFS file not existed");
			AfxMessageBox("Verify a path of FactoryFS file");
			goto init;
		}

		ShowStatus("\n  * Connecting to target phone",4);
		str.Format("\n     Try to open COM%d\t>",m_ComPort+1);
		ShowStatus(str,3);
	//	nCon_Result=ConnectWithMS();
	//	ShowMessage_ConnectWithMS(nCon_Result);

		cActionType=DWL_ALL;
		pThread=AfxBeginThread(AutoDownloadThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST);
	}
	else
		pThread=AfxBeginThread(ConnectionThreadFunc, (LPVOID)this, THREAD_PRIORITY_HIGHEST);
	
	
	//InitControls();
	return;
init:
	str.Format("  Connect");
	ShowEnv(str,4);
	ReadyControls();
}

void CCabrio_downloaderv01Dlg::DisconnectMS()
{
//	void * comPort;
	UInt8 initBaudRate,dnldBaudRate;
	CString str,str2;
	Result_t result;



	cDriverStatus=CURRENT_WITHOUT_DRIVER;



	if (nConnectMode==UART_MODE)
	{
		initBaudRate=g_BaudRate[0];
		dnldBaudRate=g_BaudRate[m_cbxBaudRate.GetCurSel()];


		str.Format("COM%d",m_ComPort+1);
		char * arg_device=LPSTR(LPCTSTR(str));
		

		str2.Format("\n   * Reconnecting (Flash Driver Change)");
		ShowStatus(str2,4);
		str2.Format("\n    Open Comport\t\t\t\t> > > ");
		ShowStatus(str2);

		
		comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , initBaudRate ) ;

		if (comPort==0)
		{
			str2.Format("FAIL");
			ShowStatus(str,4);
			goto _cleanup;	
		}
		else
		{
			str2.Format("OK");
			ShowStatus(str2,3);
		}

	/*	if( initBaudRate != dnldBaudRate ) 
		{
			str2.Format("\n    Set Target Phone BaudRate................");
			ShowStatus(str2);

			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,0) ;
			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}*/


		Sleep(1000*1);

		str.Format("\n    Now Reconnecting\t\t\t> > > ");



		ShowStatus(str);

		result=TOOL_Disconnect(comPort);

		if (result!=RESULT_OK)
		{
			str.Format("FAIL");
			ShowStatus(str,4);
		}
		else
		{
			str.Format("OK");
			ShowStatus(str,3);
		}
	}
	



_cleanup:
	if (nConnectMode==UART_MODE)
	{
		TOOL_CloseDnldPort( comPort ) ;
	}
	else
		InitControls();
		m_ctrCN.EnableWindow(true);


	if (comPort!=0 && result==RESULT_OK && (m_radio==4 || m_radio==7 || m_radio==1))
		m_ctrCN.EnableWindow(true);
	else
		InitControls();	
}

//#define _USB_CONNET_

// divisor must be 1xxx xxx1, initvalue=0x00, 0xFF
UInt8 CCabrio_downloaderv01Dlg::GetCRC7(UInt8 *bpdata, UInt8 totlen, UInt8 initvalue, UInt8 divisor, UInt8 bit0)
{
	UInt8 shiftdata, newbit, dvs_mask, dvs_and, temp8;
	UInt16 i,shiftdata1;

	if(initvalue == 0x00)
	{
		shiftdata = initvalue;
		dvs_mask = divisor & 0x7E;
		dvs_and = ~(divisor & 0x7F);

		for(i=0; i<(8*totlen); i++)
		{
			newbit = GetBit(bpdata,(UInt32)i) ^ ((shiftdata & 0x40)>>6);
			shiftdata <<= 1;
			if(newbit)
				temp8 = dvs_mask;
			else
				temp8 = 0x0000;
			temp8 ^= (shiftdata & dvs_mask);
			shiftdata = (shiftdata & dvs_and) | temp8 | newbit;

			if( ((i&7) == 7) && (bit0 == 0) )
			{
				CString str;
				str.Format("\n\rcrc7_sw=0x",(shiftdata<<1) | bit0);
				AfxMessageBox(str);
			}
		}

		return ((shiftdata<<1) | bit0);
	}
	else
	{
		shiftdata1 = (UInt16)initvalue;

		for(i=0; i<(8*totlen); i++)
		{
			shiftdata1 <<= 1;
			shiftdata1 += GetBit(bpdata,(UInt32)i);
			if( shiftdata1 >= 0x80 )
				shiftdata1 ^= divisor;
		}

		for(i=0; i<7; i++)
		{
			shiftdata1 <<= 1;
			if( shiftdata1 >= 0x80 )
				shiftdata1 ^= divisor;
		}

		return ((UInt8)(shiftdata1<<1) | bit0);
	}
}

UInt16 CCabrio_downloaderv01Dlg::GetCRC16(UInt8 *bpdata, UInt16 totlen, UInt16 initvalue, UInt32 divisor)
{
	UInt16 shiftdata, newbit, dvs_mask, dvs_and, temp16;
	UInt32 i, i1, shiftdata1;

	if(initvalue == 0x0000)
	{
		shiftdata = initvalue;
		dvs_mask = (UInt16)(divisor & 0xFFFE);
		dvs_and = ~((UInt16)(divisor & 0xFFFF));

		for(i=0; i<(8*totlen); i++)
		{
			newbit = (UInt16)GetBit(bpdata,(UInt32)i) ^ (shiftdata>>15);
			shiftdata <<= 1;
			if(newbit)
				temp16 = dvs_mask;
			else
				temp16 = 0x0000;
			temp16 ^= (shiftdata & dvs_mask);
			shiftdata = (shiftdata & dvs_and) | temp16 | newbit;
		}

		return shiftdata;
	}
	else
	{
		shiftdata1 = (UInt32)initvalue;

		for(i1=0; i1<(8*totlen); i1++)
		{
			shiftdata1 <<= 1;
			shiftdata1 += GetBit(bpdata,i1);
			if( shiftdata1 >= 0x10000 )
				shiftdata1 ^= divisor;
		}

		for(i1=0; i1<16; i1++)
		{
			shiftdata1 <<= 1;
			if( shiftdata1 >= 0x10000 )
				shiftdata1 ^= divisor;
		}

		return (UInt16)shiftdata1;
	}
}

UInt8 CCabrio_downloaderv01Dlg::GetBit(UInt8 *bpdata, UInt32 bitaddr)
{
	UInt8 bitloc, mybyte;
	bitloc = 7 - (UInt8)(bitaddr&0x07);
	mybyte = 0x01 << bitloc;

	return (*(bpdata + (bitaddr>>3)) & mybyte)>>bitloc;
}

/*
BOOL CCabrio_downloaderv01Dlg::GetBlkDataFromImage(UInt8 *bp, FILE *fp, UInt16 blklength)
{
	UInt8 c;
	UInt16 i;
	for(i=0; i<blklength; i++)
	{
		if (fread(&c, 1, 1, fp) == 1)
		{
			*(bp+i) = c;
		}
		else
		{
			AfxMessageBox("\nError in Reading Image File!");
			return FALSE;
		}
	}
	return TRUE;
}
*/

void CCabrio_downloaderv01Dlg::GetBlkDataFromArray(UInt8 *bp, UInt8 const *ap, UInt32 startaddr, UInt16 blklength)
{
	UInt16 i;
	for(i=0; i<blklength; i++)
	{
		*(bp+i) = *(ap + startaddr + i);
	}
}


#define _USB_CONNET_
#define TFS4_BO_uint16(x)	((UInt16) (0xffffU & (((x) << 8) | ((x) >> 8))))
//FEATURE_EUR
#define PREBOOT_CHAR	'w'
//////////////////////////////////////////
// Comm. with MS sequence (USB or UART) //
//////////////////////////////////////////
// Created : MooYoung, Kim              //
//////////////////////////////////////////
int CCabrio_downloaderv01Dlg::ConnectWithMS()
{

	CString str;
	unsigned char rxChar,txChar;
	Result_t result;
	UInt8 saveBaudRate;
	UInt32	nByte;
	UInt8	*fileBuffer = 0,p;
	int cnt=0;
	UInt8 startChar=0xff;
	
	static UInt8 block_buff[BLOCK_LENGTH];

	UInt32 totblks=0,lastblklength=0,blklength=0;
	
	UInt8	ch,c,c1,c2,crcon,block_pattern;
	UInt16	crc7_blk,crc16_blk,i,j,k;
	
	// variable for Badblock check
	CString pBlock[100],sBlock[100],sMergedText[100];
	UInt16 nFinish=0xEEEE,nBigValue=0;
	UInt16 nBMF[512];
	Int32 nIdx;
	Int16 nOdd=0,nCnt=0;
	usb_message_t rx_msg,rx_msg2,rx_msg3;
	bool ack;//FEATURE_EUR

	LockControls();
	
	if (m_ComPort==-1 && m_cbxBaudRate.GetCurSel()==NULL)
		return CON_ENV_ERROR;
	
	str.Format("COM%d",m_ComPort+1);

	/*    Comport      
	/ COM BAUD SPEED FLASHNAME    ComportCfg_t ü */
	memset( (char*)&comPortCfg,0,sizeof(ComPortCfg_t) );
	strcpy( (char*)comPortCfg.comPortName,str ) ;  // COM port name
	comPortCfg.baudRate = g_BaudRate[m_cbxBaudRate.GetCurSel()];//COMPORT_BAUDRATE_115K;

	
	switch( comPortCfg.baudRate )
	{
		case FP_Speed_921k:
		case FP_Speed_460k:
		case FP_Speed_115k:
			break ;
		default:
			result = RESULT_TOOL_INVALID_VALUE ;
			nCon_Result=CON_SPEED_SET_ERROR;
			goto _cleanup ;
	}

	saveBaudRate = comPortCfg.baudRate ;
	comPortCfg.baudRate = COMPORT_BAUDRATE_115K ;

	
	{
		startChar=DWL_START_CHAR;
		result=TOOL_OpenComPort(&comPortCfg,EVENPARITY);
	
		Sleep(1000*1);

		if (result!=RESULT_OK)
		{
			ShowStatus(" Fail\n",4);
		//	AfxMessageBox("Comport Error");
			nCon_Result=CON_COMM_ERROR;
			return nCon_Result;
		}
		ShowStatus("Success!!\n",3);
	}

	
	if(nConnectMode == UART_MODE)
	{
		ShowStatus("\n   - Turn on the target phone immediately!!!!\n",4);
		ShowStatus("      Listen for the BOOT signal\t\t\t> > > " );
	_waitboot:
		rxChar=0xff;
		//listen for char 1 byte 0xA5
		while(RESULT_OK==TOOL_ReadComPortWithTimeout(&comPortCfg,&rxChar,1,TIMEOUT_SEC))
		{
			if(rxChar==BOOT_CHAR)
			{
				ShowStatus("OK\n");
				txChar=DWL_START_CHAR;
				goto _sendack;
			}
	#if 1 //preboot download mode 
			else if(rxChar == PREBOOT_CHAR)
			{
				ShowStatus("OK\n");
				txChar=PREBOOT_CHAR;
				IsPrebootDL = TRUE;
				goto _sendack;
			} 
			else if(rxChar == 0x00)
			{
				goto _waitboot;
			}
	#endif
			
		}
			
		//TIMEOUT  
		if (rxChar==0xff)
		{
			//AfxMessageBox("TIMEOUT");
			ShowStatus("FAIL\n",4);
			ShowStatus("      (Check Comport connection & Bootloader existence)\n",3);
			nCon_Result=CON_TIMEOUT;
			goto _cleanup;
		}

		//Received wrong char
		if (rxChar!=BOOT_CHAR)
		{
			nCon_Result=CON_WRONG_BOOTCHAR;
			ShowStatus("Wrong code! Try again\n",4);	
			goto _cleanup ;
		}

		if(result == RESULT_TOOL_TIMEOUT)
		{
			//AfxMessageBox("TIMEOUT");
			nCon_Result=CON_TIMEOUT;
			ShowStatus("Timeout\n",4);	
			goto _cleanup;
		}		
	}


_sendack:
	ShowStatus("      Send the Download start signal\t\t> > > " );
	result=TOOL_WriteComPort(&comPortCfg,&txChar,1,&nByte);

	if (result!=RESULT_OK)
	{
		ShowStatus("FAIL\n");
		nCon_Result=CON_COMM_ERROR;
		goto _cleanup ;
	}
	rxChar=0xff;
	do
	{

		while(RESULT_OK==TOOL_ReadComPortWithTimeout(&comPortCfg,&rxChar,1,1))
		{
			if(nConnectMode == UART_MODE)
			{
				if ((rxChar==DWL_START_CHAR)||(rxChar == PREBOOT_CHAR))
				{
					ShowStatus("OK\n");

					//Connect â connectǥ
				//	m_editNandFlash.SetWindowText("Connect");

					/* + JELEE to downloader loader only once + */
					nOnline=true;
					Sleep(200);
					goto _download_loader;
	
					/* - JELEE to downloader loader only once - */
				}
			}
		}
        
		//rxChar    Timeoutð Ͱ   
		if (rxChar==0xff)
		{
			ShowStatus("Timeout\n");
			nCon_Result=CON_TIMEOUT;
			goto _cleanup;
		}

		if((rxChar!=DWL_START_CHAR)&&(rxChar != PREBOOT_CHAR))
		{
			if(IsPrebootDL)
			{
				IsPrebootDL = FALSE;
				ShowStatus("Try again\n");
				if(rxChar == BOOT_CHAR)
				{
					txChar=DWL_START_CHAR;
					goto _sendack;
				}
				else
				{
					ShowStatus("      Listen for the BOOT signal\t\t\t> > > ");
					goto _waitboot;
				}
			}

			nCon_Result=CON_WRONG_BOOTCHAR;
			goto _cleanup ;
		}
		else
			break;

	} while (1);
/* + JELEE to downloader loader only once + *///wkjoo
_download_loader:
	ack = NandDriverDownload(&comPortCfg, DRV_NAND);
	if(ack!=true)
	{
		ShowStatus("\n      Loader download fail!\n ");
		nCon_Result=CON_COMM_ERROR;
		goto _cleanup;
	}
	ShowStatus("OK\n");
	ShowStatus("\n     UART Download Mode\t> > > ");
	nCon_Result=CON_SUCCESS;
	return nCon_Result;
/* - JELEE to downloader loader only once - */
//JUN_USB_TEMP
//	rxChar=0x11;
//	RESULT_OK==TOOL_ReadComPortWithTimeout(&comPortCfg,&rxChar,1,5000);
//#if 0	//JUN_USB_TEMP
	UInt8 test1;
	result=TOOL_ReadComPortWithTimeout(&comPortCfg, &test1, 1, TIMEOUT_SEC );

	ShowStatus("      NAND device check.............\t\t> > > " );

	result=TOOL_FlashIDCheck(&comPortCfg,1,nConnectMode);
	
	UInt8 IDTYPE;

	result=TOOL_ReadComPortWithTimeout(&comPortCfg, &IDTYPE, 1, TIMEOUT_SEC );

	if (!FlashCheck(IDTYPE))
	{
		str.Format("FAIL\n");
		ShowStatus(str,4);
	/*	str.Format("\n  Turn On/Off the target phone!!!\n");
		ShowStatus(str,4);
		InitControls();
		return false;*/
	}
	else
	{
		str.Format("OK\n");
		ShowStatus(str,1);
	}
//#if 0	//JUN_USB_TEMP
	result=TOOL_GetBMI(&comPortCfg,nConnectMode);
					
	ShowStatus("      NAND Bad block check\t\t\t> > > " );
	
	
#if 0
	RESULT_OK==TOOL_ReadComPortWithTimeout(&comPortCfg,(UInt8*)nBMF,256,TIMEOUT_SEC);
	
	for (nIdx=0;nIdx<256;nIdx+=2)
        {
             if (nBMF[nIdx]==0xFFFF)
                  break;
			
					sBlock[nCnt].Format("S.Block[%d]",nBMF[nIdx]);
					pBlock[nCnt].Format("P.Block[%d]",nBMF[nIdx+1]);
			
					sMergedText[nCnt].Format("        %s ---> %s\n",pBlock[nCnt],sBlock[nCnt]);
					nCnt++;		
					nFinish=0xFFFF;
		}
#endif
#if 1
	while(RESULT_OK==TOOL_ReadComPortWithTimeout(&comPortCfg,&nFinish,2,1))
	{
		nBigValue= TFS4_BO_uint16(nFinish);

		if (nFinish==0xFFFF)
			break;
		if (nOdd==1)
		{
			sBlock[nCnt].Format("S.Block[%d]",nBigValue);
			nOdd=0;
			sMergedText[nCnt].Format("        %s ---> %s\n",pBlock[nCnt],sBlock[nCnt]);
			nCnt++;
		}
		else
		{
			pBlock[nCnt].Format("P.Block[%d]",nBigValue);
			nOdd=1;
		}
						
	}
#endif
	// bad block check algorithm not existed
	if (nFinish==0xEEEE)
	{
		str.Format("FAIL\n");
		ShowStatus(str,4);
	}
	else
	{
		// bad block 0
		if (nCnt==0)
		{
#ifdef _CUSTOMER_
			str.Format("OK\n");
#else
			str.Format("Not found\n");
#endif
			ShowStatus(str,3);
		}
		else
		{
#ifdef _CUSTOMER_
			str.Format("OK\n");
			ShowStatus(str,3);
#else
			str.Format("%d Bad block found\n      ---------------------------------------------------------\n",nCnt);
			ShowStatus(str,4);
			for (int i=0;i<nCnt;i++)
			{
				ShowStatus(sMergedText[i],4);
			}
			str.Format("      ---------------------------------------------------------\n");
			ShowStatus(str,4);
#endif
		}
	}
//#endif
	ShowStatus("\r      USB Download mode -> ");
	result=TOOL_CloseComPort( &comPortCfg ) ;
	nOnline=true;
	return CON_SUCCESS;

// algorithm for VientoSeries USB connection - moo
#ifdef OLD_STYLE_USB	

	union {						// sector size
		UInt32	sector_size;
		struct {
			UInt8	sector_size_byte0;	// lowest byte sector size
			UInt8	sector_size_byte1;	// low byte sector size
			UInt8	sector_size_byte2;	// high byte sector size
			UInt8	sector_size_byte3;	// highest byte sector size
		};
	} ss;
	
	union {						// file size
		UInt32	image_size;
		struct {
			UInt8	image_size_byte0; // lowest byte file of size
			UInt8	image_size_byte1; // low byte file of size
			UInt8	image_size_byte2; // high byte file of size
			UInt8	image_size_byte3; // highest byte of file size
		};
	} is;

	union {						// start address
		UInt32	start_addr;
		struct {
			UInt8	start_addr_byte0; // lowest byte start address
			UInt8	start_addr_byte1; // low byte start address
			UInt8	start_addr_byte2; // high byte start address
			UInt8	start_addr_byte3; // highest byte start address
		};
	} sa;

	
	str.Format("COM%d",m_ComPort+1);
	memset( (char*)&comPortCfg,0,sizeof(ComPortCfg_t) );
	strcpy( (char*)comPortCfg.comPortName,str ) ;  // COM port name
	comPortCfg.baudRate = g_BaudRate[m_cbxBaudRate.GetCurSel()];//COMPORT_BAUDRATE_115K;


	saveBaudRate = comPortCfg.baudRate ;


	// moo_20061222
	result=TOOL_OpenComPort(&comPortCfg,NOPARITY);
	if (result!=RESULT_OK)
	{
		nCon_Result=CON_COMM_ERROR;
			goto _cleanup;		

	}

	sa.start_addr=LOADER_SRAM_ADDRESS;
	is.image_size=hFlashloaderSize[0];
	
	totblks = is.image_size/BLOCK_LENGTH;
	totblks++;
	g_nDownloadedSector=totblks;
	lastblklength = is.image_size%BLOCK_LENGTH;

	fileBuffer = (UInt8*)calloc(1,hFlashloaderSize[0]) ;
	memcpy((void *)fileBuffer,(void *)hFlashloader[0],hFlashloaderSize[0]);
	g_nProgressCounter=0;
	



	
	ShowStatus("\n      Send USB Flashloader image\t\t\t");
	for(i=0; i<totblks; i++)
	{
	
		if( i == (totblks-1) )
			blklength = lastblklength;
		else
			blklength = BLOCK_LENGTH;

		memcpy(block_buff,fileBuffer+i*BLOCK_LENGTH,blklength);
		
		if( crcon == 1 )
			crc16_blk = GetCRC16(block_buff, blklength, 0x0000, 0x11021);

		block_pattern = block_buff[0];
		for(k=0; k<blklength; k++)
		{
			if(block_buff[k] != block_pattern)
			{
				block_pattern = 0x80;
				break;
			}
		}
		
		k = 0;
		ch = 0xff;
		
		{
			if(k ++)
				Sleep(100); //printf("R");
			if(1)
			{
				
				UInt32 nWrite;
				if( crcon == 2 )
					crc16_blk = 0;

				for(j=0; j<blklength; j++)
				{
					if( crcon == 2 )
						crc16_blk += block_buff[j];
				}
			
			
				TOOL_WriteComPortWithTimeout(&comPortCfg,block_buff,blklength,TIMEOUT_SEC);
				ShowStatus(">",3);
				g_nProgressCounter+=blklength;
				m_nMainPercent = (g_nProgressCounter * 100) / hFlashloaderSize[0];
				m_progressMain.SetPos(m_nMainPercent);
			}
		}

	}

	ShowStatus(" OK\n",3);
	// ID Check
	Sleep(1000*9);
	ShowStatus("\n      Check NOR Flash ID & Initialize flash\t\t> > >");
	result=TOOL_FlashIDCheck(&comPortCfg,0,nConnectMode);
	result=TOOL_ReadComPortWithTimeout(&comPortCfg, &ch, 1, TIMEOUT_SEC );
	if (!FlashCheck(ch))
	{
		str.Format(" FAIL\n",4);
		ShowStatus(str,4);
		str.Format("\n  Turn On/Off the target phone!!!\n");
		ShowStatus(str,4);
		TOOL_CloseComPort( &comPortCfg ) ;
		ReadyControls();
		return false;
	}
	ShowStatus(" OK\n",3);

	ShowStatus("      Check NAND Flash ID & Initialize flash\t\t> > >");
	result=TOOL_FlashIDCheck(&comPortCfg,1,nConnectMode);
	result=TOOL_ReadComPortWithTimeout(&comPortCfg, &ch, 1, TIMEOUT_SEC );
	if (!FlashCheck(ch))
	{
		str.Format(" FAIL\n",4);
		ShowStatus(str,4);
		str.Format("\n  Turn On/Off the target phone!!!\n");
		ShowStatus(str,4);
		TOOL_CloseComPort( &comPortCfg ) ;
		ReadyControls();
		return false;
	}
	ShowStatus(" OK\n",3);

	ShowStatus("\r      USB Download mode -> ");
 
	TOOL_CloseComPort( &comPortCfg ) ;
    nOnline=true;
	return nCon_Result;
#endif
_cleanup:
	
	ReadyControls();
	TOOL_CloseComPort( &comPortCfg ) ;
	return nCon_Result;

}

void CCabrio_downloaderv01Dlg::OnButtonDisconnect() 
{
	// TODO: Add your control notification handler code here
	CString str;
	Result_t result;
	
	bConnect=false;
	str.Format("\0");
	m_ctrlNFlash.SetWindowText("Disconnected");
	m_ctrlConnect.SetWindowText("Disconnected");
	cDriverStatus=CURRENT_WITHOUT_DRIVER;

	if (nConnectMode==USB_MODE)
	{
		result=TOOL_CloseComPort(&comPortCfg);
		if (result!=RESULT_OK)
			AfxMessageBox("Close comport error");
		Sleep(1000);
	}
	nOnline=false;
	ReadyControls();
}


void CCabrio_downloaderv01Dlg::OnButtonDlbootloader() 
{
	// TODO: Add your control notification handler code here

	CBootloaderDlg hDialog;
	
	if(hDialog.DoModal() == IDCANCEL)
	{
		return;
	}

	if (m_radioMode==1)
	{
		AfxMessageBox("Only uart mode available!!!!");
		return;
	}

	LockControls();
	
	UpdateData(true);
	if (m_ComPort==-1 && m_cbxBaudRate.GetCurSel()==NULL)
		goto init;

	pThread=AfxBeginThread(DlbootloaderThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST  );


init:
;
//	InitControls();
	
}

void CCabrio_downloaderv01Dlg::OnButtonCabrio() 
{
	// TODO: Add your control notification handler code here
	
}

#define INFO_LENGTH	235

#if 0
// binary_check function 
void CCabrio_downloaderv01Dlg::OnButtonInfo() 
{
	// TODO: Add your control notification handler code here

	CFile File;
	CString str,tstr;
	
	char * ps = new char[INFO_LENGTH];
	unsigned char * v_code = new unsigned char[4];
	int rslt;

	if (!m_strImageFileName.Compare("\0"))
	{
		AfxMessageBox("imgset file not selected");
		return;
	}


	if(!File.Open(m_strImageFileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
	{
		AfxMessageBox("Image File open Error");
		return;
	}

//	File.Read(&startAddr,4);
//	File.Read(&imageSize,4);
//	File.Seek(imageSize,CFile::current);

	File.Seek(40,CFile::current);
	File.Read(v_code,4);
	if (v_code[0]==0xba && v_code[1]==0xbe && v_code[2]==0xfa && v_code[3]==0xce)
	{
	
		File.Seek(0,CFile::begin);
		rslt=File.Read(&startAddr[0],4);
		File.Read(&imageSize[0],4);
		if (rslt==0)
		{
			AfxMessageBox("Invalid imgset file");
			File.Close();
			delete v_code;
			return;
		}
		str.Format("----------------------\n    Image list info\n----------------------\n1. ER_RO\n");
		tstr+=str;
		str.Format("   start addr : 0x%x\n",startAddr[0]);
		tstr+=str;
		str.Format("   image size : %ld\n",imageSize[0]);
		tstr+=str;

			// ER_RO
		File.Seek(imageSize[0],CFile::current);
		rslt=File.Read(&startAddr[1],4);
		File.Read(&imageSize[1],4);
		if (rslt==0)
		{
			AfxMessageBox("Invalid imgset file : 1");
			File.Close();
			delete v_code;
			return;
		}

		str.Format("\n2. sysparm_ind\n");
		tstr+=str;
		str.Format("   start addr : 0x%x\n",startAddr[1]);
		tstr+=str;
		str.Format("   image size : %ld\n",imageSize[1]);
		tstr+=str;
		// sysparm_ind			

		File.Seek(imageSize[1],CFile::current);
		rslt=File.Read(&startAddr[2],4);
		File.Read(&imageSize[2],4);
		if (rslt==0)
		{
			AfxMessageBox("Invalid imgset file : 2");
			File.Close();
			delete v_code;
			return;
		}

		str.Format("\n3. patch_dsp\n");
		tstr+=str;
		str.Format("   start addr : 0x%x\n",startAddr[2]);
		tstr+=str;
		str.Format("   image size : %ld\n",imageSize[2]);
		tstr+=str;
		// dsp_patch

		File.Seek(imageSize[2],CFile::current);
		rslt=File.Read(&startAddr[3],4);
		File.Read(&imageSize[3],4);
		if (rslt==0)
		{
			AfxMessageBox("Invalid imgset file : 3");
			File.Close();
			delete v_code;
			return;
		}

		str.Format("\n4. SpinnerFW\n");
		tstr+=str;
		str.Format("   start addr : 0x%x\n",startAddr[3]);
		tstr+=str;
		str.Format("   image size : %ld\n",imageSize[3]);
		tstr+=str;
		// spinner fw

		File.Seek(imageSize[3],CFile::current);
		rslt=File.Read(&startAddr[4],4);
		File.Read(&imageSize[4],4);
		if (rslt==0)
		{
			AfxMessageBox("Invalid imgset file : 4");
			File.Close();
			delete v_code;
			return;
		}

		str.Format("\n5. Rc1\n");
		tstr+=str;
		str.Format("   start addr : 0x%x\n",startAddr[4]);
		tstr+=str;
		str.Format("   image size : %ld\n",imageSize[4]);
		tstr+=str;
		// rc1

		File.Seek(imageSize[4],CFile::current);
		rslt=File.Read(&startAddr[5],4);
		File.Read(&imageSize[5],4);
		if (rslt==0)
		{
			AfxMessageBox("Invalid imgset file : 5");
			File.Close();
			delete v_code;
			return;
		}
		str.Format("\n6. sysparm_dep\n");
		tstr+=str;
		str.Format("   start addr : 0x%x\n",startAddr[5]);
		tstr+=str;
		str.Format("   image size : %ld\n",imageSize[5]);
		tstr+=str;
		// sysparm_dep
				
		File.Seek(imageSize[5],CFile::current);
		rslt=File.Read(&startAddr[6],4);
		File.Read(&imageSize[6],4);
		if (rslt==0)
		{
			AfxMessageBox("Invalid imgset file : 6");
			File.Close();
			delete v_code;
			return;
		}
		str.Format("\n7. rfCal\n");
		tstr+=str;
		str.Format("   start addr : 0x%x\n",startAddr[6]);
		tstr+=str;
		str.Format("   image size : %ld\n",imageSize[6]);
		tstr+=str;
		//rf cal

		File.Seek(imageSize[6],CFile::current);
		rslt=File.Read(&startAddr[7],4);
		File.Read(&imageSize[7],4);
		if (rslt==0)
		{
			AfxMessageBox("Invalid imgset file : 7");
			File.Close();
			delete v_code;
			return;
		}
		str.Format("\n8. boot2\n");
		tstr+=str;
		str.Format("   start addr : 0x%x\n",startAddr[7]);
		tstr+=str;
		str.Format("   image size : %ld\n",imageSize[7]);
		tstr+=str;

		
	}
	else
	{
		AfxMessageBox("Invalid imgset file");
		delete v_code;
		delete ps;
		return;
	}

	
	str.Format("\nChecked image_set file OK" );
	tstr+=str;
	vImageFile=1;
	
	MessageBox(tstr);
	delete v_code;
	delete ps;
}
#endif

void CCabrio_downloaderv01Dlg::OnButtonInfo() 
{
// TODO: Add your control notification handler code here
	CFile File;
	CString str;
	DWORD Checksum = 0;
	BYTE * buffer;

	unsigned long fileSize;

	if (!m_strImageFileName.Compare("\0"))
	{
		AfxMessageBox("Imgset file not selected");
		return;
	}


	if(!File.Open(m_strImageFileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
	{
		AfxMessageBox("Imgset File open Error");
		return;
	}

		fileSize=File.GetLength();

		buffer = new BYTE[fileSize];
		File.ReadHuge(buffer,fileSize);
		File.Close();
		for( int i=0; i < fileSize; i++ )
		{
			
			Checksum += buffer[i];
		}
		
		str.Format("File size : %d byte\r\nChecksum : 0x%x",fileSize,Checksum);

		MessageBox(str,"Imgset Information",MB_OK);

	
	delete buffer;
}

void CCabrio_downloaderv01Dlg::OnButtonBchk() 
{
	// TODO: Add your control notification handler code here
	LockControls();
	UpdateData(true);
	if (m_ComPort==-1 && m_cbxBaudRate.GetCurSel()==NULL)
		goto init;


	
	if (cDriverStatus==CURRENT_NOR_DRIVER)
	{
		DisconnectMS();
		cDriverStatus=CURRENT_WITHOUT_DRIVER;
	}


//	pThread=AfxBeginThread(BadBlkCheckThreadFunc, (LPVOID)this, THREAD_PRIORITY_HIGHEST  );

	
	init:
	;
	
}

void CCabrio_downloaderv01Dlg::OnButtonNandEntireFlash() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
	char szFilter[] = "*.dmp File(*.dmp)|*.dmp|*.*|*.*||";
	CFile File;
	unsigned long fsize=0;
	CFileDialog dlg(TRUE, NULL, m_strEntireFlashFileName, OFN_HIDEREADONLY,szFilter);
	
	if(dlg.DoModal() == IDOK)
	{
		m_strEntireFlashFileName = dlg.GetPathName();	
		if(File.Open(m_strEntireFlashFileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
		{
			 
			fsize=File.GetLength(); 
			if (fsize!=ENTIRE_FLASH_SIZE)
			{
				AfxMessageBox("File size must be 62.75MB");
				File.Close();
				return;
			}
			else
			{
				m_editEntireFlashPath.SetWindowText((LPCTSTR) dlg.GetPathName());
				File.Close();
			}
		}
		else
		{
			AfxMessageBox("File open failed");
			return;
		}

		AfxGetApp()->WriteProfileString("CabrioDL", "m_strEntireFlashFileName",m_strEntireFlashFileName);
	}
}

void CCabrio_downloaderv01Dlg::OnButtonBootloaderErase() 
{
	// TODO: Add your control notification handler code here
	COKDialog hDialog;
	

	if (cActionType!=DWL_ALL)
	{
		if(hDialog.DoModal() == IDCANCEL)
		{
			InitControls();
			return;
		}
	}
	
	LockControls();
	UpdateData(true);
	if (m_ComPort==-1 && m_cbxBaudRate.GetCurSel()==NULL)
		goto init;
	
	cActionType=OP_ERASE_BOOTLOADER;

	if (cDriverStatus==CURRENT_NAND_DRIVER)
	{
		/*
		DisconnectMS();
		cDriverStatus=CURRENT_WITHOUT_DRIVER;
		*/
	}
	


	pThread=AfxBeginThread(EraseThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST  );
init:
	;
	
}

void CCabrio_downloaderv01Dlg::OnButtonNorAllerase() 
{
	// TODO: Add your control notification handler code here
	COKDialog hDialog;
	

	if (cActionType!=DWL_ALL)
	{
		if(hDialog.DoModal() == IDCANCEL)
		{
			InitControls();
			return;
		}
	}
	
	LockControls();
	UpdateData(true);
	if (m_ComPort==-1 && m_cbxBaudRate.GetCurSel()==NULL)
		goto init;
	
	cActionType=OP_NOR_ERASE;

	if (cDriverStatus==CURRENT_NAND_DRIVER)
	{
		DisconnectMS();
		cDriverStatus=CURRENT_WITHOUT_DRIVER;
	}
	


	pThread=AfxBeginThread(NorEraseThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST  );
init:
	;
	
}

void CCabrio_downloaderv01Dlg::OnButtonNorDump() 
{
	// TODO: Add your control notification handler code here
	LockControls();
	UpdateData(true);
	if (m_ComPort==-1 && m_cbxBaudRate.GetCurSel()==NULL)
		goto init;
	
	cActionType=OP_NOR_DUMP;

	
	


	pThread=AfxBeginThread(NorDumpThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST  );
init:
	;
}

void CCabrio_downloaderv01Dlg::OnButtonNandDump() 
{
	// TODO: Add your control notification handler code here
	LockControls();
	UpdateData(true);
	if (m_ComPort==-1 && m_cbxBaudRate.GetCurSel()==NULL)
		goto init;
	
	cActionType=OP_NAND_DUMP;
	


	pThread=AfxBeginThread(NandDumpThreadFunc,(LPVOID)this, THREAD_PRIORITY_HIGHEST  );
init:
	;
}

int NoDumpBytes = 0;


BYTE m_Buffer[8192];

BYTE count = 0;
unsigned long		ramData;	// 4byte

unsigned char       *p_ram;
unsigned char       *s_ram;

void CCabrio_downloaderv01Dlg::Ramdump()
{
	CString str;
	BYTE Tx[10];
	unsigned long m_RamAddress=0,m_RamSize=0;
	int DumpProgress=0,i=0;
	BYTE CheckSum=0;
	int mode=0;
	Result_t result;
	

	str.Format("COM%d",m_ComPort+1);
	memset( (char*)&comPortCfg,0,sizeof(ComPortCfg_t) );
	strcpy( (char*)comPortCfg.comPortName,str ) ;  // COM port name
	comPortCfg.baudRate = g_BaudRate[m_cbxBaudRate.GetCurSel()];//COMPORT_BAUDRATE_115K;


	saveBaudRate = comPortCfg.baudRate ;


	// moo_20061222
	result=TOOL_OpenComPort(&comPortCfg,NOPARITY);
	if (result!=RESULT_OK)
	{
		AfxMessageBox("Comport error");
		return;

	}
	ShowStatus(" OpenComport success \r ") ;

	// Send 0xCF to phone
	Tx[0]=0xCF;
	result=TOOL_WriteComPortWithTimeout(&comPortCfg,&Tx[0],1,3);
	if (result!=RESULT_OK)
	{
		AfxMessageBox("0xCF sending error");
		return;
	}

	ShowStatus(" Send 0xCF success \r ") ;
	// Send 0xCC(baud rate value) to phone
	Tx[0]=0xCC;
	result=TOOL_WriteComPortWithTimeout(&comPortCfg,&Tx[0],1,3);
	if (result!=RESULT_OK)
	{
		AfxMessageBox("0xCC sending error");
		return;
	}
	ShowStatus(" Send 0x success \r ") ;
	// receive ram addresss 
	result=TOOL_ReadComPortWithTimeout(&comPortCfg,Tx,4,15);
	if (result!=RESULT_OK)
	{
		AfxMessageBox("0xCF sending error");
		return;
	}
	ShowStatus(" recv ramaddress success \r ") ;
	m_RamAddress  = Tx[0];
	m_RamAddress += (Tx[1] << 8 );
	m_RamAddress += (Tx[2] << 16 );
	m_RamAddress += (Tx[3] << 24 );

	// send checksum about ram address
	CheckSum = Tx[0] + Tx[1] + Tx[2] + Tx[3];
	result=TOOL_WriteComPortWithTimeout(&comPortCfg,&CheckSum,1,3);
	if (result!=RESULT_OK)
	{
		AfxMessageBox("0xCF sending error");
		return;
	}
	
	// receive a ack (0x77)
	result=TOOL_ReadComPortWithTimeout(&comPortCfg,Tx,1,15);
	if (result!=RESULT_OK)
	{
		AfxMessageBox("0xCF sending error");
		return;
	}
	if (Tx[0]!=0x77)
	{
		AfxMessageBox("0x77 error");
		return;
	}


	// receive ram size
	result=TOOL_ReadComPortWithTimeout(&comPortCfg,Tx,4,15);
	if (result!=RESULT_OK)
	{
		AfxMessageBox("0xCF sending error");
		return;
	}

	m_RamSize  = Tx[0];
	m_RamSize += (Tx[1] << 8 );
	m_RamSize += (Tx[2] << 16 );
	m_RamSize += (Tx[3] << 24 );

	// send checksum about ram address
	CheckSum = Tx[0] + Tx[1] + Tx[2] + Tx[3];
	result=TOOL_WriteComPortWithTimeout(&comPortCfg,&CheckSum,1,3);
	if (result!=RESULT_OK)
	{
		AfxMessageBox("0xCF sending error");
		return;
	}

	int DumpSize = 8192;
	// receive a ack (0x77)
	result=TOOL_ReadComPortWithTimeout(&comPortCfg,Tx,1,15);
	if (result!=RESULT_OK)
	{
		AfxMessageBox("0xCF sending error");
		return;
	}
	if (Tx[0]!=0x77)
	{
		AfxMessageBox("0x77 error 1");
		return;
	}

	m_progressMain.SetRange32(0,m_RamSize/8192);
	DumpProgress=0;
	m_progressMain.SetPos(DumpProgress);



	p_ram = (unsigned char *)&ramData;
	s_ram = (unsigned char *)&m_Buffer[0];

	
	while(1)
	{
	/*	result=TOOL_ReadComPortWithTimeout(&comPortCfg,Tx,4,15);
		if (result!=RESULT_OK)
		{
			AfxMessageBox("read error");
			return;
		}*/
		result=TOOL_ReadComPortWithTimeout(&comPortCfg,&Tx[0],1,15);
		if (result!=RESULT_OK)
		{
			AfxMessageBox("read error");
			return;
		}
		p_ram[3]=Tx[0];
		CheckSum+=Tx[0];

		result=TOOL_ReadComPortWithTimeout(&comPortCfg,&Tx[0],1,15);
		if (result!=RESULT_OK)
		{
			AfxMessageBox("read error");
			return;
		}
		p_ram[2]=Tx[0];
		CheckSum+=Tx[0];

		result=TOOL_ReadComPortWithTimeout(&comPortCfg,&Tx[0],1,15);
		if (result!=RESULT_OK)
		{
			AfxMessageBox("read error");
			return;
		}
		p_ram[1]=Tx[0];
		CheckSum+=Tx[0];

		result=TOOL_ReadComPortWithTimeout(&comPortCfg,&Tx[0],1,15);
		if (result!=RESULT_OK)
		{
			AfxMessageBox("read error");
			return;
		}
		p_ram[0]=Tx[0];
		CheckSum+=Tx[0];
		
		s_ram = (unsigned char *)&m_Buffer[NoDumpBytes];
		*(unsigned long *)s_ram = *(unsigned long *)p_ram;
		s_ram += 4;
		
		NoDumpBytes += 4;
		m_RamSize -= 4;

		if( (p_ram[0] == p_ram[1]) && (p_ram[0] == p_ram[2]) && (p_ram[0] == p_ram[3]) )
		{

			result=TOOL_ReadComPortWithTimeout(&comPortCfg,Tx,1,15);
			if (result!=RESULT_OK)
			{
				AfxMessageBox("read error");
				return;
			}

			CheckSum += Tx[0];
			count = 0;
			for(i=Tx[0]; i != 0 ; i--)
			{
				*(unsigned long *)s_ram = *(unsigned long *)p_ram;
				s_ram += 4;
			}

			NoDumpBytes += (4*Tx[0]);
			m_RamSize -= (4*Tx[0]);
			
			if ( NoDumpBytes >= DumpSize )
			{
				
				/* Send CheckSum */
				Tx[0] = CheckSum;
				result=TOOL_WriteComPortWithTimeout(&comPortCfg,&Tx[0],1,3);
				if (result!=RESULT_OK)
				{
					AfxMessageBox("write error");
					return;
				}
				CheckSum = 0;
			}

		}
		else
		{
			// not zip mode
			if ( NoDumpBytes >= DumpSize )
			{
			
				Tx[0]=CheckSum;
				result=TOOL_WriteComPortWithTimeout(&comPortCfg,&Tx[0],1,3);
				if (result!=RESULT_OK)
				{
					AfxMessageBox("write error");
					return;
				}
				CheckSum=0;
				result=TOOL_ReadComPortWithTimeout(&comPortCfg,Tx,1,15);
				if (result!=RESULT_OK)
				{
					AfxMessageBox("write error");
					return;
				}
				if (Tx[0]!=0x77)
				{
					AfxMessageBox("0x77 error 3");
					return;
				}

				NoDumpBytes = 0;
				CheckSum = 0;
				count = 0;
				
				DumpProgress++;
				m_progressMain.SetPos( DumpProgress );
				if (m_RamSize==0)
				{
					AfxMessageBox("END");
					return;
				}
				if ( m_RamSize < 8192 )
					DumpSize = m_RamSize;
			}

		}



	}


}


bool CCabrio_downloaderv01Dlg::NorDump(UInt8 cActionType)
{
	
//	void * comPort;
	UInt8 initBaudRate,dnldBaudRate;
	CString str,str2,dname;
	Result_t result;
	bool rslt;
	char * arg_device;
	unsigned long startAddr,length;

	CNorDumpDialog hDialog;
	
	if(hDialog.DoModal() == IDCANCEL)
	{
		InitControls();
		return false;
	}
	else
	{

		if (!(hDialog.m_fAddress>=0 && hDialog.m_fAddress<=0x1FFFFFE
			&& hDialog.m_fAddress<hDialog.m_tAddress 
			&& hDialog.m_tAddress>=1 && hDialog.m_tAddress<=0x1FFFFFF))
		{
			MessageBox("Dump range invalid","Error");
			InitControls();
			return false;
		}

		g_nDownloadedSector=GetSectorNum(hDialog.m_fAddress,hDialog.m_tAddress-hDialog.m_fAddress);
		startAddr=hDialog.m_fAddress;
		length=hDialog.m_tAddress-hDialog.m_fAddress;
		temp_nfrom=startAddr;
		all_size=0;
		used_size=0;
	}

	str.Format("nordump0x%lx_0x%lx.dmp",startAddr,startAddr+length);
	CFileDialog fdialog(FALSE, str, str, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
									  "All Files (*.*)|*.*|All Files (*.*)|*.*||" );
						
	if (IDOK==fdialog.DoModal())
	{
		dname = fdialog.GetPathName();
		m_editFileName.SetWindowText(str);
	}
	else
	{
		MessageBox("File select canceled","Error");
		InitControls();
		return false;
	}

	rslt = m_DumpFile.Open( dname, CFile::modeCreate | CFile::modeWrite );
	if ( rslt == FALSE )
	{
		AfxMessageBox("Internal Error! (file creation)");
		InitControls();
		return false;
	}

	if (cDriverStatus==CURRENT_NAND_DRIVER)
	{
		DisconnectMS();
		cDriverStatus=CURRENT_WITHOUT_DRIVER;
	}
	


	str.Format("COM%d",m_ComPort+1);
	arg_device=LPSTR(LPCTSTR(str));
	if (nConnectMode==UART_MODE)
	{
		if ( (cDriverStatus==CURRENT_WITHOUT_DRIVER) || (cDriverStatus==CURRENT_NAND_DRIVER))
		{
			rslt=NorDriverDownload(&comPortCfg,1);
			if (rslt==false)
				goto _cleanup;
		}
	}


	initBaudRate=g_BaudRate[0];
	dnldBaudRate=g_BaudRate[m_cbxBaudRate.GetCurSel()];

	str2.Format("\n  * NOR Flash DUMP");
	ShowStatus(str2,4);




	
	if( (!initBaudRate ) || (!dnldBaudRate ))
	{
		AfxMessageBox("BaudRate Error");
		rslt=false;
		goto _cleanup;
	}

	str2.Format("\n    Open Comport\t\t\t\t> > > ");
	ShowStatus(str2);	

	if (nConnectMode==UART_MODE)
	{

	//	Sleep(1000*1);

		comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , initBaudRate ) ;

		if (comPort==0)
		{
			str2.Format("FAIL");
			ShowStatus(str2,4);
			rslt=false;
			goto _cleanup;	
		}
		else
		{
			str2.Format("OK");
			ShowStatus(str2,3);
		}

		
		
		if( initBaudRate != dnldBaudRate ) 
		{
			str2.Format("\n    Set Target Phone BaudRate\t\t> > > ");
			ShowStatus(str2);
			
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
		else
		{
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
	}
        else
        {
	        comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , dnldBaudRate ) ;

        	if (comPort==0)
        	{
        		str2.Format("FAIL");
        		ShowStatus(str2,4);
        		rslt=false;
        		goto _cleanup;
         	}
        	else
        	{
         		str2.Format("OK");
	        	ShowStatus(str2,3);
        	}
        }

	Sleep(1000*1);
	
	str.Format("\n    Now DUMP start!!\n");
	ShowStatus(str);
	str2.Format("-----------------------------------------------------------------------------------------------\n");
	ShowStatus(str2);
	
	result = TOOL_CaptureImage( nConnectMode,(UInt8*)dname.GetBuffer(MYBUFF_SIZE)
			,comPort,startAddr,length,FLASHLOADER_CMD_NOR_CAPTURE_IMAGE,ToolProgressCbDump,ToolFileHandleCb);

	if( RESULT_OK != result ) 
	{
		str.Format("\r\n\r\n -  Fail!!!!!!!!");
		ShowStatus(str,4);
		str.Format( "Error flashing erase : %s\n",TOOL_GetResultStr( result ));
		AfxMessageBox(str);
		rslt=false;
		
		goto _cleanup;
	}
		
	if (nConnectMode==UART_MODE)
	{
		//flashdrv_nandimg downloading successfully..
		if( initBaudRate != dnldBaudRate ) 
		{
			result = TOOL_SetTargetBaudRate( comPort, initBaudRate,0 ) ;
			if( RESULT_OK != result ) 
			{
				str.Format( "Error  changing target baud rate : %s\n",TOOL_GetResultStr( result ));
				AfxMessageBox(str);	
				rslt=false;
				goto _cleanup;
			}

			TOOL_ChangeComPortBaudRate( comPort, initBaudRate ) ;
		}
	}
	ShowStatus("\n\n      DUMP");

	str.Format("  Completed!!!\n");
	ShowStatus(str,3);

	rslt=true;
	cDriverStatus=CURRENT_NOR_DRIVER;
_cleanup:
	TOOL_CloseDnldPort( comPort );
	
	if (result==RESULT_OK)
	{
		m_DumpFile.Close();
		MessageBox("DUMP complete","NOTICE");
	}
	InitControls();
	m_ctrCN.EnableWindow(true);
	return rslt;
}

bool CCabrio_downloaderv01Dlg::NandDump(UInt8 cActionType)
{
	
//	void * comPort;
	UInt8 initBaudRate,dnldBaudRate;
	CString str,str2,dname;
	Result_t result;
	bool rslt,nErase,IsTmpFile;
	char * arg_device;
	unsigned long startAddr,length;

	CNandDump hDialog;
	
	if(hDialog.DoModal() == IDCANCEL)
	{
		InitControls();
		return false;
	}
	else
	{

		if (!(hDialog.m_fAddress>=0 && hDialog.m_fAddress<=(NAND_SIZE-1)
			&& hDialog.m_fAddress<hDialog.m_tAddress 
			&& hDialog.m_tAddress>=1 && hDialog.m_tAddress<=NAND_SIZE))
		{
			MessageBox("Dump range invalid","Error");
			InitControls();
			return false;
		}

		g_nDownloadedSector=GetSectorNum2(hDialog.m_fAddress,hDialog.m_tAddress-hDialog.m_fAddress);
		startAddr=hDialog.m_fAddress;
		length=hDialog.m_tAddress-hDialog.m_fAddress+1;
		temp_nfrom=startAddr;
		all_size=0;
		used_size=0;

		// Erase  ƴ üũ 
		if (hDialog.m_boolErase==TRUE)
			nErase=TRUE;
		else
			nErase=FALSE;
	}
	
	if (nErase==FALSE)
	{
	if (startAddr==TFS_START_ADDR)
	{
		str.Format("tfs_area_dump.dmp");
	}
	else
	{
		str.Format("nanddump0x%lx_0x%lx.dmp",startAddr,startAddr+length);
	}
	CFileDialog fdialog(FALSE, str, str, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
									  "All Files (*.*)|*.*|All Files (*.*)|*.*||" );
						
	if (IDOK==fdialog.DoModal())
	{
		dname = fdialog.GetPathName();
		m_editFileName.SetWindowText(str);
	}
	else
	{
		MessageBox("File select canceled","Error");
		InitControls();
		return false;
	}
	

		IsTmpFile = m_DumpFile.Open( dname, CFile::modeCreate | CFile::modeWrite );
		if ( IsTmpFile == FALSE )
		{
			AfxMessageBox("Internal Error! (file creation)");
			InitControls();
			return false;
		}
	}


	str.Format("COM%d",m_ComPort+1);
	arg_device=LPSTR(LPCTSTR(str));

	initBaudRate=g_BaudRate[0];
	dnldBaudRate=g_BaudRate[m_cbxBaudRate.GetCurSel()];

	if (nErase==FALSE)
	{
		str2.Format("\n  * NAND Flash DUMP");
		ShowStatus(str2,4);
	}
	else
	{
		str2.Format("\n  * NAND Flash partial erase");
		ShowStatus(str2,4);
	}

	
	if( (!initBaudRate ) || (!dnldBaudRate ))
	{
		AfxMessageBox("BaudRate Error");
		rslt=false;
		goto _cleanup;
	}

	str2.Format("\n    Open Comport\t\t\t\t> > > ");
	ShowStatus(str2);

	if ((cActionType==DWL_BOOT4) || (nConnectMode==UART_MODE))	//JUN_comm_test___
	{

		Sleep(1000*1);

		comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , initBaudRate ) ;

		if (comPort==0)
		{
			str2.Format("FAIL");
			ShowStatus(str2,4);
			rslt=false;
			goto _cleanup;	
		}
		else
		{
			str2.Format("OK");
			ShowStatus(str2,3);
		}

		

		if( initBaudRate != dnldBaudRate ) 
		{
			str2.Format("\n    Set Target Phone BaudRate\t\t> > > ");
			ShowStatus(str2);
			
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
		else
		{
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
		
	}

#if 0
	 comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , dnldBaudRate ) ;

  	if (comPort==0)
  	{
       	str2.Format("FAIL");
       	ShowStatus(str2,4);
       	rslt=false;
       	goto _cleanup;
   	}
   	else
    {
       	str2.Format("OK");
	   	ShowStatus(str2,3);
   	}
#endif

	Sleep(1000*1);



	if (nErase==FALSE)
	{
		str.Format("\n    Now DUMP start!!\n");
		ShowStatus(str);
	}
	else
	{
		str.Format("\n    Now Partial erase start!!\n");
		ShowStatus(str);
	}
	str2.Format("-----------------------------------------------------------------------------------------------\n");
	ShowStatus(str2);

	if (nErase==FALSE)
	{
		result = TOOL_CaptureImage( nConnectMode,(UInt8*)dname.GetBuffer(MYBUFF_SIZE)
			,comPort,startAddr,length,FLASHLOADER_CMD_NAND_CAPTURE_IMAGE,ToolProgressCbDump,ToolFileHandleCb);
	}
	else
	{
		result = TOOL_PartialErase(comPort,startAddr,length,ToolProgressCbDump);
	}
	
	if( RESULT_OK != result ) 
	{
		str.Format("\r\n\r\n -  Fail!!!!!!!!");
		ShowStatus(str,4);
		str.Format( "Error flashing erase : %s\n",TOOL_GetResultStr( result ));
		AfxMessageBox(str);
		rslt=false;
		
		goto _cleanup;
	}
	
	if (nConnectMode==UART_MODE)
	{

		Sleep(1000*2);
		//flashdrv_nandimg downloading successfully..
		if( initBaudRate != dnldBaudRate ) 
		{
			result = TOOL_SetTargetBaudRate( comPort, initBaudRate,0 ) ;
			if( RESULT_OK != result ) 
			{
				str.Format( "Error  changing target baud rate : %s\n",TOOL_GetResultStr( result ));
				AfxMessageBox(str);	
				rslt=false;
				goto _cleanup;
			}

			TOOL_ChangeComPortBaudRate( comPort, initBaudRate ) ;
		}
	}
	ShowStatus("\n\n      DUMP");

	str.Format("  Completed!!!\n");
	ShowStatus(str,3);
	
	m_DumpFile.Close();
	rslt=true;
	cDriverStatus=CURRENT_NAND_DRIVER;
_cleanup:
	TOOL_CloseDnldPort( comPort );
	
	if (result==RESULT_OK)
		MessageBox("DUMP Complete","NOTICE");
	InitControls();
	m_ctrCN.EnableWindow(true);
	return rslt;
}


void CCabrio_downloaderv01Dlg::OnChangeEditManual() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
		UpdateData(true);



	CString str,str2;	
	int tempBlock,tempPagenum,tempOffset;
	static bool bFirstAccess=FALSE;

//	str.GetLength
	GetDlgItemText(IDC_EDIT_MANUAL,str);

	//Է¹߿ 16   ð üũ
	if (!IsHex(str))
	{
		MessageBox("Wrong value","WARNING");
		SetDlgItemText(IDC_EDIT_MANUAL,"0");
		UpdateData(true);
		return;
	}

	//Է¹ 16(ڿ) 16()· ȯ
	m_fAddress=ConvHex(str);
	
	//Է¹   Ѿ MAX ڵ 
	//MAX 1   1byte ĸİ ʿ2
	
/*	if (m_fAddress<0xfff)
	{
		m_fAddress=0x1000;
		SetDlgItemText(IDC_EDIT_MANUAL,"1000");
		UpdateData(true);
		return;
	}*/
	

	if (m_fAddress>0x1FFFFFE)
	{
		m_fAddress=0x1FE0000;
		SetDlgItemText(IDC_EDIT_MANUAL,"1FE0000");
		UpdateData(true);
		return;
	}

	
	
}


int CCabrio_downloaderv01Dlg::ConvHex(const CString & str)
{
	int total=0;
	int len=str.GetLength();
	int len2=len-1;

	char * ss=LPSTR(LPCTSTR(str));

	for (int i=0;i<len;i++)
	{
		if (ss[i]=='a' || ss[i]=='A')
		{
			total+=10*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='b' || ss[i]=='B')
		{
			total+=11*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='c' || ss[i]=='C')
		{
			total+=12*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='d' || ss[i]=='D')
		{
			total+=13*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='e' || ss[i]=='E')
		{
			total+=14*pow(16,len2);
			len2--;
			continue;
		}
		if (ss[i]=='f' || ss[i]=='F')
		{
			total+=15*pow(16,len2);
			len2--;
			continue;
		}
	
		total+=(ss[i]-48)*pow(16,len2);
		len2--;

	}
	return total;
}

int CCabrio_downloaderv01Dlg::IsHex(const CString &st)
{
	int total=0;
	int len=st.GetLength();
	int len2=len-1;

		char * ss=LPSTR(LPCTSTR(st));

	
	
	for (int i=0;i<len;i++)
	{
		if (ss[i]>='0' && ss[i]<='9')
			continue;
		if (ss[i]=='a' || ss[i]=='A')
			continue;
		if (ss[i]=='b' || ss[i]=='B')
			continue;
		if (ss[i]=='c' || ss[i]=='C')
			continue;
		if (ss[i]=='d' || ss[i]=='D')
			continue;
		if (ss[i]=='e' || ss[i]=='E')
			continue;
		if (ss[i]=='f' || ss[i]=='F')
			continue;
		return 0;
	}
	return 1;

}

void CCabrio_downloaderv01Dlg::OnButtonManualImage() 
{
	// TODO: Add your control notification handler code here

	
	char szFilter[] = "?.img File(*.img)|*.img|*.*|*.*||";
	CFile File;

	CFileDialog dlg(TRUE, NULL, m_strManualImage, OFN_HIDEREADONLY,szFilter);
		
	if(dlg.DoModal() == IDOK)
	{
		m_strManualImage = dlg.GetPathName();
		if(File.Open(m_strManualImage,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
		{	
			m_editManualImagePath.SetWindowText((LPCTSTR) dlg.GetPathName());
			File.Close();
		}
		else
		{
			AfxMessageBox("Image File Size Error");
		}

		AfxGetApp()->WriteProfileString("CabrioDL", "m_strManualImage",m_strManualImage);
	}

}

void CCabrio_downloaderv01Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	CString str,str_month,str_day,str_year,month,day;
	CDialog::OnTimer(nIDEvent);
	CTime nTime=CTime::GetCurrentTime();
	char * cMonth;  //ð ´.
	char * cDay;
	int nMonth=0;
//	str.Format("%d.%d.%d   %d:%d:%d", nTime.GetYear(), nTime.GetMonth(), nTime.GetDay(),nTime.GetHour(),nTime.GetMinute(),nTime.GetSecond());
//	m_editTime.SetWindowText(str);

	month=nTime.GetMonth();
	if (month<0xa)
		str_month.Format("0%d",nTime.GetMonth());
	else
		str_month.Format("%d",nTime.GetMonth());

	day=nTime.GetDay();
	if (day<0xa)
		str_day.Format("0%d",nTime.GetDay());
	else
		str_day.Format("%d",nTime.GetDay());

	cMonth=LPSTR(LPCTSTR(str_month));
	cDay=LPSTR(LPCTSTR(str_day));
	str_year.Format("%d",nTime.GetYear());

	CString sPercent;
	CWnd *ptr=AfxGetMainWnd();
#ifdef _CUSTOMER_
	if (m_nMainPercent!=0)
	{	
		if(m_nMainPercent > 100)
			m_nMainPercent = 100;
		sPercent.Format(" %d%% Done...   BCM213X1 Downloader v0.68(C)",m_nMainPercent);
		ptr->SetWindowText(sPercent);
//		sPercent.Format("%d",m_nMainPercent);
//		m_btnPer.SetWindowText(sPercent);
	}
	else
	{   
		if (nConnectMode==UART_MODE && nOnline==true)
			sPercent.Format(" COM%d (UART)   BCM213X1 Downloader v0.68(C)",m_ComPort+1);
		if (nConnectMode==USB_MODE && nOnline==true)
            sPercent.Format(" COM%d (USB)   BCM213X1 Downloader v0.68(C)",m_ComPort+1);
		if (nOnline==false)
			sPercent.Format(" Disconnected            BCM213X1 Downloader v0.68(C)");

		ptr->SetWindowText(sPercent);
		
	}
#else
	if (m_nMainPercent!=0)
	{	
		if(m_nMainPercent > 100)
			m_nMainPercent = 100;
		sPercent.Format(" %d%% Done...   BCM213X1 Downloader v0.68(D)",m_nMainPercent);
		ptr->SetWindowText(sPercent);
//		sPercent.Format("%d",m_nMainPercent);
//		m_btnPer.SetWindowText(sPercent);
	}
	else
	{   
		if (nConnectMode==UART_MODE && nOnline==true)
			sPercent.Format(" COM%d (UART)   BCM213X1 Downloader v0.68(D)",m_ComPort+1);
		if (nConnectMode==USB_MODE && nOnline==true)
            sPercent.Format(" COM%d (USB)   BCM213X1 Downloader v0.68(D)",m_ComPort+1);
		if (nOnline==false)
			sPercent.Format(" Disconnected             BCM213X1 Downloader v0.68(D)");

		ptr->SetWindowText(sPercent);
		
	}
#endif


//	str_time.Format("%d%d%d",nTime.GetYear(),cMonth,cDay);
	str_time=str_year+str_month+str_day;
//	UpdateData(FALSE); 
}

void CCabrio_downloaderv01Dlg::OnButtonManualNandImage() 
{
	// TODO: Add your control notification handler code here
	char szFilter[] = "?.img File(*.img)|*.img|*.*|*.*||";
	CFile File;

	CFileDialog dlg(TRUE, NULL, m_strManualNandImage, OFN_HIDEREADONLY,szFilter);
		
	if(dlg.DoModal() == IDOK)
	{
		m_strManualNandImage = dlg.GetPathName();
		if(File.Open(m_strManualNandImage,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
		{	
			m_editManualNandImagePath.SetWindowText((LPCTSTR) dlg.GetPathName());
			File.Close();
		}
		else
		{
			AfxMessageBox("Image File Size Error");
		}

		AfxGetApp()->WriteProfileString("CabrioDL", "m_strManualNandImage",m_strManualNandImage);
	}
	
}

void CCabrio_downloaderv01Dlg::OnChangeEditManualNand() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(true);



	CString str,str2;	
	int tempBlock,tempPagenum,tempOffset;
	static bool bFirstAccess=FALSE;

//	str.GetLength
	GetDlgItemText(IDC_EDIT_MANUAL_NAND,str);

	//Է¹߿ 16   ð üũ
	if (!IsHex(str))
	{
		MessageBox("Wrong value","WARNING");
		SetDlgItemText(IDC_EDIT_MANUAL_NAND,"0");
		UpdateData(true);
		return;
	}

	//Է¹ 16(ڿ) 16()· ȯ
	m_fAddress=ConvHex(str);
	
	//Է¹   Ѿ MAX ڵ 
	//MAX 1   1byte ĸİ ʿ2
	
/*	if (m_fAddress<0xfff)
	{
		m_fAddress=0x1000;
		SetDlgItemText(IDC_EDIT_MANUAL,"1000");
		UpdateData(true);
		return;
	}*/


	if (m_fAddress>0x7E60000)
	{
		m_fAddress=0x7E40000;
		SetDlgItemText(IDC_EDIT_MANUAL_NAND,"7E40000");
		UpdateData(true);
		return;
	}
}

void CCabrio_downloaderv01Dlg::OnRadioUart() 
{
	// TODO: Add your control notification handler code here
	m_ComPort = AfxGetApp()->GetProfileInt("CabrioDL", "UartPort", m_ComPort);
	m_ctrlComPort.SetCurSel(m_ComPort);
	UpdateData(true);
}

void CCabrio_downloaderv01Dlg::OnRadioUsb() 
{
	// TODO: Add your control notification handler code here
	m_ComPort = AfxGetApp()->GetProfileInt("CabrioDL", "UsbPort", m_ComPort);
	m_ctrlComPort.SetCurSel(m_ComPort);
	UpdateData(true);
}

void CCabrio_downloaderv01Dlg::OnButtonCalInfo() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
	CFile File;
	CString str;
	DWORD Checksum = 0;
	BYTE * buffer;

	unsigned long fileSize;

	if (!m_strParamDepFileName.Compare("\0"))
	{
		AfxMessageBox("Calset file not selected");
		return;
	}


	if(!File.Open(m_strParamDepFileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
	{
		AfxMessageBox("Calset File open Error");
		return;
	}

		fileSize=File.GetLength();

		buffer = new BYTE[fileSize];
		File.ReadHuge(buffer,fileSize);
		File.Close();
		for( int i=0; i < fileSize; i++ )
		{
			
			Checksum += buffer[i];
		}
		
		str.Format("File size : %d byte\r\nChecksum : 0x%x",fileSize,Checksum);

		MessageBox(str,"Calset Information",MB_OK);

	
	delete buffer;
}

void CCabrio_downloaderv01Dlg::OnButtonRsrcInfo() 
{
	// TODO: Add your control notification handler code here
	CFile File;
	CString str;
	DWORD Checksum = 0;
	BYTE * buffer;

	unsigned long fileSize;

	if (!m_strRscrFileName.Compare("\0"))
	{
		AfxMessageBox("Rsrc file not selected");
		return;
	}


	if(!File.Open(m_strRscrFileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
	{
		AfxMessageBox("Rsrc File open Error");
		return;
	}

		fileSize=File.GetLength();

		buffer = new BYTE[fileSize];
		File.ReadHuge(buffer,fileSize);
		File.Close();
		for( int i=0; i < fileSize; i++ )
		{
			
			Checksum += buffer[i];
		}
		
		str.Format("File size : %d byte\r\nChecksum : 0x%x",fileSize,Checksum);

		MessageBox(str,"Rsrc Information",MB_OK);

	
	delete buffer;
	
}

void CCabrio_downloaderv01Dlg::OnButtonRsrc2Info() 
{
	// TODO: Add your control notification handler code here
	CFile File;
	CString str;
	DWORD Checksum = 0;
	BYTE * buffer;

	unsigned long fileSize;

	if (!m_strRscr2FileName.Compare("\0"))
	{
		AfxMessageBox("Rsrc2 file not selected");
		return;
	}


	if(!File.Open(m_strRscr2FileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
	{
		AfxMessageBox("Rsrc2 File open Error");
		return;
	}

		fileSize=File.GetLength();

		buffer = new BYTE[fileSize];
		File.ReadHuge(buffer,fileSize);
		File.Close();
		for( int i=0; i < fileSize; i++ )
		{
			
			Checksum += buffer[i];
		}
		
		str.Format("File size : %d byte\r\nChecksum : 0x%x",fileSize,Checksum);

		MessageBox(str,"Rsrc2 Information",MB_OK);

	
	delete buffer;
}

void CCabrio_downloaderv01Dlg::OnButtonFacInfo() 
{
	// TODO: Add your control notification handler code here
	CFile File;
	CString str;
	DWORD Checksum = 0;
	BYTE * buffer;

	unsigned long fileSize;

	if (!m_strFactoryFSFileName.Compare("\0"))
	{
		AfxMessageBox("FactoryFS file not selected");
		return;
	}


	if(!File.Open(m_strFactoryFSFileName,CFile::modeRead | CFile::typeBinary | CFile::shareDenyNone))
	{
		AfxMessageBox("FactoryFS File open Error");
		return;
	}

		fileSize=File.GetLength();

		buffer = new BYTE[fileSize];
		File.ReadHuge(buffer,fileSize);
		File.Close();
		for( int i=0; i < fileSize; i++ )
		{
			
			Checksum += buffer[i];
		}
		
		str.Format("File size : %d byte\r\nChecksum : 0x%x",fileSize,Checksum);

		MessageBox(str,"FactoryFS Information",MB_OK);

	
	delete buffer;
}



bool CCabrio_downloaderv01Dlg::BML_Format()
{
	

	CTFSDialog hDialog;
	
//	if(hDialog.DoModal() == IDCANCEL)
//	{
//		InitControls();
//		return false;
//	}


//	void * comPort;
	UInt8 initBaudRate,dnldBaudRate;
	CString str,str2;
	Result_t result;
	bool rslt;


	str.Format("COM%d",m_ComPort+1);
	char * arg_device=LPSTR(LPCTSTR(str));




	if (nConnectMode==UART_MODE)
	{
		if (cDriverStatus==CURRENT_WITHOUT_DRIVER || cDriverStatus==CURRENT_NOR_DRIVER)
		{
			rslt=NandDriverDownload(&comPortCfg,1);
			if (rslt==false)
				goto _cleanup;
		}
	}




	initBaudRate=g_BaudRate[0];
	dnldBaudRate=g_BaudRate[m_cbxBaudRate.GetCurSel()];

	str2.Format("\n  * BML Format");
	ShowStatus(str2,4);


	
	if( (!initBaudRate ) || (!dnldBaudRate ))
	{
		AfxMessageBox("BaudRate Error");

			goto _cleanup;
	}

	
	str2.Format("\n    Open Comport\t\t\t\t> > > ");
        ShowStatus(str2);
	if (nConnectMode==UART_MODE)
	{

	//	Sleep(1000*1);

		comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , initBaudRate ) ;

		if (comPort==0)
		{
			str2.Format("FAIL");
			ShowStatus(str2,4);
			rslt=false;
			goto _cleanup;	
		}
		else
		{
			str2.Format("OK");
			ShowStatus(str2,3);
		}

		
		
		if( initBaudRate != dnldBaudRate ) 
		{
			str2.Format("\n    Set Target Phone BaudRate\t\t> > > ");
			ShowStatus(str2);
			
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
		else
		{
			result = TOOL_SetTargetBaudRate( comPort, dnldBaudRate,1 ) ;

			if( RESULT_OK != result )
			{
				str2.Format("FAIL\n");
				ShowStatus(str2,4);
				rslt=false;
				goto _cleanup;	
			}
			else
			{
				str2.Format("OK");
				ShowStatus(str2,3);
			}

			TOOL_ChangeComPortBaudRate( comPort, dnldBaudRate ) ;
		}
	}
        else
        {
	        comPort = TOOL_OpenDnldPort( (UInt8*)arg_device , dnldBaudRate ) ;

        	if (comPort==0)
        	{
        		str2.Format("FAIL");
        		ShowStatus(str2,4);
        		rslt=false;
        		goto _cleanup;
         	}
        	else
        	{
         		str2.Format("OK");
	        	ShowStatus(str2,3);
        	}
        }

	Sleep(1000*1);

	str.Format("\n    Now NAND BML Format Setting\t\t> > > ");

//	str.Format("\n    Now NOR TFS Format Setting\t\t> > > ");

	ShowStatus(str);

	result=TOOL_BMLformat(comPort);
	result=RESULT_OK;
	if( RESULT_OK != result ) 
	{
		str.Format("Fail");
		ShowStatus(str,4);
		str.Format( "Error BML erase : %s\n",TOOL_GetResultStr( result ));
		AfxMessageBox(str);
		rslt=false;
		goto _cleanup;
	}
	else
	{
		str.Format("OK\n");
		ShowStatus(str,3);
	}
	



	//flashdrv_nandimg downloading successfully..

	if (nConnectMode==UART_MODE)
	{
		if( initBaudRate != dnldBaudRate ) 
		{
			result = TOOL_SetTargetBaudRate( comPort, initBaudRate,0 ) ;
			if( RESULT_OK != result ) 
			{
				str.Format( "Error  changing target baud rate : %s\n",TOOL_GetResultStr( result ));
				AfxMessageBox(str);	
				rslt=false;
				goto _cleanup;
			}

			TOOL_ChangeComPortBaudRate( comPort, initBaudRate ) ;
		}
	}
	
	rslt=true;
	cDriverStatus=CURRENT_NAND_DRIVER;
//	cDriverStatus=CURRENT_NOR_DRIVER;
_cleanup:
	TOOL_CloseDnldPort( comPort );
	MessageBox("BML All Erased. Turn On/Off","  NOTICE  ");
	InitControls();
	return rslt;

}


void CCabrio_downloaderv01Dlg::OnBmlFormat() 
{
	// TODO: Add your control notification handler code here

	LockControls();
	UpdateData(true);
	if (m_ComPort==-1 && m_cbxBaudRate.GetCurSel()==NULL)
		goto init;


	
	if (cDriverStatus==CURRENT_NOR_DRIVER)
	{
		DisconnectMS();
		cDriverStatus=CURRENT_WITHOUT_DRIVER;
	}

	

	pThread=AfxBeginThread(BML_FORMATThreadFunc, (LPVOID)this, THREAD_PRIORITY_HIGHEST  );
	
	init:
	;
//	InitControls();
	
}

BOOL CCabrio_downloaderv01Dlg::TFS_Download(void * comPort,UInt8 nConnectMode)
{
	unsigned char ch;
	int rcvSize=0;
	static int rxBytes;
	ULONG vl_CheckSum=0;
	int FileLen;
	ULONG *pl_SystemTime;
	CString str,sMsg;
	BYTE	Tx[60];
	BOOL	Success;
//	CString sMsg;
	Result_t	rslt;

//	

	ComPortCfg_t * cPort=(ComPortCfg_t *)comPort;

	m_RxState=RX_WAIT_CHANGE_UART_SPEED;
	m_Operation = OP_NAND_FORMAT;

	m_progressMain.SetPos(m_nMainPercent);
	
#if 0
	Tx[0] = CMD_CHANGE_UART_SPEED_DONE;
	TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
#endif

	rslt=TOOL_TFSformat(comPort,nConnectMode);

	while (RESULT_OK==TOOL_ReadComPortWithTimeout(cPort, &ch, 1, 0xFF ))
	{

		switch ( m_RxState )
		{
		case RX_WAIT_CHANGE_UART_SPEED:
			if ( m_Operation == OP_NAND_DOWNLOAD )
			{
				BOOL IsOk;
				// check TFS file size
	
				str.Format( "Tfs :  %s  \nCfg : %s\n ",m_strOgmPath , m_strOgmCfgPath);
				ShowStatus( str );
				

				IsOk = TFS_CheckFileSize();
				if ( !IsOk )
					break;				
			
				ShowStatus("     Mounting TFS system...\n");
				ShowStatus("      ** Start Downloading TFS file **\n");
			//	OutputStatus_MINI( str );
		

				m_RxState = RX_WAIT_TFS_MOUNT;
				Tx[0] = CMD_TFS_MOUNT;
				m_CheckSum = Tx[0];

				TOOL_CMD(cPort,FLASHLOADER_CMD_TFS_MOUNT,nConnectMode);
				//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
			}
			else if ( m_Operation == OP_NAND_FORMAT )
			{
				m_RxState = RX_WAIT_TFS_FORMAT;
				Tx[0] = CMD_FORMAT_NAND;
				m_CheckSum = Tx[0];
		
				ShowStatus( "     TFS Format...\n");
				TOOL_CMD(cPort,FLASHLOADER_CMD_FORMAT_NAND,nConnectMode);
				//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
			}
			else if ( m_Operation == OP_NAND_STATUS )
			{
				m_RxState = RX_WAIT_TFS_STATUS;
				Tx[0] = CMD_CHECK_NAND_STATUS;
				m_CheckSum = Tx[0];
				//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
				TOOL_CMD(cPort,FLASHLOADER_CMD_CHECK_NAND_STATUS,nConnectMode);
			}

			break;

		case RX_WAIT_TFS_STATUS:

			if(ch == CMD_CHECK_NAND_STATUS_DONE)
			{
               		m_RxState = RX_WAIT_READ_TFS_STATUS;
				rxBytes = 0;
			}
			else if(ch == CMD_GET_STATUS_ERROR)
			{
				m_RxState = RX_WAIT_READ_TFS_STATUS;
				rxBytes = 0;
			}
			else if(ch == CMD_TFS4_INIT_ERROR)
           		{
				m_RxState = RX_WAIT_TFS_INIT_ERROR;
				rxBytes = 0;
			}

			break;

		case RX_WAIT_READ_TFS_STATUS:

			Tx[rxBytes] = ch;
			rxBytes++;

			if ( rxBytes == 44 )
			{
				int tmp;
				rxBytes = 0;
#if 0
				str.Format( "OK!\r\n\r\n< Result >\r\n" );
			    ShowStatus(str);

				tmp = *( (int *)&Tx[0]);
				str.Format( "1. FileSystem Type( f_type ) : %X\r\n", tmp  );
				ShowStatus(str);
				tmp = *( (int *)&Tx[4]);
				str.Format( "2. Optimal transfer block size( f_bsize ) : %d (0x%X)\r\n", tmp, tmp );
				ShowStatus(str);
				tmp = *( (int *)&Tx[8]);
				str.Format( "3. block size in bits( f_bsizebits ) : %d (0x%X)\r\n", tmp, tmp );
				ShowStatus(str);
				tmp = *( (int *)&Tx[12]);
				str.Format( "4. total data blocks in file system( f_blocks ) : %d (0x%X)\r\n", tmp, tmp );
				ShowStatus( str);
				tmp = *( (int *)&Tx[16]);
				str.Format( "5. free blocks in file system( f_bfree ) : %d (0x%X)\r\n", tmp, tmp );
				ShowStatus(str);
				tmp = *( (int *)&Tx[20]);
				str.Format( "6. free blocks avail to non-superuser( f_bavail ) : %d (0x%X)\r\n", tmp, tmp );
				ShowStatus(str);
				tmp = *( (int *)&Tx[24]);
				str.Format( "7. total file nodes in file system( f_files ) : %d (0x%X)\r\n", tmp, tmp );
				ShowStatus(str);
				tmp = *( (int *)&Tx[28]);
				str.Format( "8. free file nodes in file system( f_ffree ) : %d (0x%X)\r\n", tmp, tmp );
				ShowStatus(str);
				str.Format( "9. file system id( f_fsid ) : %c%c%c%c\r\n", Tx[35], Tx[34], Tx[33], Tx[32] );
				ShowStatus(str);
				tmp = *( (int *)&Tx[36]);
				str.Format( "10. maximum file size( f_maxfilesize ) : %d (0x%X)\r\n", tmp, tmp );
				ShowStatus(str);
				tmp = *( (short *)&Tx[40]);
				str.Format( "11. maximum length of filenames( f_namelen ) : %d (0x%X)\r\n", tmp, tmp );
				ShowStatus(str);
#endif

#if 0
				m_RxState = RX_END;
#else
				m_RxState = RX_WAIT_WRITE_COMPLETE_NAND;
				Tx[0] = CMD_WRITE_COMPLETE_NAND;
				//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
				TOOL_CMD(cPort,FLASHLOADER_CMD_WRITE_COMPLETE_NAND,nConnectMode);
#endif
		//		EnableButtons();
			}

			break;

		case RX_WAIT_TFS_FORMAT:            /*2005.08.11  jungim.kim  for use AutoNandFormat*/
			if ( (ch== CMD_FORMAT_NAND_DONE))
			{
				ShowStatus( "     TFS Format...OK\n");
				m_RxState = RX_END;
				str="Success!\r\n";
		//		OutputStatus( str );
			//	OutputStatus_MINI( str );
				

				BOOL IsOk;
				// check TFS file size

				IsOk = TFS_CheckFileSize();
				if ( !IsOk )
					break;
				str = "     ** Mounting TFS system... \n";
				ShowStatus( str);
				str = "     ** Start Downloading TFS file **\n";
				ShowStatus( str);
			

				m_RxState = RX_WAIT_TFS_MOUNT;
				Tx[0] = CMD_TFS_MOUNT;
				m_CheckSum = Tx[0];
				//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;				
				TOOL_CMD(cPort,FLASHLOADER_CMD_TFS_MOUNT,nConnectMode);
			}
			else if(ch==CMD_FORMAT_NAND_ERROR)
			{
				ShowStatus(  "     TFS Format...FAIL\n");
				m_RxState = RX_WAIT_TFS_FORMAT_ERROR;
			}

			
			break;

		case RX_WAIT_TFS_FORMAT_ERROR:

			Tx[rxBytes] = ch;
			rxBytes++;
			if ( rxBytes == 5)
				{
					int error_message=0;
					int i=0;
					char error_func;
					rxBytes=0;

					error_func=Tx[i++];
					error_message=Tx[i++]<<24;
					error_message|=Tx[i++]<<16;
					error_message|=Tx[i++]<<8;
					error_message|=Tx[i];
					
					m_RxState = RX_END;
					str.Format( "\n     Format Error!\n Funccode(0x%x)->Errorcode (0x%x)\r\n",error_func,error_message  );
					AfxMessageBox(str);
			//		OutputStatus( str );
			//		OutputStatus_MINI("Format Error !\n");
			//		EnableButtons();

					
				}
	
			break;
/*SHKIM Add*/
		case RX_WAIT_TFS_STATUS_ERROR:

			Tx[rxBytes] = ch;
			rxBytes++;
			if ( rxBytes == 5)
				{
					int error_message=0;
					int i=0;
					char error_func;
					rxBytes=0;
					error_func=Tx[i++];
					error_message=Tx[i++]<<24;
					error_message|=Tx[i++]<<16;
					error_message|=Tx[i++]<<8;
					error_message|=Tx[i];
					
					m_RxState = RX_END;
					str.Format( "\n     Get Status Error!\n Funccode(0x%x)->Errorcode (0x%x)\r\n",error_func,error_message  );
					AfxMessageBox(str);
			//		EnableButtons();
					
				}
	
			break;	
/*SHKIM Add*/
		case RX_WAIT_TFS_INIT_ERROR:

			Tx[rxBytes] = ch;
			rxBytes++;
			if ( rxBytes == 5)
				{
					int error_message=0;
					int i=0;
					char error_func;
					rxBytes=0;
					error_func=Tx[i++];
					error_message=Tx[i++]<<24;
					error_message|=Tx[i++]<<16;
					error_message|=Tx[i++]<<8;
					error_message|=Tx[i];
					
					m_RxState = RX_END;
					str.Format( "\n     Init,mount Error!\n Funccode(0x%x)->Errorcode (0x%x)\r\n",error_func,error_message	);
					AfxMessageBox(str);
			//		OutputStatus_MINI("TFS INIT ERROR ! \n");
					
		//			EnableButtons();
		//			
				}
	
			break;	

		case RX_WAIT_TFS_MOUNT:
			UInt32 test;
			if ( ch != m_CheckSum )
			{
				m_RxState = RX_END;
				str.Format( "     Mount Fail! (0x%X)\n", ch );
				ShowStatus( str);
			}
			else //TFS4 Init Mount OK!
			{
				str = "OK!\n"; 
		//		OutputStatus( str );
				
				/*sdhong 20041012 for write checksum in NOR AREA*/	
				m_RxState = RX_WAIT_WRITE_NANDCHECKSUM;
				Tx[0] = CMD_WRITE_NAND_CHECKSUM;
				//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
				TOOL_CMD(cPort,FLASHLOADER_CMD_WRITE_NAND_CHECKSUM,nConnectMode);
				vl_CheckSum = CalCheckSum(m_strOgmPath,&FileLen);
				str.Format("     Sending NAND CheckSum:%x\n ",vl_CheckSum);
				ShowStatus( str);

				Sleep(1000);
				Tx[0] = (BYTE) ( (vl_CheckSum >> 24) & 0xFF );
				Tx[1] = (BYTE) ( (vl_CheckSum >> 16) & 0xFF );
				Tx[2] = (BYTE) ( (vl_CheckSum >> 8) & 0xFF );
				Tx[3] = (BYTE) ( vl_CheckSum & 0xFF );
				m_CheckSum = Tx[0]; m_CheckSum += Tx[1]; m_CheckSum += Tx[2]; m_CheckSum += Tx[3];
#if 0
		//		for (int i=0;i<4;i++)
		//		{
					TOOL_WriteComPortWithTimeout( cPort, Tx, 4, TIMEOUT_SEC ) ;
		//		}
#else
#if 0
				TOOL_WriteComPortWithTimeout( cPort, &Tx[0], 1, TIMEOUT_SEC ) ;
				TOOL_WriteComPortWithTimeout( cPort, &Tx[1], 1, TIMEOUT_SEC ) ;
				TOOL_WriteComPortWithTimeout( cPort, &Tx[2], 1, TIMEOUT_SEC ) ;
				TOOL_WriteComPortWithTimeout( cPort, &Tx[3], 1, TIMEOUT_SEC ) ;
#endif
			
				TOOL_WriteComPort( cPort, &Tx[0], 1, &test ) ;
				TOOL_WriteComPort( cPort, &Tx[1], 1, &test ) ;
				TOOL_WriteComPort( cPort, &Tx[2], 1, &test ) ;
				TOOL_WriteComPort( cPort, &Tx[3], 1, &test ) ;

#endif				
					
	
				
			}

			break;
			
		/*sdhong 20041012 for write checksum in NOR AREA*/	
		case RX_WAIT_WRITE_NANDCHECKSUM:
			if ( ch != m_CheckSum )
			{
				m_RxState = RX_END;
				str.Format( "     Write nand checksum Error! (0x%X)\n", ch );
				ShowStatus(  str);
			}
			else //TFS4 Init Mount OK!
			{
				str = "OK!\r\n";
		//		OutputStatus( str );
				pl_SystemTime=(ULONG*)Tx;
				m_RxState = RX_WAIT_TFSTIME_SET;
		 /*sdhong 20041019 tfs system time set*/		
				LocalsystemTime=CTime::GetCurrentTime();

				TOOL_CMD(cPort,FLASHLOADER_CMD_SET_TFSTIME,nConnectMode);
				pl_SystemTime[0]=0;
				//Tx[0]=CMD_SET_TFSTIME;
				

				pl_SystemTime[1]=LocalsystemTime.GetSecond();
				pl_SystemTime[2]=LocalsystemTime.GetMinute();
				pl_SystemTime[3]=LocalsystemTime.GetHour();
				pl_SystemTime[4]=LocalsystemTime.GetDay();
				pl_SystemTime[5]=LocalsystemTime.GetMonth();
				pl_SystemTime[6]=LocalsystemTime.GetYear();

				m_CheckSum=0;
			//	Sleep(1000);
#ifndef _USB_BLOCK_
				TOOL_WriteComPortWithTimeout( cPort, &Tx[1], 27, TIMEOUT_SEC );
				for(int i=1; i<28;i++)
				{
					m_CheckSum+=Tx[i];
				//	TOOL_WriteComPortWithTimeout( cPort, &Tx[i], 1, TIMEOUT_SEC );
				}
#else
				for(int i=1; i<28;i++)
				{
					m_CheckSum+=Tx[i];
					TOOL_WriteComPortWithTimeout( cPort, &Tx[i], 1, TIMEOUT_SEC );
				}
#endif

			}

			break;
		 /*sdhong 20041019 tfs system time set*/
		case RX_WAIT_TFSTIME_SET:

			if(ch!=m_CheckSum)
			{
				m_RxState = RX_END;
				str.Format( "\n     Write Set TFSTIME Error! (0x%X)\r\n", ch );
				ShowStatus( str);
			}
			else 
			{
				str = "     TFS time set OK!\r\n"; 
				ShowStatus( str);

				m_RxState = RX_WAIT_TFS_DIR_NAME_RECEIVED;
				m_CfgIndx = 0;
				
				if(TFS_CreateDir()==FALSE)
				{
				m_RxState=RX_END;
				}
					
			}
			break;
			
		case RX_WAIT_TFS_DIR_NAME_RECEIVED:

			if ( ch != m_CheckSum )
			{
				m_RxState = RX_END;
				str = "Fail! (in sending name)\r\n";
				ShowStatus( str);
			}
			else
			{
				//str = "OK!\r\n";
				//OutputStatus( str );

				//str = "Creating DIR_NAME... ";
				//OutputStatus( str );

				m_RxState = RX_WAIT_TFS_DIR_CREATED;
			}

			break;

		case RX_WAIT_TFS_DIR_CREATED:

			if ( ch != CMD_CREATE_DIR_DONE )
			{
				m_RxState = RX_END;
				str.Format( "Fail! (0x%X)\r\n", ch );
		//		OutputStatus( str );
				break;
			}

			str = "OK!\r\n";
		//	OutputStatus( str );

			m_RxState = RX_WAIT_TFS_DIR_NAME_RECEIVED;
			if ( TFS_CreateDir() == FALSE )//Make Directory Finished
			{
				Success = m_OgmFile.Open( m_strOgmPath, CFile::modeRead | CFile::shareDenyWrite );
				if ( !Success )
				{
					m_RxState = RX_END;
					str.Format( "Fail to open %s", m_strOgmPath );
					AfxMessageBox( str );
					break;
				}

				str = "     Writing a TFS Version...\n ";
				ShowStatus(str);

				m_RxState = RX_WAIT_TFS_RELEASE_VERSION_CREATED;
//TX TFSVersion				
				Tx[0] = CMD_CREATE_TFS_VERSION;
			//	TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
				TOOL_CMD(cPort,FLASHLOADER_CMD_CREATE_TFS_VERSION,nConnectMode);
				{
					m_CheckSum = 0;
					for ( int i=0; i<MAX_LEN_TFS_VERSION; i++ )
					{
						Tx[i] = m_TFSVersion[i];
						m_CheckSum += Tx[i];
					}
#ifndef _USB_BLOCK_
					TOOL_WriteComPortWithTimeout( cPort, &Tx[0], MAX_LEN_TFS_VERSION, TIMEOUT_SEC );
#else

					for (i=0;i<MAX_LEN_TFS_VERSION;i++)
						TOOL_WriteComPortWithTimeout( cPort, &Tx[i], 1, TIMEOUT_SEC ) ;
#endif
				}
				

			}

			break;

        case RX_WAIT_TFS_RELEASE_VERSION_CREATED:

			if ( ch != CMD_CREATE_TFS_VERSION )
			{
				m_RxState = RX_END;
				str.Format( "     Release Version Fail! (0x%X)\r\n", ch );
				ShowStatus(str);
				break;
			}
//TX TFSReleseVer	SHKIM Add Tfs release Version 040713
			if(v_ReleaseVerFlag == TRUE)
			{
				m_RxState = RX_WAIT_TFS_VERSION_CREATED;
				Tx[0] = CMD_CREATE_TFS_RELEASE_VERSION;
		
				//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
				TOOL_CMD(cPort,FLASHLOADER_CMD_CREATE_TFS_RELEASE_VERSION,nConnectMode);
	
				for ( int i=0; i<MAX_LEN_TFS_RELEASE_VERSION; i++ )
				{
					Tx[i] = m_TFSReleaseVer[i];
				}
#ifndef _USB_BLOCK_
					TOOL_WriteComPortWithTimeout( cPort, &Tx[0], MAX_LEN_TFS_RELEASE_VERSION, TIMEOUT_SEC );
#else

					for (i=0;i<MAX_LEN_TFS_RELEASE_VERSION;i++)
						TOOL_WriteComPortWithTimeout( cPort, &Tx[i], 1, TIMEOUT_SEC ) ;
#endif			
			}
			else
			{
				m_RxState = RX_WAIT_TFS_VERSION_CREATED;
				Tx[0] = CMD_NO_TFS_RELEASE_VERSION;
			//	gSerialPort.WriteComm( Tx, 1 );
				//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
				TOOL_CMD(cPort,FLASHLOADER_CMD_NO_TFS_RELEASE_VERSION,nConnectMode);
			}

		    break;


		case RX_WAIT_TFS_VERSION_CREATED:

			if ( ch != CMD_CREATE_TFS_VERSION )
			{
				m_RxState = RX_END;
				str.Format( "     Project Version Fail! (0x%X)\r\n", ch );
				ShowStatus(str);
			//	OutputStatus_MINI("INIT ERROR ! \n");
				break;
			}

			str = "OK!\r\n";
		//	OutputStatus( str );

#ifdef __TFS4__  //edit here about progress bar
	//		m_cProgressDwl.SetRange32(0, TFS_FileSize);

			m_ProgressSize = 0;
			
			sMsg.Format( "%d", m_ProgressSize );
			//m_cProgressDwl.SetPos(0);
			ShowStatus( sMsg );
#endif
			m_RxState = RX_WAIT_TFS_FILE_NAME_RECEIVED;
			m_CfgIndx = 0;
			TFS_CreateFile();

			break;	

		case RX_WAIT_TFS_FILE_NAME_RECEIVED:

			if ( ch != m_CheckSum )
			{
				m_RxState = RX_END;
				str.Format( "Fail!(%x:%x) (in sending name and size)\r\n",ch,m_CheckSum);
				ShowStatus( str);
			}
			else
			{
				m_RxState = RX_WAIT_TFS_FILE_TRANSFER;
				m_IsTFSOneFileComplete = FALSE;
				m_TFSOneFileSize = file_size;

				SendTFSData();
				if ( m_IsTFSOneFileComplete )
					m_RxState=RX_WAIT_TFS_FILE_CREATED;
//					m_RxState = RX_WAIT_TFS_FILE_WRITING;
			}

			break;

		case RX_WAIT_TFS_FILE_TRANSFER:

			if ( ch != m_CheckSum )
			{
				m_RxState = RX_END;
				str.Format("     checksum mismatched!(%x) \r\n",ch);
				ShowStatus( str);
			}
			else
			{
				m_RxState = RX_WAIT_TFS_FILE_TRANSFER;

				SendTFSData();
				
				if ( m_IsTFSOneFileComplete )
				{
				/*sdhong.200507321.tfslarge(10M)dump*/
				m_RxState=RX_WAIT_TFS_FILE_CREATED;
//				m_RxState = RX_WAIT_TFS_FILE_WRITING;
				}
				
			}

			break;

		// Last part of TFS file is transferred?
		case RX_WAIT_TFS_FILE_WRITING:

			if ( ch != m_CheckSum )
			{
				m_RxState = RX_END;
				str.Format("     checksum mismatched!a in file writing (%x) \r\n",ch);
				ShowStatus( str);
				break;
			}

			m_RxState = RX_WAIT_TFS_FILE_CREATED;

			break;

		// NAND writing is OK?
		case RX_WAIT_TFS_FILE_CREATED:
			if ( ch != CMD_CREATE_FILE_DONE )
			{
				m_RxState = RX_END;
				str.Format( "Writing error(0x%X)\r\n", ch );
				ShowStatus( str);
				break;
			}

			str = "Writing and Check OK!\r\n";
			str = "OK!\n";
				ShowStatus(str );
			
			m_RxState = RX_WAIT_TFS_FILE_NAME_RECEIVED;
			// All TFS files created?
		
			if ( TFS_CreateFile() == FALSE )
			{
				
				m_OgmFile.Close();
				g_nProgressCounter=100;
				m_progressMain.SetPos(g_nProgressCounter);

				str.Format( "     Complete nand!\r\n" );
				ShowStatus( str);
#if 1
				m_RxState = RX_WAIT_TFS_STATUS;
				Tx[0] = CMD_CHECK_NAND_STATUS;
			//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
				TOOL_CMD(cPort,FLASHLOADER_CMD_CHECK_NAND_STATUS,nConnectMode);
#else
				m_RxState = RX_WAIT_WRITE_COMPLETE_NAND;
				Tx[0] = CMD_WRITE_COMPLETE_NAND;
				//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
				TOOL_CMD(cPort,FLASHLOADER_CMD_WRITE_COMPLETE_NAND,nConnectMode);
#endif
			}
			break;


			/*sdhong_20041116_tfsfileCompleteCheck */
		case RX_WAIT_WRITE_COMPLETE_NAND:
			if ( ch != CMD_WRITE_COMPLETE_NAND )
			{
			str.Format( "     Writing NAND Fail! \r\n" );
			ShowStatus( str);
			}
			else {
			
			str.Format( "     Unmounting TFS!" );
			ShowStatus( str);
#if 0
			m_RxState = RX_WAIT_TFS_STATUS;
			Tx[0] = CMD_CHECK_NAND_STATUS;
			//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
			TOOL_CMD(cPort,FLASHLOADER_CMD_CHECK_NAND_STATUS,nConnectMode);
#else
			m_RxState = RX_WAIT_TFS_UNMOUNT;
			Tx[0] = CMD_UNMOUNT_TFS;
			//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
			TOOL_CMD(cPort,FLASHLOADER_CMD_UNMOUNT_TFS,nConnectMode);
#endif
			}

			break;
			
		case RX_WAIT_TFS_UNMOUNT:

			if ( ch != CMD_UNMOUNT_TFS )
			{
				m_RxState = RX_END;
				str.Format( "     Unmounting Error!(0x%0X)\n", ch );
				ShowStatus( str);
				break;
			}

			str = "OK!\r\n";
		//	OutputStatus( str );

			m_EndTime = CTime::GetCurrentTime();
			m_ElapsedTime = m_EndTime - m_StartTime;

		//	str = m_ElapsedTime.Format("\r\n** Downloading Time %M:%S **\r\n");
		//	ShowStatus(str);
//			OutputStatus_MINI(str);
			// In only OGM, m_FileLength = 0
	//		str.Format( "** (Total %d bytes) **\r\n", m_ProgressSize + m_FileLength_orig );
	//		SendMessageToMMI( BFLOADERAPP_THREADTOMMI_INFO, str);
	//		OutputStatus_MINI(str);

			//m_ProgressSize = 0;
		//	AfxMessageBox("Download completed!", MB_SYSTEMMODAL | MB_ICONINFORMATION );
	//		EnableButtons();
	//		WriteHistory(2);
			return TRUE;
			break;

		case RX_END:
			return FALSE; 
			break;
		}
	}
}


void CCabrio_downloaderv01Dlg::SendTFSData()
{
	BYTE Tx[10];
	DWORD dwRead, i;
	DWORD sizeToRead;
	CString sMsg;
	m_CheckSum = 0;
	CString str;
	ComPortCfg_t * cPort = (ComPortCfg_t *)comPort;
	static int fileSize=0;

	//Tx[0] = CMD_CREATE_FILE_CONT;
	Tx[0] = CMD_CREATE_FILE_CONT_CHECK; /*shong for tfs4 check*/
//	gSerialPort.WriteComm( Tx, 1 );

	
	//TOOL_WriteComPortWithTimeout( cPort, &Tx, 1, TIMEOUT_SEC ) ;
	TOOL_CMD(cPort,FLASHLOADER_CMD_CREATE_FILE_CONT_CHECK,nConnectMode);

	if ( m_TFSOneFileSize < BUFF_SIZE )
		sizeToRead = m_TFSOneFileSize;
	else
	{
		sizeToRead = BUFF_SIZE;
		m_TFSOneFileSize -= BUFF_SIZE;
	}

	if ( sizeToRead == 0 )
	{
		m_IsTFSOneFileComplete = TRUE;
		return;
	}

	dwRead = m_OgmFile.Read(buffer, sizeToRead);
	if ( sizeToRead < BUFF_SIZE )
	{
		m_IsTFSOneFileComplete = TRUE;
	}	
//	Sleep(100);	//VENUS
#ifndef _USB_BLOCK_
	TOOL_WriteComPortWithTimeout( cPort, &buffer, dwRead, TIMEOUT_SEC ) ;
#else
	for (i=0;i<dwRead;i++)
		TOOL_WriteComPortWithTimeout( cPort, &buffer[i], 1, TIMEOUT_SEC ) ;
#endif

#ifndef __TFS4__ //edit here about progress bar
//	m_ProgressSize += dwRead;
//	m_cProgressDwl.SetPos( m_ProgressSize );
//	CString sMsg;
	fileSize+=dwRead;

	if (fileSize / (64*1024)==1)
	{
		g_nProgressCounter++;
		m_nMainPercent = (g_nProgressCounter * 100) / g_nDownloadedSector;
		m_progressMain.SetPos(m_nMainPercent);
		fileSize=0;
	}

#if 0
	sMsg.Format( "%d", (m_ProgressSize*100)/TFS_FileSize);
	ShowStatus(sMsg );
#endif

#endif
/*   
     //SCLEE Debug to know how many bytes are transferred to phone 
	str.Format("progress bar value\ : %d \r\n",m_ProgressSize);
	OutputStatus( str );	
*/
	for ( i=0; i<sizeToRead; i++ )
		m_CheckSum += buffer[i];

	return;
}

void CCabrio_downloaderv01Dlg::FinishDownload()
{
	DWORD vl_CheckSum=0;
	m_IsComplete = FALSE;

	m_EndTime = CTime::GetCurrentTime();
	m_ElapsedTime = m_EndTime - m_StartTime;

//	OutputStatus_MINI( str );
		
//	str.Format( "** (Total %d bytes) **\r\n", m_FileLength_orig );
//	OutputStatus( str );
//	OutputStatus_MINI( str );
		
	AfxMessageBox("     Download completed!", MB_SYSTEMMODAL | MB_ICONINFORMATION );
//	EnableButtons();

}

DWORD CCabrio_downloaderv01Dlg::CalCheckSum(CString m_strBinPath,int *FileLen)
{

	int nleft;
	CString str;
	BOOL Success;
	DWORD vl_CheckSum=0, answer=0;
	CFile m_file;

	Success = m_file.Open( m_strOgmPath, CFile::modeRead | CFile::shareDenyWrite );
	if ( !Success )
	{
		m_RxState = RX_END;
		AfxMessageBox("Fail to open bin file!");
		return 0;
	}

	/*check sum calcuation**/
	*FileLen = m_file.GetLength();
	nleft=*FileLen;

	CString csData(' ', nleft);
	// Read the file into the buffer
	m_file.Read(csData.GetBuffer(nleft), nleft);
	// Always release the buffer after writing to it.
	csData.ReleaseBuffer();

	int nCRC = Get_CRC(csData, nleft);
	// Convert the returned integer into a character string.
	// char ch[20];
	// itoa(nCRC, ch, 16);  // Note that the integer is a 16 bit hex

	/*
	while (nleft > 15) {
	  m_BinFile.Read(vl_buffer,16);
		vl_CheckSum += *((DWORD*)vl_buffer);
		vl_CheckSum += *((DWORD*)&vl_buffer[4]);
		vl_CheckSum += *((DWORD*)&vl_buffer[8]);
		vl_CheckSum += *((DWORD*)&vl_buffer[12]);
	     nleft -= 16;
	  }

	if (nleft<=15) {
		m_BinFile.Read(vl_buffer,nleft);
		for(int i=0;i<nleft;i++)
		{
	   *(unsigned char *) (&answer) = (unsigned char )vl_buffer[i];
	     vl_CheckSum += answer;
		}
	  }
    
	    vl_CheckSum = (vl_CheckSum >> 16) + (vl_CheckSum & 0xffffffff);
	    vl_CheckSum += (vl_CheckSum >> 16);
	    answer = ~vl_CheckSum;
*/
		
	m_file.Close();

	return nCRC;
	/*checksum calcuation*/

}



int CCabrio_downloaderv01Dlg::Get_CRC(CString &csData, DWORD dwSize)
{
	// Be sure to use unsigned variables,
	// because negative values introduce high bits
	// where zero bits are required.
	ULONG  crc(0xffffffff);
	int len;
	unsigned char* buffer;

	len = dwSize;
	// Save the text in the buffer.
	buffer = (unsigned char*)(LPCTSTR)csData;
	// Perform the algorithm on each character
	// in the string, using the lookup table values.
	while(len--)
		crc = (crc >> 8) ^ crc32_table[(crc & 0xFF) ^ *buffer++];
	// Exclusive OR the result with the beginning value.
	return crc^0xffffffff;
}

void CCabrio_downloaderv01Dlg::Init_CRC32_Table()
{// Called by OnInitDialog()

	// This is the official polynomial used by CRC-32 
	// in PKZip, WinZip and Ethernet. 
	ULONG ulPolynomial = 0x04c11db7;

	// 256 values representing ASCII character codes.
	for(int i = 0; i <= 0xFF; i++)
	{
		crc32_table[i]=Reflect(i, 8) << 24;
		for (int j = 0; j < 8; j++)
			crc32_table[i] = (crc32_table[i] << 1) ^ (crc32_table[i] & (1 << 31) ? ulPolynomial : 0);
		crc32_table[i] = Reflect(crc32_table[i], 32);
	}
}

ULONG CCabrio_downloaderv01Dlg::Reflect(ULONG ref, char ch)
{// Used only by Init_CRC32_Table()

	ULONG value(0);

	// Swap bit 0 for bit 7
	// bit 1 for bit 6, etc.
	for(int i = 1; i < (ch + 1); i++)
	{
		if(ref & 1)
			value |= 1 << (ch - i);
		ref >>= 1;
	}
	return value;
}


BOOL CCabrio_downloaderv01Dlg::TFS_CheckFileSize()
{
	BOOL Success;
	CString str;
	DWORD idx, tmp_idx;
	char str_num[200];
	DWORD size, total_size;
	CString sOgmCfgPath,sOgmPath;

	sOgmPath=m_strOgmPath;
	sOgmCfgPath=m_strOgmCfgPath;

	Success = m_OgmFile.Open( sOgmPath, CFile::modeRead | CFile::shareDenyWrite );
	if ( !Success )
	{
		str.Format( "Fail to open %s", sOgmPath );
		AfxMessageBox( str );
		return FALSE;
	}
	TFS_FileSize = m_OgmFile.GetLength();
	m_OgmFile.Close();


	Success = m_OgmCfgFile.Open( sOgmCfgPath, CFile::modeRead | CFile::shareDenyWrite );
	if ( !Success )
	{
		str.Format( "Fail to open %s", sOgmCfgPath );
		AfxMessageBox( str );
		return FALSE;
	}

	TfsCfgBufferLen = m_OgmCfgFile.GetLength();

	TFsCfgBuffer = new char[TfsCfgBufferLen];

	m_OgmCfgFile.Read( TFsCfgBuffer, TfsCfgBufferLen );
	m_OgmCfgFile.Close();

	total_size = 0;
	idx = 0;
	while ( idx < TfsCfgBufferLen )
	{
		tmp_idx = TextFindInBuffer( "FILE_SIZE : ", TFsCfgBuffer, idx );
		if ( tmp_idx == 0 )
			break;
		idx = tmp_idx + 12;
		tmp_idx = 0;
		while ( TFsCfgBuffer[idx] >= '0' && TFsCfgBuffer[idx] <= '9' )
		{
			str_num[tmp_idx] = TFsCfgBuffer[idx];
			idx++;
			tmp_idx++;
		}
		str_num[tmp_idx] = 0;
		sscanf( str_num, "%d", &size );
		total_size += size;
	}

	if ( TFS_FileSize != total_size )
	{
		str.Format("TfsFilesize(%d):CfgFilesize(%d)",TFS_FileSize,total_size);
	//	OutputStatus( str );
		AfxMessageBox( "TFS file size mismatched!!!" );
		return FALSE;
	}

	// check TFS Version in .cfg file
	idx = 0;
	tmp_idx = TextFindInBuffer( "TFSVERSION : ", TFsCfgBuffer, idx );

	if ( tmp_idx == 0 )
	{
		AfxMessageBox("TFSVERSION not found in cfg file" );
		delete []TFsCfgBuffer;
		return FALSE;
	}

	idx = tmp_idx + 13;
	for ( tmp_idx=idx; tmp_idx<idx+MAX_LEN_TFS_VERSION; tmp_idx++ )
			m_TFSVersion[tmp_idx-idx] = TFsCfgBuffer[tmp_idx];

// check TFS Release Version in .cfg file SHKIM Add TFS Release Version 040714
	idx = 0;
	tmp_idx = TextFindInBuffer( "TFSRELEASEVERSION : ", TFsCfgBuffer, idx );

	if ( tmp_idx == 0 )//There's No TFSRELEASEVERSION
	{
		v_ReleaseVerFlag = FALSE;
	}
    else
    {
        v_ReleaseVerFlag = TRUE;
	    idx = tmp_idx + 20;
	    for ( tmp_idx=idx; tmp_idx<idx+MAX_LEN_TFS_RELEASE_VERSION; tmp_idx++ )
			m_TFSReleaseVer[tmp_idx-idx] = TFsCfgBuffer[tmp_idx];
    }
	return TRUE;
	
}

BOOL CCabrio_downloaderv01Dlg::TFS_CreateDir( void )
{
	CString str;
	unsigned long length;
	DWORD tmp_idx;
	BYTE Tx[MAX_DIRNAME_SIZE]; /*52*/
	/*sdhong from multibyte to UTF8*/
	char UTF8buffer[MAX_DIRNAME_SIZE]={0};
	int UTF8len;
	ComPortCfg_t * cPort = (ComPortCfg_t *)comPort;
	tmp_idx = TextFindInBuffer( "DIR_NAME : ", TFsCfgBuffer, m_CfgIndx );
	if ( tmp_idx == 0 )
	{
		m_CfgIndx = 0;
		return FALSE;
	}
	else
	{
		m_CfgIndx = tmp_idx + 11;
		tmp_idx = 0;
		while ( TFsCfgBuffer[m_CfgIndx] != 0x0D )
		{
			file_name[tmp_idx] = TFsCfgBuffer[m_CfgIndx];
			m_CfgIndx++;
			tmp_idx++;
		}
		file_name[tmp_idx] = 0;

/* sdhong_20041025_multibytechar */
		MultibyteToUTF8(file_name, UTF8buffer,&UTF8len);

		if(UTF8len>MAX_DIRNAME_SIZE)
		{
		str.Format ("     Directory name is too long\"%s\"... ", file_name );
		ShowStatus( str);
		m_RxState = RX_END;
		return TRUE;
		}

#ifdef _CUSTOMER_
		str.Format ("     Cr.dir... \n");
#else
		str.Format ("     Cr.dir \"%s\"... \n", file_name );
#endif
		ShowStatus(str);

		TOOL_CMD(cPort,FLASHLOADER_CMD_CREATE_DIR,nConnectMode);
		Tx[0] = CMD_CREATE_DIR;
		Tx[1] = (char) ((UTF8len >> 8 ) & 0xFF);// length of DIR_NAME
		m_CheckSum = Tx[1];
		Tx[2] = (char) ( UTF8len & 0xFF );
		m_CheckSum += Tx[2];
 
		
		for ( int i=3; i<UTF8len+3; i++ )
		{
			Tx[i] = UTF8buffer[i-3];
			m_CheckSum += Tx[i];
			
		}
#ifndef _USB_BLOCK_
		// first 2byte -> name length
#if 1
		TOOL_WriteComPortWithTimeout( cPort, &Tx[1], 1, TIMEOUT_SEC ) ;
		TOOL_WriteComPortWithTimeout( cPort, &Tx[2], 1, TIMEOUT_SEC ) ;

		// directory name
		TOOL_WriteComPortWithTimeout( cPort, &Tx[3], UTF8len, TIMEOUT_SEC ) ;
#else
		TOOL_WriteComPort( cPort, &Tx[1], 1, &length ) ;
		TOOL_WriteComPort( cPort, &Tx[2], 1, &length ) ;

		// directory name
		TOOL_WriteComPort( cPort, &Tx[3], UTF8len, &length ) ;
#endif

#else
		for ( i=1; i<UTF8len+3;i++)
		{
			TOOL_WriteComPortWithTimeout( cPort, &Tx[i], 1, TIMEOUT_SEC ) ;
		}
#endif
		
			
	}

	return TRUE;
}

BOOL CCabrio_downloaderv01Dlg::TFS_CreateFile( void )
{
		CString str;
	DWORD tmp_idx;
	DWORD len_name;
	BYTE Tx[MAX_FILENAME_SIZE];
	/*sdhong from multibyte to UTF8*/
	char UTF8buffer[MAX_FILENAME_SIZE]={0};
	int UTF8len;
	ComPortCfg_t * cPort = (ComPortCfg_t *)comPort;
	tmp_idx = TextFindInBuffer( "FILE_NAME : ", TFsCfgBuffer, m_CfgIndx );
	if ( tmp_idx == 0 )
	{
		m_CfgIndx = 0;
		return FALSE;
	}
	else
	{
		m_CfgIndx = tmp_idx + 12;
		tmp_idx = 0;
		// extract 'FILE_NAME'
		while ( TFsCfgBuffer[m_CfgIndx] != 0x0D )
		{
			file_name[tmp_idx] = TFsCfgBuffer[m_CfgIndx];
			m_CfgIndx++;
			tmp_idx++;
		}
		file_name[tmp_idx] = 0;
		len_name = tmp_idx;
		
		/* sdhong_20041025_multibytechar */
		MultibyteToUTF8(file_name,UTF8buffer,&UTF8len);

		if(UTF8len>MAX_FILENAME_SIZE)
		{
		str.Format ("     File name is too long\"%s\"... ", file_name );
		ShowStatus(str);
		m_RxState = RX_END;
		return FALSE;
		}
		
		tmp_idx = TextFindInBuffer( "FILE_SIZE : ", TFsCfgBuffer, m_CfgIndx );
		m_CfgIndx = tmp_idx + 12;
		tmp_idx = 0;
		// extract 'FILE_SIZE'
		while ( TFsCfgBuffer[m_CfgIndx] != 0x0D )
		{
			Tx[tmp_idx] = TFsCfgBuffer[m_CfgIndx];
			m_CfgIndx++;
			tmp_idx++;
		}
		Tx[tmp_idx] = 0;
		sscanf( (char *)Tx, "%d", &file_size );
#ifdef _CUSTOMER_
		str.Format ("     Wrt.file... ");
#else
		str.Format ("     Wrt.file \"%s\" (%d bytes)... ", file_name, file_size );
#endif
		ShowStatus(str);
//		OutputStatus_MINI( str );

		TOOL_CMD(cPort,FLASHLOADER_CMD_CREATE_FILE,nConnectMode);
		Tx[0] = CMD_CREATE_FILE;
		/* sdhong_20041025_multibytechar */
		Tx[1] = (char) ((UTF8len >> 8 ) & 0xFF); // 2BYTE length of FILE_NAME
		m_CheckSum = Tx[1];
		Tx[2] = (char) ( UTF8len & 0xFF ); 
		m_CheckSum += Tx[2];

		int i;
		for ( i=3; i<UTF8len+3; i++ )
		{
			
			Tx[i] = (UTF8buffer[i-3]);
			m_CheckSum += Tx[i];
			//str.Format ("%c(%x)   ",Tx[i],Tx[i] );
		      //OutputStatus( str );
		
		}
		
		Tx[i] = (BYTE) ( (file_size >> 24) & 0xFF );
		Tx[i+1] = (BYTE) ( (file_size >> 16) & 0xFF );
		Tx[i+2] = (BYTE) ( (file_size >> 8 ) & 0xFF );
		Tx[i+3] = (BYTE) ( (file_size      ) & 0xFF );
		m_CheckSum += ( Tx[i]+Tx[i+1]+Tx[i+2]+Tx[i+3] );

#ifndef _USB_BLOCK_
		TOOL_WriteComPortWithTimeout( cPort, &Tx[1], 1, TIMEOUT_SEC ) ;
		TOOL_WriteComPortWithTimeout( cPort, &Tx[2], 1, TIMEOUT_SEC ) ;
		TOOL_WriteComPortWithTimeout( cPort, &Tx[3], UTF8len, TIMEOUT_SEC ) ; // 3,4,5
		TOOL_WriteComPortWithTimeout( cPort, &Tx[i], 1, TIMEOUT_SEC ) ; //6
		TOOL_WriteComPortWithTimeout( cPort, &Tx[i+1], 1, TIMEOUT_SEC ) ; // 7
		TOOL_WriteComPortWithTimeout( cPort, &Tx[i+2], 1, TIMEOUT_SEC ) ; //8
		TOOL_WriteComPortWithTimeout( cPort, &Tx[i+3], 1, TIMEOUT_SEC ) ; //9
#else
		for ( i=1; i<UTF8len+7;i++)
		{
			TOOL_WriteComPortWithTimeout( cPort, &Tx[i], 1, TIMEOUT_SEC ) ;
		}
#endif
	}

	return TRUE;
}

DWORD CCabrio_downloaderv01Dlg::TextFindInBuffer(char *str_find, char *str_src, DWORD idx)
{
	char *pbuf = &str_src[idx];
	char *pfound;

	pfound = strstr( pbuf, str_find);

	if ( pfound == NULL )
		return 0;

	return ( (DWORD)(pfound - str_src) );
}

/* sdhong_20041025_multibytechar */
//sdhong  modify  multibyte char to UTF8
void CCabrio_downloaderv01Dlg::MultibyteToUTF8(char *src, char*dest,int *destlen)
{

	int srclen;
	WORD UTF8_filename[500]={0};
	DWORD UTF8_namelen;
	CString str;
	if(src!=NULL)
	 {
	 srclen=strlen(src);
	 if(srclen>500) 
	 	{
	 	str.Format("/r/n MultibyteToUTF8 ERROR /r/n");
//		OutputStatus( str);
	 	return;
	 	}
	 }
	else return;
	
	UTF8_namelen = MultiByteToWideChar(CP_ACP, 0,  src, -1, NULL, 0);

	MultiByteToWideChar(CP_ACP, 0,src,srclen,UTF8_filename, UTF8_namelen);
		
	srclen = WideCharToMultiByte(CP_UTF8, 0,  UTF8_filename,UTF8_namelen,dest,500,0, 0);
	
	*destlen=srclen;

}

/* sdhong_20041025_multibytechar */
void CCabrio_downloaderv01Dlg::UTF8ToMultibyte(char *src, char*dest,int *destlen)
{

	int srclen;
	WORD UTF8_filename[500]={0};
	DWORD UTF8_namelen;
	CString str;
	if(src!=NULL)
	 {
	 srclen=strlen(src);

	 if(srclen>500) 
	 {
	 	str.Format("/r/n UTF8ToMultibyte ERROR /r/n ");
	//	OutputStatus( str);
	 	return;
	 }
	 
	 }
	else return;
	
	UTF8_namelen = MultiByteToWideChar(CP_UTF8, 0,  src, -1, NULL, 0);

	MultiByteToWideChar(CP_UTF8, 0,src,srclen,UTF8_filename, UTF8_namelen);
		
	srclen = WideCharToMultiByte(CP_ACP, 0,  UTF8_filename,UTF8_namelen,dest,500,0, 0);
	
	*destlen=srclen;

}


void CCabrio_downloaderv01Dlg::OnCheckEr() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
//	checkER=m_ckER;
	checkER=1;

}

void CCabrio_downloaderv01Dlg::OnCheckParm() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
//	checkPARAM=(int)m_ckParam;
	checkPARAM=1;
}

void CCabrio_downloaderv01Dlg::OnCheckRc1() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	checkRC1=m_ckRc1;
}

void CCabrio_downloaderv01Dlg::OnCheckCal() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
//	checkCALSET=m_ckCal;
}

void CCabrio_downloaderv01Dlg::OnCheckBoot() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	checkBOOT2=m_ckBoot;
}

void CCabrio_downloaderv01Dlg::OnButtonRamdump() 
{
	// TODO: Add your control notification handler code here
	pThread=AfxBeginThread(RamdumpThreadFunc,(LPVOID)this, THREAD_PRIORITY_TIME_CRITICAL);
}

BOOL CCabrio_downloaderv01Dlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if (pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN || pMsg->wParam == VK_ESCAPE))
		return TRUE;

	
	return CDialog::PreTranslateMessage(pMsg);
}
