 // cabrio_downloaderv01Dlg.h : header file
//

#if !defined(AFX_CABRIO_DOWNLOADERV01DLG_H__15B72A5F_F602_4EE1_BB86_D9CE64F79500__INCLUDED_)
#define AFX_CABRIO_DOWNLOADERV01DLG_H__15B72A5F_F602_4EE1_BB86_D9CE64F79500__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "tool_api.h"




#define CURRENT_WITHOUT_DRIVER	0x00
#define CURRENT_NOR_DRIVER		0x01
#define CURRENT_NAND_DRIVER		0x02


#ifndef __TFS4__  // moo_20070201
#define MAX_LEN_TFS_VERSION 16
#define MAX_LEN_TFS_RELEASE_VERSION 12 //SHKIM Add TFS Release Version 040713
#define MAX_FILENAME_SIZE  (500+10) /* sdhong_20041025_multibytechar , max value is u16 , 10 is command*/
#define MAX_DIRNAME_SIZE  (512+10) /* sdhong_20041025_multibytechar , max value is u16,10 is command */
#endif

#ifndef _mootest_
#define PACKET_SIZE_OF_UART     2048

#define CMD_SET_BASE_ADDR               0xD0
#define CMD_REQ_FLASHID                 0xD1
#define CMD_CHANGE_UART_SPEED           0xD2
#define CMD_WRITE_ADDRESS               0xD3
#define CMD_SET_FILESIZE                0xD4
#define CMD_ERASE_SECTOR                0xD5
#define CMD_WRITE_WORD                  0xD6
#define CMD_UNLOCK_BYPASS               0xD7
#define CMD_DUMP_SECTOR                 0xD8
#define CMD_CHANGE_UART_SPEED_DONE      0xD9
#define CMD_TFS_MOUNT                   0xDA
#define CMD_CREATE_DIR                  0xDB
#define CMD_CREATE_DIR_DONE             0xDC
#define CMD_CREATE_FILE                 0xDD
#define CMD_CREATE_FILE_CONT            0xDE
#define CMD_CREATE_FILE_DONE            0xDF
#define CMD_FORMAT_NAND                 0xE0
#define CMD_FORMAT_NAND_DONE            0xE1
#define CMD_FORMAT_ERR_TABLE            0xE2
#define CMD_CREATE_TFS_VERSION          0xE3
#define CMD_UNMOUNT_TFS                 0xE4
#define CMD_READ_TFS_DIR                0xE5
#define CMD_READ_TFS_DIR_ERR            0xE6
#define CMD_READ_TFS_DIR_DONE           0xE7
#define CMD_READ_TFS_FILE_SIZE          0xE8
#define CMD_READ_TFS_FILE_SIZE_DONE     0xE9
#define CMD_READ_TFS_ONE_FILE           0xEA
#define CMD_DUMMY                       0xEB
#define CMD_CHECK_NAND_STATUS           0xEC
#define CMD_CHECK_NAND_STATUS_DONE      0xED
#define CMD_DELETE_TFS_FILE             0xEE
#define CMD_READ_TFS_FILE_STATUS        0xF0 /*sdhong*/
#define CMD_READ_TFS_FILE_STATUS_DONE   0xF1 /*sdhong*/
#define CMD_FORMAT_NAND_ERROR           0xF2
#define CMD_TFS4_INIT_ERROR             0xF3/*SHKIM.ADD*/
#define CMD_GET_STATUS_ERROR            0xF4/*SHKIM.ADD*/
#define CMD_CREATE_TFS_RELEASE_VERSION  0xF5 /*SHKIM.ADD.040717*/
#define CMD_NO_TFS_RELEASE_VERSION      0xF6 /*SHKIM.ADD.040717*/

#define CMD_DMA_SETUP                   0xF7
#define CMD_DMA_PROGRESS                0xF8
#define CMD_DMA_STOP                    0xF9
#define CMD_ERASE_SECTOR64_DOWNLOAD     0xFA
#define CMD_ERASE_SECTOR16_DOWNLOAD     0xFB
#define CMD_ERASE_SECTOR8_DOWNLOAD      0xFC
#define CMD_BOOTING                       0xFD
#define CMD_CREATE_FILE_CONT_CHECK           0xFE /*sdhong for tfs4 check*/


#define CMD_DOWNLOAD_COMPLETE        0xFF

/*sdhong for nand dumper*/
#define CMD_NAND_STARTDUMP  0xC0 
#define CMD_NAND_DUMP_OK 0xC1
#define CMD_NAND_DUMP_ERROR 0xC2
#define CMD_NAND_DUMP_END 0xC3
#define CMD_SET_TFSTIME 0xC4 /*sdhong 041019 tfs system time set*/

/*sdhong 20041012 for write checksum in NOR AREA*/	
#define CMD_WRITE_NOR_CHECKSUM  0xC8 
#define CMD_WRITE_NAND_CHECKSUM  0xC9 
/* sdhong_20041025_multibytechar */
#define CMD_CONTINUE_SENDNAME  0xCB 

/*sdhong_20041116_tfsfileCompleteCheck */
#define CMD_WRITE_COMPLETE_NAND 0xC5
#define CMD_WRITE_COMPLETE_NOR 0xC6

#define CMD_ERASE_SECTOR128_DOWNLOAD     0xC7   
#define CMD_ERASE_SECTOR32_DOWNLOAD     0xCC  

/*sdhong_20041227_chipversion_check*/
#define CMD_READ_CHIP_ID 0xB0
#endif

/////////////////////////////////////////////////////////////////////////////
// CCabrio_downloaderv01Dlg dialog

class CCabrio_downloaderv01Dlg : public CDialog
{
// Construction
public:

	CBitmapButton	m_ctrCap;

	bool BML_Format();

	CString st;
    CString str_time;
	int		nConnectMode;
	double 	totaltime;                   //ð
	UInt8 	saveBaudRate;                //baudrate  
	int		 nCon_Result;                //connect return  
	bool 		bConnect;                //connect ǥ
	char 	v_FileName[30];
	unsigned long all_size;
	unsigned long used_size;
	long temp_nfrom;
	unsigned long m_fAddress;
	int		m_nDownloadNum;

	//ư Ʈ  
	CFont m_font,m_font2,m_font3,m_font4,m_font5,m_font6,m_font7;

	//configuration  
	int m_nBaudRate;
	int m_ComPort;
	int m_nMainPercent;

	//sector ϱ  Լ
	int GetSectorNum(unsigned long startAddr, unsigned long filesize);
	int GetSectorNum2(unsigned long startAddr, unsigned long filesize);
	int ConvHex(const CString & str);
	int IsHex(const CString &st);

	void ShowHead();
	void LockControls(void);
	void InitControls(void);
	void ReadyControls();

	// Լ

	
	bool Erase(UInt8);			/* NAND Erase */
	bool NorErase(UInt8);
	bool TFS_Format(UInt8);     /* TFS Format */ 
	int ConnectWithMS();
	void DisconnectMS();
	bool NorDump(UInt8 cActionType);
	bool NandDump(UInt8 cActionType);
   
	//̹ ٿε  Լ
    

#ifndef __TFS4__ // moo_20070201 : add new api for ASTON
		//TFS4 Download api
	BOOL TFS_Download(void * comPort,UInt8 nConnectMode);
	  BOOL TFS_CheckFileSize();
	  BOOL TFS_CreateDir( void );
	  BOOL TFS_CreateFile( void );
	  DWORD TextFindInBuffer(char *str_find, char *str_src, DWORD idx);
	  void MultibyteToUTF8(char *src, char*dest,int *destlen);
	  void UTF8ToMultibyte(char *src, char*dest,int *destlen);
	  DWORD CalCheckSum(CString m_strBinPath,int *FileLen);
	  void SendTFSData();
	  void FinishDownload();
	  int Get_CRC(CString &csData, DWORD dwSize);
	  void Init_CRC32_Table(); // Builds Lookup table array
	  ULONG Reflect(ULONG ref, char ch);
  
#endif

	bool NorDriverDownload(ComPortCfg_t *comPortCfg,int cActionType);
	bool NandDriverDownload(ComPortCfg_t *comPortCfg,int cActionType);

	UInt8 GetCRC7(UInt8 *bpdata, UInt8 totlen, UInt8 initvalue, UInt8 divisor, UInt8 bit0);
	UInt16 GetCRC16(UInt8 *bpdata, UInt16 totlen, UInt16 initvalue, UInt32 divisor);
	UInt8 GetBit(UInt8 *bpdata, UInt32 bitaddr);
	void GetBlkDataFromArray(UInt8 *bp, UInt8 const *ap, UInt32 startaddr, UInt16 blklength);
	BOOL GetBlkDataFromImage(UInt8 *bp, FILE *fp, UInt16 blklength);
	/*----------------------------------------------------------------------------------------
	 Item Download - NorDownload, NandDownload
		(UInt8 cActionType,int prompt)
	------------------------------------------------------------------------------------------
	 driver download check  -> CURRENT_WITHOUT_DRIVER ϰ ش ̹ ٿε
	1. cActionType   : download type
	2. prompt :  ޼  ǥ : 0 ->ǥ
				                        1 ->ǥ                                        */
	bool NorDownload(UInt8 cActionType,int prompt);
	bool NandDownload(UInt8 cActionType,int prompt);

	/* Bootloader Download */
	bool Dlbootloader(UInt8 cActionType);
	// ڵ  Լ
	char * PathMake(CString str);
	void RestoreProgramSetting(void);
	void InitVariables(void);

	//EditBox ¿ Լ
	void ShowStatus(CString str);        //MAIN  ǥâ  Լ : 
	void ShowStatus(CString str,int a);  //MAIN  ǥâ  Լ : int a -> 1: Ķ() 
										 //										 2: ()
										 //										 3: Ķ()
									     //										 4: ()

	void ShowEnv(CString str,int a);
	void ShowMessage_ConnectWithMS(int a);
	void ShowTotalTime();
	int FlashCheck(unsigned char t);
	void DisplayButton(UInt8 type,int a,unsigned long addr);

	//ϰ Լ
	void GetCheckSum(CString Filename);
	void GetFileName(CString path);
	unsigned long GetFileSize(CString filename);	
	
	void Ramdump();
	CCabrio_downloaderv01Dlg(CWnd* pParent = NULL);	// standard constructor

	/*********************************************/
	/* ٿε  ϵ ̸ ϴ  */
	/*********************************************/
	
	//NOR Flash....................................
	//̸
	CString m_strFlashDrvName;
	CString m_strImageFileName;
	CString m_strParamDepFileName;
	CString m_strManualImage;

	//ũ
	unsigned long m_nImageSize;
	unsigned long m_nParamDepSize;
	unsigned long m_nManulImageSize;
	//NAND Flash.........................................
	//̸
	CString m_strNandFlashFileName;
	CString m_strRscrFileName;
	CString m_strRscr2FileName;
	CString m_strFactoryFSFileName;
	CString m_strEntireFlashFileName;
	CString m_strManualNandImage;

	//ũ
	unsigned long m_nNandFlashSize;
	unsigned long m_nRscrSize;
	unsigned long m_nRscr2Size;
	unsigned long m_nFactoryFSSize;
	unsigned long m_nEntireFlashSize;
	unsigned long m_nManualNandImageSize;

	CString k;
	CFile	m_DumpFile;
	
	bool	nOnline;

	// image file check variables
	int		vImageFile;
	int		vTfsFile;

	// image set components
	UInt32	startAddr[8];
	UInt32	imageSize[8];

	BYTE m_Buffer[8192];

#ifndef _TFS4_DOWNLOAD_
	CString m_strOgmPath;
	CString m_strOgmCfgPath;

	CString m_strAfxOgmPath[5];
	CString	m_sTFSPath;
	CString	m_sTfsPath;

#endif

// Dialog Data
	//{{AFX_DATA(CCabrio_downloaderv01Dlg)
	enum { IDD = IDD_CABRIO_DOWNLOADERV01_DIALOG };
	CButton	m_btnPer;
	CButton	m_ctrBMLFORMAT;
	CRichEditCtrl	m_ctrlNandFlash;
	CButton	m_btnManualNand;
	CButton	m_btnManualNor;
	CEdit	m_editManualNandImagePath;
	CEdit	m_editManualNandAddress;
	CEdit	m_editDN;
	CEdit	m_editTime;
	CEdit	m_editManualImagePath;
	CEdit	m_editManualAddress;
	CButton	m_ctrNorDump;
	CButton	m_ctrNorErase;
	CButton	m_ctrNandDump;
	CButton	m_ctrBootloaderErase;
	CEdit	m_editEntireFlashPath;
	CButton	m_ctrEntireFlash;
	CButton	m_ctrlBChk;
	CButton	m_btnInfo;
	CEdit	m_editSubStatus;
	CButton	m_idok;
	CButton	m_ctrlDlbootloader;
	CButton	m_ctrlDisconnect;
	CRichEditCtrl	m_ctrlConnect;
	CRichEditCtrl	m_ctrlNFlash;
	CButton	m_ctrlStart;
	CEdit	m_editFileName;
	CEdit	m_editCheckSum;
	CEdit	m_editFileSize;
	CButton	m_ctrTFSFormat;
	CButton	m_ctrCabrio;
	CButton	m_ctrTitle;
	CButton	m_ctrCN;
	CButton	m_ctrSysDep;
	//CButton	m_ctrCap;
	CButton	m_ctrFactoryFS;
	CButton	m_ctrRscr2;
	CButton	m_ctrRscr;
	CProgressCtrl	m_progressMain;
	CButton	m_ctrDownloadButton;
	CEdit	m_editRscr2Path;
	CEdit	m_editRscrPath;
	CEdit	m_editParamDepPath;
	CEdit	m_editFactoryFSPath;
	CRichEditCtrl	m_editStatus;
	CEdit	m_editFontPath;
	CButton	m_ctrPhoneImage;
	CComboBox	m_cbxBaudRate;
	CButton	m_chbxImage;
	CEdit	m_editImagePath;
	CComboBox	m_ctrlComPort;
	int		m_radio;
	BOOL	m_boolECC;
	BOOL	m_boolAuto;
	BOOL	m_boolAutoReboot;
	BOOL	m_boolCalset;
	int		m_radioMode;
	BOOL	m_boolBootloader;
	BOOL	m_boolImage;
	BOOL	m_boolRsrc;
	BOOL	m_ckBoot;
	BOOL	m_ckCal;
	BOOL	m_ckER;
	BOOL	m_ckParam;
	BOOL	m_ckRc1;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCabrio_downloaderv01Dlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;
	CWinThread * pThread;
	ComPortCfg_t	comPortCfg;
	void * comPort;

	//CFile ݵ public θ ȵȴ.

#ifndef __TFS4__  // moo_20070201
	CFile	m_OgmFile;
	CFile	m_OgmCfgFile;
	char m_TFSVersion[MAX_LEN_TFS_VERSION];
	char m_TFSReleaseVer[MAX_LEN_TFS_RELEASE_VERSION];//SHKIM Add TFS Release Version 040713
	DWORD m_CfgIndx;
	DWORD m_TFSOneFileSize;
	BOOL v_ReleaseVerFlag;//SHKIM Add 040717
	BYTE m_CheckSum;
	int m_RxState;
	int m_Operation;
	CTime LocalsystemTime;
	BOOL m_IsTFSOneFileComplete;
	CTimeSpan m_ElapsedTime;
	CTime m_EndTime;
	CTime m_StartTime;
	BOOL m_IsComplete;
	ULONG crc32_table[256]; // Lookup table array
	ULONG m_ProgressSize;
	int oMode;
#endif
	
	// Generated message map functions
	//{{AFX_MSG(CCabrio_downloaderv01Dlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnSelchangeComboComport();
	afx_msg void OnButtonPhoneImage();
	afx_msg void OnSelchangeComboBaudrate();
	afx_msg void OnButtonNandRscr();
	afx_msg void OnButtonNandRscr2();
	afx_msg void OnButtonNandFactoryfs();
	afx_msg void OnButtonSysparmDep();
	afx_msg void OnButtonDownload2();
	afx_msg void OnButtonCap();
	afx_msg void OnButtonCN();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnButtonTitle();
	afx_msg void OnButtonTfsFormat();
	afx_msg void OnButtonStart();
	afx_msg void OnButtonDisconnect();
	afx_msg void OnButtonDlbootloader();
	afx_msg void OnButtonCabrio();
	afx_msg void OnButtonInfo();
	afx_msg void OnButtonBchk();
	afx_msg void OnButtonNorDump();
	afx_msg void OnButtonNandDump();
	afx_msg void OnButtonBootloaderErase();
	afx_msg void OnButtonNorAllerase();
	afx_msg void OnButtonNandEntireFlash();
	afx_msg void OnChangeEditManual();
	afx_msg void OnButtonManualImage();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnButtonManualNandImage();
	afx_msg void OnChangeEditManualNand();
	afx_msg void OnRadioUart();
	afx_msg void OnRadioUsb();
	afx_msg void OnButtonCalInfo();
	afx_msg void OnButtonRsrcInfo();
	afx_msg void OnButtonRsrc2Info();
	afx_msg void OnButtonFacInfo();
	afx_msg void OnBML_Format();
	afx_msg void OnFormat();
	afx_msg void OnBmlFormat();
	afx_msg void OnCheckEr();
	afx_msg void OnCheckParm();
	afx_msg void OnCheckRc1();
	afx_msg void OnCheckCal();
	afx_msg void OnCheckBoot();
	afx_msg void OnButtonRamdump();
	afx_msg void OnBmpHidebtn();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CABRIO_DOWNLOADERV01DLG_H__15B72A5F_F602_4EE1_BB86_D9CE64F79500__INCLUDED_)
