//****************** Copyright 1997 Mobilink Telecom, Inc. *********************
//
// Description:  This file contains the global constants of the mobile station
//		processor software component
//
//******************************************************************************

#ifndef _INC_CONSTS_H_
#define _INC_CONSTS_H_

#include "types.h"

#ifndef TRUE
#define TRUE			( (Boolean)1 )
#endif

#ifndef FALSE
#define FALSE			( (Boolean)0 )
#endif

#define NOT_AVAIL		0xff

#ifdef NO_LA_TESTPOINT
#define _TP_OUTPUT(x, y)
#else

#define LA_RTOS			0x00000001
#define	LA_PHY			0x00000002
#define LA_MP			0x00000004
#define LA_DATA			0x00000008
#define LA_ECDC			0x00000010
#define LA_STACK		0x00000020
#define LA_GENERAL		0x00000080
#define LA_IRAT			0x00000040

extern	UInt32			isTestPointEnabled;
#define _TP_OUTPUT(mask, x)	if(isTestPointEnabled & mask)	{x};
#endif

#ifndef WIN32

#define SPARE_TP		(*(volatile UInt16 *)0x4fffff0)
#define TP2				(*(volatile UInt16 *)0x4fffff2)
#define TP4				(*(volatile UInt16 *)0x4fffff4)
#define TP6				(*(volatile UInt16 *)0x4fffff6)
#define TP8				(*(volatile UInt16 *)0x4fffff8)
#define TPa				(*(volatile UInt16 *)0x4fffffa)
#define TPc				(*(volatile UInt16 *)0x4fffffc)
#define TPe				(*(volatile UInt16 *)0x4fffffe)
#define SPEED_TP		(*(volatile UInt16 *)0x4ffff8e)
#define OAKMSG_TP		(*(volatile UInt16 *)0x4ffff8c)
#define FRAME_INT_TP	(*(volatile UInt16 *)0x4ffff8a)
#define DATA_TP			(*(volatile UInt16 *)0x4ffff88)
#define TPP0 			(*(volatile UInt32 *)0x4ffffe0)	
#define TPP4 			(*(volatile UInt32 *)0x4ffffe4)	
#define TPP8 			(*(volatile UInt32 *)0x4ffffe8)	
#define TPPc 			(*(volatile UInt32 *)0x4ffffec)	

#define FRAME_TP		(*(volatile UInt16 *)0x4ffff50) // to 0x4ffff70
#define FRAME_INDEX_TP	(*(volatile UInt16 *)0x4ffffb0)
#define CMD_TP			(*(volatile UInt16 *)0x4ffffc0)

#define TX_DATA_INDEX_TP (*(volatile UInt16  *)0x4fff700)
#define TX_DATA_MODE_TP	(*(volatile UInt16  *)0x4fff702)
#define TX_DATA_TP		(*(volatile UInt16 *)0x4fff000)
#define TX_FACCH_TP		(*(volatile UInt16 *)0x4fff100)
#define TX_SACCH_TP		(*(volatile UInt16 *)0x4fff200)

#define RX_DATA_INDEX_TP (*(volatile UInt16 *)0x4fff708)
#define RX_DATA_TP		(*(volatile UInt16 *)0x4fff080)
#define RX_FACCH_TP		(*(volatile UInt16 *)0x4fff180)
#define RX_SACCH_TP		(*(volatile UInt16 *)0x4fff280)
#define RX_BFI			(*(volatile UInt16 *)0x4fff500)

#define TBF_IF_MON0		(*(volatile UInt16 *)0x4fff600)
#define TBF_IF_MON1		(*(volatile UInt16 *)0x4fff602)
#define TBF_IF_MON2		(*(volatile UInt16 *)0x4fff604)
#define TBF_IF_MON3		(*(volatile UInt16 *)0x4fff606)


// High layer related test points
#define DTT_ACTION				(*(volatile UInt16 *)0x4ffff00)
#define DTT_WRITE_FRAMES 		(*(volatile UInt16 *)0x4ffff02)
#define DTT_READ_FRAMES  		(*(volatile UInt16 *)0x4ffff04)
#define DTA_READ_INDEX   		(*(volatile UInt16 *)0x4ffff06)
#define DTA_WRITE_INDEX   		(*(volatile UInt16 *)0x4ffff08)
#define L1DS_WRITE_INDEX   		(*(volatile UInt16 *)0x4ffff0a)
#define L1DS_READ_INDEX   		(*(volatile UInt16 *)0x4ffff0c)
#define DTT_READ_SUBNUM			(*(volatile UInt16 *)0x4ffff0e)

#define TP_DTN_ACTION			(*(volatile UInt16 *)0x4ffff10)
								
#define TP_L1S_ACTION			(*(volatile UInt16 *)0x4ffff12)

#define TP_RRM_ACTION			(*(volatile UInt16 *)0x4ffff14)

#define TP_DLL_ACTION			(*(volatile UInt16 *)0x4ffff16)

#define DTT_READ_BYTCNT			(*(volatile UInt16 *)0x4ffff18)
#define DTT_READ_L1S2INT		(*(volatile UInt16 *)0x4ffff1a)
#define DTT_READ_INT2DTA		(*(volatile UInt16 *)0x4ffff1c)
#define DTT_READ_INT2DTA2		(*(volatile UInt16 *)0x4ffff1e)

#define TP_DRL_ACTION			(*(volatile UInt16 *)0x4ffff20)

#define TP_DCH_ACTION			(*(volatile UInt16 *)0x4ffff30)

#define ATC_ACTION				(*(volatile UInt16 *)0x4ffff40)

#define TP_HEAP_ALLOC_SIZE		(*(volatile UInt16 *)0x4000000)

#define TP_ASSERT				(*(volatile UInt16 *)0x4888888)

#define TP_OAK_RXQUAL_FULL		(*(volatile UInt16 *)0x4100000)
#define TP_OAK_RXQUAL_SUB		(*(volatile UInt16 *)0x4100002)
#define TP_OAK_RXLEV_FULL		(*(volatile UInt16 *)0x4100004)
#define TP_OAK_RXLEV_SUB		(*(volatile UInt16 *)0x4100006)
	 
#define TP_READ_BUFF			(*(volatile UInt16 *)0x41ff000)
#define TP_RX_BUFF_BFI			(*(volatile UInt16 *)0x41ff040)
#define TP_RX_BUFF_CODE			(*(volatile UInt16 *)0x41ff042)
#define TP_RX_BUFF_OTD			(*(volatile UInt16 *)0x41ff044)
#define TP_RX_BUFF_INDEX		(*(volatile UInt16 *)0x41ff046)
#define TP_RX_BUFF_ADJ			(*(volatile UInt16 *)0x41ff048)

#define TP_WRITE_BUFF			(*(volatile UInt16 *)0x41ff080)
#define TP_TX_BUFF_INDEX		(*(volatile UInt16 *)0x41ff0c0)
#define TP_TX_BUFF_CODE			(*(volatile UInt16 *)0x41ff0c2)

#define TP_MAC_GET_BLOCK_TX_SLOT (*(volatile UInt16 *)0x41ff050)
#define TP_MAC_GET_BLOCK_FN 	(*(volatile UInt32 *)0x41ff054)
#define TP_MAC_GET_BLOCK_TBF_ID (*(volatile UInt16 *)0x41ff058)

#define TP_MAC_ACK_NU_SENT 		(*(volatile UInt16 *)0x41ff05a)
#define TP_MAC_ACK_FN		 	(*(volatile UInt32 *)0x41ff05c)

#define TP_START_PLOT_FRAME		(*(volatile UInt16 *)0x41ff060)

#define TP_FRAME_STATE			(*(volatile UInt16 *)0x4110000)
#define TP_SWEEP_SIZE			(*(volatile UInt16 *)0x4120000)
#define TP_SWEEP_CNT			(*(volatile UInt16 *)0x4120002)
#define TP_L1_RX_MSG            (*(volatile UInt16 *)0x4130000)												

#define TP_CELLDATA_ID			(*(volatile UInt16 *)0x4200000)
#define TP_CELLDATA_VALID		(*(volatile UInt16 *)0x4200002)
#define TP_CELLDATA_SYNC		(*(volatile UInt16 *)0x4200004)
#define TP_CELLDATA_ARFCN		(*(volatile UInt16 *)0x4200006)
#define TP_CELLDATA_RXLEV		(*(volatile UInt16 *)0x4200008)

#define TP_SORT_INDEX			(*(volatile UInt16 *)0x4300000)
#define TP_SORT_ARFCN			(*(volatile UInt16 *)0x4300002)
#define TP_SORT_RXLEV			(*(volatile UInt16 *)0x4300004)

#define TP_MON_ARFCN			(*(volatile UInt16 *)0x4400000)
#define TP_MON_RXLEV			(*(volatile UInt16 *)0x4400002)

#define TP_RX_SLOTS_PATT		(*(volatile UInt16 *)0x4500000)
#define TP_TX_SLOTS_PATT		(*(volatile UInt16 *)0x4500002)
#define TP_FIRST_SLOT			(*(volatile UInt16 *)0x4500004)
#define TP_TCH_MODE 			(*(volatile UInt16 *)0x4500006)
#define TP_CHAN_CFG_IS_HSCSD	(*(volatile UInt16 *)0x4500008)

// Test Points for ECDC 0x4600000..0x4600fff
#define TP_ECDC_ENTER			(*(volatile UInt16 *)0x4600000)
#define TP_ECDC_MSR_EVT			(*(volatile UInt16 *)0x4600002)
#define TP_ECDC_MSR_RD			(*(volatile UInt16 *)0x4600004)
#define TP_ECDC_RX_EVT			(*(volatile UInt16 *)0x4600006)
#define TP_ECDC_RPT_DTR			(*(volatile UInt16 *)0x4600008)
#define TP_ECDC_FC				(*(volatile UInt16 *)0x460000a)
#define TP_ECDC_RTS				(*(volatile UInt16 *)0x460000c)
#define TP_ECDC_DTR				(*(volatile UInt16 *)0x460000e)
#define TP_ECDC_T1_ENTER		(*(volatile UInt16 *)0x4600010)
#define TP_ECDC_T1_EXIT			(*(volatile UInt16 *)0x4600012)
#define TP_ECDC_MPX_RPT_EVT		(*(volatile UInt16 *)0x4600014)
#define TP_ECDC_V24_RPT_LSI		(*(volatile UInt16 *)0x4600016)
#define TP_ECDC_V24_EVT_PRC		(*(volatile UInt16 *)0x4600018)

#define TP_ECDC_DROPPED			(*(volatile UInt32 *)0x460001c)
#define TP_ECDC_SENT			(*(volatile UInt32 *)0x4600020)

#define TP_ECDC_V24_UPD_DCE_FC	(*(volatile UInt16 *)0x4600030)
#define TP_ECDC_V24_RPT_REM_FC	(*(volatile UInt16 *)0x4600032)
#define TP_ECDC_UPD_DCE_FC		(*(volatile UInt16 *)0x4600034)
#define TP_ECDC_RPT_REM_FC		(*(volatile UInt16 *)0x4600036)
#define TP_ECDC_UPD_DCE_SZ		(*(volatile UInt16 *)0x4600038)

#define TP_ECDC_BYTES_READ		(*(volatile UInt32 *)0x4600100)
#define TP_ECDC_DTE_RD_DATA		(*(volatile UInt8  *)0x4600104)
#define TP_ECDC_BYTES_WRITTEN	(*(volatile UInt32 *)0x4600180)
#define TP_ECDC_DTE_WR_DATA		(*(volatile UInt8  *)0x4600184)

#define TP_ECDC_TX_DATA			( (volatile UInt16 *)0x4600300)	// Data sent to Stack (up to 256 bytes per read)
#define TP_ECDC_RX_DATA			( (volatile UInt16 *)0x4600400)	// Data received from Stack (up to 256 bytes per write)

#define TP_ECDC_EXIT			(*(volatile UInt16 *)0x4600ffe)

#define TP_SIO_RX_CHAR			(*(volatile UInt8  *)0x4601000)
#define TP_SIO_TX_CHAR			(*(volatile UInt8  *)0x4601001)
#define TP_SIO_BRK_CK0			(*(volatile UInt16 *)0x4601010)
#define TP_SIO_BRK_CK1			(*(volatile UInt16 *)0x4601012)
#define TP_SIO_BRK_CK2			(*(volatile UInt16 *)0x4601014)
#define TP_SIO_BRK_CK3			(*(volatile UInt16 *)0x4601016)
#define TP_SIO_BRK_CK4			(*(volatile UInt16 *)0x4601018)
#define TP_SIO_BRK_CK5			(*(volatile UInt16 *)0x460101a)
#define TP_SIO_BRK_CK6			(*(volatile UInt16 *)0x460101c)
#define TP_SIO_BRK_CK7			(*(volatile UInt16 *)0x460101e)
#define TP_SIO_MSR_MON			(*(volatile UInt16 *)0x4601020)
#define TP_SIO_IS_TXEN			(*(volatile UInt16 *)0x4601022)

#define TP_TX_96_SLOT_NO		(*(volatile UInt16 *)0x4602000)
#define TP_TX_96_NT_FRAME		(*(volatile UInt16 *)0x4602002)
#define TP_RX_96_SLOT_NO		(*(volatile UInt16 *)0x4602080)
#define TP_RX_96_NT_FRAME		(*(volatile UInt16 *)0x4602082)

#define TP_TX_144_SLOT_NO		(*(volatile UInt16 *)0x4602100)
#define TP_TX_144_NT_FRAME		(*(volatile UInt16 *)0x4602102)
#define TP_RX_144_SLOT_NO		(*(volatile UInt16 *)0x4602180)
#define TP_RX_144_NT_FRAME		(*(volatile UInt16 *)0x4602182)

#define TP_SERIAL_TX_SIZE		(*(volatile UInt16 *)0x4680000)

#define TP_FLW_SIO_RX_CNT		(*(volatile UInt32 *)0x4688800)
#define TP_FLW_SIO_TX_CNT		(*(volatile UInt32 *)0x4688880)

#define TP_FLW_MPXRX_RX_CNT			(*(volatile UInt32 *)0x4688804)
#define TP_FLW_MPX_TX_CNT			(*(volatile UInt32 *)0x4688884)

//
// Not really a test point, but rather, a placeholder for test point in 
// __16__rt_stkovf_split_big in rt_16.s so it doesn't get used unwittingly.  
// Rt_16.s reads memmap.inc and not this file so there's no common include 
// file.  Having this here should at least raise a flag...
//
#define	TP_STACK_OVERFLOW		(*(volatile UInt32 *)0x46ffffc)

#define TP_RXPM_SIO				(*(volatile UInt16 *)0x4700000)
#define TP_RXPM_RXDATA			(*(volatile UInt16 *)0x4700002)
#define TP_RXPM_MPX				(*(volatile UInt16 *)0x4700004)
#define TP_RXPM_V24				(*(volatile UInt16 *)0x4700006)
#define TP_RXPM_ATC				(*(volatile UInt16 *)0x4700008)
#define TP_RXPM_ECDC			(*(volatile UInt16 *)0x470000a)
#define TP_RXPM_PPP				(*(volatile UInt16 *)0x470000c)
#define TP_RXPM_DTT				(*(volatile UInt16 *)0x470000e)

#define TP_TXPM_UART			(*(volatile UInt16 *)0x4700010)
#define TP_TXPM_SIO				(*(volatile UInt16 *)0x4700012)
#define TP_TXPM_MPX				(*(volatile UInt16 *)0x4700014)
#define TP_TXPM_V24				(*(volatile UInt16 *)0x4700016)
#define TP_TXPM_ATC				(*(volatile UInt16 *)0x4700018)
#define TP_TXPM_ECDC			(*(volatile UInt16 *)0x470001a)
#define TP_TXPM_PPP				(*(volatile UInt16 *)0x470001c)
#define TP_TXPM_DTT				(*(volatile UInt16 *)0x470001e)

#else

// Dummy Testpoint Array

extern UInt16 dummy_buff[1024];

#define SPARE_TP		(*(volatile UInt16 *)dummy_buff) 
#define TP2				(*(volatile UInt16 *)dummy_buff) 
#define TP4				(*(volatile UInt16 *)dummy_buff) 
#define TP6				(*(volatile UInt16 *)dummy_buff) 
#define TP8				(*(volatile UInt16 *)dummy_buff) 
#define TPa				(*(volatile UInt16 *)dummy_buff) 
#define TPc				(*(volatile UInt16 *)dummy_buff) 
#define TPe				(*(volatile UInt16 *)dummy_buff) 
#define SPEED_TP		(*(volatile UInt16 *)dummy_buff) 
#define OAKMSG_TP		(*(volatile UInt16 *)dummy_buff) 
#define FRAME_INT_TP	(*(volatile UInt16 *)dummy_buff) 
#define DATA_TP			(*(volatile UInt16 *)dummy_buff) 
#define TPP0 			(*(volatile UInt16 *)dummy_buff) 
#define TPP4 			(*(volatile UInt16 *)dummy_buff) 	
#define TPP8 			(*(volatile UInt16 *)dummy_buff) 	
#define TPPc 			(*(volatile UInt16 *)dummy_buff) 	

#define FRAME_TP		(*(volatile UInt16 *)dummy_buff) 
#define FRAME_INDEX_TP	(*(volatile UInt16 *)dummy_buff) 
#define CMD_TP			(*(volatile UInt16 *)dummy_buff) 
#define TX_DATA_INDEX_TP (*(volatile UInt16 *)dummy_buff) 
#define TX_DATA_MODE_TP (*(volatile UInt16 *)dummy_buff) 
#define TX_DATA_TP		(*(volatile UInt16 *)dummy_buff) 
#define TX_FACCH_TP		(*(volatile UInt16 *)dummy_buff) 
#define TX_SACCH_TP		(*(volatile UInt16 *)dummy_buff) 
#define RX_DATA_INDEX_TP (*(volatile UInt16 *)dummy_buff) 
#define RX_DATA_TP		(*(volatile UInt16 *)dummy_buff) 
#define RX_FACCH_TP		(*(volatile UInt16 *)dummy_buff) 
#define RX_SACCH_TP		(*(volatile UInt16 *)dummy_buff) 
#define TBF_IF_MON0		(*(volatile UInt16 *)dummy_buff) 
#define TBF_IF_MON1		(*(volatile UInt16 *)dummy_buff) 
#define TBF_IF_MON2		(*(volatile UInt16 *)dummy_buff) 
#define TBF_IF_MON3		(*(volatile UInt16 *)dummy_buff) 

// High layer related test points
#define DTT_ACTION			(*(volatile UInt16 *)dummy_buff) 
#define DTT_WRITE_FRAMES	(*(volatile UInt16 *)dummy_buff) 
#define DTT_READ_FRAMES 	(*(volatile UInt16 *)dummy_buff) 
#define DTA_READ_INDEX  	(*(volatile UInt16 *)dummy_buff) 
#define DTA_WRITE_INDEX 	(*(volatile UInt16 *)dummy_buff) 
#define L1DS_WRITE_INDEX	(*(volatile UInt16 *)dummy_buff) 
#define L1DS_READ_INDEX 	(*(volatile UInt16 *)dummy_buff) 

#define TP_DTN_ACTION			(*(volatile UInt16 *)dummy_buff) 

#define TP_DRL_ACTION			(*(volatile UInt16 *)dummy_buff) 

#define TP_DCH_ACTION			(*(volatile UInt16 *)dummy_buff) 

#define TP_HEAP_ALLOC_SIZE		(*(volatile UInt16 *)dummy_buff) 
#define TP_ASSERT			(*(volatile UInt16 *)dummy_buff) 

#define TP_L1S_ACTION			(*(volatile UInt16 *)dummy_buff) 
#define TP_OAK_RXQUAL_FULL		(*(volatile UInt16 *)dummy_buff) 
#define TP_OAK_RXQUAL_SUB		(*(volatile UInt16 *)dummy_buff) 
#define TP_OAK_RXLEV_FULL		(*(volatile UInt16 *)dummy_buff) 
#define TP_OAK_RXLEV_SUB		(*(volatile UInt16 *)dummy_buff) 

#define TP_FRAME_STATE			(*(volatile UInt16 *)dummy_buff) 
#define TP_SWEEP_SIZE			(*(volatile UInt16 *)dummy_buff) 
#define TP_SWEEP_CNT			(*(volatile UInt16 *)dummy_buff) 
#define TP_L1_RX_MSG            (*(volatile UInt16 *)dummy_buff) 

#define TP_READ_BUFF			(*(volatile UInt16 *)dummy_buff) 
#define TP_RX_BUFF_BFI			(*(volatile UInt16 *)dummy_buff) 
#define TP_RX_BUFF_CODE			(*(volatile UInt16 *)dummy_buff) 
#define TP_RX_BUFF_OTD			(*(volatile UInt16 *)dummy_buff) 
#define TP_RX_BUFF_INDEX		(*(volatile UInt16 *)dummy_buff) 
#define TP_RX_BUFF_ADJ			(*(volatile UInt16 *)dummy_buff) 

#define TP_WRITE_BUFF			(*(volatile UInt16 *)dummy_buff) 
#define TP_TX_BUFF_INDEX		(*(volatile UInt16 *)dummy_buff) 
#define TP_TX_BUFF_CODE			(*(volatile UInt16 *)dummy_buff) 

#define TP_MAC_GET_BLOCK_TX_SLOT (*(volatile UInt16 *)dummy_buff) 
#define TP_MAC_GET_BLOCK_FN 	(*(volatile UInt16 *)dummy_buff) 
#define TP_MAC_GET_BLOCK_TBF_ID (*(volatile UInt16 *)dummy_buff) 

#define TP_MAC_ACK_NU_SENT 		(*(volatile UInt16 *)dummy_buff) 
#define TP_MAC_ACK_FN		 	(*(volatile UInt16 *)dummy_buff) 

#define TP_START_PLOT_FRAME		(*(volatile UInt16 *)dummy_buff) 

#define TP_CELLDATA_ID			(*(volatile UInt16 *)dummy_buff) 
#define TP_CELLDATA_VALID		(*(volatile UInt16 *)dummy_buff) 
#define TP_CELLDATA_SYNC		(*(volatile UInt16 *)dummy_buff) 
#define TP_CELLDATA_ARFCN		(*(volatile UInt16 *)dummy_buff) 
#define TP_CELLDATA_RXLEV		(*(volatile UInt16 *)dummy_buff) 

#define TP_SORT_INDEX			(*(volatile UInt16 *)dummy_buff) 
#define TP_SORT_ARFCN			(*(volatile UInt16 *)dummy_buff) 
#define TP_SORT_RXLEV			(*(volatile UInt16 *)dummy_buff) 

#define TP_MON_ARFCN			(*(volatile UInt16 *)dummy_buff) 			
#define TP_MON_RXLEV			(*(volatile UInt16 *)dummy_buff) 

#define TP_RX_SLOTS_PATT		(*(volatile UInt16 *)dummy_buff) 
#define TP_TX_SLOTS_PATT		(*(volatile UInt16 *)dummy_buff) 
#define TP_FIRST_SLOT			(*(volatile UInt16 *)dummy_buff) 
#define TP_TCH_MODE 			(*(volatile UInt16 *)dummy_buff) 
#define TP_CHAN_CFG_IS_HSCSD	(*(volatile UInt16 *)dummy_buff) 

#define TP_ECDC_ENTER			(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_MSR_EVT			(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_MSR_RD			(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_RX_EVT			(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_RPT_DTR			(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_FC				(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_RTS				(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_DTR				(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_T1_ENTER		(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_T1_EXIT			(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_MPX_RPT_EVT		(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_V24_RPT_LSI		(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_V24_EVT_PRC		(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_DROPPED			(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_SENT			(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_BYTES_READ		(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_DTE_RD_DATA		(*(volatile UInt8  *)dummy_buff)
#define TP_ECDC_BYTES_WRITTEN	(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_DTE_WR_DATA		(*(volatile UInt8  *)dummy_buff)
#define TP_ECDC_V24_UPD_DCE_FC	(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_V24_RPT_REM_FC	(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_UPD_DCE_FC		(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_RPT_REM_FC		(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_UPD_DCE_SZ		(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_TX_DATA			(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_RX_DATA			(*(volatile UInt16 *)dummy_buff) 
#define TP_ECDC_EXIT			(*(volatile UInt16 *)dummy_buff) 

#define TP_SIO_RX_CHAR			(*(volatile UInt16 *)dummy_buff) 
#define TP_SIO_TX_CHAR			(*(volatile UInt16 *)dummy_buff) 
#define TP_SIO_BRK_CK0			(*(volatile UInt16 *)dummy_buff) 
#define TP_SIO_BRK_CK1			(*(volatile UInt16 *)dummy_buff) 
#define TP_SIO_BRK_CK2			(*(volatile UInt16 *)dummy_buff) 
#define TP_SIO_BRK_CK3			(*(volatile UInt16 *)dummy_buff) 
#define TP_SIO_BRK_CK4			(*(volatile UInt16 *)dummy_buff) 
#define TP_SIO_BRK_CK5			(*(volatile UInt16 *)dummy_buff) 
#define TP_SIO_BRK_CK6			(*(volatile UInt16 *)dummy_buff) 
#define TP_SIO_BRK_CK7			(*(volatile UInt16 *)dummy_buff) 

#define TP_TX_96_SLOT_NO		(*(volatile UInt16 *)dummy_buff) 
#define TP_RX_96_SLOT_NO		(*(volatile UInt16 *)dummy_buff) 
#define TP_TX_96_NT_FRAME		(*(volatile UInt16 *)dummy_buff) 
#define TP_RX_96_NT_FRAME		(*(volatile UInt16 *)dummy_buff) 

#define TP_TX_144_SLOT_NO		(*(volatile UInt16 *)dummy_buff) 
#define TP_RX_144_SLOT_NO		(*(volatile UInt16 *)dummy_buff) 
#define TP_TX_144_NT_FRAME		(*(volatile UInt16 *)dummy_buff) 
#define TP_RX_144_NT_FRAME		(*(volatile UInt16 *)dummy_buff) 

#define TP_SERIAL_TX_SIZE		(*(volatile UInt16 *)dummy_buff) 

#define TP_FLW_SIO_RX_CNT		(*(volatile UInt16 *)dummy_buff) 
#define TP_FLW_SIO_TX_CNT		(*(volatile UInt16 *)dummy_buff) 

#define TP_FLW_MPXRX_RX_CNT		(*(volatile UInt16 *)dummy_buff) 
#define TP_FLW_MPX_TX_CNT		(*(volatile UInt16 *)dummy_buff) 

#define	TP_STACK_OVERFLOW		(*(volatile UInt16 *)dummy_buff) 

#endif	// end if ifdef WIN32


#ifndef NULL
#ifdef __cplusplus
#define NULL          0
#else
#define NULL ((void *)0)
#endif
#endif

#endif

//_shared_tx_buff: D:82A0	-> 6000540( arm address) 
//typedef struct
//{
//	volatile UInt16 octets;
//	volatile UInt16 tx_option;
//	volatile UInt16 msg[ CONTENTS_SIZE ];	// Two octets per word
//} TxBuf_t;
//size = 60 bytes
//
//#define CONTENTS_SIZE		28		// # of octets in multislot message
//#define ENTRY_TXBUF_FACCH		1
//#define ENTRY_TXBUF_SACCH		2
//#define ENTRY_TXBUF_SDCCH		3
//tx sdcch buffer address = 0x540 + 60 *3 = 0x5f4
//tx FACCH buffer address = 0x540 + 60 = 0x57c 
//tx DATA buffer address = 0x540 + 60 * 4 = 0x630

//_shared_rx_buff: D:8080, in file D:\hscsd\grip\common\shared.c
//
//#define ENTRY_RXBUF_FACCH		1
//#define ENTRY_RXBUF_SACCH		6
//#define ENTRY_RXBUF_SDCCH		3
//
//typedef struct
//{
//	volatile UInt16 bfi;
//	volatile UInt16 index;
//	volatile UInt16 otd;
//	volatile UInt16 octets;
//	volatile UInt16 rxlev;
//	volatile UInt16 coding;
//	volatile UInt16 msg[ CONTENTS_SIZE ];	// Two octets per word
//} RxBuf_t;
// rx sdcch buffer address = 0x100 + 68 * 3 = 0x60001cc
// 
// rx FACCH buffer address = 0x100 + 68 = 0x6000144
// rx DATA buffer address = 0x100 + 68 * 4  = 0x6000210	( actual data starts from 