#include  <windows.h>
#include "tool_api.h"
#include "flash_api.h"
#include "norflashdrv.h"
#include "nandflashdrv.h"
#include "preboot.h"
#include "bootloader.h"
#include "bootloaderdrv.h"
#include "bootloader1a.h"
#include "bootloader1b.h"
#include "bootloader2.h"
#include "env.h"
#include "itcmloader.h"
#include "resultcode.h"

//NOR component
#define DWL_IMGSET		0x10
#define DWL_CALSET		0x11
#define DWL_MANUAL		0x16

//NAND component
#define DWL_RSRC1		0x12
#define DWL_RSRC2		0x13
#define DWL_FACTORYFS	0x14
#define DWL_ALL			0x15
#define DWL_FLASHALL		0x1A
#define DWL_MANUAL_NAND	0x30

#define OP_ERASE		0x16
#define OP_FORMAT		0x17
#define OP_NAND_ERASE		0x18
#define OP_ERASE_BOOTLOADER	0x19
#define OP_NOR_ERASE		0x20
#define OP_NOR_DUMP			0x1B
#define OP_NAND_DUMP		0x1C

//Driver type
#define DRV_NAND		0x20
#define DRV_PREBOOT     0x21
#define DRV_NOR			0x22
#define DRV_BOOTLOADER	0x23
//-----------------------------------------------------------------------------
//	Prototypes
//-----------------------------------------------------------------------------

static UInt8   _GetCheckSum( UInt8 mode, UInt8 *buff, UInt32 sector_size ) ;
static Boolean _GetSector( UInt8 mode, FILE *fp, UInt8 *buff, UInt32 sector_size ) ;

//-----------------------------------------------------------------------------
//	For timeouts of read/write APIs
//-----------------------------------------------------------------------------

//#define TIMEOUT_SEC 8

#define IOBUFSIZE	8192

typedef unsigned char BYTE;



int offset_s;
UInt32 flash_checksum=0;
BYTE Tx[100];
static int m_FileSize[80];
static UInt8 DS[512];
static int cnt=0;

UInt8 TFSMap[64];
//
//	these static vars support download to PC card
//	-- ref. TOOL_SetPcCardToDownloadMode()
//
static Boolean isPcDownloadMode = FALSE ;
static ComPortCfg_t pcComPortCfg ;
static FILE *fp=0;
static UInt8 IDTYPE;
UInt8	chksum,rchksum ;
static Result_t _SendSectorBoot(
	ComPortCfg_t* comPort,
	UInt8	*buff,
	UInt32	sector_size,
	ToolProgressCb_t progressCb
	)
{
	UInt32	sectorBytesWritten;
	UInt8	chksum ;
	Result_t result ;

	for( sectorBytesWritten=0; sectorBytesWritten<sector_size;){
		UInt32 nWrite = min(1024,sector_size-sectorBytesWritten) ;
		result = TOOL_WriteComPortWithTimeout( comPort, (UInt8*)buff+sectorBytesWritten, nWrite, TIMEOUT_SEC ) ;
		if( RESULT_OK != result ) {
			return result ;
		}
		sectorBytesWritten = sectorBytesWritten + nWrite;

	}



	chksum = _GetCheckSum( UART_MODE,buff, sector_size ) ;

	result = TOOL_WriteComPortWithTimeout( comPort, &chksum, 1, TIMEOUT_SEC ) ;
	if( RESULT_OK != result ) {
		return result ;
	}
	return RESULT_OK ;
}

void SetOffset(int v)
{
	offset_s=v;
}
static Boolean _GetSector_H(UInt8 mode,
	UInt8	*image,
	UInt8	*buff,
	UInt32	sector_size
	) 
{
	
	UInt32	i;

	for( i=0; i<sector_size; i++ ){
		buff[i] = image[offset_s+i];
		
	}
   offset_s += sector_size;

	
	return( TRUE );
}

//VENUS_USB_DOWNLOADER

//#define MAX_MESSAGE_ENTRY 10

//typedef struct _tagUSBMessage{
//  unsigned char cmd;
//  unsigned short seq_no;
//  unsigned char reserved;
//  unsigned int entries[MAX_MESSAGE_ENTRY];
//}usb_message_t;

static UInt16 GetSequenceNumber(void){
  return ((UInt16)(rand() & 0xffff));
}

static UInt32 GetCRC32(UInt32 *pdata, UInt32 size){
  UInt32 i, sum;
  for(i=0;i<size;i++){
    sum+=pdata[i];
  }
  return (~sum + 1);
}

static UInt32 BuildOutgoingMessage
(
 usb_message_t *pmsg,
 UInt8 cmd, 
 UInt32* pdata, 
 UInt32 size,			/* size of data portion only */
 UInt16 seq_no
 
 ){
  int i;

  if (seq_no==0){
    seq_no = GetSequenceNumber();
  }
  pmsg->cmd = cmd;
  pmsg->seq_no = seq_no;
  for (i=0; i<size;i++){
    pmsg->entries[i] = pdata[i];
  }
  pmsg->entries[i] = GetCRC32(pdata,size+1);

  return (i+2);
  
}

static UInt32 BuildOutgoingMessage_TFS
(
 usb_message_t *pmsg,
 UInt32* pdata, 
 UInt32 size,			/* size of data portion only */
 UInt16 seq_no
 
 ){
  int i;

  if (seq_no==0){
    seq_no = GetSequenceNumber();
  }
  pmsg->cmd = REQ_TFS_DOWNLOAD;
  pmsg->seq_no = seq_no;
  for (i=0; i<size;i++){
    pmsg->entries[i] = pdata[i];
  }
  pmsg->entries[i] = GetCRC32(pdata,size+1);

  return (i+2);
  
}

static UInt32 BuildOutgoingMessage_OTHER
(
 usb_message_t *pmsg,
 UInt32* pdata, 
 UInt32 size,			/* size of data portion only */
 UInt16 seq_no
 
 ){
  int i;

  if (seq_no==0){
    seq_no = GetSequenceNumber();
  }
  pmsg->cmd = REQ_OTHER_DOWNLOAD;
  pmsg->seq_no = seq_no;
  for (i=0; i<size;i++){
    pmsg->entries[i] = pdata[i];
  }
  pmsg->entries[i] = GetCRC32(pdata,size+1);

  return (i+2);
  
}

static Result_t SendACK(usb_message_t *pmsg, UInt8 cmd, ComPortCfg_t* comPort){
  pmsg->cmd = cmd;
  pmsg->seq_no = GetSequenceNumber();
  pmsg->entries[0] = GetCRC32((UInt8*)pmsg, 1);

  return TOOL_WriteComPortWithTimeout(comPort, (UInt8*)pmsg, 8, TIMEOUT_SEC);
}

static Boolean cancelRequest = FALSE ;

void TOOL_CancelDownload( void )
{
	cancelRequest = TRUE ;
}


//#define GET_CMD(_a) (_a.cmd & 0xff)
#define FP_ImageOK_ACK 0x30
#define FP_Finished_ACK (0x31)

//USB_DOWNLOADER

Result_t TOOL_DownloadBoot(ComPortCfg_t 	*comPort,UInt8 type ) 
{
//	int				numBytesDownloaded;
//	int				bytesInFile;
	FILE  			*fp = 0 ;
	UInt8			c ;
	UInt8			*fileBuffer = 0 ;
	Result_t		result ;
	UInt8			saveBaudRate ;
	
	OutputDebugString("Updater: Entering TOOL_DownloadFlashDriver") ;

	//
	//	verify caller-specified baudrate
	//
	switch( comPort->baudRate )
	{
		case FP_Speed_115k:
		case FP_Speed_230k:
		case FP_Speed_460k:
		case FP_Speed_812k:
		case FP_Speed_921k:
			break ;
		default:
			result = RESULT_TOOL_INVALID_VALUE ;
			goto _cleanup ;
	}

	saveBaudRate = comPort->baudRate ;
	comPort->baudRate = COMPORT_BAUDRATE_115K ;

	//
	//	open the COM port
	//
	result = TOOL_OpenComPort( comPort ,NOPARITY) ;
	if( RESULT_OK != result ) 
	{
		goto _cleanup ;
	}

	fileBuffer = (UInt8*)calloc(1,hBootloaderDrvSize[0]) ;  //TC58_BOOT
	memcpy((void *)fileBuffer,(void *)hBootloaderDrv[0],hBootloaderDrvSize[0]);
	result = TOOL_WriteComPortWithTimeout( comPort, fileBuffer, sizeof(hBootloaderDrv)/2, TIMEOUT_SEC ) ;


    if( RESULT_OK != result ) 
	{
                goto _cleanup ;
    }

	Sleep( 1000 * 2 ) ;

    for (;;)
	{
            //
            //	get speed change request
            //
	
       OutputDebugString("Updater: Waiting for FP_Speed_Req") ;
       result = TOOL_ReadComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC );
       if( RESULT_OK != result ) 
	   {
			goto _cleanup ;
       }

       if( c != FP_Speed_Req )
	   {
            OutputDebugString("Updater: Sync Error on FP_Speed_Req") ;
            result = RESULT_TOOL_SYNC_ERROR ;
            continue;
                    //goto _cleanup ;
       }
       else
            break;
        
	}
	
		

    OutputDebugString("Updater: Received FP_Speed_Req") ;

	//
	//	send/ack speed 
	//
	comPort->baudRate = saveBaudRate ;

	result = TOOL_WriteComPortWithTimeout( comPort, &comPort->baudRate, 1, TIMEOUT_SEC ) ;	
	if( RESULT_OK != result ) {
		goto _cleanup ;
	}

	OutputDebugString("Updater: Waiting for FP_Speed_ChgDone") ;
	result = TOOL_ReadComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
	if( RESULT_OK != result ) {
		goto _cleanup ;
	}

	if( c != FP_Speed_ChgDone ){
		//result = RESULT_TOOL_SYNC_ERROR ;
		goto _cleanup ;
	}
	OutputDebugString("Updater: Received FP_Speed_ChgDone") ;
	


	result = RESULT_OK ;

	

	//
	//	clean up and exit
	//
_cleanup:
	//
	//	close com port unless in PC mode or error
	//
	if(  RESULT_OK != result  ) 
	{
		if ( RESULT_OK != result )
		{
			OutputDebugString("Flash driver download error: Closing ComPort\n") ;
		}

		
	}

	TOOL_CloseComPort( comPort ) ;

	if( fileBuffer ) {
		free( fileBuffer ) ;
	}

	Sleep( 250 ) ;

	return result ;
}

Result_t TOOL_DownloadBootDL(ComPortCfg_t *comPort, UInt32 startAddress,ToolProgressCb_t	progressCb, UInt8 cActionType) // LHYEONSU
{

	static UInt8			sector_buff[FLASH_MAX_SECTOR_SIZE_BYTES];//	MAX_SECTOR_SIZE
	UInt8			c ;

	UInt32			sector_size;
	UInt32			image_size;
	Result_t		result ;
	UInt32 tempAddress=startAddress;

	UInt8			*fileBuffer = 0 ;

	


	OutputDebugString("Updater: Entering TOOL_DownloadImage") ;

	//
	//	verify caller-specified baudrate
	//
	switch( comPort->baudRate )
	{
		case FP_Speed_921k:
		case FP_Speed_460k:
		case FP_Speed_115k:
			break ;
		default:
			result = RESULT_TOOL_INVALID_VALUE ;
			goto _cleanup ;
	}

	result = TOOL_OpenComPort( comPort,NOPARITY ) ;
	if( RESULT_OK != result ) 
	{
		goto _cleanup ;
	}
	if(cActionType==DWL_BOOT1){
	image_size = hBootloaderSize[0];
	fileBuffer = (UInt8*)calloc(1,hBootloaderSize[0]) ;
	memcpy((void *)fileBuffer,(void *)hBootloader[0],hBootloaderSize[0]);
	}
	else if(cActionType==DWL_BOOT2){
	image_size = hBootloader1aSize[0];
	fileBuffer = (UInt8*)calloc(1,hBootloader1aSize[0]) ;
	memcpy((void *)fileBuffer,(void *)hBootloader1a[0],hBootloader1aSize[0]);
	}
	else{
	image_size = hBootloader1bSize[0];
	fileBuffer = (UInt8*)calloc(1,hBootloader1bSize[0]) ;
	memcpy((void *)fileBuffer,(void *)hBootloader1b[0],hBootloader1bSize[0]);
	}

	Sleep (1000 * 3);
    for (;;)
    {
            OutputDebugString("Updater: Sending FP_StartReq") ;
            c = FP_StartReq ;
            result = TOOL_WriteComPortWithTimeout(comPort, &c, 1, TIMEOUT_SEC);
            if( RESULT_OK != result ) {
                    goto _cleanup ;
            }

            result = TOOL_ReadComPortWithTimeout(comPort, &c, 1, TIMEOUT_SEC);

			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}

            if( c == FP_StartOK ) {
                goto start_ok;
            }

            OutputDebugString("Updater: out-of-sync - trying again") ;
            Sleep(1000);
    }

	while(1) 
	{

		result = TOOL_ReadComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
		if( RESULT_OK != result ) 
		{
			goto _cleanup ;
		}

     start_ok:
		if( c == FP_StartOK ) 
		{
			UInt32 bs ;
			OutputDebugString("Updater: Received FP_StartOK") ;

			bs = TOOL_SwapU32( startAddress ) ;
			result = TOOL_WriteComPortWithTimeout( comPort, &bs, 4, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}

			bs = TOOL_SwapU32( image_size ) ;
			result = TOOL_WriteComPortWithTimeout( comPort, &bs, 4, TIMEOUT_SEC ) ;
			if( RESULT_OK != result )
			{
				goto _cleanup ;
			}
		}
		else if( c ==  FP_ImageOK ) 
		{
			OutputDebugString("Updater: Received FP_ImageOK") ;
			c = FP_RequestBlockSize ;
			result = TOOL_WriteComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}
		}

		else if( c ==  FP_AddrWrong ) 
		{
			OutputDebugString("Updater: Received FP_AddrWrong") ;
			result = RESULT_TOOL_ADDRESS_INVALID ;
			goto _cleanup ;
		}

		else if( c ==  FP_ImageTooLarge ) 
		{
			OutputDebugString("Updater: Received FP_ImageTooLarge") ;
			result = RESULT_TOOL_ADDRESS_INVALID ;
			goto _cleanup ;
		}

		else if( c ==  FP_ReturnBlockSize ) 
		{
			UInt32 bs ;
			
			OutputDebugString("Updater: Received FP_ReturnBlockSize") ;
			result = TOOL_ReadComPortWithTimeout( comPort, &bs, 4, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}

			sector_size = TOOL_SwapU32( bs ) ;

			if( !_GetSector_H(UART_MODE, fileBuffer, sector_buff, sector_size ) )
			{
				result = RESULT_TOOL_INTERNAL_ERROR ;
				goto _cleanup ;
			}

		
			
			result = _SendSectorBoot(comPort, sector_buff, sector_size, progressCb);
			result = RESULT_OK;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}
			

		}

		else if( c ==  FP_SectorOK ) 
		{
	//		progressCb(TRUE,TRUE,0,chksum,FALSE);
			OutputDebugString("Updater: Received FP_SectorOK") ;
			c = FP_RequestBlockSize ;
			result = TOOL_WriteComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}
			tempAddress+=sector_size;
		}

		else if( c ==  FP_Resend ) 
		{
			OutputDebugString("Updater: Received FP_Resend") ;
			result = _SendSector( UART_MODE,comPort, sector_buff, sector_size, progressCb,tempAddress );
			if( RESULT_OK != result )
			{
				goto _cleanup ;
			}
		}

		else if( c ==  FP_Failed ) 
		{
			OutputDebugString("Updater: Received FP_Failed") ;
			result = RESULT_TOOL_SYNC_ERROR ;
			goto _cleanup ;
		}

		else if( c ==  FP_Finished ) 
		{
			OutputDebugString("Updater: Received FP_Finished") ;
			result = RESULT_OK ;
			goto _cleanup ;
		}

		else 
		{
			result = RESULT_TOOL_INTERNAL_ERROR ;
			goto _cleanup ;
		}
	}

_cleanup:

	TOOL_CloseComPort( comPort ) ;


	return result ;
}

//-----------------------------------------------------------------------------
//	Public functions
//-----------------------------------------------------------------------------
Result_t TOOL_DownloadBootloaderDrv(ComPortCfg_t 	*comPort) 
{
	UInt8			c ;
	UInt8			*fileBuffer = 0 ;
	Result_t		result ;
	UInt8			saveBaudRate ;


	//
	//	verify caller-specified baudrate
	//
	switch( comPort->baudRate )
	{
		case FP_Speed_921k:
		case FP_Speed_460k:
		case FP_Speed_115k:
			break ;
		default:
			result = RESULT_TOOL_INVALID_VALUE ;
			goto _cleanup ;
	}

	saveBaudRate = comPort->baudRate ;
	comPort->baudRate = COMPORT_BAUDRATE_115K ;


	//
	//	open the COM port
	//
	result = TOOL_OpenComPort( comPort,NOPARITY ) ;
	if( RESULT_OK != result ) 
	{
		goto _cleanup ;
	}


	//
	//	download
	//
	fileBuffer = (UInt8*)calloc(1,hBootloaderDrvSize[0]) ;
	memcpy((void *)fileBuffer,(void *)hBootloaderDrv[0],hBootloaderDrvSize[0]);
	result = TOOL_WriteComPortWithTimeout( comPort, fileBuffer, sizeof(hBootloaderDrv)/2, TIMEOUT_SEC ) ;


	if( RESULT_OK != result ) {
		goto _cleanup ;
	}
	
	result = TOOL_ReadComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
	if( RESULT_OK != result ) {
		goto _cleanup ;
	}

	if( c != FP_Speed_Req ){

		result = RESULT_TOOL_SYNC_ERROR ;
		goto _cleanup ;
	}

	//
	//	send/ack speed 
	//
	comPort->baudRate = saveBaudRate ;
	result = TOOL_WriteComPortWithTimeout( comPort, &comPort->baudRate, 1, TIMEOUT_SEC ) ;	
	if( RESULT_OK != result ) {
		goto _cleanup ;
	}
	
	result = TOOL_ReadComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
	if( RESULT_OK != result ) {
		goto _cleanup ;
	}
	if( c != FP_Speed_ChgDone ){
		result = RESULT_TOOL_SYNC_ERROR ;
		goto _cleanup ;
	}

	
	result = RESULT_OK ;

	//
	//	clean up and exit
	//
_cleanup:
	//
	//	close com port unless in PC mode or error
	//

//	OutputDebugString("Updater: Closing ComPort") ;
	TOOL_CloseComPort( comPort ) ;


	if( fp ) {
		fclose( fp ) ;
	}

	if( fileBuffer ) {
		free( fileBuffer ) ;
	}

	return result ;
}

Result_t TOOL_DownloadFlashDriver(ComPortCfg_t *comPort, UInt8 cDriverType) 
{
	int				size=0;
	int i;
	UInt8			*fileBuffer = 0 ;
	Result_t		result ;
	UInt8			saveBaudRate ;

	//
	//	verify caller-specified baudrate
	//
	switch( comPort->baudRate )
	{
		case FP_Speed_921k:
		case FP_Speed_460k:
		case FP_Speed_115k:
			break ;
		default:
			result = RESULT_TOOL_INVALID_VALUE ;
			goto _cleanup ;
	}

	saveBaudRate = comPort->baudRate ;
	comPort->baudRate = COMPORT_BAUDRATE_115K ;


		//
		//	open the COM port
		//
	result = TOOL_OpenComPort( comPort ,NOPARITY) ;
	if( RESULT_OK != result ) 
	{
			
		goto _cleanup ;
	}
#if 1
	if (cDriverType==DRV_PREBOOT)
	{
		fileBuffer = (UInt8*)calloc(1,hPrebootDrvSize[0]) ;
		memcpy((void *)fileBuffer,(void *)hPrebootDrv[0],hPrebootDrvSize[0]);
		result = TOOL_WriteComPortWithTimeout( comPort, fileBuffer, sizeof(hPrebootDrv)/2, TIMEOUT_SEC ) ;

	}
	if (cDriverType==DRV_NOR)
	{
		fileBuffer = (UInt8*)calloc(1,hNorDriverSize[0]) ;
		memcpy((void *)fileBuffer,(void *)hNorDriver[0],hNorDriverSize[0]);
		result = TOOL_WriteComPortWithTimeout( comPort, fileBuffer, sizeof(hNorDriver)/2, TIMEOUT_SEC ) ;
	}
	if (cDriverType==DRV_NAND)
	{
		fileBuffer = (UInt8*)calloc(1,hNandDriverSize[0]) ;
		memcpy((void *)fileBuffer,(void *)hNandDriver[0],hNandDriverSize[0]);
		result = TOOL_WriteComPortWithTimeout( comPort, fileBuffer, sizeof(hNandDriver)/2, TIMEOUT_SEC ) ;
	}

	if( RESULT_OK != result ) {
		goto _cleanup ;
	}
	
	//// FIXME: bypass to allow preboot download
	if(cDriverType==DRV_PREBOOT)
	{
		result=RESULT_OK;
		Sleep(1000*1);
		goto _cleanup ;
	}

	//Flash Type üũ
#endif	
	Sleep(1000*3);
	if (cDriverType==DRV_NOR)
		result=TOOL_FlashIDCheck(comPort,0,0xc9);
	else
		result=TOOL_FlashIDCheck(comPort,1,0xc9);
	
//	Sleep(500);
	result=TOOL_ReadComPortWithTimeout(comPort, &IDTYPE, 1, TIMEOUT_SEC );
	

	result = RESULT_OK ;

	//
	//	clean up and exit
	//
_cleanup:
	//
	//	close com port unless in PC mode or error
	//
	OutputDebugString("Updater: Closing ComPort") ;
	TOOL_CloseComPort( comPort ) ;


	if( fp ) {
		fclose( fp ) ;
	}

	if( fileBuffer ) {
		free( fileBuffer ) ;
	}

	return result ;
}



UInt32 * GetFlashChecksum()
{
	return &flash_checksum;
}

int * GetBadBlk()
{
	return &m_FileSize;
}

int * GetIDType()
{
	return &IDTYPE;
}

UInt8 * GetDescription()
{
	return &DS;
}

Result_t TOOL_DownloadBootloader(ComPortCfg_t *comPort, UInt32 startAddress)
{

	UInt8			c,chksum;
	UInt8			*fileBuffer = 0 ;

	UInt32			image_size;
	Result_t		result ;

	OutputDebugString("Updater: Entering TOOL_DownloadImage") ;

	//
	//	verify caller-specified baudrate
	//
	switch( comPort->baudRate )
	{
		case FP_Speed_921k:
		case FP_Speed_460k:
		case FP_Speed_115k:
			break ;
		default:
			result = RESULT_TOOL_INVALID_VALUE ;
			goto _cleanup ;
	}

	result = TOOL_OpenComPort( comPort,NOPARITY ) ;
	if( RESULT_OK != result ) 
	{
		goto _cleanup ;
	}

	image_size = hBootloaderSize[0];
	fileBuffer = (UInt8*)calloc(1,hBootloaderSize[0]) ;
	memcpy((void *)fileBuffer,(void *)hBootloader[0],hBootloaderSize[0]);
		

	// Sending FP_StartReq
	c = FP_StartReq ;
	result = TOOL_WriteComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
	if( RESULT_OK != result ) {
		goto _cleanup ;
	}

	while(1) 
	{
		
		result = TOOL_ReadComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
		
		if( RESULT_OK != result ) 
		{
			goto _cleanup ;
		}

		if( c == FP_StartOK ) 
		{	
			// Received FP_StartOK
			UInt32 bs ;
		
			bs = TOOL_SwapU32( startAddress ) ;
			result = TOOL_WriteComPortWithTimeout( comPort, &bs, 4, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) {
				goto _cleanup ;
			}

			bs = TOOL_SwapU32( image_size ) ;
			result = TOOL_WriteComPortWithTimeout( comPort, &bs, 4, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) {
				goto _cleanup ;
			}
		}

		else if( c ==  FP_ImageOK ) 
		{
			// Received FP_ImageOK
			c = FP_RequestBlockSize ;
			result = TOOL_WriteComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) {
				goto _cleanup ;
			}
		}

		else if( c ==  FP_AddrWrong ) 
		{
			// Received FP_AddrWrong
			result = RESULT_TOOL_ADDRESS_INVALID ;
			goto _cleanup ;
		}

		else if( c ==  FP_ImageTooLarge ) {
			// Received FP_ImageTooLarge
			result = RESULT_TOOL_ADDRESS_INVALID ;
			goto _cleanup ;
		}

		else if( c ==  FP_ReturnBlockSize ) 
		{
			// Received FP_ReturnBlockSize
			UInt32 bs ;
			result = TOOL_ReadComPortWithTimeout( comPort, &bs, 4, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}

			result = TOOL_WriteComPortWithTimeout( comPort, fileBuffer, sizeof(hBootloader)/2, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}
			chksum = _GetCheckSum( UART_MODE,fileBuffer, sizeof(hBootloader)/2 ) ;

			result = TOOL_WriteComPortWithTimeout( comPort, &chksum, 1, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				return result ;
			}
		}

		else if( c ==  FP_SectorOK ) 
		{
			// Received FP_SectorOK
			c = FP_RequestBlockSize ;
			result = TOOL_WriteComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}
		}

		else if( c ==  FP_Resend ) 
		{
			// Received FP_Resend
			result = TOOL_WriteComPortWithTimeout( comPort, fileBuffer, sizeof(hBootloader)/2, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) {
				goto _cleanup ;
			}
		}

		else if( c ==  FP_Failed ) 
		{
			// Received FP_Failed
			result = RESULT_TOOL_SYNC_ERROR ;
			goto _cleanup ;
		}

		else if( c ==  FP_Finished ) {
			// Received FP_Finished
			result = RESULT_OK ;
			goto _cleanup ;
		}

		else 
		{
			// Unknown Error
			result = RESULT_TOOL_INTERNAL_ERROR ;
			goto _cleanup ;
		}
	}

_cleanup:
	//
	//	close com port unless in error
	//

	TOOL_CloseComPort( comPort ) ;


	return result ;
}

UInt8* TOOL_GetResultStr( Result_t result )
{
	switch( result ) 
	{

		case RESULT_OK:
			return (UInt8*)"OK" ;

		case RESULT_ERROR:
			return (UInt8*)"Error" ;

		case RESULT_TOOL_INVALID_ARG:
			return (UInt8*)"Invalid argument" ;

		case RESULT_TOOL_FILE_OPEN_ERROR:
			return (UInt8*)"File open error" ;

		case RESULT_TOOL_FILE_CREATE_ERROR:
			return (UInt8*)"File create error" ;

		case RESULT_TOOL_FILE_READ_ERROR:
			return (UInt8*)"File read error" ;

		case RESULT_TOOL_FILE_WRITE_ERROR:
			return (UInt8*)"File write error" ;

		case RESULT_TOOL_INTERNAL_ERROR:
			return (UInt8*)"Internal error" ;

		case RESULT_TOOL_INCFILE_ERROR:
			return (UInt8*)"Include file error" ;

		case RESULT_TOOL_INVALID_KEYWORD:
			return (UInt8*)"Invalid keyword" ;

		case RESULT_TOOL_WRONG_NUM_OF_PARMS:
			return (UInt8*)"Wrong number of parameters" ;

		case RESULT_TOOL_INVALID_VALUE:
			return (UInt8*)"Invalid value" ;

		case RESULT_TOOL_COMPORT_ERROR:
			return (UInt8*)"COM port error" ;

		case RESULT_TOOL_SYNC_ERROR:
			return (UInt8*)"Synchronization error" ;

		case RESULT_TOOL_TIMEOUT:
			return (UInt8*)"No respone at the target phone" ;

		case RESULT_TOOL_ADDRESS_INVALID:
			return (UInt8*)"Invalid image address" ;

		case RESULT_TOOL_INVALID_IMEI:
			return (UInt8*)"Invalid IMEI - must be 14 digits" ;

		case RESULT_TOOL_INVALID_MCC_MNC:
			return (UInt8*)"Invalid MCC/MNC" ;

		case RESULT_TOOL_WRONG_ORDER_SIMLOCK_CODES:
			return (UInt8*)"Wrong order of SIMLOCK codes" ;

		case RESULT_TOOL_INVALID_IMSI:
			return (UInt8*)"Invalid IMSI" ;

		case RESULT_TOOL_SECBOOT_CMD_INVALID:
			return (UInt8*)"Secure loader command ID invalid" ;

		case RESULT_TOOL_SECBOOT_FORMAT_INVALID:
			return (UInt8*)"Secure loader command format invalid" ;

		case RESULT_TOOL_SECBOOT_BAUDRATE_INVALID:
			return (UInt8*)"Secure loader baud rate invalid" ;

		case RESULT_TOOL_SECBOOT_CRC_ERROR:
			return (UInt8*)"Secure loader CRC error" ;

		case RESULT_TOOL_SECBOOT_MEMALIGN_ERROR:
			return (UInt8*)"Secure loader memory alignment error" ;

		case RESULT_TOOL_SECBOOT_FLASHPRGM_ERROR:
			return (UInt8*)"Secure loader flash programming error" ;

		case RESULT_TOOL_SECBOOT_OTHER_ERROR:
			return (UInt8*)"Secure loader error" ;

		case RESULT_TOOL_SECBOOT_PROTOCOL_ERROR:
			return (UInt8*)"Secure loader protocol error" ;

		case RESULT_TOOL_SECBOOT_BUFSIZE_ERROR:
			return (UInt8*)"Secure loader command or response length error" ;

		case RESULT_TOOL_SECBOOT_FILEOPEN_ERROR:
			return (UInt8*)"Secure loader file open error" ;

		case RESULT_TOOL_SYSPARM_WARNING:
			return (UInt8*)"System parameter warning" ;

		case RESULT_TOOL_SYSPARM_ERROR:
			return (UInt8*)"System parameter error" ;

		default:
			return (UInt8*)"Unexpected result code returned" ;
	}
}

//-----------------------------------------------------------------------------
//	Private functions
//-----------------------------------------------------------------------------

UInt32 TOOL_SwapU32( UInt32 u )
{
	UInt32 x = u ;
	x  = ( u & 0xff000000 ) >> 24 ;
	x |= ( u & 0x00ff0000 ) >> 8 ;
	x |= ( u & 0x0000ff00 ) << 8 ;
	x |= ( u & 0x000000ff ) << 24 ;
	return x ;
}

UInt16 TOOL_SwapU16( UInt16 u )
{
	UInt16 x = u ;
	x  = ( u & 0xff00 ) >> 8 ;
	x |= ( u & 0x00ff ) << 8 ;
	return x ;
}

static UInt8 _GetCheckSum(UInt8 mode,
	UInt8	*buff,
	UInt32	sector_size
	)
{
	UInt32	i;
	UInt8	check_sum;

	check_sum = 0;
	for( i=0; i<sector_size; i++ ){
		check_sum += buff[i];
	}
//speed
	if ((mode==UART_MODE) && (sector_size<128*1024))
		Sleep(200);

	return( check_sum );
}

static Boolean _GetSector(UInt8 mode,
	FILE	*fp,
	UInt8	*buff,
	UInt32	sector_size
	)
{
	UInt32	i;

	for( i=0; i<sector_size; i++ ){
		buff[i] = 0;
		if( fread( &buff[i], 1 , 1, fp ) != 1 ){
			return( FALSE );
		}
	}
//speed          
	if ((mode==UART_MODE) && (sector_size<128*1024))
		Sleep(1000*1);
	
	return( TRUE );
}


static void _PrintChecksum(ToolProgressCb_t progressCb,int flag)
{
	if( progressCb ) 
	{
			progressCb( TRUE,TRUE,flag,0,FALSE) ;	// report end of sector
	}
}

Result_t _SendSector(UInt8 mode,
	ComPortCfg_t* comPort,
	UInt8	*buff,
	UInt32	sector_size,
	ToolProgressCb_t progressCb,
	UInt32 nAddress
	)
{
	UInt32	sectorBytesWritten;
	UInt8	sFlag=0;
	Result_t result ;

	for( sectorBytesWritten=0; sectorBytesWritten<sector_size;)
	{
		UInt32 nWrite = min(1024,sector_size-sectorBytesWritten) ;
		result = TOOL_WriteComPortWithTimeout( comPort, (UInt8*)buff+sectorBytesWritten, nWrite, TIMEOUT_SEC ) ;
		if( RESULT_OK != result ) 
		{
			return result ;
		}
		sectorBytesWritten = sectorBytesWritten + nWrite;

		if( progressCb )
		{	
			//progressCb : Ű
			//Progress ǥ(TRUE,FALSE), Checksumǥ(TRUE,FALSE) ,ּҰ+ó,ٿεũ
				progressCb( FALSE,FALSE,sector_size,sector_size,FALSE) ;
		}
	}


	if( progressCb ) 
	{
		//progressCb : Ű
		//Progress ǥ(TRUE,FALSE), Checksumǥ(TRUE,FALSE) ,ּҰ+ó,ٿεũ
		progressCb( TRUE,FALSE,nAddress,sector_size,FALSE) ;	// report end of sector
	}
if(mode!=USB_MODE){
	chksum = _GetCheckSum( mode,buff, sector_size ) ;
/*	
        if (mode==UART_MODE)
             Sleep(500);
*/
	//üũ ۽ 
	result = TOOL_WriteComPortWithTimeout( comPort, &chksum, 1, TIMEOUT_SEC );
	//üũ 
	result = TOOL_ReadComPortWithTimeout( comPort, &rchksum,1, TIMEOUT_SEC);

	if( RESULT_OK != result ) 
	{
		return result ;
	}
	else
	{	//   üũ pc üũ Ѵ.
		if (chksum!=rchksum)
		{
			//progressCb : Ű
			//Progress ǥ(TRUE,FALSE), Checksumǥ(TRUE,FALSE) ,ּҰ+ó,ٿεũ
			progressCb( FALSE,TRUE,1,sector_size,FALSE);

			return RESULT_ERROR;
		}
		else
			return RESULT_OK;
	}
}
	return RESULT_OK;
}


Result_t _SendSectorUSB
(
 UInt8 mode,
 ComPortCfg_t* comPort,
 UInt8	*buff,
 UInt32	sector_size,
 UInt8 *checksum_out,
 ToolProgressCb_t progressCb,
 UInt32 nAddress
 )
{
	UInt32	sectorBytesWritten;
	UInt8	chksum ;
	Result_t result ;
	UInt8* ptemp = buff;
	/* Return the checksum */
	*checksum_out = _GetCheckSum( mode, ptemp, sector_size ) ;

	for( sectorBytesWritten=0; sectorBytesWritten<sector_size;)
{
		UInt32 nWrite = min(1024,sector_size-sectorBytesWritten) ;
		result = TOOL_WriteComPortWithTimeout( comPort, (UInt8*)buff+sectorBytesWritten, nWrite, TIMEOUT_SEC ) ;
		if( RESULT_OK != result )
 {
			return result ;
		}
		sectorBytesWritten = sectorBytesWritten + nWrite;

			if( progressCb )
		{	
			//progressCb : Ű
			//Progress ǥ(TRUE,FALSE), Checksumǥ(TRUE,FALSE) ,ּҰ+ó,ٿεũ
				progressCb( FALSE,FALSE,sector_size,sector_size,FALSE) ;
		}	
	}

	if( progressCb ) 
	{
		//progressCb : Ű
		//Progress ǥ(TRUE,FALSE), Checksumǥ(TRUE,FALSE) ,ּҰ+ó,ٿεũ
		progressCb( TRUE,FALSE,nAddress,sector_size,FALSE) ;	// report end of sector
	}
#ifdef SHOW_CHECKSUM
	  printf(" %x ", *checksum_out ) ;
#endif
	return RESULT_OK ;
}

static Result_t _SendSector_TFLASH(UInt8 mode,
	ComPortCfg_t* comPort,
	UInt8	*buff,
	UInt32	sector_size,
	ToolProgressCb_t progressCb,
	UInt32 nAddress
	)
{
	UInt32	sectorBytesWritten;
	UInt8	sFlag=0;
	Result_t result ;

	if( progressCb ) 
	{
		//progressCb : Ű
		//Progress ǥ(TRUE,FALSE), Checksumǥ(TRUE,FALSE) ,ּҰ+ó,ٿεũ
		progressCb( TRUE,FALSE,nAddress,sector_size,FALSE) ;	// report end of sector
	}
	return RESULT_OK;
}

static Result_t _RecvSector(
	ComPortCfg_t* comPort,
	UInt8	*buff,
	UInt32	sector_size,
	ToolProgressCbDump_t progressCb,
	UInt32 addr
	)
{
	UInt32	sectorBytesRead;
	UInt8	chksum ;
	Result_t result ;

	int i=0,cnt=0,j=0,written_cnt=0;;

	for( sectorBytesRead=0; sectorBytesRead<sector_size;){
		
		UInt32 nRead = min(1024,sector_size-sectorBytesRead) ;
		OutputDebugString("64") ;
		result = TOOL_ReadComPortWithTimeout( comPort, (UInt8*)buff+sectorBytesRead, nRead, TIMEOUT_SEC ) ;
		if( RESULT_OK != result ) {
			OutputDebugString("63") ;
			return result ;
		}
		sectorBytesRead = sectorBytesRead + nRead;

		if( progressCb ) {
			OutputDebugString("62") ;
			progressCb( FALSE,0x00 ,addr) ;
		}
	}
//	OutputDebugString("61") ;
	j=0;
	cnt=0;
	written_cnt=0;

	


	if( progressCb ) {
		progressCb( TRUE,&TFSMap,addr ) ;	// report end of sector
	}


	OutputDebugString("debugdebug  213134") ;
	
	if (progressCb)
	{
	
		result = TOOL_ReadComPortWithTimeout( comPort, &chksum, 1, TIMEOUT_SEC ) ;
		if( RESULT_OK != result ) {
			return result ;
		}

#if 0
		if( chksum != _GetCheckSum( mode,buff, sector_size ) ) {
			printf( "CHECKSUM ERROR\n" ) ;
			OutputDebugString("checksum error") ;
			return RESULT_ERROR ;
		}
#endif
	}

	return RESULT_OK ;
}

Result_t TOOL_GetBMI( ComPortCfg_t * comport,UInt8 nConnectMode)
{
	FLASHLOADER_Cmd_t cmd ;
	Result_t result;
	usb_message_t tx_msg;
	int msgSize = 0;
    int data[2];

if (nConnectMode==UART_MODE){
	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_BML_GETINFO ) ;
	cmd.p1	= TOOL_SwapU32( 0 ) ;
	cmd.p2	= TOOL_SwapU32( 0 ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	
	result = TOOL_WriteComPortWithTimeout(comport, &cmd, sizeof(cmd),TIMEOUT_SEC ) ;
}
else
{

	data[0]=TOOL_SwapU32(FLASHLOADER_CMD_BML_GETINFO);
	data[1]=0;
    memset(&tx_msg, 0, sizeof(tx_msg));
    /* build start request message */
    msgSize = BuildOutgoingMessage_OTHER(&tx_msg,data,2,0);
    msgSize <<=2;		/* in bytes */

     result = TOOL_WriteComPortWithTimeout(comport, (UInt8*)&tx_msg, msgSize, TIMEOUT_SEC);

}

	Sleep(500);
	return result;
}
Result_t TOOL_FlashIDCheck( ComPortCfg_t * comPort,int type,UInt8 nConnectMode)
{
	FLASHLOADER_Cmd_t cmd ;
	Result_t result;
	usb_message_t tx_msg;
	int msgSize = 0;
    int data[2];
	char bufff[40];
	

if (nConnectMode==UART_MODE){
	if (type==0)
	{
		cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_NOR_IDCHECK ) ;
		cmd.p1	= TOOL_SwapU32( 0 ) ;
		cmd.p2	= TOOL_SwapU32( 0 ) ;
		cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;
	}
	else
	{
		cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_NAND_IDCHECK ) ;
		cmd.p1	= TOOL_SwapU32( 0 ) ;
		cmd.p2	= TOOL_SwapU32( 0 ) ;
		cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;
	}
	result = TOOL_WriteComPortWithTimeout(comPort, &cmd, sizeof(cmd),TIMEOUT_SEC ) ;
	}
else{
		if (type==0)
	{
		data[0]=TOOL_SwapU32(FLASHLOADER_CMD_NOR_IDCHECK);

	}
	else
	{
		data[0]=TOOL_SwapU32(FLASHLOADER_CMD_NAND_IDCHECK);
	}

    data[1]=0;
    memset(&tx_msg, 0, sizeof(tx_msg));
    /* build start request message */
    msgSize = BuildOutgoingMessage_OTHER(&tx_msg,data,2,0);
    msgSize <<=2;		/* in bytes */

    result = TOOL_WriteComPortWithTimeout(comPort, (UInt8*)&tx_msg, msgSize, TIMEOUT_SEC);
}
	

//	Sleep(1000);
	return result;
}


Result_t TOOL_OpenComPort( ComPortCfg_t * comPort ,int nParity)
{
#ifndef _ttt_
	char comportname_in_unc[128] ;
	COMMTIMEOUTS	timeouts;
	//  To solve the problem of using COM port number greater than 9

	sprintf( comportname_in_unc, "\\\\.\\%s", (char*)comPort->comPortName ) ;
/*	
	comPort->sio = CreateFile(
		comportname_in_unc,
		GENERIC_READ | GENERIC_WRITE,
	    0,                    							// exclusive access
    	NULL,                 							// no security attrs
        OPEN_EXISTING,
	    FILE_ATTRIBUTE_NORMAL,
		NULL
		);
*/
	//to support USB serial port: automatically detect the port availability for 5 seconds
	{
		int cnt=0;
		do{
			comPort->sio = CreateFile(
					comportname_in_unc,
					GENERIC_READ | GENERIC_WRITE,
					0,                    							// exclusive access
    				NULL,                 							// no security attrs
        			OPEN_EXISTING,									
					FILE_ATTRIBUTE_NORMAL,
					NULL
					);

			cnt ++;
			printf("-") ;
			Sleep(100);
			if(cnt > 50)
			{
				printf("\n%s can not be opened\n", comPort->comPortName) ;
				return RESULT_TOOL_COMPORT_ERROR ;
			}
		}while(comPort->sio == INVALID_HANDLE_VALUE);
	}
	
	if( INVALID_HANDLE_VALUE == comPort->sio ) {
		return RESULT_TOOL_COMPORT_ERROR ;
	}

	comPort->olRead.hEvent = CreateEvent(
		NULL,    // no security
        TRUE,    // explicit reset req
        FALSE,   // initial event reset
        NULL ) ; // no name

	comPort->olWrite.hEvent = CreateEvent(
		NULL,    // no security
        TRUE,    // explicit reset req
        FALSE,   // initial event reset
        NULL ) ; // no name
#if 1	
#if 0
	timeouts.ReadIntervalTimeout = 0xFFFFFFFF;
	timeouts.ReadTotalTimeoutMultiplier = 1;
	timeouts.ReadTotalTimeoutConstant = 2;
	timeouts.WriteTotalTimeoutMultiplier = 1;
	timeouts.WriteTotalTimeoutConstant = 2;



#else
	timeouts.ReadIntervalTimeout = MAXDWORD;
	timeouts.ReadTotalTimeoutMultiplier = 0;
	timeouts.ReadTotalTimeoutConstant = 0;
//	timeouts.WriteTotalTimeoutMultiplier = 2; //2*9600/115200;
//	timeouts.WriteTotalTimeoutMultiplier = 2*9600/115200;;
//	timeouts.WriteTotalTimeoutConstant = ; //0;
	timeouts.WriteTotalTimeoutMultiplier = 0;
	timeouts.WriteTotalTimeoutConstant = 2*9600/115200;;
#endif




	SetCommTimeouts( comPort->sio, &timeouts);
	
#endif
	GetCommState( comPort->sio, &comPort->dcb ) ;

	comPort->dcb.BaudRate = ComportBaudRateToDcbBaudRate( comPort->baudRate ) ;
	if( !comPort->dcb.BaudRate ) {
		return RESULT_TOOL_INVALID_VALUE ;
	}

	comPort->dcb.ByteSize = 8 ;
	comPort->dcb.Parity   = NOPARITY ;
	comPort->dcb.StopBits = ONESTOPBIT ;
	comPort->dcb.fOutxCtsFlow = FALSE;
	comPort->dcb.fOutxDsrFlow = FALSE;
	comPort->dcb.fInX     = 0 ;
	comPort->dcb.fOutX    = 0 ;
	comPort->dcb.fBinary = TRUE ;
	comPort->dcb.fParity = TRUE ;

	SetCommState( comPort->sio, &comPort->dcb ) ;
    SetCommMask( comPort->sio, EV_RXCHAR ) ;
    SetupComm( comPort->sio, 4096, 4096 ) ;
    PurgeComm( comPort->sio, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR ) ;

	return RESULT_OK ;
#else
	char comportname_in_unc[128] ;
	COMMTIMEOUTS	timeouts;
	//  To solve the problem of using COM port number greater than 9

	sprintf( comportname_in_unc, "\\\\.\\%s", (char*)comPort->comPortName ) ;
	
	


	comPort->sio = CreateFile(
		comportname_in_unc,
		GENERIC_READ | GENERIC_WRITE,
	    0,                    							// exclusive access
    	NULL,                 							// no security attrs
        OPEN_EXISTING,
	    FILE_ATTRIBUTE_NORMAL,
		NULL
		);

	
#if 1	
	if (!EscapeCommFunction(comPort->sio, SETDTR))
	{
		LPVOID lpMsgBuf;

		FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
					  FORMAT_MESSAGE_FROM_SYSTEM, NULL, GetLastError(),
					  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
					  (LPTSTR) &lpMsgBuf, 0, NULL);
		fprintf(stderr, "%s\n", (LPTSTR) lpMsgBuf);
		LocalFree(lpMsgBuf);

		return RESULT_TOOL_COMPORT_ERROR;
	}
#endif
	
	
	comPort->olRead.Offset=0;
	comPort->olRead.OffsetHigh=0;
	comPort->olRead.hEvent = CreateEvent(
		NULL,    // no security
        TRUE,    // explicit reset req
        FALSE,   // initial event reset
        NULL ) ; // no name
	
	comPort->olWrite.Offset=0;
	comPort->olWrite.OffsetHigh=0;
	comPort->olWrite.hEvent = CreateEvent(
		NULL,    // no security
        TRUE,    // explicit reset req
        FALSE,   // initial event reset
        NULL ) ; // no name

/*	comPort->olRead.hEvent = CreateEvent(
		NULL,    // no security
        TRUE,    // explicit reset req
        FALSE,   // initial event reset
        NULL ) ; // no name

	comPort->olWrite.hEvent = CreateEvent(
		NULL,    // no security
        TRUE,    // explicit reset req
        FALSE,   // initial event reset
        NULL ) ; // no name*/

	if( INVALID_HANDLE_VALUE == comPort->sio ) {
			CloseHandle(comPort->sio);
			return RESULT_TOOL_COMPORT_ERROR ;
		}
#if 1	
#if 1
	timeouts.ReadIntervalTimeout = 0xFFFFFFFF;
	timeouts.ReadTotalTimeoutMultiplier = 1;
	timeouts.ReadTotalTimeoutConstant = 2;
	timeouts.WriteTotalTimeoutMultiplier = 1;
	timeouts.WriteTotalTimeoutConstant = 2;



#else
	timeouts.ReadIntervalTimeout = MAXDWORD;
	timeouts.ReadTotalTimeoutMultiplier = 0;
	timeouts.ReadTotalTimeoutConstant = 0;
//	timeouts.WriteTotalTimeoutMultiplier = 2; //2*9600/115200;
//	timeouts.WriteTotalTimeoutMultiplier = 2*9600/115200;;
//	timeouts.WriteTotalTimeoutConstant = ; //0;
	timeouts.WriteTotalTimeoutMultiplier = 0;
	timeouts.WriteTotalTimeoutConstant = 2*9600/115200;;
#endif




	SetCommTimeouts( comPort->sio, &timeouts);
	
#endif
	GetCommState( comPort->sio, &comPort->dcb ) ;

	switch( comPort->baudRate ) 
	{
		case COMPORT_BAUDRATE_115K:
			comPort->dcb.BaudRate = 115200;
			//comPort->dcb.BaudRate = 90000;
			break ;
		case COMPORT_BAUDRATE_460K:
			comPort->dcb.BaudRate = 460800 ;
			break ;
		case COMPORT_BAUDRATE_812K:
			comPort->dcb.BaudRate = 812000 ;
			break ;
		case COMPORT_BAUDRATE_921K:
			comPort->dcb.BaudRate = 921600 ;

			break ;
		default:
			return RESULT_TOOL_INVALID_VALUE ;
	}
	comPort->dcb.DCBlength = sizeof( DCB ) ;
	comPort->dcb.ByteSize = 8 ;
	comPort->dcb.Parity   = nParity ;
	comPort->dcb.StopBits = ONESTOPBIT ;
	comPort->dcb.fOutxCtsFlow = FALSE;
	comPort->dcb.fOutxDsrFlow = FALSE;
	comPort->dcb.fInX     = 0 ;
	comPort->dcb.fOutX    = 0 ;
	comPort->dcb.fBinary = TRUE ;
	comPort->dcb.fParity = TRUE ;
	comPort->dcb.fRtsControl= RTS_CONTROL_TOGGLE ;
		
	SetCommState( comPort->sio, &comPort->dcb ) ;
    SetCommMask( comPort->sio, EV_RXCHAR ) ;
    SetupComm( comPort->sio, 4096, 4096 ) ;
    PurgeComm( comPort->sio, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR ) ;

	return RESULT_OK ;
#endif
}

Result_t TOOL_WriteComPort( ComPortCfg_t * comPort, void * buf, UInt32 bufLen, UInt32 * nWrite )
{
#if 0//FEATURE_EUR
	//
	//	USB->serial converter occasionally crashes ("goes blue-screen") on large data
	//	transfers; this will meter large transfers
	//
#define MAX_XFER_SIZE 0x8000
	if( bufLen > MAX_XFER_SIZE ) bufLen = MAX_XFER_SIZE  ;
	
	if( !WriteFile( comPort->sio, buf, bufLen, nWrite, &comPort->olWrite ) ) 
	{
		return RESULT_TOOL_COMPORT_ERROR ;
	}
	
	return RESULT_OK ;
#endif

	//  FEATURE_EUR
	//	USB->serial converter occasionally crashes ("goes blue-screen") on large data
	//	transfers; this will meter large transfers
	//
#define MAX_XFER_SIZE 0x8000
	
	DWORD	dwWritten, dwError, dwErrorFlags;
	COMSTAT	comstat;
	
	if( bufLen > MAX_XFER_SIZE ) bufLen = MAX_XFER_SIZE  ;
	
	if( !WriteFile( comPort->sio, buf, bufLen, nWrite, &comPort->olWrite ) ) 
	{
		if (GetLastError() == ERROR_IO_PENDING)
		{
			//  ڰ  ְų  ڰ    Overapped IO
			// Ư  ERROR_IO_PENDING  ޽ ޵ȴ.
			// timeouts  ðŭ ٷش.
			while (! GetOverlappedResult(comPort->sio, &comPort->olWrite, nWrite, TRUE))
			{
				dwError = GetLastError();
				if (dwError != ERROR_IO_INCOMPLETE)
				{
					ClearCommError(comPort->sio, &dwErrorFlags, &comstat);
					break;
				}
			}
		}
		else
		{
			dwWritten = 0;
			ClearCommError( comPort->sio, &dwErrorFlags, &comstat);
			return RESULT_TOOL_COMPORT_ERROR ;
		}		
	}
	return RESULT_OK ;
}

Result_t TOOL_WriteComPortAll( ComPortCfg_t * comPort, void * buf, UInt32 bufLen )
{
	UInt32	bytesRemaining = bufLen ;
	UInt8	*ioBufPtr = buf ;
	UInt32	nWrite ;

	while( bytesRemaining ) 
	{
		if( RESULT_OK != TOOL_WriteComPort( comPort, ioBufPtr, bytesRemaining, &nWrite ) ) 
		{
			return RESULT_TOOL_COMPORT_ERROR ;
		}

		
		bytesRemaining -= nWrite ;
		ioBufPtr += nWrite ;

		Sleep( 1 ) ;
	}

	return RESULT_OK ;
}

Result_t TOOL_ReadComPort( ComPortCfg_t * comPort, void * buf, UInt32 bufLen, UInt32 * nRead )
{
	if( !ReadFile( comPort->sio, buf, bufLen, nRead, &comPort->olRead ) )
	{
		return RESULT_TOOL_COMPORT_ERROR ;
	}
	return RESULT_OK ;
}

Result_t TOOL_ReadComPortAll( ComPortCfg_t * comPort, void * buf, UInt32 bufLen )
{
	UInt32	bytesRemaining = bufLen ;
	UInt8	*ioBufPtr = buf ;
	UInt32	nRead ;

	while( bytesRemaining ) 
	{
		if( RESULT_OK != TOOL_ReadComPort( comPort, ioBufPtr, bytesRemaining, &nRead ) ) 
		{
			return RESULT_TOOL_COMPORT_ERROR ;
		}

		bytesRemaining -= nRead ;
		ioBufPtr += nRead ;
	}

	return RESULT_OK ;
}

void TOOL_CloseFP()
{
	if( fp ) 
	{
		fclose( fp ) ;
	}
}

static UInt32 ComportBaudRateToDcbBaudRate( UInt8 comPortBaudRate )
{
	switch( comPortBaudRate ) 
	{
		case COMPORT_BAUDRATE_115K:
			return 115200;
		case COMPORT_BAUDRATE_460K:
			return 460800 ;
		case COMPORT_BAUDRATE_812K:
			return 812000 ;
		case COMPORT_BAUDRATE_921K:
			return 921600 ;
	}
	return 0 ;
}

static UInt8 DcbBaudRateToComportBaudRate( UInt32 dcbBaudRate )
{
	switch( dcbBaudRate ) 
	{
		case 115200:
			return COMPORT_BAUDRATE_115K;
		case 460800:
			return COMPORT_BAUDRATE_460K;
		case 812000:
			return COMPORT_BAUDRATE_812K;
		case 921600:
			return COMPORT_BAUDRATE_921K;
	}
	return 0 ;
}

Result_t TOOL_CloseComPort( ComPortCfg_t * comPort )
{
	CloseHandle( comPort->olRead.hEvent ) ;
	CloseHandle( comPort->olWrite.hEvent ) ;

	SetCommMask( comPort->sio, 0 ) ;
	PurgeComm( comPort->sio, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR ) ;
	Sleep(1000*1);
	CloseHandle( comPort->sio ) ;
	
	
	return RESULT_OK ;
}

//--------------------------------------------------------------------------------------------
//	Read and Write with timeout
//--------------------------------------------------------------------------------------------
#define SLEEP_INTERVAL_MSEC 5// msec

Result_t TOOL_WriteComPortWithTimeout( ComPortCfg_t * comPort, UInt8* buf, UInt32 bufLen, UInt8 toSec )
{
	UInt32	bytesRemaining = bufLen ;
	UInt8	*ioBufPtr = buf ;
	UInt32	nWrite ;
	UInt32	retry = toSec * 1000 / SLEEP_INTERVAL_MSEC ;
	UInt32	count = retry ;

	while( bytesRemaining ) {
		if( RESULT_OK != TOOL_WriteComPort( comPort, ioBufPtr, bytesRemaining, &nWrite ) ) {
			return RESULT_TOOL_COMPORT_ERROR ;
		}

		if( nWrite ) {
			count = retry ;
		}
		else {
			Sleep( SLEEP_INTERVAL_MSEC ) ;
			if( !count-- ) {
				return RESULT_TOOL_TIMEOUT ;
			}
		}
		bytesRemaining -= nWrite ;
		ioBufPtr += nWrite ;
	}

	return RESULT_OK ;
}

UInt8 TOOL_ChangeComPortBaudRate( void * comPortPtr, UInt8 comPortBaudRate )
{
	ComPortCfg_t * comPort = comPortPtr ;
	UInt8 prevComPortBaudRate ;

	GetCommState( comPort->sio, &comPort->dcb ) ;

	prevComPortBaudRate = DcbBaudRateToComportBaudRate( comPort->dcb.BaudRate ) ;

	comPort->dcb.BaudRate = ComportBaudRateToDcbBaudRate( comPortBaudRate ) ;
	if( !comPort->dcb.BaudRate )
	{
		return RESULT_TOOL_INVALID_VALUE ;
	}

	SetCommState( comPort->sio, &comPort->dcb ) ;
    PurgeComm( comPort->sio, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR ) ;

	return prevComPortBaudRate ;
}

Result_t TOOL_ReadComPortWithTimeout( ComPortCfg_t * comPort, UInt8  * buf, UInt32 bufLen, UInt8 toSec )
{
	UInt32	bytesRemaining = bufLen ;
	UInt8	*ioBufPtr = buf ;
	UInt32	nRead ;
	UInt32	retry = toSec * 1000 / SLEEP_INTERVAL_MSEC ;
	UInt32	count = retry ;

	while( bytesRemaining ) 
	{
		if( RESULT_OK != TOOL_ReadComPort( comPort, ioBufPtr, bytesRemaining, &nRead ) ) 
		{
			return RESULT_TOOL_COMPORT_ERROR ;
		}

		if( nRead ) 
		{
			count = retry ;
		}
		else 
		{
			Sleep( SLEEP_INTERVAL_MSEC ) ;
			if( !count-- ) 
			{
				return RESULT_TOOL_TIMEOUT ;
			}
		}

		bytesRemaining -= nRead ;
		ioBufPtr += nRead ;
	}

	return RESULT_OK ;
}


static UInt32 fsize( FILE * fp ) 
{
	int currentPos  ;
	int imageSize ;

	currentPos = ftell( fp ) ;

	fseek( fp, 0, SEEK_END ) ;

	imageSize = ftell( fp ) ;

	fseek( fp, currentPos, SEEK_SET ) ;

	return (UInt32) imageSize ;
}

//
//	Open port for flash download
//
void* TOOL_OpenDnldPort(UInt8 *devName,	UInt8	baudRateCode )
{
	ComPortCfg_t * comPort = 0 ;
	Result_t result ;
	Boolean comPortOpen = FALSE ;

	comPort = (ComPortCfg_t*)calloc( 1, sizeof( ComPortCfg_t ) ) ;
	if( !comPort ) 
	{
		result = RESULT_TOOL_INTERNAL_ERROR ;
		goto _error ;
	}

	strcpy( (char*)comPort->comPortName, (char*)devName ) ;
	comPort->baudRate = baudRateCode ;

	result =TOOL_OpenComPort(comPort,NOPARITY) ;
	if( RESULT_OK != result ) 
	{
		goto _error ;
	}

	Sleep( 1000 ) ;

	return comPort ;

_error:
	if( comPortOpen && comPort ) 
	{
		TOOL_CloseComPort( comPort ) ;
	}
	if( comPort ) 
	{
		free( comPort ) ;
	}

	return 0 ;
}

//
//	Close flash download port
//
void TOOL_CloseDnldPort(
	void	*comPort ) 
{
	if( comPort ) {
		Sleep( 250 ) ;
		TOOL_CloseComPort( comPort ) ;
		free( comPort ) ;
	}
}

Result_t TOOL_Disconnect(void * comPort)
{
	FLASHLOADER_Cmd_t	cmd ;
	UInt8	*xferBuf = 0 ;
	Result_t	result ;
	int size=0;
	
	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_EXIT_DRIVER ) ;
	cmd.p1	= TOOL_SwapU32( 0 ) ;
	cmd.p2	= TOOL_SwapU32( 0 ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;

	return result;
}

Result_t TOOL_TFSformat(void *comPort,UInt8 nConnectMode)
{

	FLASHLOADER_Cmd_t	cmd ;
	UInt8		 *xferBuf = 0 ;
	Result_t	result ;
	int size=0;
	usb_message_t tx_msg;
	int msgSize = 0;
    int data[2];

if (nConnectMode==UART_MODE){
	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_TFS_FORMAT ) ;
	cmd.p1	= TOOL_SwapU32( 0xE00000 ) ;
	cmd.p2	= TOOL_SwapU32(  0x20000 ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;
	}
else{
    data[0]=TOOL_SwapU32(FLASHLOADER_CMD_TFS_FORMAT);
    data[1]=0;
    memset(&tx_msg, 0, sizeof(tx_msg));
    /* build start request message */
    msgSize = BuildOutgoingMessage_TFS(&tx_msg,data,2,0);
    msgSize <<=2;		/* in bytes */

    result = TOOL_WriteComPortWithTimeout(comPort, (UInt8*)&tx_msg, msgSize, TIMEOUT_SEC);
	}
	Sleep(1000*1);

	return result;

}

Result_t TOOL_CMD(void *comPort,UInt32 type,UInt8 nConnectMode)
{

	FLASHLOADER_Cmd_t	cmd ;
	UInt8		 *xferBuf = 0 ;
	Result_t	result ;
	int size=0;
	usb_message_t tx_msg;
	int msgSize = 0;
    int data[2];

if (nConnectMode==UART_MODE){
	cmd.id	= TOOL_SwapU32( type ) ;
	cmd.p1	= TOOL_SwapU32( 0 ) ;
	cmd.p2	= TOOL_SwapU32(  0 ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;
	}
else{

	data[0]=TOOL_SwapU32(type);
    data[1]=0;
    memset(&tx_msg, 0, sizeof(tx_msg));
    /* build start request message */
    msgSize = BuildOutgoingMessage_TFS(&tx_msg,data,2,0);
    msgSize <<=2;		/* in bytes */

    result = TOOL_WriteComPortWithTimeout(comPort, (UInt8*)&tx_msg, msgSize, TIMEOUT_SEC);
	
}
//	Sleep(100);

	return result;

}

Result_t TOOL_CMD2(void *comPort,UInt32 type,UInt8 nConnectMode,UInt8 data_usb)
{

	FLASHLOADER_Cmd_t	cmd ;
	UInt8		 *xferBuf = 0 ;
	Result_t	result ;
	int size=0;
	usb_message_t tx_msg;
	int msgSize = 0;
    int data[2];

if (nConnectMode==UART_MODE){
	cmd.id	= TOOL_SwapU32( type ) ;
	cmd.p1	= TOOL_SwapU32( 0 ) ;
	cmd.p2	= TOOL_SwapU32(  0 ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;
	}
else{

	data[0]=TOOL_SwapU32(type);
    data[1]=data_usb;
    memset(&tx_msg, 0, sizeof(tx_msg));
    /* build start request message */
    msgSize = BuildOutgoingMessage_TFS(&tx_msg,data,2,0);
    msgSize <<=2;		/* in bytes */

    result = TOOL_WriteComPortWithTimeout(comPort, (UInt8*)&tx_msg, msgSize, TIMEOUT_SEC);
	
}
//	Sleep(100);

	return result;

}

Result_t TOOL_CMD3(void *comPort,UInt32 type,UInt8 nConnectMode,UInt32* data_usb, UInt32 nParam)
{
	
	FLASHLOADER_Cmd_t	cmd ;
	UInt8		 *xferBuf = 0 ;
	Result_t	result ;
	int size=0;
	usb_message_t tx_msg;
	int msgSize = 0;
    int data[8];
#if 0	
	if (nConnectMode==UART_MODE)
	{
		cmd.id	= TOOL_SwapU32( type ) ;
		cmd.p1	= TOOL_SwapU32( 0 ) ;
		cmd.p2	= TOOL_SwapU32(  0 ) ;
		cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;
		
		result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;
	}
	else{
		
		data[0]=TOOL_SwapU32(type);
		for(int i=0; i<nParam; i++)
		{
			data[i+1]=(int)(*(data_usb+i));
		}
		memset(&tx_msg, 0, sizeof(tx_msg));
		/* build start request message */
		msgSize = BuildOutgoingMessage_TFS(&tx_msg,data, nParam,0);
		msgSize <<=2;		/* in bytes */
		
		result = TOOL_WriteComPortWithTimeout(comPort, (UInt8*)&tx_msg, msgSize, TIMEOUT_SEC);
		
	}
	//	Sleep(100);
#endif	
	return result;
	
}


Result_t TOOL_BMLformat(void *comPort)
{

	FLASHLOADER_Cmd_t	cmd ;
	UInt8		 *xferBuf = 0 ;
	Result_t	result ;
	int size=0;


	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_BML_FORMAT ) ;
	cmd.p1	= TOOL_SwapU32( 0 ) ;
	cmd.p2	= TOOL_SwapU32( 0 ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;

	Sleep(1000*5);

	return result;

}


Result_t TOOL_SetTime(void *comPort,char * cTime,UInt8 nConnectMode)
{

	FLASHLOADER_Cmd_t	cmd ;
	UInt8	 *xferBuf = 0 ;
	UInt8	cAck=0;
	Result_t	result ;
	int size=0,i;
	usb_message_t tx_msg;
	int msgSize = 0;
    int data[2];


if (nConnectMode==UART_MODE){
	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_SET_DATE ) ;
	cmd.p1	= TOOL_SwapU32( 0 ) ;
	cmd.p2	= TOOL_SwapU32( 0 ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;
}
else{

	data[0]=TOOL_SwapU32(FLASHLOADER_CMD_SET_DATE);
    data[1]=0;
    memset(&tx_msg, 0, sizeof(tx_msg));
    /* build start request message */
    msgSize = BuildOutgoingMessage_OTHER(&tx_msg,data,2,0);
    msgSize <<=2;		/* in bytes */

    result = TOOL_WriteComPortWithTimeout(comPort, (UInt8*)&tx_msg, msgSize, TIMEOUT_SEC);

}

	Sleep(500);
	cAck=0x0;
	
	i=strlen(cTime);
	result = TOOL_WriteComPortWithTimeout(comPort,cTime, 8 ,TIMEOUT_SEC ) ;

	Sleep(1000*1);

	return result;

}

Result_t TOOL_FlashErase(void *comPort,UInt8 type,UInt8 nConnectMode)
{

	FLASHLOADER_Cmd_t	cmd ;
	UInt8	 *xferBuf = 0 ;
	UInt8	cAck=0;
	Result_t	result ;
	int size=0;
	usb_message_t tx_msg;
	int msgSize = 0;
    int data[2];


if (nConnectMode==UART_MODE){
	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_NAND_ALLERASE ) ;
	if (type==OP_ERASE_BOOTLOADER)
	cmd.p1	= TOOL_SwapU32( 1 ) ;
	else
	cmd.p1	= TOOL_SwapU32( 0 ) ;
	
	cmd.p2	= TOOL_SwapU32( 0 ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;
	}
else{
	
	data[0]=TOOL_SwapU32(FLASHLOADER_CMD_NAND_ALLERASE);
	if (type==OP_ERASE_BOOTLOADER)
	data[1]=TOOL_SwapU32( 1 );
	else
	data[1]=TOOL_SwapU32( 0 );

    memset(&tx_msg, 0, sizeof(tx_msg));
    /* build start request message */
    msgSize = BuildOutgoingMessage_OTHER(&tx_msg,data,2,0);
    msgSize <<=2;		/* in bytes */

    result = TOOL_WriteComPortWithTimeout(comPort, (UInt8*)&tx_msg, msgSize, TIMEOUT_SEC);

	}
	
	if (type!=OP_ERASE_BOOTLOADER)
	{
		cAck=0x0;
		while(RESULT_OK==TOOL_ReadComPortWithTimeout(comPort,&cAck,1,30))
		{
			if (cAck==0x46)
				break;
		}

		cAck=0x0;
		while(RESULT_OK==TOOL_ReadComPortWithTimeout(comPort,&cAck, 1,30 ))
		{
			//0xB9 --> Ack(nand all erase finished) from MS
			if (cAck==0xB9)
				break;
		}
	}

	Sleep(1000*1);

	return result;

}

Result_t TOOL_NorFlashDownload(	UInt8 mode, void *comPort,UInt8 *imageListName,UInt32 startAddress,	UInt32 nSize, ToolProgressCb_t progressCb)
{
	FILE		*f = 0 ;
	FLASHLOADER_Cmd_t	cmd ;
	UInt8		*xferBuf = 0 ;
	UInt32		bytesDownloaded = 0;
	Result_t	result ;
	unsigned long nWritten=0;
	int bFail=0;
	
	int	bExit=0;

	f = fopen( imageListName, "rb" ) ;
	if( !f ) 
	{
		result = RESULT_TOOL_FILE_OPEN_ERROR ;
		goto _exit ;
	}

	xferBuf = (UInt8*)calloc( 1, 1024*1024 ) ;
	
	if( !xferBuf ) 
	{
		result = RESULT_TOOL_INTERNAL_ERROR ;
		goto _exit ;
	}
	
	for( ;; ) 
	{

		UInt32 xferBytes=0;
		UInt32 startAddr ;
		UInt32 imageSize ;


		if (startAddress==(UInt32)0xabcdefab || startAddress==(UInt32)0xbabeface)
		{
		
			//imgset, calset Ե ּҿ ̹  д´.
			if( fread( &startAddr, 4, 1, f ) != 1) 
			{
				break;
			}
			if( fread( &imageSize, 4, 1, f ) != 1 ) 
			{
				//printf ("read error\n");
				break;
			}
#if 0	
			if (startAddress==0xbabeface && startAddr==0x0)
			{
				
				fseek(f,imageSize,1);

				if( 1 != fread( &startAddr, 4, 1, f ) ) 
				{
					break;
				}
				if( 1 != fread( &imageSize, 4, 1, f ) ) 
				{
					//printf ("read error\n");
					break;
				}
				
			}
#endif
				startAddress=0xABCDEFAB;
		}
		else
		{
			if (bExit==1)
				break;

			startAddr=startAddress;
		
			//imageSize = filelength( fileno(f) );
		
			imageSize = nSize;

		
			bExit=1;
		}

		//0x0 ~ 0x10000 bootloadeṟ 
		// ´.
	/*	if (startAddr==0)
			startAddr=0x00010000;*/
		cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_NOR_LOAD_IMAGE ) ;
		cmd.p1	= TOOL_SwapU32( startAddr ) ;
		cmd.p2	= TOOL_SwapU32( imageSize ) ;
		cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

		result = TOOL_WriteComPortWithTimeout(comPort, &cmd, sizeof( cmd ),	TIMEOUT_SEC ) ;
	
		if( RESULT_OK != result ) 
		{
			goto _exit ;
		}
		
		nWritten=startAddr;

		if( progressCb ) 
		{
			progressCb( TRUE,TRUE,2,0 ,FALSE) ;
		}
		
		for( ;; ) 
		{
		
			UInt8 chksum,rslt;
		/*	UInt32 nWrite;
			int blk,blkrest,i,blklength;
			UInt32	sectorBytesWritten;
			Result_t result ;*/
			
			result = TOOL_ReadComPortWithTimeout(comPort,&xferBytes,sizeof( xferBytes ),TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				progressCb(TRUE,TRUE,6,0,FALSE);
				goto _exit ;
			}

			xferBytes = TOOL_SwapU32( xferBytes ) ;

			if( 0 == xferBytes ) break ;

			fread( xferBuf, 1, xferBytes, f ) ;

			

			result = TOOL_WriteComPortWithTimeout(comPort,xferBuf,xferBytes,TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				progressCb(TRUE,TRUE,6,0,FALSE);
				goto _exit ;
			}

			if( progressCb ) 
			{
				progressCb( TRUE,FALSE,nWritten,xferBytes ,FALSE) ;
				nWritten+=xferBytes;
			}

		
            if (mode==UART_MODE)
                Sleep(450);
            else
 		        Sleep(50);

			chksum = _GetCheckSum( mode,xferBuf, xferBytes ) ;
			result = TOOL_WriteComPortWithTimeout( comPort, &chksum, 1, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				return result ;
			}
			
			result = TOOL_ReadComPortWithTimeout( comPort, &rslt, 1, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				progressCb(TRUE,TRUE,6,0,FALSE);
				goto _exit;
			}
			if (rslt!=FP_SectorOK)
			{
				if (rslt==FP_Resend)	//resend
				{
					progressCb( TRUE,TRUE,3,0 ,FALSE) ;
					fseek(f,-xferBytes,SEEK_CUR);
					nWritten-=xferBytes;
				}
				else
				{
					if (rslt==FP_Failed)
						//Sync error
						progressCb( TRUE,TRUE,4,0 ,FALSE) ;
					else
						//Internal error
						progressCb( TRUE,TRUE,5,0,FALSE ) ;

					result=RESULT_TOOL_INTERNAL_ERROR;
					goto _exit;
				}
			}
			if( progressCb ) 
			{
				//checksum OK
				progressCb( TRUE,TRUE,0,chksum,FALSE) ;
			}
		
		}
		
		result = TOOL_ReadComPortWithTimeout( comPort, &flash_checksum, sizeof(flash_checksum), TIMEOUT_SEC ) ;
		if( RESULT_OK != result ) 
		{
			goto _exit;
			//return result ;
		}
		flash_checksum = TOOL_SwapU32( flash_checksum ) ;
	}

	
_exit:
	if( f ) {
		fclose( f ) ;
	}

	if( xferBuf ) {
		free( xferBuf ) ;
	}

	return result ;
}

Result_t TOOL_NorErase(	void *comPort,UInt32 startAddress,	ToolProgressCb_t progressCb)
{
	FLASHLOADER_Cmd_t	cmd ;
	UInt32		bytesDownloaded = 0;
	Result_t	result ;
	unsigned long nWritten=0;



	UInt32 xferBytes=0;
	UInt32 startAddr ;
	UInt32 imageSize ;

	if (startAddress==0x0)
	
		imageSize=0x10000;
	else
		//imageSize=0x1FE0000;
		imageSize=0x20000;
	
	
	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_NOR_ALLERASE );
	cmd.p1	= TOOL_SwapU32( startAddress ) ;
	cmd.p2	= TOOL_SwapU32( imageSize ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(comPort, &cmd, sizeof( cmd ),	TIMEOUT_SEC ) ;
	
	if( RESULT_OK != result ) 
	{
		goto _exit ;
	}

	if (startAddress==0 ||startAddress==0x1E90000)
	
		goto _exit;
	
	nWritten=startAddress;
	
	for( ;; ) 
	{
		
		UInt8 chksum,rslt;
		result = TOOL_ReadComPortWithTimeout(comPort,&xferBytes,sizeof( xferBytes ),TIMEOUT_SEC ) ;
		if( RESULT_OK != result ) 
		{
			progressCb(TRUE,TRUE,6,0,FALSE);
			goto _exit ;
		}
		xferBytes = TOOL_SwapU32( xferBytes ) ;
		if( 0 == xferBytes ) break ;

		if( progressCb ) 
		{
			progressCb( TRUE,FALSE,nWritten,xferBytes,TRUE ) ;
			nWritten+=xferBytes;
		}
	
		result = TOOL_ReadComPortWithTimeout( comPort, &rslt, 1, TIMEOUT_SEC ) ;
		if( RESULT_OK != result ) 
		{
			progressCb(TRUE,TRUE,6,0,FALSE);
			goto _exit;
		}
		if (rslt!=FP_SectorOK)
		{
			if (rslt==FP_Resend)
				//resend
				progressCb( TRUE,TRUE,3,0 ,FALSE) ;
			else
			{
				if (rslt==FP_Failed)
					//Sync error
					progressCb( TRUE,TRUE,4,0 ,FALSE) ;
				else
					//Internal error
					progressCb( TRUE,TRUE,5,0,FALSE ) ;
			}
				
			result=RESULT_TOOL_INTERNAL_ERROR;
			goto _exit;
		}
		if (nWritten==(imageSize+startAddress))
			break;
	}

	
_exit:
	return result ;
}

//
//	Flash images in image set
//

//JUN
Result_t TOOL_DownloadDriver(ComPortCfg_t 	*comPort) 
{
	int				numBytesDownloaded;
	int				bytesInFile;
	FILE  			*fp = 0 ;
	UInt8			c ;
	UInt8			*fileBuffer = 0 ;
	Result_t		result ;
	UInt8			saveBaudRate ;

	OutputDebugString("Updater: Entering TOOL_DownloadDriver") ;

	//
	//	allocate buffer and read file to memory
	//
	fileBuffer = (UInt8*)calloc(1,hPrebootDrvSize[0]) ;
	memcpy((void *)fileBuffer,(void *)hPrebootDrv[0],hPrebootDrvSize[0]);
	
	if( !fileBuffer ) {
		result = RESULT_TOOL_INTERNAL_ERROR ;
		goto _cleanup ;
	}

	//
	//	verify caller-specified baudrate
	//
	switch( comPort->baudRate )
	{
		case FP_Speed_115k:
		case FP_Speed_230k:
		case FP_Speed_460k:
		case FP_Speed_812k:
		case FP_Speed_921k:
			break ;
		default:
			result = RESULT_TOOL_INVALID_VALUE ;
			goto _cleanup ;
	}

	saveBaudRate = comPort->baudRate ;
	comPort->baudRate = COMPORT_BAUDRATE_115K ;

	//
	//	open the COM port
	//
	result = TOOL_OpenComPort( comPort,NOPARITY ) ;
	if( RESULT_OK != result ) 
	{
		goto _cleanup ;
	}
	

	//
	//	download
	//
	OutputDebugString("Updater: Downloading driver image");
	result = TOOL_WriteComPortWithTimeout( comPort, fileBuffer, sizeof(hPrebootDrv)/2, TIMEOUT_SEC ) ;
	if( RESULT_OK != result ) {
		goto _cleanup ;
	}

	Sleep( 250 ) ;

	result = RESULT_OK ;

	//
	//	clean up and exit
	//
_cleanup:
	//
	//	close com port unless in PC mode or error
	//
	if( RESULT_OK != result  ) 
	{
		if ( RESULT_OK != result )
		{
			OutputDebugString("Flash driver download error: Closing ComPort\n") ;
		}

		
	}

	TOOL_CloseComPort( comPort ) ;

	
	if( fileBuffer ) {
		free( fileBuffer ) ;
	}

	return result ;
}
Result_t TOOL_DownloadDriver_Itcm(ComPortCfg_t 	*comPort) 
{
	int				numBytesDownloaded;
	int				bytesInFile;
	FILE  			*fp = 0 ;
	UInt8			c ;
	UInt8			*fileBuffer = 0 ;
	Result_t		result ;
	UInt8			saveBaudRate ;

	OutputDebugString("Updater: Entering TOOL_DownloadDriver") ;

	//
	//	allocate buffer and read file to memory
	//
	fileBuffer = (UInt8*)calloc(1,hItcmDrvSize[0]) ;
	memcpy((void *)fileBuffer,(void *)hItcmDrv[0],hItcmDrvSize[0]);
	
	if( !fileBuffer ) {
		result = RESULT_TOOL_INTERNAL_ERROR ;
		goto _cleanup ;
	}

	//
	//	verify caller-specified baudrate
	//
	switch( comPort->baudRate )
	{
		case FP_Speed_115k:
		case FP_Speed_230k:
		case FP_Speed_460k:
		case FP_Speed_812k:
		case FP_Speed_921k:
			break ;
		default:
			result = RESULT_TOOL_INVALID_VALUE ;
			goto _cleanup ;
	}
/*
	saveBaudRate = comPort->baudRate ;
	comPort->baudRate = COMPORT_BAUDRATE_115K ;

	//
	//	open the COM port
	//
	result = TOOL_OpenComPort( comPort,NOPARITY ) ;
	if( RESULT_OK != result ) 
	{
		goto _cleanup ;
	}
*/

	//
	//	download
	//
	OutputDebugString("Updater: Downloading driver image");
	result = TOOL_WriteComPortWithTimeout( comPort, fileBuffer, sizeof(hItcmDrv)/2, TIMEOUT_SEC ) ;
	if( RESULT_OK != result ) {
		goto _cleanup ;
	}

	Sleep( 250 ) ;

	result = RESULT_OK ;

	//
	//	clean up and exit
	//
_cleanup:
	//
	//	close com port unless in PC mode or error
	//
	if( RESULT_OK != result  ) 
	{
		if ( RESULT_OK != result )
		{
			OutputDebugString("Flash driver download error: Closing ComPort\n") ;
		}

		
	}

	TOOL_CloseComPort( comPort ) ;

	
	if( fileBuffer ) {
		free( fileBuffer ) ;
	}

	return result ;
}

Result_t TOOL_DownloadDriver_Itcm_set_Baudrate(ComPortCfg_t 	*comPort) 
{
	int				numBytesDownloaded;
	int				bytesInFile;
	FILE  			*fp = 0 ;
	UInt8			c ;
	UInt8			*fileBuffer = 0 ;
	Result_t		result ;
	UInt8			saveBaudRate ;

	OutputDebugString("Updater: Entering TOOL_DownloadDriver") ;

	//
	//	allocate buffer and read file to memory
	//
	fileBuffer = (UInt8*)calloc(1,hItcmDrvSize[0]) ;
	memcpy((void *)fileBuffer,(void *)hItcmDrv[0],hItcmDrvSize[0]);
	
	if( !fileBuffer ) {
		result = RESULT_TOOL_INTERNAL_ERROR ;
		goto _cleanup ;
	}

	//
	//	verify caller-specified baudrate
	//
	switch( comPort->baudRate )
	{
		case FP_Speed_115k:
		case FP_Speed_230k:
		case FP_Speed_460k:
		case FP_Speed_812k:
		case FP_Speed_921k:
			break ;
		default:
			result = RESULT_TOOL_INVALID_VALUE ;
			goto _cleanup ;
	}

	saveBaudRate = comPort->baudRate ;
	comPort->baudRate = COMPORT_BAUDRATE_115K ;

	//
	//	open the COM port
	//
	result = TOOL_OpenComPort( comPort,NOPARITY ) ;
	if( RESULT_OK != result ) 
	{
		goto _cleanup ;
	}


	//
	//	download
	//
	OutputDebugString("Updater: Downloading driver image");
	result = TOOL_WriteComPortWithTimeout( comPort, fileBuffer, sizeof(hItcmDrv)/2, TIMEOUT_SEC ) ;
	if( RESULT_OK != result ) {
		goto _cleanup ;
	}

	Sleep( 250 ) ;

	result = RESULT_OK ;

	//
	//	clean up and exit
	//
_cleanup:
	//
	//	close com port unless in PC mode or error
	//
	if( RESULT_OK != result  ) 
	{
		if ( RESULT_OK != result )
		{
			OutputDebugString("Flash driver download error: Closing ComPort\n") ;
		}

		
	}

	TOOL_CloseComPort( comPort ) ;

	
	if( fileBuffer ) {
		free( fileBuffer ) ;
	}

	return result ;
}


Result_t TOOL_NandFlashDownload(UInt8 mode,
	void				*comPort,
	UInt8				*imageListName,
	UInt32				startAddress,
	ToolProgressCb_t	progressCb
)
{
	FILE		*fp = 0 ;
	FLASHLOADER_Cmd_t	cmd ;
	UInt8		c;
	UInt32		bytesDownloaded = 0 ,j=0;
	Result_t	result ;
	UInt32 image_size, sector_size;
	UInt8	sector_buff[FLASH_MAX_SECTOR_SIZE_BYTES];
	UInt32	nAddress=0;
	UInt16 count=0;
	UInt32	DownloadToByte;
	static	UInt16	sysparmFiles=0;
	static	UInt16	calFiles=0;
		


	fp = fopen( imageListName, "rb" ) ;
	if( !fp ) 
	{
		result = RESULT_TOOL_FILE_OPEN_ERROR ;
		goto _cleanup ;
	}

	for( ;; ) 
	{

		UInt32 xferBytes=0;
		UInt32 startAddr ;
		UInt32 imageSize ;

		if(startAddress == IMGSET_ONLY || startAddress == CALSET_ONLY || startAddress == RSRC_ONLY || startAddress == RSRC2_ONLY ){	
		//if(startAddress != RSRC_ONLY){
		//imgset, calset Ե ּҿ ̹  д´.
		if( fread( &startAddr, 4, 1, fp ) != 1) 
		{
			result=RESULT_OK;
			break;
		}
		if( fread( &imageSize, 4, 1, fp ) != 1 ) 
		{
		//printf ("read error\n");
			result=RESULT_OK;
			break;
		}
		}
		if(startAddress == IMGSET_ONLY){
		if (checkER==0)
		{
			fseek(fp,imageSize,SEEK_CUR);
			checkER=2;
			continue;
		}

		if (checkER==1)
		{
			checkER=2;
			goto send_image;
		}

		if (checkPARAM==0)
		{
			fseek(fp,imageSize,SEEK_CUR);

			// sysparm 3-files, so sysparmFiles increase number for 3
			++sysparmFiles;
			if (sysparmFiles==3)
			{
				checkPARAM=2;
				sysparmFiles=0;
			}
			continue;
		}
		if (checkPARAM==1)
		{
			++sysparmFiles;
			if (sysparmFiles==2)
			{
				checkPARAM=2;
				sysparmFiles=0;
			}
			goto send_image;
		}
		}
if(startAddress == RSRC_ONLY){
		if (checkRC1==0)
		{
//			fseek(fp,imageSize,SEEK_CUR);
			checkRC1=2;
			continue;
		}
		if (checkRC1==1)
		{
			checkRC1=2;
			goto send_image;
		}
		}
if(startAddress == RSRC2_ONLY){
		if (checkRC2==0)
		{
//			fseek(fp,imageSize,SEEK_CUR);
			checkRC2=2;
			continue;
		}
		if (checkRC2==1)
		{
			checkRC2=2;
			goto send_image;
		}
		}
if(startAddress == CALSET_ONLY){
		if (checkCALSET==0)
		{
			fseek(fp,imageSize,SEEK_CUR);

			// cal-file 2 files, so cal-file increase number for 2
			++calFiles;
			if (calFiles==2)
			{
				checkCALSET=2;
				calFiles=0;
			}
			continue;
		}
		if (checkCALSET==1)
		{
			++calFiles;
			if (calFiles==1)
			{
				checkCALSET=2;
				calFiles=0;
			}
			goto send_image;
		}
}
		if (checkBOOT2==0)
		{
			checkBOOT2=2;
			break;
		}
		if (checkBOOT2==1)
		{
			checkBOOT2=2;
			goto send_image;
		}
		
send_image:

#if 0
		if(startAddress == RSRC_ONLY)
		{
			startAddr = RSRC1_START_ADDR;
			imageSize = filelength( fileno(fp) );

		}
		
		if(startAddress == RSRC2_ONLY)
		{
			startAddr = RSRC2_START_ADDR;
			imageSize = filelength( fileno(fp) );

		}
		
#endif		
		cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_NAND_LOAD_IMAGE ) ;
		cmd.p1	= TOOL_SwapU32( startAddr ) ;
		cmd.p2	= TOOL_SwapU32( imageSize ) ;
		cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

		nAddress=startAddr;
		DownloadToByte=imageSize;
		result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;

//		nWritten=startAddr;


		if( RESULT_OK != result ) 
		{
			goto _cleanup ;
		}

		if( progressCb ) 
		{
			progressCb( TRUE,TRUE,2,0 ,FALSE) ;
		}
        
		if (mode==UART_MODE)
             Sleep(1000*1);
		
	while(1) 
	{
		result = TOOL_ReadComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
		
		if( RESULT_OK != result ) 
		{
			progressCb( TRUE,TRUE,6,0,FALSE);
			goto _cleanup ;
		}

		else if( c ==  FP_ImageOK ) 
		{
			OutputDebugString("Updater: Received FP_ImageOK") ;
		/*	if (mode==USB_MODE)
                            Sleep(50);*/
			c = FP_RequestBlockSize ;
			result = TOOL_WriteComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
		
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}
		}
		else if( c ==  FP_AddrWrong ) 
		{
			OutputDebugString("Updater: Received FP_AddrWrong") ;
			result = RESULT_TOOL_ADDRESS_INVALID ;
			goto _cleanup ;
		}
		else if( c ==  FP_ImageTooLarge ) 
		{
			OutputDebugString("Updater: Received FP_ImageTooLarge") ;
			result = RESULT_TOOL_ADDRESS_INVALID ;
			goto _cleanup ;
		}

		else if( c ==  FP_ReturnBlockSize ) 
		{
			UInt32 bs ;
			
			OutputDebugString("Updater: Received FP_ReturnBlockSize") ;
			result = TOOL_ReadComPortWithTimeout( comPort, &bs, 4, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}

			sector_size = TOOL_SwapU32( bs ) ;
			
#if 0		
			if (DownloadToByte<=0x20000)
				sector_size=DownloadToByte;
#endif		
			if (startAddress==TFS_START_ADDR)
			{
		
				if( !_GetSector( mode,fp, sector_buff, sector_size+4096 ) )
				{
					result = RESULT_TOOL_INTERNAL_ERROR ;
					goto _cleanup ;
				}

				result = _SendSector( mode, comPort, sector_buff, sector_size+4096, progressCb,nAddress );
			}
			else
			{
				if( !_GetSector( mode, fp, sector_buff, sector_size ) )
				{
					result = RESULT_TOOL_INTERNAL_ERROR ;
					goto _cleanup ;
				}

				result = _SendSector( mode, comPort, sector_buff, sector_size, progressCb,nAddress );
						
			}

			if( RESULT_OK != result) 
			{
				count++;

				if (count>=4)
				{
					count=0;
					goto _cleanup ;
				}
			}
			else
			nAddress+=sector_size;
			DownloadToByte-=0x20000;
		}
		else if( c ==  FP_SectorOK ) 
		{
			progressCb(TRUE,TRUE,0,rchksum,FALSE);
			OutputDebugString("Updater: Received FP_SectorOK") ;
			c = FP_RequestBlockSize ;

               //   	if (mode==UART_MODE)
                              //Sleep(700);JUN0612
			result = TOOL_WriteComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
		
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}
		}
		else if( c ==  FP_Resend ) 
		{
			progressCb( TRUE,TRUE,3,0,FALSE);
			for( j=0; j<2000000; j++ );	// wait for ~0.5 s
			OutputDebugString("Updater: Received FP_Resend") ;
			result = _SendSector( mode, comPort, sector_buff, sector_size, progressCb,nAddress);
			if( RESULT_OK != result) 
			{
				count++;

				if (count>=4)
				{
					count=0;
					goto _cleanup ;
				}
			}
			else
			nAddress+=sector_size;
		}
		else if( c ==  FP_Failed ) 
		{
			progressCb( TRUE,TRUE,4,0,FALSE);
			OutputDebugString("Updater: Received FP_Failed") ;
			result = RESULT_TOOL_SYNC_ERROR ;
			goto _cleanup ;
		}
		else if( c ==  FP_Finished ) 
		{
			OutputDebugString("Updater: Received FP_Finished") ;
           
#if 0
			if (mode==USB_MODE)
			{
                 Sleep(2000*1);
			     c=0xab;
			     TOOL_WriteComPortWithTimeout(comPort,&c, 1, TIMEOUT_SEC );
            }
#endif
			Sleep(1000*1);
			result = RESULT_OK ;
		break;
		//	goto _cleanup ;
		}
		else 
		{
			progressCb( TRUE,TRUE,5,0,FALSE);
			result = RESULT_TOOL_INTERNAL_ERROR ;
			goto _cleanup ;
		}
	}
	}

_cleanup:

	if( fp ) 
	{
		fclose( fp ) ;
	}
	return result ;
}

Result_t TOOL_NandFlashDownload_Tflash(UInt8 mode,
	void				*comPort,
	UInt8				*imageListName,
	UInt32				startAddress,
	ToolProgressCb_t	progressCb
)
{
	FILE		*fp = 0 ;
	FLASHLOADER_Cmd_t	cmd ;
	UInt8		c;
	UInt32		bytesDownloaded = 0 ,j=0;
	Result_t	result ;
	UInt32 image_size, sector_size;
	UInt8	sector_buff[FLASH_MAX_SECTOR_SIZE_BYTES];
	UInt32	nAddress=0;
	UInt16 count=0;
	UInt8			*fileBuffer = 0 ;
	UInt8	boot_mode=0;

	if (strcmp(imageListName,"boot2")!=0)
	{
		fp = fopen( imageListName, "rb" ) ;
		if( !fp ) 
		{
			result = RESULT_TOOL_FILE_OPEN_ERROR ;
			goto _cleanup ;
		}
		boot_mode=0;
	}
	else
	{
		boot_mode=1;
		fileBuffer = (UInt8*)calloc(1,hBootloader2Size[0]) ;  //TC58_BOOT
		memcpy((void *)fileBuffer,(void *)hBootloader2[0],hBootloader2Size[0]);
	//	result = TOOL_WriteComPortWithTimeout( comPort, fileBuffer, sizeof(hBootloaderDrv)/2, TIMEOUT_SEC ) ;
	}


	if (startAddress==TFS_START_ADDR)
		image_size=0x2920000;		//TFS Downΰ spare ϹǷ main    
	if (boot_mode==0)
		image_size = filelength( fileno(fp) );
	if (boot_mode==1)
		image_size=hBootloader2Size[0];
	
	
	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_NAND_LOAD_IMAGE ) ;

	cmd.p1	= TOOL_SwapU32( startAddress ) ;
	cmd.p2	= TOOL_SwapU32( image_size ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	nAddress=startAddress;
	result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;

	if( RESULT_OK != result ) 
	{
		goto _cleanup ;
	}
        if (mode==UART_MODE)
             Sleep(1000*3);

	while(1) 
	{
		result = TOOL_ReadComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
		
		if( RESULT_OK != result ) 
		{
			progressCb( TRUE,TRUE,6,0,FALSE);
			goto _cleanup ;
		}

		else if( c ==  FP_ImageOK ) 
		{
			OutputDebugString("Updater: Received FP_ImageOK") ;
		/*	if (mode==USB_MODE)
                            Sleep(50);*/
			c = FP_RequestBlockSize ;
			result = TOOL_WriteComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}
		}
		else if( c ==  FP_AddrWrong ) 
		{
			OutputDebugString("Updater: Received FP_AddrWrong") ;
			result = RESULT_TOOL_ADDRESS_INVALID ;
			goto _cleanup ;
		}
		else if( c ==  FP_ImageTooLarge ) 
		{
			OutputDebugString("Updater: Received FP_ImageTooLarge") ;
			result = RESULT_TOOL_ADDRESS_INVALID ;
			goto _cleanup ;
		}

		else if( c ==  FP_ReturnBlockSize ) 
		{
			UInt32 bs ;
			
			OutputDebugString("Updater: Received FP_ReturnBlockSize") ;
			result = TOOL_ReadComPortWithTimeout( comPort, &bs, 4, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}

			sector_size = TOOL_SwapU32( bs ) ;
			
			if (boot_mode==1)
			{
				memcpy(sector_buff,fileBuffer,sector_size);
				fileBuffer+=sector_size;
			}
			else
			{
				if( !_GetSector( mode, fp, sector_buff, sector_size ) )
				{
					result = RESULT_TOOL_INTERNAL_ERROR ;
					goto _cleanup ;
				}
			}

			result = _SendSector( mode, comPort, sector_buff, sector_size, progressCb,nAddress );
				
			if( RESULT_OK != result) 
			{
				count++;

				if (count>=4)
				{
					count=0;
					goto _cleanup ;
				}
			}
			else
			nAddress+=sector_size;

		}
		else if( c ==  FP_SectorOK ) 
		{
			progressCb(TRUE,TRUE,0,rchksum,FALSE);
			OutputDebugString("Updater: Received FP_SectorOK") ;
			c = FP_RequestBlockSize ;

                  	if (mode==UART_MODE)
                              Sleep(100);
			result = TOOL_WriteComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) 
			{
				goto _cleanup ;
			}
		}
		else if( c ==  FP_Resend ) 
		{
			progressCb( TRUE,TRUE,3,0,FALSE);
			for( j=0; j<2000000; j++ );	// wait for ~0.5 s
			OutputDebugString("Updater: Received FP_Resend") ;
			result = _SendSector( mode, comPort, sector_buff, sector_size, progressCb,nAddress);
			if( RESULT_OK != result) 
			{
				count++;

				if (count>=4)
				{
					count=0;
					goto _cleanup ;
				}
			}
			else
			nAddress+=sector_size;
		}
		else if( c ==  FP_Failed ) 
		{
			progressCb( TRUE,TRUE,4,0,FALSE);
			OutputDebugString("Updater: Received FP_Failed") ;
			result = RESULT_TOOL_SYNC_ERROR ;
			goto _cleanup ;
		}
		else if( c ==  FP_Finished ) 
		{
			OutputDebugString("Updater: Received FP_Finished") ;
                        if (mode==USB_MODE)
			{
                             Sleep(1000*1);
			     c=0xab;
			     TOOL_WriteComPortWithTimeout(comPort,&c, 1, TIMEOUT_SEC );
                        }

			result = RESULT_OK ;
			goto _cleanup ;
		}
		else 
		{
			progressCb( TRUE,TRUE,5,0,FALSE);
			result = RESULT_TOOL_INTERNAL_ERROR ;
			goto _cleanup ;
		}
	}

_cleanup:

	if( fp ) 
	{
		fclose( fp ) ;
	}
	return result ;
}

Result_t TOOL_PartialErase(
	VOID		*comPort,
	UInt32 				startAddress,
	UInt32				image_size,
	ToolProgressCbDump_t	progressCb )
{

	UInt8			cAck;
	FLASHLOADER_Cmd_t	cmd ;
	Result_t		result ;
	int i;

	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_NAND_PARTIAL_ERASE ) ;
	cmd.p1	= TOOL_SwapU32( startAddress ) ;
	cmd.p2	= TOOL_SwapU32( image_size ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;
	
	if( RESULT_OK != result ) 
	{
		goto _cleanup ;
	}
	Sleep(1000*1);

	cAck=0x0;
	while(RESULT_OK==TOOL_ReadComPortWithTimeout(comPort,&cAck,1,30))
	{
		if (cAck==0x46)
			break;
	}

	cAck=0x0;
	while(RESULT_OK==TOOL_ReadComPortWithTimeout(comPort,&cAck, 1,60 ))
	{
		//0xB9 --> Ack(nand all erase finished) from MS
		if (cAck==0xB9)
			break;
	}

_cleanup:

	return result ;
}

Result_t TOOL_CaptureImage( UInt8 mode,
	UInt8				*captureFileName, 
	VOID		*comPort,
	UInt32 				startAddress,
	UInt32				image_size,
	UInt32	flashType,
	ToolProgressCbDump_t	progressCb,
	ToolFileHandleCb_t		fileCb)
{
	UInt8			sector_buff[FLASH_MAX_SECTOR_SIZE_BYTES];			//	MAX_SECTOR_SIZE
	UInt8			spare_buff[MAX_SPARE_SIZE];
	FILE  			*fp = 0 ;	
	UInt8			c ;
	FLASHLOADER_Cmd_t	cmd ;
	UInt32			sector_size;
	Result_t		result ;
	UInt32			nAddress;
	int i;
	BOOL			tfsdump=FALSE;

	cmd.id	= TOOL_SwapU32( flashType ) ;
	cmd.p1	= TOOL_SwapU32( startAddress ) ;
	cmd.p2	= TOOL_SwapU32( image_size ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(comPort,&cmd, sizeof( cmd ),TIMEOUT_SEC ) ;

//	Sleep(500);

#if 0	//jun_tfs
	if (startAddress==TFS_START_ADDR)
		tfsdump=TRUE;
#endif
	if( RESULT_OK != result ) 
	{
		goto _cleanup ;
	}

//	if (mode==UART_MODE)
//       Sleep(1000*3);

	nAddress=startAddress;

	while(1) {

		OutputDebugString("1") ;
		result = TOOL_ReadComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
		if( RESULT_OK != result ) {
			goto _cleanup ;
		}


		if( c ==  FP_ImageOK ) {
			c = FP_RequestBlockSize ;
			OutputDebugString("4") ;
			result = TOOL_WriteComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) {
				goto _cleanup ;
			}
		}

		else if( c ==  FP_AddrWrong ) {
			result = RESULT_TOOL_ADDRESS_INVALID ;
			goto _cleanup ;
		}

		else if( c ==  FP_ImageTooLarge ) {
			result = RESULT_TOOL_ADDRESS_INVALID ;
			goto _cleanup ;
		}

		else if( c ==  FP_ReturnBlockSize ) {
			UInt32 bs ;

			OutputDebugString("5") ;
			result = TOOL_ReadComPortWithTimeout( comPort, &bs, 4, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) {
				goto _cleanup ;
			}

			sector_size = TOOL_SwapU32( bs ) ;

//			if( !_GetSector( fp, sector_buff, sector_size ) ){
//				result = RESULT_TOOL_INTERNAL_ERROR ;
//				goto _cleanup ;
//			}

			OutputDebugString("6") ;

			if (tfsdump==TRUE)
			{
				result = _RecvSector( comPort, sector_buff, sector_size+4096, progressCb ,nAddress);
				if( RESULT_OK != result ) {
					goto _cleanup ;
				}
			}
			else
			{
				result = _RecvSector( comPort, sector_buff, sector_size, progressCb,nAddress);
				if( RESULT_OK != result ) {
					goto _cleanup ;
				}
			}
			
		/*	for(i=0;i<FLASH_MAX_SECTOR_SIZE_BYTES;i++)
			{
				if (sector_buff[i]!=0xff)
				{
					result = RESULT_TOOL_SYNC_ERROR ;
					goto _cleanup ;
				}
			}*/
			
			if (tfsdump==TRUE)
			{
				for (i=0;i<256;i++)
				{
					fileCb(sector_buff+i*528,512);
					fileCb(sector_buff+i*528+512,16);
				}
			}
			else
				fileCb(sector_buff,sector_size);
			
			nAddress+=sector_size;
			if (sector_size<128*1024)
			Sleep(1000*1);
	

		}

		else if( c ==  FP_SectorOK ) {
			c = FP_RequestBlockSize ;OutputDebugString("7") ;;
	           	if (mode==UART_MODE)
                   Sleep(500);
			result = TOOL_WriteComPortWithTimeout( comPort, &c, 1, TIMEOUT_SEC ) ;
			if( RESULT_OK != result ) {
				goto _cleanup ;
			}
		}

		else if( c ==  FP_Resend ) {
			result = RESULT_ERROR ;
			goto _cleanup ;
		}

		else if( c ==  FP_Failed ) {
			result = RESULT_TOOL_SYNC_ERROR ;
			goto _cleanup ;
		}

		else if( c ==  FP_Finished ) {
			result = RESULT_OK ;
			goto _cleanup ;
		}

		else {
			result = RESULT_TOOL_INTERNAL_ERROR ;
			goto _cleanup ;
		}
	}

_cleanup:
	if( fp ) {
		fclose( fp ) ;
	}

	return result ;
}

//
//	send 'reset' to processor (indicated by 0 image size)
//
Result_t TOOL_Reset(
	void	*comPort,
	UInt8	cause
)
{
	FLASHLOADER_Cmd_t	cmd ;
	Result_t result ;

	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_RESET ) ;
	cmd.p1	= TOOL_SwapU32( 0 ) ;
	cmd.p2	= TOOL_SwapU32( 0 ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(
		comPort, 
		&cmd, 
		sizeof( cmd ),
		TIMEOUT_SEC ) ;

	return result ;
}


//
//	set target baudrate
//
Result_t TOOL_SetTargetBaudRate( void *comPort,	UInt8 baudRateCode, int type)
{
	FLASHLOADER_Cmd_t cmd ;
	Result_t result ;

	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_INIT_COMM ) ;
	cmd.p1	= TOOL_SwapU32( baudRateCode ) ;
	cmd.p2	= TOOL_SwapU32( type ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	
	result = TOOL_WriteComPortWithTimeout(comPort, &cmd, sizeof(cmd),TIMEOUT_SEC ) ;

	Sleep(1000*1);
	return result ;
}

Result_t TOOL_PhoneReset(void * comPort)
{
	FLASHLOADER_Cmd_t cmd;
	Result_t result;

	cmd.id	= TOOL_SwapU32( FLASHLOADER_CMD_PHONE_RESET ) ;
	cmd.p1	= TOOL_SwapU32( 0 ) ;
	cmd.p2	= TOOL_SwapU32( 0 ) ;
	cmd.ct	= TOOL_SwapU32( FLASHLOADER_CMD_TRAILER ) ;

	result = TOOL_WriteComPortWithTimeout(comPort, &cmd, sizeof(cmd),TIMEOUT_SEC ) ;

	Sleep(1000*2);
	return result ;
}


Result_t TOOL_USBDownloadImage
( 
 UInt8 mode,
 UInt8		*imageFileName, 
 void 	*comPort,
 UInt32 	startAddress,
 ToolProgressCb_t	progressCb 
 ){
  static UInt8		sector_buff[MAX_TRANSFER_SIZE];//	MAX_SECTOR_SIZE
  FILE  *fp = 0 ;	
  UInt8	c,m_c;
 
  
  UInt32 sector_size;
  UInt32 image_size;
  Result_t result ;
  static int numPacket = 0;
  static int myisize;
  usb_message_t tx_msg;
  usb_message_t rx_msg;
  UInt32	nAddress=0;
  static	UInt16	sysparmFiles=0;
  static	UInt16	calFiles=0;
  const int cmd_msg_size = 16;
  UInt8 transfer_start = 0;
  UInt8 recv_chksum = 0;
  UInt8 checksum = 0;
  static UInt8 gbIgnorechksum = 0;
  
  fp = fopen( (char*)imageFileName, "rb" );
  if ( !fp ){
    result = RESULT_TOOL_FILE_OPEN_ERROR ;
    goto _cleanup ;
  }

  for (;;){
    int msgSize = 0;
    int data[10];
    int i = 0;
	UInt32 xferBytes=0;
	UInt32 startAddr ;
	UInt32 imageSize ;

		if(startAddress == IMGSET_ONLY || startAddress == CALSET_ONLY || startAddress == RSRC_ONLY || startAddress == RSRC2_ONLY || startAddress == FFS_ONLY ){	
		//if(startAddress != RSRC_ONLY){
		//imgset, calset Ե ּҿ ̹  д´.
		if( fread( &startAddr, 4, 1, fp ) != 1) 
		{
			result=RESULT_OK;
			break;
		}
		if( fread( &imageSize, 4, 1, fp ) != 1 ) 
		{
		//printf ("read error\n");
			result=RESULT_OK;
			break;
		}
		}
		
		if(startAddress == IMGSET_ONLY){
		if (checkER==0)
		{
			fseek(fp,imageSize,SEEK_CUR);
			checkER=2;
			continue;
		}

		if (checkER==1)
		{
			checkER=2;
			goto send_image;
		}

		if (checkPARAM==0)
		{
			fseek(fp,imageSize,SEEK_CUR);

			// sysparm 3-files, so sysparmFiles increase number for 3
			++sysparmFiles;
			if (sysparmFiles==3)
			{
				checkPARAM=2;
				sysparmFiles=0;
			}
			continue;
		}
		if (checkPARAM==1)
		{
			++sysparmFiles;
			if (sysparmFiles==2)
			{
				checkPARAM=2;
				sysparmFiles=0;
			}
			goto send_image;
		}
		}
if(startAddress == RSRC_ONLY){
		if (checkRC1==0)
		{
//			fseek(fp,imageSize,SEEK_CUR);
			checkRC1=2;
			continue;
		}
		if (checkRC1==1)
		{
			checkRC1=2;
			goto send_image;
		}
		}
if(startAddress == RSRC2_ONLY){
		if (checkRC2==0)
		{
//			fseek(fp,imageSize,SEEK_CUR);
			checkRC2=2;
			continue;
		}
		if (checkRC2==1)
		{
			checkRC2=2;
			goto send_image;
		}
		}
if(startAddress == FFS_ONLY){
			goto send_image;
		}
if(startAddress == CALSET_ONLY){
		if (checkCALSET==0)
		{
			fseek(fp,imageSize,SEEK_CUR);

			// cal-file 2 files, so cal-file increase number for 2
			++calFiles;
			if (calFiles==2)
			{
				checkCALSET=2;
				calFiles=0;
			}
			continue;
		}
		if (checkCALSET==1)
		{
			++calFiles;
			if (calFiles==1)
			{
				checkCALSET=2;
				calFiles=0;
			}
			goto send_image;
		}
}
		if (checkBOOT2==0)
		{
			checkBOOT2=2;
			break;
		}
		if (checkBOOT2==1)
		{
			checkBOOT2=2;
			goto send_image;
		}
			
send_image:
#if 0
	if(startAddress == RSRC_ONLY)
	{
		startAddr = RSRC1_START_ADDR;
		imageSize = filelength( fileno(fp) );

	}
		
	if(startAddress == RSRC2_ONLY)
	{
		startAddr = RSRC2_START_ADDR;
		imageSize = filelength( fileno(fp) );

	}
#endif		
	nAddress=startAddr;
	image_size=imageSize;


	if( progressCb ) 
	{
		progressCb( TRUE,TRUE,2,0 ,FALSE) ;
	}

    
    c = FP_StartReq ;
    data[0]=nAddress;
    data[1]=image_size;
    memset(&tx_msg, 0, sizeof(tx_msg));
    /* build start request message */
    msgSize = BuildOutgoingMessage(&tx_msg,c,data,2,0);
    msgSize <<=2;		/* in bytes */

    result = TOOL_WriteComPortWithTimeout(comPort, (UInt8*)&tx_msg, msgSize, TIMEOUT_SEC);
    if( RESULT_OK != result ) {
      goto _cleanup ;
    }

while(1){
#if 0
      //      memset(&rx_msg,0,sizeof(rx_msg));
      /* expect the image ok message */
      result = TOOL_ReadComPortWithTimeout(comPort, (UInt8*)&rx_msg, 16, TIMEOUT_SEC);

      if( RESULT_OK != result ) {
	goto _cleanup ;
      }
      //      for (i=0;i<3;i++){
      //	printf("\n#%d. 0x%08x",i+1, ((int*)&rx_msg)[i]);
      //      }
      sector_size = 0;

	  m_c = GET_CMD(rx_msg);
	  
	  if(m_c==FP_ImageOK)
	  {
	OutputDebugString("Updater: FP_ImageOK received.") ;
	sector_size = ((int*)&rx_msg)[1];

	memset(&tx_msg, 0, sizeof(tx_msg));
	result = SendACK(&tx_msg, FP_ImageOK_ACK, comPort);
	if( RESULT_OK != result ) {
	  goto _cleanup ;
	}

	if( !_GetSector( mode, fp, sector_buff, sector_size ) ){
	  result = RESULT_TOOL_INTERNAL_ERROR ;
	  goto _cleanup ;
	}
	result = _SendSector(mode, comPort, sector_buff, sector_size, progressCb,nAddress);
	if( RESULT_OK != result ) {
	  goto _cleanup ;
	}
	else
		nAddress +=sector_size;
	  }
	else if(m_c==FP_Finished)
	{
	OutputDebugString("Updater: Received FP_Finished") ;
	memset(&tx_msg, 0, sizeof(tx_msg));
	result = SendACK(&tx_msg, FP_Finished_ACK, comPort);
	Sleep(10000);
	//goto _cleanup ;
	break;
	}
	else if(m_c==FP_ImageTooLarge)
    {
 
	OutputDebugString("Updater: Received FP_ImageTooLarge") ;
	result = RESULT_TOOL_ADDRESS_INVALID ;
	goto _cleanup ;
	}
	else if(m_c==FP_AddrWrong)
    {
	OutputDebugString("Updater: Received FP_AddrWrong") ;
	result = RESULT_TOOL_ADDRESS_INVALID ;
	goto _cleanup ;
	}
#endif
      /* expect the image ok message */
      result = TOOL_ReadComPortWithTimeout(comPort, (UInt8*)&rx_msg, cmd_msg_size, TIMEOUT_SEC);

      if( RESULT_OK != result ) {
	    goto _cleanup ;
      }
      sector_size = 0;

	  m_c = GET_CMD(rx_msg);

      
	if(m_c==FP_ImageOK){
		  
	OutputDebugString("Updater: FP_ImageOK received.") ;
	sector_size = ((int*)&rx_msg)[1];
	/* read the checksum before send the ACK back */
	if (transfer_start){	  
	  recv_chksum = (UInt8)((int*)&rx_msg)[2];
	  transfer_start = 0;	
	  if (recv_chksum != checksum){
	    goto _cleanup;
	  }
	}
	/* send the ACK back */
	memset(&tx_msg, 0, sizeof(tx_msg));
	result = SendACK(&tx_msg, FP_ImageOK_ACK, comPort);
	if( RESULT_OK != result ) {
	  goto _cleanup ;
	}
	/* read image data from the file */
	if( !_GetSector( mode, fp, sector_buff, sector_size  ) ){
	  result = RESULT_TOOL_INTERNAL_ERROR ;
	  goto _cleanup ;
	}
	/* send the data to target device */
	gbIgnorechksum = 1;
	checksum = 0;
	result = _SendSectorUSB(mode, comPort, sector_buff, sector_size,&checksum, progressCb,nAddress);
	progressCb(TRUE,TRUE,0,recv_chksum,FALSE);
	transfer_start = 1;
	if( RESULT_OK != result ) {
	  goto _cleanup ;
	}
	else{
		nAddress +=sector_size;
	}

		  }
      
	if(m_c==FP_Finished){
	OutputDebugString("Updater: Received FP_Finished");
	if (transfer_start){
	  /* For this Finished, the checksum is at the first data field */
	  recv_chksum = (UInt8)((int*)&rx_msg)[1];
	  transfer_start = 0;
	  if (recv_chksum != checksum){
	    goto _cleanup;
	  }
	}
	#ifdef USB_SERIAL_DRIVER
	memset(&tx_msg, 0, sizeof(tx_msg));
	result = SendACK(&tx_msg, FP_Finished_ACK, comPort);
	#endif
//	goto _cleanup ;
	break;
	}
     
	if(m_c==FP_ImageTooLarge){
	OutputDebugString("Updater: Received FP_ImageTooLarge") ;
	result = RESULT_TOOL_ADDRESS_INVALID ;
	goto _cleanup ;
	}
   
	if(m_c==FP_AddrWrong){
	OutputDebugString("Updater: Received FP_AddrWrong") ;
	result = RESULT_TOOL_ADDRESS_INVALID ;
	goto _cleanup ;
	}
  
    
    }
  
  }

_cleanup:

	if( fp ) 
	{
		fclose( fp ) ;
	}
	return result ;

}



Result_t TOOL_USBDownloadImage_MANUAL
( 
 UInt8 mode,
 UInt8		*imageFileName, 
 void 	*comPort,
 UInt32 	startAddress,
 ToolProgressCb_t	progressCb 
 ){
  static UInt8		sector_buff[MAX_TRANSFER_SIZE];//	MAX_SECTOR_SIZE
  FILE  *fp = 0 ;	
  UInt8	c,m_c;
 
  
  UInt32 sector_size;
  UInt32 image_size;
  Result_t result ;
  static int numPacket = 0;
  static int myisize;
  usb_message_t tx_msg;
  usb_message_t rx_msg;
  UInt32	nAddress=0;
  static	UInt16	sysparmFiles=0;
  static	UInt16	calFiles=0;
  const int cmd_msg_size = 16;
  UInt8 transfer_start = 0;
  UInt8 recv_chksum = 0;
  UInt8 checksum = 0;
  static UInt8 gbIgnorechksum = 0;
  int msgSize = 0;
  int data[10];
  int i = 0;
  UInt32 xferBytes=0;

  
  fp = fopen( (char*)imageFileName, "rb" );
  if ( !fp ){
    result = RESULT_TOOL_FILE_OPEN_ERROR ;
    goto _cleanup ;
  }
		    	
		
	nAddress=startAddress;
	image_size=filelength( fileno(fp) );


	if( progressCb ) 
	{
		progressCb( TRUE,TRUE,2,0 ,FALSE) ;
	}

    
    c = FP_StartReq ;
    data[0]=nAddress;
    data[1]=image_size;
    memset(&tx_msg, 0, sizeof(tx_msg));
    /* build start request message */
    msgSize = BuildOutgoingMessage(&tx_msg,c,data,2,0);
    msgSize <<=2;		/* in bytes */

    result = TOOL_WriteComPortWithTimeout(comPort, (UInt8*)&tx_msg, msgSize, TIMEOUT_SEC);
    if( RESULT_OK != result ) {
      goto _cleanup ;
    }

while(1){

      /* expect the image ok message */
      result = TOOL_ReadComPortWithTimeout(comPort, (UInt8*)&rx_msg, cmd_msg_size, TIMEOUT_SEC);

      if( RESULT_OK != result ) {
	    goto _cleanup ;
      }
      sector_size = 0;

	  m_c = GET_CMD(rx_msg);

      
	if(m_c==FP_ImageOK){
		  
	OutputDebugString("Updater: FP_ImageOK received.") ;
	sector_size = ((int*)&rx_msg)[1];
	/* read the checksum before send the ACK back */
	if (transfer_start){	  
	  recv_chksum = (UInt8)((int*)&rx_msg)[2];
	  transfer_start = 0;	
	  if (recv_chksum != checksum){
	    goto _cleanup;
	  }
	}
	/* send the ACK back */
	memset(&tx_msg, 0, sizeof(tx_msg));
	result = SendACK(&tx_msg, FP_ImageOK_ACK, comPort);
	if( RESULT_OK != result ) {
	  goto _cleanup ;
	}
	/* read image data from the file */
	if( !_GetSector( mode, fp, sector_buff, sector_size  ) ){
	  result = RESULT_TOOL_INTERNAL_ERROR ;
	  goto _cleanup ;
	}
	/* send the data to target device */
	gbIgnorechksum = 1;
	checksum = 0;
	result = _SendSectorUSB(mode, comPort, sector_buff, sector_size,&checksum, progressCb,nAddress);
	progressCb(TRUE,TRUE,0,recv_chksum,FALSE);
	transfer_start = 1;
	if( RESULT_OK != result ) {
	  goto _cleanup ;
	}
	else{
		nAddress +=sector_size;
	}

		  }
      
	if(m_c==FP_Finished){
	OutputDebugString("Updater: Received FP_Finished");
	if (transfer_start){
	  /* For this Finished, the checksum is at the first data field */
	  recv_chksum = (UInt8)((int*)&rx_msg)[1];
	  transfer_start = 0;
	  if (recv_chksum != checksum){
	    goto _cleanup;
	  }
	}
	#ifdef USB_SERIAL_DRIVER
	memset(&tx_msg, 0, sizeof(tx_msg));
	result = SendACK(&tx_msg, FP_Finished_ACK, comPort);
	#endif
//	goto _cleanup ;
	break;
	}
     
	if(m_c==FP_ImageTooLarge){
	OutputDebugString("Updater: Received FP_ImageTooLarge") ;
	result = RESULT_TOOL_ADDRESS_INVALID ;
	goto _cleanup ;
	}
   
	if(m_c==FP_AddrWrong){
	OutputDebugString("Updater: Received FP_AddrWrong") ;
	result = RESULT_TOOL_ADDRESS_INVALID ;
	goto _cleanup ;
	}
  
    
    }
  
  

_cleanup:

	if( fp ) 
	{
		fclose( fp ) ;
	}
	return result ;

}
