//-----------------------------------------------------------------------------
//	
//	Copyright 2004 Broadcom Corporation
//
//	Common tools API.  Used for PC and target code.
//
//-----------------------------------------------------------------------------

#ifndef __TOOL_API_H__
#define __TOOL_API_H__

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef _WIN32
#include	<windows.h>
#include 	<stdio.h>
#include 	<conio.h>
#include	"io.h"
#endif // _WIN32

#include	"types.h"
#include	"resultcode.h"

//
//----------------------- image download protocol codes -----------------------
//
#define FP_Speed_115k		(0x88)	// use 115k to download
#define FP_Speed_230k		(0x89)	// use 230k to download
#define FP_Speed_460k		(0x8a)	// use 460k to download
#define FP_Speed_921k		(0x8b)	// use 921k to download
#define FP_Speed_3m			(0x8d)	// use 921k to download
#define FP_Speed_Req		(0x91)	// request baudrate
#define FP_Speed_ChgDone	(0x92)	// baudrate change done
#define	FP_Speed_812k		(0x93)	// use 812k to download (PC card)
#define BAD_BLK_SIGNAL		(0x9A)
#define BAD_BLK_END			(0x9B)

#define FP_StartReq 0x5a		// command to request start transmission
#define FP_StartOK 	0xa5		// command to answer request start transmission
#define FP_ImageOK  0x26		// Write one sector OK
#define FP_SectorOK			(FP_ImageOK+1)			// 27 Write one sector OK   
#define FP_Failed			(FP_SectorOK+1)			// 28 Writing failed because unknown reason
#define FP_Finished			(FP_Failed+1)			// 29 all image writing complete
#define FP_Resend			(FP_Finished+1)			// 2A request resend last sector
#define FP_AddrWrong		(FP_Resend+1)			// 2B Start address out of range
#define FP_ImageTooLarge	(FP_AddrWrong+1)		// 2C Image too large compare to the flash space
#define FP_RequestBlockSize (FP_ImageTooLarge+1)	// 2D request the sector size
#define FP_ReturnBlockSize	(FP_RequestBlockSize+1)	// retrun the sector size


#define REQ_TFS_DOWNLOAD      0x32
#define REQ_OTHER_DOWNLOAD		0x33

#define MAX_MESSAGE_ENTRY 10

#define GET_CMD(_a) (_a.cmd & 0xff)
	
typedef struct _tagUSBMessage{
  unsigned char cmd;
  unsigned short seq_no;
  unsigned char reserved;
  unsigned int entries[MAX_MESSAGE_ENTRY];
}usb_message_t;
//
//-----------------------------------------------------------------------------
//

#define MAX_TRANSFER_SIZE       0x210000


#ifdef _WIN32

#define COMPORT_BAUDRATE_115K	(FP_Speed_115k)
#define COMPORT_BAUDRATE_460K	(FP_Speed_460k)
#define COMPORT_BAUDRATE_812K	(FP_Speed_812k)
#define COMPORT_BAUDRATE_921K	(FP_Speed_921k)


typedef struct {
	UInt8		comPortName[ 16 ] ;
	UInt8		baudRate ;
	HANDLE		sio ;
	OVERLAPPED  olWrite ;
	OVERLAPPED	olRead ;
	DCB			dcb ;
}	ComPortCfg_t ;

void TOOL_CloseFP();
int * GetBadBlk();
int * GetIDType();
UInt8 * GetDescription();
UInt32 * GetFlashChecksum();


Result_t TOOL_DownloadDriver_Itcm(ComPortCfg_t 	*comPort);	//jun_0228
Result_t TOOL_DownloadDriver_Itcm_set_Baudrate(ComPortCfg_t 	*comPort);	//jun_0228


Result_t TOOL_DownloadFlashDriver(ComPortCfg_t 	*comPort,UInt8 cDriverType) ;
Result_t TOOL_DownloadBootloaderDrv(ComPortCfg_t 	*comPort);

typedef void (*ToolProgressCb_t) ( Boolean endOfSector,Boolean checksum,unsigned long size,unsigned int nWrite,Boolean bErase);
typedef void (*ToolProgressCbDump_t)(Boolean endOfSector, UInt8 * m,unsigned long addr);
typedef void (*ToolFileHandleCb_t) (UInt8 * m,unsigned long nSize);

Result_t TOOL_DownloadBootloader(  
	ComPortCfg_t 	*comPort,
	UInt32 			startAddress);


Result_t TOOL_SetPcCardToDownloadMode( 
	ComPortCfg_t * comPort ) ;

typedef enum {
	LOADCAL_LOADTYPE_UNKNOWN,
	LOADCAL_LOADTYPE_IND,
	LOADCAL_LOADTYPE_DEP,
	LOADCAL_LOADTYPE_ALL,
	LOADCAL_LOADTYPE_SIM
}	LOADCAL_LoadType_t ;

Result_t TOOL_ParseSystemParms( 
	LOADCAL_LoadType_t	loadType,
	UInt8				*inFileName, 
	UInt8				*outFileName,
	UInt8				**msgList ) ;

Result_t TOOL_ParseDspPatch (
	UInt8		*inFileName1,
	UInt8		*inFileName2,
	UInt8		*outFileName,
	UInt8		**msgList ) ;

typedef void (*HOSTTOOL_CbFunc_t) (		/**< progress callback function */
	UInt32 downloadedBytes				/**< number of bytes downloaded */
) ;


UInt8 TOOL_ChangeComPortBaudRate( 
	void			*comPort,			/**< COM port configuration */
	UInt8			baudRateCode		/**< baud rate code */
	) ;

/** 
	Open port for image download.  This function opens a com port (serial or
	USB) for downloading images to flash memory.  The return value, if not
	NULL, is used in calls to HOSTTOOL_FlashImageSet.

	@param *devName		(in) Name of the download device (serial or USB)
	@param baudRateCode	(in) Baud rate for serial download; ignored for USB
	@return void*		COM port pointer, or NULL if error
**/

void* TOOL_OpenDnldPort(
	UInt8	*devName,
	UInt8	baudRateCode
);

/** 
	Flash image set.  This function downloads an image set to flash using the 
	resident boot loader. The image is created using the
	HOSTTOOL_CreateImageSet API.  The baud rate is not changed for download. 

	@param *comPort		(in) Value returned by HOSTTOOL_OpenDnldPort
	@param *imageSetName (in) Name of the image set file to flash
	@param  cbFunc		(in) Progress callback function or NULL
	@return Result_t	 Completion status
**/
Result_t TOOL_DownloadDriver(ComPortCfg_t 	*comPort);
Result_t TOOL_DownloadBootDL(ComPortCfg_t *comPort, UInt32 startAddress,ToolProgressCb_t	progressCb, UInt8 cActionType); // LHYEONSU
Result_t TOOL_DownloadBoot(ComPortCfg_t 	*comPort,UInt8 type );
Result_t TOOL_NandFlashDownload(
	UInt8				mode,
	void				*comPort,
	UInt8				*imageSetName,
	UInt32				startAddr,
	ToolProgressCb_t	progressCb
);
void SetOffset(int v);
Result_t TOOL_NandFlashDownload_Tflash(
	UInt8				mode,
	void				*comPort,
	UInt8				*imageSetName,
	UInt32				startAddr,
	ToolProgressCb_t	progressCb
);

Result_t TOOL_NorFlashDownload(
	UInt8 mode,
	void *comPort,
	UInt8 *imageListName,
	UInt32 startAddress,
	UInt32 nSize,
	ToolProgressCb_t progressCb
);

Result_t TOOL_CaptureImage(UInt8 mode,
	UInt8				*captureFileName, 
	void				*comPort,
	UInt32 				startAddress,
	UInt32				image_size,
	UInt32				flashType,
	ToolProgressCbDump_t	progressCb,
	ToolFileHandleCb_t		fileCb
);

Result_t TOOL_PartialErase(
	VOID		*comPort,
	UInt32 				startAddress,
	UInt32				image_size,
	ToolProgressCbDump_t	progressCb
	);

Result_t TOOL_USBDownloadImage
( 
 UInt8 mode,
 UInt8		*imageFileName, 
 void 	*comPort,
 UInt32 	startAddress,
 ToolProgressCb_t	progressCb 
 );


Result_t TOOL_USBDownloadImage_MANUAL
( 
 UInt8 mode,
 UInt8		*imageFileName, 
 void 	*comPort,
 UInt32 	startAddress,
 ToolProgressCb_t	progressCb 
 );
/** 
	Send reset command to processor..

	@param *comPort		(in) Value returned by HOSTTOOL_OpenDnldPort
	@param cause		(in) Reset cause
	@return Result_t	Completion status
**/

Result_t TOOL_BadBlkChk(void *comPort);
Result_t TOOL_BadBlkCheck(void *comPort);
Result_t TOOL_TFSformat(void *comPort,UInt8 nConnectMode);
Result_t TOOL_BMLformat(void *comPort);
Result_t TOOL_FlashErase(void *comPort,UInt8 type,UInt8 nConnectMode);
Result_t TOOL_Disconnect(void * comPort);
Result_t TOOL_Reset(void	*comPort,UInt8	cause);
Result_t TOOL_NorErase(	void *comPort,UInt32 startAddress,	ToolProgressCb_t progressCb);
Result_t TOOL_Make(void *comPort);
Result_t TOOL_Back(void *comPort);

Result_t TOOL_PhoneReset(void *comPort);
Result_t TOOL_TfsExplorer(void	*comPort,UInt8	cause);
Result_t _SendSector( UInt8 mode, ComPortCfg_t *comPort, UInt8 *buff, UInt32 sector_size,ToolProgressCb_t progressCb, UInt32 nAddress );
Result_t _SendSectorUSB( UInt8 mode, ComPortCfg_t *comPort, UInt8 *buff, UInt32 sector_size,UInt8 *checksum_out,ToolProgressCb_t progressCb, UInt32 nAddress );

/** 
	Send baud rate command to processor..

	@param *comPort		(in) Value returned by HOSTTOOL_OpenDnldPort
	@param baudRateCode	(in) Baud rate
	@return Result_t	Completion status
**/

Result_t TOOL_SetTargetBaudRate( void *comPort,	UInt8 baudRateCode,int type);


/** 
	Close download port..

	@param *comPort		(in) Value returned by HOSTTOOL_OpenDnldPort
**/

void TOOL_CloseDnldPort(
	void	*comPort
);
	
Result_t TOOL_CMD(void *comPort,UInt32 cmd,UInt8 nConnectMode);
Result_t TOOL_CMD2(void *comPort,UInt32 type,UInt8 nConnectMode,UInt8 data_usb);
//-----------------------------------------------------------------------------
//	General support
//-----------------------------------------------------------------------------

UInt8*	TOOL_GetResultStr( Result_t result ) ;
Boolean TOOL_IsIncludeStmt( char* line ) ;
FILE*	TOOL_OpenIncludeFile( char* line, char* inFileName ) ;

//-----------------------------------------------------------------------------
//	Low-level API support functions
//-----------------------------------------------------------------------------
Result_t TOOL_SetTime(void *comPort,char * cTime,UInt8 nConnectMode);
Result_t TOOL_FlashIDCheck( ComPortCfg_t * comport,int type,UInt8 nConnectMode);
Result_t TOOL_GetBMI( ComPortCfg_t * comport,UInt8 nConnectMode);

/**	Open COM port */
Result_t TOOL_OpenComPort( 
	ComPortCfg_t	*comPort,			/**< COM port configuration */
	int nParity
	) ;

/**	Read from COM port.  Performs one read operation and returns
 *	the number of bytes read. */
Result_t TOOL_ReadComPort( 
	ComPortCfg_t	*comPort,			/**< COM port configuration */
	void			*buf,				/**< I/O buffer */
	UInt32			 bufLen,			/**< max bytes to read */
	UInt32			*nRead				/**< actual bytes read */
	) ;

/**	Read from COM port.  Performs one or more read operations to
 *	read number of bytes requested.  */
Result_t TOOL_ReadComPortAll( 
	ComPortCfg_t	*comPort,			/**< COM port configuration */
	void			*buf,				/**< I/O buffer */
	UInt32			 bufLen				/**< number of bytes to read */
	) ;

/**	Write COM port.  Performs one write operation and returns
 *	the number of bytes written. */
Result_t TOOL_WriteComPort( 
	ComPortCfg_t	*comPort,			/**< COM port configuration */
	void			*buf,				/**< I/O buffer */
	UInt32			 bufLen,			/**< max bytes to write */
	UInt32			*nWrite				/**< actual bytes written */
	) ;

/**	Read from COM port.  Performs one or more write operations to
 *	write number of bytes requested.  */
Result_t TOOL_WriteComPortAll( 
	ComPortCfg_t	*comPort,			/**< COM port configuration */
	void			*buf,				/**< I/O buffer */
	UInt32			 bufLen				/**< number of bytes to write */
	) ;

/**	Close COM port */
Result_t TOOL_CloseComPort( 
	ComPortCfg_t	*comPort			/**< COM port configuration */
	) ;

/**	Read from COM port with timeout. */
Result_t TOOL_ReadComPortWithTimeout( 
	ComPortCfg_t	*comPort,			/**< COM port configuration */
	void			*buf,				/**< I/O buffer */
	UInt32			 bufLen,			/**< number of bytes to read */
	UInt8			 toSec ) ;			/**< timeout in seconds */

/**	Write to COM port with timeout. */
Result_t TOOL_WriteComPortWithTimeout( 
	ComPortCfg_t	*comPort,			/**< COM port configuration */
	void			*buf,				/**< I/O buffer */
	UInt32			 bufLen,			/**< number of bytes to write */
	UInt8			 toSec ) ;			/**< timeout in seconds */

UInt32 TOOL_SwapU32( UInt32 x ) ;
UInt16 TOOL_SwapU16( UInt16 x ) ;

/** key-keyname association */
typedef struct {
	int		keyId ;				/**< key ID */
	char	*name ;				/**< key name */
}	ParmFileKeyTbl_t ;

/** parsed line information */
typedef struct {
  int		keyId;				/**< the key ID */
  int		nParam;				/**< number of parameters */
  char		params[32][32+1];	/**< array of parameters */
  int		lineNo;				/**< line number in text file */
} ParmFileLineInfo_t;

/** Load a basic parameter file.  A basic parameter file is a text file where each
 *	line defines a keyword and a number of optional parameters in the format,
 *
 *		keyword [parm1 [parm2 [parm3 [... parmn]]]
 *
 *	Comments may be added either starting with '#' or '//'; all characters in
 *	following and including the comment mark are ignored.
 *	
 */
Result_t TOOL_LoadBasicParamFile( 
	FILE *				inFile,			/**< pointer to input file */
	ParmFileKeyTbl_t*	keyTbl,			/**< pointer to key table */
	ParmFileLineInfo_t*	lineInfoPtr,	/**< pointer to parsed line info */
	int					maxLineInfo,	/**< max number of parsed lines */
	int*				numLineInfo		/**< actual number of parsed lines */
	) ;

#endif // _WIN32

#define FLASHLOADER_CMD_NOR_LOAD_IMAGE			0xffff0000	//	p1 = startAddr; p2 = imageSize
#define FLASHLOADER_CMD_NOR_CAPTURE_IMAGE		0xffff0001
#define FLASHLOADER_CMD_NOR_ALLERASE			0xffff0002
#define FLASHLOADER_CMD_NOR_IDCHECK				0xffff0003
#define FLASHLOADER_CMD_NAND_LOAD_IMAGE			0xffff0004	//	p1 = startAddr; p2 = imageSize
#define FLASHLOADER_CMD_NAND_CAPTURE_IMAGE		0xffff0005
#define FLASHLOADER_CMD_NAND_ALLERASE			0xffff0006
#define FLASHLOADER_CMD_NAND_IDCHECK			0xffff0007

#define FLASHLOADER_CMD_TFS_FORMAT				0xffff0008
#define FLASHLOADER_CMD_TFS_EXPLORER			0xffff0009
#define FLASHLOADER_CMD_TFLASH					0xffff0010
#define FLASHLOADER_CMD_BADBLK_CHECK			0xffff0011
#define FLASHLOADER_CMD_DISPLAY_BBT				0xffff0012
#define FLASHLOADER_CMD_NAND_PARTIAL_ERASE		0xffff0013
#define FLASHLOADER_CMD_BML_FORMAT				0xffff0014

#define FLASHLOADER_CMD_RESET					0xffff0015	//	p1 = cause
#define FLASHLOADER_CMD_INIT_COMM				0xffff0016	//	p1 = baudRate
#define FLASHLOADER_CMD_EXIT_DRIVER				0xffff0017
#define FLASHLOADER_CMD_PHONE_RESET				0xffff0018
#define FLASHLOADER_CMD_SET_DATE				0xffff0019
#define FLASHLOADER_CMD_BML_GETINFO             0xffff001B

#define FLASHLOADER_CMD_TFS_MOUNT                                  0xffff0020
#define FLASHLOADER_CMD_SET_TFSTIME                                0xffff0021
#define FLASHLOADER_CMD_CREATE_DIR                                 0xffff0022
#define FLASHLOADER_CMD_CREATE_TFS_VERSION                  0xffff0023
#define FLASHLOADER_CMD_CREATE_TFS_RELEASE_VERSION   0xffff0024
#define FLASHLOADER_CMD_NO_TFS_RELEASE_VERSION           0xffff0025
#define FLASHLOADER_CMD_CREATE_FILE                               0xffff0026
#define FLASHLOADER_CMD_CREATE_FILE_CONT_CHECK         0xffff0027
#define FLASHLOADER_CMD_FORMAT_NAND                            0xffff0028
#define FLASHLOADER_CMD_CHECK_NAND_STATUS                 0xffff0029
#define FLASHLOADER_CMD_UNMOUNT_TFS                            0xffff002A
#define FLASHLOADER_CMD_READ_TFS_DIR                             0xffff002B
#define FLASHLOADER_CMD_READ_TFS_FILE_STATUS              0xffff002C
#define FLASHLOADER_CMD_READ_TFS_FILE_SIZE                    0xffff002D
#define FLASHLOADER_CMD_READ_TFS_ONE_FILE                   0xffff002E
#define FLASHLOADER_CMD_DELETE_TFS_FILE                        0xffff002F
#define FLASHLOADER_CMD_WRITE_COMPLETE_NAND					0xffff0030
#define FLASHLOADER_CMD_WRITE_NAND_CHECKSUM					0xffff0031

#define FLASHLOADER_CMD_TRAILER					0xff00ff00	//	end command
typedef struct {
	UInt32	id ;
	UInt32	p1 ;
	UInt32	p2 ;
	UInt32	ct ;
}	FLASHLOADER_Cmd_t ;


extern int checkER;
extern int checkPARAM;
extern int checkRC1;
extern int checkRC2;
extern int checkCALSET;
extern int checkBOOT2;



#ifndef _WIN32

#include <stdarg.h>

#include "irqctrl.h"

typedef void (*FLASHLOADER_IrqController_t)( void ) ;

//
//	symbols exported from flashloader_asm.s
//
IRQMask_t	FLASHLOADER_EnableFlashProgramming( void ) ;
void		FLASHLOADER_DisableFlashProgramming( IRQMask_t irqMask ) ;
void		FLASHLOADER_InitUSB( void ) ;
void		FLASHLOADER_ReadUSB( void * addr, UInt32 nBytes ) ;
void		FLASHLOADER_WriteUSB( void * addr, UInt32 nBytes ) ;
void		FLASHLOADER_SetIrqController( FLASHLOADER_IrqController_t irqController ) ;
void		FLASHLOADER_MapItcm( void ) ;
void		FLASHLOADER_MapFlash( void ) ;

#define		FLASHLOADER_RESET_ERROR		0

void		FLASHLOADER_Reset( UInt8 reason ) ;

//	NOTE:  use dbgPrintf for debugging and FLASHLOADER_PrintStr/FLASHLOADER_PrintHex
//	for production.

void dbgPrintf( char* fmt, ... ) ;
void FLASHLOADER_PrintStr( char* c ) ;
void FLASHLOADER_PrintHex( UInt32 x ) ;

#endif // _WIN32

#ifdef __cplusplus
}
#endif

#endif // __TOOL_API_H__
