//****************** Copyright 1997 Mobilink Telecom, Inc. *********************
//
// Description:  This file contains the global typedefs of the mobile station
//		processor software component
//
// $RCSfile: types.h $
// $Revision: 1.6 $
// $Date: 2000/08/09 17:32:38 $
// $Author: Iulia $
//
//******************************** History *************************************
//
// $Log: types.h $
// Revision 1.6  2000/08/09 17:32:38  Iulia
// Added definition of BitField.
// Revision 1.5  1998/09/25 17:04:19Z  dlwin
// Added ENABLE_DEBUG_CODE define.
// Revision 1.4  1997/03/13 01:59:10  awong
// Added INLINE, INTERRUPT, and TRAP #defines
// Revision 1.3  1997/03/06 19:01:58  kpaulsen
// Added newline to end of file to make armcc happy.
// Revision 1.2  1997/03/05 21:38:22  awong
// Updated headers (//)
// Added #ifndef stuff
// Revision 1.1  1997/03/05 00:24:55  awong
// Initial revision
//
//******************************************************************************

#ifndef _INC_TYPES_H_
#define _INC_TYPES_H_

typedef unsigned char UInt8;
typedef unsigned short UInt16;
typedef unsigned long UInt32;
typedef signed char Int8;
typedef signed short Int16;
typedef signed long Int32;
typedef UInt8 Boolean;
typedef unsigned int BitField;

#define INLINE							__inline
#define INTERRUPT						__irq
#define TRAP( trap_num )				__swi( (trap_num) )

#define ENABLE_DEBUG_CODE

#ifdef WIN32
typedef UInt8 SDL_Boolean;
#endif

typedef enum	// unicode types
{
	UNICODE_NONE 	= 0x00,			// not for unicode
	UNICODE_80 		= 0x80,			// unicode tag 80
	UNICODE_81 		= 0x81,			// unicode tag 81
	UNICODE_82 		= 0x82			// unicode tag 82
}Unicode_t;



#endif

