#ifndef __UART_API_H__
#define __UART_API_H__

#include "consts.h"
#include "types.h"

#define	DEBUG_PORT			((UInt8 *)(SERIAL_PORT_B))
#define	DOWNLOAD_PORT		((UInt8 *)(SERIAL_PORT_A))

//--- IER Bits
//#define	IER_RxInt_ENABLE	0x01
//#define	IER_TxInt_ENABLE	0x02

//--- FCR Bits
#define	FCR_FIFO_ENABLE		0x01
#define	FCR_RX_FIFO_RESET	0x02
#define	FCR_TX_FIFO_RESET	0x04

//--- LCR Bits
#define	LCR_ENABLE_DIVISOR_LATCH	 0x80

//--- LSR Bits
#define	LSR_RX_RDY			0x01
#define	LSR_TX_EMPTY		0x20

//--- MCR Bits
//#define	MCR_LOOP_BACK		0x10

//---- PCR: IRPC bit (bit 5)
#define  IRPC_BIT			5

//--- registers map
#define	RxTxFifo			0x00	// Rx/Tx Holding Register (DLL)
#define	IER					0x04	// Interrupt Enable Register (DLM)
#define	FCR_ISR				0x08	// Fifo Control Register/Interrupt Status Register
#define	LCR					0x0C	// Line Control Register
//#define	MCR					0x10	// Modem Control Register
#define	LSR					0x14	// Line Status Register
//#define	MSR					0x16	// Modem Status Register
//#define	SPR					0x18	// Scratch Pad Register

//--- Baud Rate
//#define	BaudRate_28dot8		0x38 	// 115200
//#define	BaudRate_57dot6		0x1c 	// 115200
//#define	BaudRate_115dot2	0x0E 	// 115200
//#define	BaudRate_230dot4	0x38 	// 230400
//#define	BaudRate_460dot8	0x1c 	// 460800
//#define	BaudRate_921dot6	0x0E 	// 921600

//--- Parity
//#define	Parity_Odd   		0x08 		// Odd Parity
//#define	Parity_Even  		0x18		// Event Parity 
//#define	Parity_None  		0x00		// No Parity

//--- LineConfig
//#define	LC_5_Bit_Word_1    	0x00		// 5 Bit Word - 1 Stop Bit
//#define	LC_6_Bit_Word_1    	0x01		// 6 Bit Word - 1 Stop Bit
//#define	LC_7_Bit_Word_1    	0x02		// 7 Bit Word - 1 Stop Bit
//#define	LC_8_Bit_Word_1    	0x03		// 8 Bit Word - 1 Stop Bit
//#define	LC_5_Bit_Word_1p5  	0x04		// 5 Bit Word - 1.5 Stop Bit
//#define	LC_6_Bit_Word_2    	0x05		// 6 Bit Word - 2 Stop Bits
//#define	LC_7_Bit_Word_2    	0x06		// 6 Bit Word - 1 Stop Bit
//#define	LC_8_Bit_Word_2    	0x07		// 8 Bit Word - 2 Stop Bits

//#define DQ7					0x80
//#define DQ5					0x20

void UART_Init(
	UInt8 	*port,
	UInt8	fcr_isr,
	UInt16  booster,
	UInt16	baudrate,
	UInt8	lineconfig_parity);

UInt8 UART_RecvChr(
	UInt8	*port);

void UART_SendChr(
	UInt8	*port,
	UInt8	value);

void UART_SendHex(
	UInt8	*port,
	UInt8	length,
	UInt32	value);

void UART_SendStr(
	UInt8	*port,
	UInt8	*string);

void UART_ClrRxBuff(
	UInt8	*port);

void UART_SendUInt32BS( UInt8 * port, UInt32 u ) ;
UInt32 UART_RecvUInt32BS( UInt8 * port ) ;

#endif // __UART_API_H__