# /etc/bash.bashrc: executed by bash(1) for non-login shells.
#
export HOME="/data/local"
export PATH="/sbin:/bin:/system/bin:/system/xbin:/data/local/tmp"

# If not running interactively, don't do anything
[ -z "$PS1" ] && return

# We want /system/xbin first. Not to get confused with lame
# toolbox commands
#
export PATH="/system/xbin:/sbin:/system/bin:/data/local/tmp"
echo PATH is $PATH

# let's be honest. Why are we here if we don't want to modify /system?
if [ $(id -u) -eq 0 ]; then
    echo "Running as root - Mounted /system as read/write"
    mount -o rw,remount /
    mount -o rw,remount /system
fi

# Prompt color codes
txtblk='\e[0;30m' # Black - Regular
txtred='\e[0;31m' # Red
txtgrn='\e[0;32m' # Green
txtylw='\e[0;33m' # Yellow
txtblu='\e[0;34m' # Blue
txtpur='\e[0;35m' # Purple
txtcyn='\e[0;36m' # Cyan
txtwht='\e[0;37m' # White
bldblk='\e[1;30m' # Black - Bold
bldred='\e[1;31m' # Red
bldgrn='\e[1;32m' # Green
bldylw='\e[1;33m' # Yellow
bldblu='\e[1;34m' # Blue
bldpur='\e[1;35m' # Purple
bldcyn='\e[1;36m' # Cyan
bldwht='\e[1;37m' # White
unkblk='\e[4;30m' # Black - Underline
undred='\e[4;31m' # Red
undgrn='\e[4;32m' # Green
undylw='\e[4;33m' # Yellow
undblu='\e[4;34m' # Blue
undpur='\e[4;35m' # Purple
undcyn='\e[4;36m' # Cyan
undwht='\e[4;37m' # White
bakblk='\e[40m'   # Black - Background
bakred='\e[41m'   # Red
badgrn='\e[42m'   # Green
bakylw='\e[43m'   # Yellow
bakblu='\e[44m'   # Blue
bakpur='\e[45m'   # Purple
bakcyn='\e[46m'   # Cyan
bakwht='\e[47m'   # White
txtrst='\e[0m'    # Text Reset

# Set rows and columns
#stty rows 44 cols 132
#echo Terminal has 44 rows 132 columns
#echo Use '"stty rows <#rows> cols <#cols>" to change it'
#echo
