/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.midlet.MIDlet;

public class AudioMidlet
extends MIDlet
implements CommandListener,
PlayerListener,
Runnable {
    private static final String EXIT = "Exit";
    private static final String PAUSE = "Pause";
    private static final String PLAY = "Play";
    private Display display;
    private Form playerForm;
    private Thread thread;
    private Player player;
    private StringItem curStatus;
    private final Command cmdExit = new Command("Exit", 7, 2);
    private final Command cmdPause = new Command("Pause", 8, 1);
    private final Command cmdPlay = new Command("Play", 8, 1);

    public AudioMidlet() {
        this.display = Display.getDisplay((MIDlet)this);
        this.playerForm = new Form("MMAPI Audio");
        this.initAudio();
        this.curStatus = new StringItem("Player Status:", "Reading Content");
        this.playerForm.append((Item)this.curStatus);
        this.playerForm.addCommand(this.cmdExit);
        this.playerForm.addCommand(this.cmdPause);
        this.playerForm.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.playerForm);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.playerClose();
    }

    public void exitMidlet() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void initAudio() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/Mozart1.mid");
            this.player = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
            this.player.setLoopCount(-1);
            this.player.realize();
            this.player.prefetch();
            this.player.addPlayerListener((PlayerListener)this);
        }
        catch (Exception exception) {
            if (this.player != null) {
                this.player.close();
                this.player = null;
            }
            System.err.println("Problem creating player" + exception);
        }
        this.startPlayer();
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string == "started") {
            this.curStatus.setText("Started Playing Audio");
        } else if (string == "stopped") {
            this.curStatus.setText("Stopped Playing Audio");
        } else if (string == "closed") {
            this.curStatus.setText("Closed Playing Audio");
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdPause && displayable == this.playerForm) {
            this.playerPause();
            this.playerForm.removeCommand(this.cmdPause);
            this.playerForm.addCommand(this.cmdPlay);
        } else if (command == this.cmdExit && displayable == this.playerForm) {
            this.exitMidlet();
        } else if (command == this.cmdPlay && displayable == this.playerForm) {
            this.playerForm.removeCommand(this.cmdPlay);
            this.playerForm.addCommand(this.cmdPause);
            this.startPlayer();
        }
    }

    public void startPlayer() {
        if (this.player != null) {
            try {
                this.player.start();
            }
            catch (MediaException mediaException) {
                System.err.println((Object)mediaException);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    public void playerPause() {
        if (this.player != null) {
            try {
                this.player.stop();
            }
            catch (MediaException mediaException) {
                System.err.println((Object)mediaException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerClose() {
        AudioMidlet audioMidlet = this;
        synchronized (audioMidlet) {
            this.playerPause();
            if (this.player != null) {
                this.player.close();
                this.player = null;
            }
        }
    }
}

