/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;

class Client
implements DiscoveryListener {
    private DiscoveryAgent discoveryAgent;
    private UUID[] uuidSet;
    private String serviceUrl;
    private Display display = null;
    private StreamConnection conn = null;
    private final Form form = new Form("Client...");
    private static final String CLIENTMSG = "\nHello From Client..";

    public Client(Display dis) {
        this.display = dis;
        this.display.setCurrent((Displayable)this.form);
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = localDevice.getDiscoveryAgent();
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
            this.form.append("\nstart Inquiry...");
            this.form.append("\nSearching for device...");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        try {
            this.form.append("\nDevice Discovered");
            this.form.append("\nMajor Device Class: " + cod.getMajorDeviceClass() + " Minor Device Class: " + cod.getMinorDeviceClass());
            this.form.append("\nBluetooth Address: " + btDevice.getBluetoothAddress());
            this.form.append("\nBluetooth Friendly Name: " + btDevice.getFriendlyName(true));
            this.uuidSet = new UUID[1];
            this.uuidSet[0] = BluetoothDemo.RFCOMM_UUID;
            int searchID = this.discoveryAgent.searchServices(null, this.uuidSet, btDevice, (DiscoveryListener)this);
        }
        catch (Exception e) {
            this.form.append("\nDevice Discovered Error: " + e);
        }
    }

    public void inquiryCompleted(int discType) {
        this.form.append("\nInquiryCompleted");
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        this.form.append("\nServicesDiscovered");
        for (int i = 0; i < servRecord.length; ++i) {
            this.serviceUrl = servRecord[i].getConnectionURL(0, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int responseCode) {
        if (responseCode == 3) {
            this.form.append("\nSERVICE_SEARCH_ERROR\n");
        }
        if (responseCode == 1) {
            this.form.append("\nSERVICE_SEARCH_COMPLETED\n");
            this.form.append("\nService URL: " + this.serviceUrl);
            try {
                int ch;
                Alert alert = new Alert("Info...", "Server Responding...", null, AlertType.INFO);
                alert.setTimeout(1200);
                this.conn = (StreamConnection)Connector.open((String)this.serviceUrl);
                OutputStream output = this.conn.openOutputStream();
                InputStream inputStream = this.conn.openInputStream();
                int length = inputStream.read();
                byte[] data = null;
                data = new byte[length];
                for (length = 0; length != data.length; length += ch) {
                    ch = inputStream.read(data, length, data.length - length);
                    if (ch != -1) continue;
                    throw new IOException("Can't read data");
                }
                String msg = new String(data);
                this.form.append(msg);
                this.display.setCurrent((Displayable)this.form);
                output.write(CLIENTMSG.length());
                output.write(CLIENTMSG.getBytes());
                output.close();
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
            finally {
                try {
                    this.conn.close();
                }
                catch (IOException ioe) {
                    this.form.append("Error Closing connection " + ioe);
                }
            }
        }
        if (responseCode == 2) {
            this.form.append("\nSERVICE_SEARCH_TERMINATED\n");
        }
        if (responseCode == 4) {
            this.form.append("\nSERVICE_SEARCH_NO_RECORDS\n");
        }
        if (responseCode == 6) {
            this.form.append("\nSERVICE_SEARCH_DEVICE_NOT_REACHABLE\n");
        }
    }
}

