/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;

class Server
implements Runnable {
    private StreamConnectionNotifier notifier;
    private StreamConnection conn;
    private LocalDevice localDevice;
    private boolean isInit;
    private static final String SERVERURL = "btspp://localhost:" + BluetoothDemo.RFCOMM_UUID + ";name=rfcommtest;authorize=false";
    private Display display = null;
    private final Form form = new Form("Server...");
    private static final String SERVERMSG = "\nHello Form Server...";

    public Server(Display dis) {
        this.display = dis;
        this.display.setCurrent((Displayable)this.form);
        this.isInit = false;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        if (!this.isInit) {
            try {
                this.conn = null;
                this.form.append("Searching for Client...");
                this.localDevice = LocalDevice.getLocalDevice();
                this.localDevice.setDiscoverable(10390323);
                this.notifier = (StreamConnectionNotifier)Connector.open((String)SERVERURL);
            }
            catch (BluetoothStateException e) {
                this.form.append("BluetoothStateException: " + e.getMessage());
            }
            catch (IOException e) {
                this.form.append("IOException: " + e.getMessage());
            }
            this.isInit = true;
        }
        try {
            int ch;
            this.conn = this.notifier.acceptAndOpen();
            OutputStream output = this.conn.openOutputStream();
            output.write(SERVERMSG.length());
            output.write(SERVERMSG.getBytes());
            output.close();
            InputStream inputStream = this.conn.openInputStream();
            int length = inputStream.read();
            byte[] data = null;
            data = new byte[length];
            for (length = 0; length != data.length; length += ch) {
                ch = inputStream.read(data, length, data.length - length);
                if (ch != -1) continue;
                throw new IOException("Can't read data");
            }
            String msg = new String(data);
            this.form.append(msg);
            inputStream.close();
            this.conn.close();
            this.notifier.close();
        }
        catch (Exception ex) {
            this.form.append("Bluetooth Server Running Error: " + ex);
        }
    }
}

