/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class ClientServer
implements DiscoveryListener {
    UUID RFCOMM_UUID = new UUID(3L);
    private StreamConnection streamConn = null;
    private LocalDevice localDevice = null;
    private InputStream inputSteam = null;
    private OutputStream outputStream = null;
    private StreamConnectionNotifier notifier = null;
    public boolean isServer = false;
    public boolean isServerFound = false;
    public boolean isInitServer = false;
    public boolean isInitClient = false;
    private static String serverUrl;
    private final String CLIENT_RESPONSE;
    private DiscoveryAgent agent = null;

    public ClientServer(boolean isServer) {
        this.CLIENT_RESPONSE = "CLIENT READY";
        this.isServer = isServer;
        if (this.isServer) {
            this.initServer();
        } else {
            this.initClient();
        }
    }

    private void initServer() {
        serverUrl = "btspp://localhost:" + this.RFCOMM_UUID + ";name=rfcommtest;authorize=true";
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            this.localDevice.setDiscoverable(10390323);
            this.notifier = (StreamConnectionNotifier)Connector.open((String)serverUrl);
            this.streamConn = this.notifier.acceptAndOpen();
            this.isInitServer = true;
            this.outputStream = this.streamConn.openOutputStream();
            this.inputSteam = this.streamConn.openInputStream();
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initClient() {
        this.searchAvailDevices();
    }

    public void searchAvailDevices() {
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            this.agent = this.localDevice.getDiscoveryAgent();
            this.agent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException ex) {
            ex.printStackTrace();
        }
    }

    public void sendMessages(String strData) {
        if (this.isInitClient || this.isInitServer) {
            try {
                this.outputStream.write(strData.length());
                this.outputStream.write(strData.getBytes());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String recieveMessages() {
        byte[] data = null;
        try {
            int ch;
            int length = this.inputSteam.read();
            data = new byte[length];
            for (length = 0; length != data.length; length += ch) {
                ch = this.inputSteam.read(data, length, data.length - length);
                if (ch != -1) continue;
                throw new IOException("Can't read data");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(data);
    }

    public void inquiryCompleted(int discType) {
        System.out.println("InquiryCompleted");
    }

    public void serviceSearchCompleted(int transID, int respCode) {
        if (this.isServerFound) {
            try {
                this.streamConn = (StreamConnection)Connector.open((String)serverUrl);
                this.outputStream = this.streamConn.openOutputStream();
                this.inputSteam = this.streamConn.openInputStream();
                this.outputStream.write("CLIENT READY".length());
                this.outputStream.write("CLIENT READY".getBytes());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    void closeAll() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.inputSteam != null) {
                this.inputSteam.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] records) {
        for (int i = 0; i < records.length; ++i) {
            serverUrl = records[i].getConnectionURL(2, false);
            if (!serverUrl.startsWith("btspp")) continue;
            this.isServerFound = true;
            this.isInitClient = true;
            break;
        }
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        try {
            System.out.println("Device Discovered");
            System.out.println("Major Device Class: " + cod.getMajorDeviceClass() + " Minor Device Class: " + cod.getMinorDeviceClass());
            System.out.println("Bluetooth Address: " + btDevice.getBluetoothAddress());
            System.out.println("Bluetooth Friendly Name: " + btDevice.getFriendlyName(true));
            UUID[] uuidSet = new UUID[]{this.RFCOMM_UUID};
            this.agent.searchServices(null, uuidSet, btDevice, (DiscoveryListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

