/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MainCanvas
extends Canvas
implements CommandListener {
    CanvasMidlet midlet;
    int width;
    int height;
    private final Command cmdExit = new Command("Exit", 7, 2);
    private final Command cmdSelect = new Command("Select", 4, 2);
    private Command leftCommand = null;
    private Command rightCommand = null;
    private Font font = null;
    private boolean selected;
    private String keyvalue = null;
    private String keyname = null;

    public MainCanvas(CanvasMidlet midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.font = Font.getDefaultFont();
        this.addCommand(this.cmdExit, 1);
        this.addCommand(this.cmdSelect, 0);
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    public void drawCommands(Graphics g) {
        g.setColor(0, 0, 0);
        if (this.leftCommand != null && this.leftCommand.getLabel().equals("Select")) {
            g.drawString("Select", 0, this.height - this.font.getHeight() - 1, 0);
        }
        if (this.rightCommand != null && this.rightCommand.getLabel().equals("Exit")) {
            g.drawString("Exit", this.width - this.font.stringWidth("Exit") - 1, this.height - this.font.getHeight() - 1, 20);
        }
    }

    public void addCommand(Command cmd, int pos) {
        if (pos == 0) {
            this.leftCommand = cmd;
        } else {
            this.rightCommand = cmd;
        }
    }

    public void paint(Graphics g) {
        g.setColor(138, 237, 244);
        g.fillRect(0, 0, this.width, this.height);
        g.setFont(this.font);
        if (this.selected) {
            g.setColor(255, 255, 255);
        } else {
            g.setColor(0, 0, 255);
        }
        g.drawString("Welcome to ", this.width / 2, 0, 17);
        g.drawString("Samsung Mobile Innovator", this.width / 2, this.font.getHeight(), 17);
        g.setColor(0, 0, 0);
        g.drawString("KeyPressed", this.width / 2, this.font.getHeight() * 2, 17);
        if (this.keyvalue != null) {
            g.drawString("keyvalue=" + this.keyvalue, this.width / 2, this.font.getHeight() * 3, 17);
        }
        if (this.keyname != null) {
            g.drawString("keyname=" + this.keyname, this.width / 2, this.font.getHeight() * 4, 17);
        }
        this.drawCommands(g);
    }

    public void commandAction(Command cmd, Displayable disp) {
        if (cmd == this.cmdExit) {
            this.midlet.exitMidlet();
        } else if (cmd == this.cmdSelect) {
            this.selected = !this.selected;
            this.repaint();
        }
    }

    public void keyPressed(int keycode) {
        this.keyvalue = Integer.toString(keycode);
        this.keyname = this.getKeyName(keycode);
        switch (keycode) {
            case -7: {
                if (this.rightCommand == null) break;
                this.commandAction(this.rightCommand, (Displayable)this);
                break;
            }
            case -6: {
                if (this.leftCommand == null) break;
                this.commandAction(this.leftCommand, (Displayable)this);
            }
        }
        this.repaint();
    }
}

