/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Invocation;
import javax.microedition.content.Registry;
import javax.microedition.content.RequestListener;
import javax.microedition.content.ResponseListener;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class ContentMidlet
extends MIDlet
implements CommandListener,
RequestListener,
ResponseListener {
    Invocation invoc;
    ContentHandlerServer handler;
    Registry registry;
    Display display;
    Form form;
    ImageItem imageItem;
    TextField urlField;
    Command backCommand = new Command("Back", 2, 1);
    Command goCommand = new Command("Go", 4, 1);
    Command saveCommand = new Command("Save", 1, 2);

    public ContentMidlet() {
        this.display = Display.getDisplay((MIDlet)this);
        this.form = new Form("Content Viewer");
        this.urlField = new TextField("Enter a link to an image", "http://", 90, 1);
        this.imageItem = new ImageItem(null, null, 3, "-no image-");
        this.form.setCommandListener((CommandListener)this);
        this.displayURL();
        this.registry = Registry.getRegistry((String)"example.contentviewer.ContentViewer");
        this.registry.setListener((ResponseListener)this);
        try {
            this.handler = Registry.getServer((String)"example.contentviewer.ContentViewer");
        }
        catch (ContentHandlerException che) {
            this.register();
        }
        if (this.handler != null) {
            this.handler.setListener((RequestListener)this);
        }
    }

    void displayURL() {
        this.form.deleteAll();
        this.form.removeCommand(this.backCommand);
        this.form.removeCommand(this.saveCommand);
        this.form.addCommand(this.goCommand);
        this.form.append((Item)this.urlField);
        this.display.setCurrent((Displayable)this.form);
    }

    void showImage(Image image) {
        this.form.deleteAll();
        this.form.removeCommand(this.goCommand);
        this.imageItem.setImage(image);
        this.form.addCommand(this.backCommand);
        this.form.addCommand(this.saveCommand);
        this.form.append((Item)this.imageItem);
        this.display.setCurrent((Displayable)this.form);
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean force) {
        if (this.handler != null) {
            this.handler.setListener(null);
        }
        if (this.registry != null) {
            this.registry.setListener(null);
        }
        this.finish(5);
    }

    public void invocationRequestNotify(ContentHandlerServer h) {
        if (this.invoc != null) {
            this.handler.finish(this.invoc, 5);
        }
        this.invoc = this.handler.getRequest(false);
        if (this.invoc != null) {
            this.displayImage(this.invoc);
        }
    }

    public void invocationResponseNotify(Registry r) {
        Invocation resp = r.getResponse(false);
        if (resp != null) {
            int st = resp.getStatus();
            String msg = st == 5 ? "Request successful" : (st == 6 ? "Request cancelled" : "Request failed");
            this.displayURL();
            Alert alert = new Alert("Request completed", msg, null, AlertType.INFO);
            this.display.setCurrent(alert, (Displayable)this.form);
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.backCommand) {
            this.finish(5);
            this.display.setCurrent(null);
        }
        if (c == this.goCommand) {
            new Thread(){

                public void run() {
                    ContentMidlet.this.doInvoke(ContentMidlet.this.urlField.getString());
                }
            }.start();
        }
        if (c == this.saveCommand) {
            new Thread(){

                public void run() {
                    ContentMidlet.this.doSave();
                }
            }.start();
        }
    }

    void doInvoke(String url) {
        try {
            Invocation invoc = new Invocation(url);
            boolean mustExit = this.registry.invoke(invoc);
            if (mustExit) {
                this.destroyApp(true);
                this.notifyDestroyed();
            }
        }
        catch (IOException ex) {
            Alert alert = new Alert("Image not available", "Could not link to " + url, null, null);
            this.display.setCurrent((Displayable)alert);
        }
    }

    boolean finish(int status) {
        if (this.invoc != null) {
            boolean mustExit = this.handler.finish(this.invoc, status);
            this.invoc = null;
            if (mustExit) {
                this.destroyApp(true);
                this.notifyDestroyed();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void displayImage(Invocation invoc) {
        HttpConnection conn = null;
        InputStream is = null;
        if (this.imageItem != null) {
            this.imageItem.setImage(null);
        }
        try {
            conn = (HttpConnection)invoc.open(false);
            int status = conn.getResponseCode();
            if (status != 200) {
                Alert alert = new Alert("Can not display the image", "image not found at " + invoc.getURL(), null, AlertType.ERROR);
                this.display.setCurrent((Displayable)alert);
                this.finish(6);
                return;
            }
            String type = conn.getType();
            if (!"image/png".equals(type)) {
                Alert alert = new Alert("Can not display the image", "Unknown type " + type, null, AlertType.ERROR);
                this.display.setCurrent((Displayable)alert);
                this.finish(6);
                return;
            }
            is = conn.openInputStream();
            Image image = Image.createImage((InputStream)is);
            this.showImage(image);
            this.display.setCurrent((Displayable)this.form);
            return;
        }
        catch (IOException e) {
            Alert alert = new Alert("Can not display the image", "Image not available", null, AlertType.ERROR);
            this.display.setCurrent((Displayable)alert);
            this.finish(6);
            return;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    void register() {
        try {
            String[] chTypes = new String[]{"image/png"};
            String[] chSuffixes = new String[]{".png"};
            String[] chActions = new String[]{"open"};
            String CHID = "com.samsung.contentviewer";
            String[] ACCESS_ALLOWED = new String[]{"com.sun.example"};
            this.handler = this.registry.register("example.contentviewer.ContentViewer", chTypes, chSuffixes, chActions, null, CHID, ACCESS_ALLOWED);
        }
        catch (ContentHandlerException ex) {
            Alert alert = new Alert("Unable to register handler", "Handler conflicts with another handler", null, AlertType.ERROR);
            this.display.setCurrent((Displayable)alert);
        }
        catch (ClassNotFoundException cnf) {
            Alert alert = new Alert("Unable to register handler", "Handler class not found", null, AlertType.ERROR);
            this.display.setCurrent((Displayable)alert);
        }
    }

    void doSave() {
        try {
            Invocation nextInvoc = new Invocation();
            nextInvoc.setID("ScreenSaver");
            nextInvoc.setURL(this.invoc.getURL());
            nextInvoc.setResponseRequired(false);
            boolean mustExit = this.registry.invoke(nextInvoc, this.invoc);
            if (mustExit) {
                this.destroyApp(true);
                this.notifyDestroyed();
            }
        }
        catch (IOException ex) {
            Alert alert = new Alert("Invoking ScreenSaver", "Could not save the image", null, AlertType.ERROR);
            this.display.setCurrent((Displayable)alert);
        }
    }
}

