/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class FileMidletDemo
extends MIDlet
implements CommandListener {
    private Display display = null;
    private final Command CMD_EXIT = new Command("Exit", 7, 1);
    private final Command CMD_VIEW = new Command("View", 1, 2);
    private final Command CMD_NEW = new Command("New", 1, 3);
    private final Command CMD_OK = new Command("Ok", 4, 4);
    private final Command CMD_DELETE = new Command("Delete", 1, 5);
    private final String SEPERATOR;
    private Image image_dir = null;
    private Image image_file = null;
    private final char SEP = (char)47;
    private final String INIT_DIR;
    private String currentDir = "/";
    private TextField textField = null;
    private ChoiceGroup choiceGroup = null;

    public FileMidletDemo() {
        this.SEPERATOR = "/";
        this.INIT_DIR = "..";
        this.initRes();
        this.display = Display.getDisplay((MIDlet)this);
        this.initFileSys();
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
    }

    private void createFile() {
        Form form = new Form("New File");
        this.textField = new TextField("Enter Name", null, 256, 0);
        this.choiceGroup = new ChoiceGroup("Enter the file Name", 1, new String[]{"Regular File", "Directory"}, new Image[]{this.image_file, this.image_dir});
        form.addCommand(this.CMD_EXIT);
        form.addCommand(this.CMD_OK);
        form.append((Item)this.textField);
        form.append((Item)this.choiceGroup);
        form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)form);
    }

    private void executeMentionFile(String newFile, boolean isDir) {
        try {
            FileConnection fileConn = (FileConnection)Connector.open((String)("file:///" + this.currentDir + newFile));
            if (isDir) {
                fileConn.mkdir();
            } else {
                fileConn.create();
            }
            this.initFileSys();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showFile(String fileName) {
    }

    private void traversDir(String fileName) {
        if (this.currentDir.equals("/")) {
            if (fileName.equals("..")) {
                return;
            }
            this.currentDir = fileName;
        } else {
            int i;
            this.currentDir = fileName.equals("..") ? ((i = this.currentDir.lastIndexOf(47, this.currentDir.length() - 2)) != -1 ? this.currentDir.substring(0, i + 1) : "/") : this.currentDir + fileName;
        }
        this.initFileSys();
    }

    private void deleteFolder(String folder) {
        try {
            FileConnection fileConn = (FileConnection)Connector.open((String)("file://localhost/" + this.currentDir + folder));
            Enumeration e = fileConn.list("*", true);
            if (!e.hasMoreElements()) {
                fileConn.delete();
                this.initFileSys();
            } else {
                Alert alert = new Alert("Error!!!", "Cann't delete empty folder", null, AlertType.ERROR);
                alert.setTimeout(-2);
                alert.addCommand(this.CMD_EXIT);
                alert.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)alert);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteFile(String file) {
        try {
            FileConnection fileConn = (FileConnection)Connector.open((String)("file://localhost/" + this.currentDir + file));
            fileConn.delete();
        }
        catch (IOException e) {
            Alert alert = new Alert("Error!", "Can not access/delete file " + file + " in directory " + this.currentDir + "\nException: " + e.getMessage(), null, AlertType.ERROR);
            alert.setTimeout(-2);
            alert.addCommand(this.CMD_EXIT);
            alert.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)alert);
        }
    }

    private void delete(String file) {
        if (!file.endsWith("..")) {
            if (file.charAt(file.length() - 1) == '/') {
                this.deleteFolder(file);
            } else {
                this.deleteFile(file);
            }
        }
        this.initFileSys();
    }

    private void initRes() {
        try {
            this.image_dir = Image.createImage((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/dir.png"));
            this.image_file = Image.createImage((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/file.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initFileSys() {
        List dirList = null;
        Enumeration e = null;
        FileConnection fileConn = null;
        if ("/".equals(this.currentDir)) {
            e = FileSystemRegistry.listRoots();
            dirList = new List(this.currentDir, 3);
        } else {
            try {
                fileConn = (FileConnection)Connector.open((String)("file://localhost/" + this.currentDir));
                e = fileConn.list();
                dirList = new List(this.currentDir, 3);
                dirList.append("..", this.image_dir);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        while (e.hasMoreElements()) {
            String element = (String)e.nextElement();
            if (element.charAt(element.length() - 1) == '/') {
                dirList.append(element, this.image_dir);
                continue;
            }
            dirList.append(element, this.image_file);
        }
        if (fileConn != null) {
            try {
                fileConn.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        dirList.addCommand(this.CMD_EXIT);
        dirList.addCommand(this.CMD_VIEW);
        dirList.addCommand(this.CMD_NEW);
        dirList.addCommand(this.CMD_DELETE);
        dirList.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)dirList);
    }

    public void commandAction(Command cmd, Displayable dis) {
        if (cmd == this.CMD_EXIT) {
            try {
                this.destroyApp(true);
                this.notifyDestroyed();
            }
            catch (MIDletStateChangeException e) {
                e.printStackTrace();
            }
        } else if (cmd == this.CMD_VIEW) {
            List dirList = (List)dis;
            final String currentfile = dirList.getString(dirList.getSelectedIndex());
            new Thread(new Runnable(){

                public void run() {
                    if (currentfile.charAt(currentfile.length() - 1) == '/' || currentfile.endsWith("..")) {
                        FileMidletDemo.this.traversDir(currentfile);
                    } else {
                        FileMidletDemo.this.showFile(currentfile);
                    }
                }
            }).start();
        } else if (cmd == this.CMD_NEW) {
            this.createFile();
        } else if (cmd == this.CMD_OK) {
            final String newFile = this.textField.getString();
            if (newFile == null || newFile.equals("")) {
                Alert alert = new Alert("Error!!!", "File name is empty....", null, AlertType.ERROR);
                alert.setTimeout(-2);
                alert.addCommand(this.CMD_EXIT);
                alert.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)alert);
            } else {
                new Thread(new Runnable(){

                    public void run() {
                        FileMidletDemo.this.executeMentionFile(newFile, FileMidletDemo.this.choiceGroup.getSelectedIndex() != 0);
                    }
                }).start();
            }
        } else if (cmd == this.CMD_DELETE) {
            List list = (List)dis;
            final String file = list.getString(list.getSelectedIndex());
            new Thread(new Runnable(){

                public void run() {
                    FileMidletDemo.this.delete(file);
                }
            }).start();
        }
    }
}

