/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;

public class GMapDisplay
extends Form
implements CommandListener,
HttpResponse {
    GMapMidlet midlet;
    private static final Command searchCmd = new Command("Search", 1, 1);
    private static final Command exitCmd = new Command("Exit", 7, 2);
    public static final Command backCmd = new Command("Back", 2, 2);
    public static final Command showMapCmd = new Command("showMap", 1, 1);
    public static final Command selectCmd = new Command("Select", 1, 1);
    private TextField sourceField;
    private TextField destinationField;
    private HttpUtil util;
    private Form mapForm = null;
    private XMLParser xmlParser;
    private Vector routeVector;
    private Form routeDetailsForm;
    private List routeList;
    private int zoomLevel;
    private int width;
    private int height;

    public GMapDisplay(GMapMidlet midlet) {
        super("Google Map");
        this.midlet = midlet;
        this.zoomLevel = 12;
        this.routeVector = new Vector();
        this.sourceField = new TextField("Enter Source", null, 1024, 0);
        this.destinationField = new TextField("Enter Destination", null, 1024, 0);
        this.util = new HttpUtil();
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.append((Item)this.sourceField);
        this.append((Item)this.destinationField);
        this.addCommand(searchCmd);
        this.addCommand(exitCmd);
        this.setCommandListener(this);
    }

    private void showWaitingForm() {
        Form form = new Form("Please Wait");
        form.append("Fetching Please Wait....");
        form.addCommand(backCmd);
        form.setCommandListener((CommandListener)this);
        this.midlet.display.setCurrent((Displayable)form);
    }

    private void showSelectedRouteMap(Image img) {
        if (this.mapForm == null) {
            this.mapForm = new Form("");
            this.mapForm.addCommand(backCmd);
            this.mapForm.setCommandListener((CommandListener)this);
        }
        this.mapForm.deleteAll();
        this.mapForm.append(img);
        this.midlet.display.setCurrent((Displayable)this.mapForm);
    }

    private void showRouteDetails(int index) {
        Route route = (Route)this.routeVector.elementAt(index);
        String selectedRouteDetails = route.getRouteDetails();
        if (this.routeDetailsForm == null) {
            this.routeDetailsForm = new Form("Route Details");
            this.routeDetailsForm.addCommand(showMapCmd);
            this.routeDetailsForm.addCommand(backCmd);
            this.routeDetailsForm.setCommandListener((CommandListener)this);
        }
        this.routeDetailsForm.deleteAll();
        this.routeDetailsForm.append("Route " + index + " : " + route.getSummary() + "\n" + "Distance : " + route.getDistance() + "\n" + "Time : " + route.getTimeToTravel());
        this.routeDetailsForm.append(selectedRouteDetails);
        this.midlet.display.setCurrent((Displayable)this.routeDetailsForm);
    }

    public void recievedData(String responseData, String screen, int status) {
        if (status == 200) {
            if (screen.equals("directions")) {
                this.parseDirectionsXML(responseData);
            } else if (screen.equals("map")) {
                Alert alert = new Alert("Error");
                alert.setString("Unable to Fetch. Try Again");
                alert.setTimeout(1500);
                this.midlet.display.setCurrent(alert, (Displayable)this.routeDetailsForm);
            }
        } else {
            Alert alert = new Alert("Error");
            alert.setString("Unable to Fetch. Try Again");
            alert.setTimeout(1500);
            if (screen.equals("map")) {
                this.midlet.display.setCurrent(alert, (Displayable)this.routeDetailsForm);
            } else {
                this.midlet.display.setCurrent(alert, (Displayable)this);
            }
        }
    }

    public void recievedImage(byte[] responseData, String screen, int status) {
        if (status == 200) {
            if (screen.equals("map")) {
                try {
                    Image mapImage = Image.createImage((byte[])responseData, (int)0, (int)responseData.length);
                    this.showSelectedRouteMap(mapImage);
                }
                catch (Exception e) {
                    Alert alert = new Alert("Error");
                    alert.setString("Unable to Fetch. Try Again");
                    alert.setTimeout(1500);
                    this.midlet.display.setCurrent(alert, (Displayable)this.routeDetailsForm);
                }
            }
        } else {
            Alert alert = new Alert("Error");
            alert.setString("Unable to Fetch. Try Again");
            alert.setTimeout(1500);
            if (screen.equals("map")) {
                this.midlet.display.setCurrent(alert, (Displayable)this.routeDetailsForm);
            } else {
                this.midlet.display.setCurrent(alert, (Displayable)this);
            }
        }
    }

    private void showRouteList() {
        this.routeList = new List("Available Routes", 3);
        for (int i = 0; i < this.routeVector.size(); ++i) {
            Route route = (Route)this.routeVector.elementAt(i);
            this.routeList.append("Route " + (i + 1) + " : " + route.getSummary() + "\n" + "Distance : " + route.getDistance() + "\n" + "Time : " + route.getTimeToTravel(), null);
        }
        this.routeList.addCommand(backCmd);
        this.routeList.setSelectCommand(selectCmd);
        this.routeList.setCommandListener((CommandListener)this);
        this.midlet.display.setCurrent((Displayable)this.routeList);
    }

    private void parseDirectionsXML(String XMLData) {
        try {
            this.xmlParser = new XMLParser();
            this.xmlParser.createParser(XMLData.getBytes());
            String status = "";
            this.routeVector.removeAllElements();
            do {
                this.xmlParser.read();
            } while (!this.xmlParser.startTag("DirectionsResponse"));
            while (!this.xmlParser.endTag("DirectionsResponse")) {
                this.xmlParser.read();
                if (this.xmlParser.startTag("status")) {
                    this.xmlParser.read();
                    status = this.xmlParser.getText();
                    continue;
                }
                if (!status.equals("OK") || !this.xmlParser.startTag("route")) continue;
                Route route = new Route();
                while (!this.xmlParser.endTag("route")) {
                    this.xmlParser.read();
                    if (this.xmlParser.startTag("summary")) {
                        this.xmlParser.read();
                        String summary = this.xmlParser.getText();
                        route.setSummary(summary);
                        continue;
                    }
                    if (this.xmlParser.startTag("leg")) {
                        Leg leg = new Leg();
                        while (!this.xmlParser.endTag("leg")) {
                            String text;
                            String value;
                            String lng;
                            String lat;
                            this.xmlParser.read();
                            if (this.xmlParser.startTag("step")) {
                                Step step = new Step();
                                while (!this.xmlParser.endTag("step")) {
                                    String text2;
                                    String value2;
                                    String lng2;
                                    String lat2;
                                    this.xmlParser.read();
                                    if (this.xmlParser.startTag("travel_mode")) {
                                        this.xmlParser.read();
                                        String travelMode = this.xmlParser.getText();
                                        step.setTravelMode(travelMode);
                                        continue;
                                    }
                                    if (this.xmlParser.startTag("start_location")) {
                                        while (!this.xmlParser.endTag("start_location")) {
                                            this.xmlParser.read();
                                            if (this.xmlParser.startTag("lat")) {
                                                this.xmlParser.read();
                                                lat2 = this.xmlParser.getText();
                                                step.setStepStartLatitude(lat2);
                                                continue;
                                            }
                                            if (!this.xmlParser.startTag("lng")) continue;
                                            this.xmlParser.read();
                                            lng2 = this.xmlParser.getText();
                                            step.setStepStartLongitude(lng2);
                                        }
                                        continue;
                                    }
                                    if (this.xmlParser.startTag("end_location")) {
                                        while (!this.xmlParser.endTag("end_location")) {
                                            this.xmlParser.read();
                                            if (this.xmlParser.startTag("lat")) {
                                                this.xmlParser.read();
                                                lat2 = this.xmlParser.getText();
                                                step.setStepEndLatitude(lat2);
                                                continue;
                                            }
                                            if (!this.xmlParser.startTag("lng")) continue;
                                            this.xmlParser.read();
                                            lng2 = this.xmlParser.getText();
                                            step.setStepEndLongitude(lng2);
                                        }
                                        continue;
                                    }
                                    if (this.xmlParser.startTag("polyline")) {
                                        while (!this.xmlParser.endTag("polyline")) {
                                            this.xmlParser.read();
                                            if (this.xmlParser.startTag("points")) {
                                                this.xmlParser.read();
                                                String points = this.xmlParser.getText();
                                                step.setPolylinePoints(points);
                                                continue;
                                            }
                                            if (!this.xmlParser.startTag("levels")) continue;
                                            this.xmlParser.read();
                                            String levels = this.xmlParser.getText();
                                            step.setPolylineLevels(levels);
                                        }
                                        continue;
                                    }
                                    if (this.xmlParser.startTag("duration")) {
                                        while (!this.xmlParser.endTag("duration")) {
                                            this.xmlParser.read();
                                            if (this.xmlParser.startTag("value")) {
                                                this.xmlParser.read();
                                                value2 = this.xmlParser.getText();
                                                step.setStepDurationValue(value2);
                                                continue;
                                            }
                                            if (!this.xmlParser.startTag("text")) continue;
                                            this.xmlParser.read();
                                            text2 = this.xmlParser.getText();
                                            step.setStepDurationText(text2);
                                        }
                                        continue;
                                    }
                                    if (this.xmlParser.startTag("html_instructions")) {
                                        this.xmlParser.read();
                                        String htmlInstructions = this.xmlParser.getText();
                                        step.setHtmlInstructions(htmlInstructions);
                                        continue;
                                    }
                                    if (!this.xmlParser.startTag("distance")) continue;
                                    while (!this.xmlParser.endTag("distance")) {
                                        this.xmlParser.read();
                                        if (this.xmlParser.startTag("value")) {
                                            this.xmlParser.read();
                                            value2 = this.xmlParser.getText();
                                            step.setStepDistanceValue(value2);
                                            continue;
                                        }
                                        if (!this.xmlParser.startTag("text")) continue;
                                        this.xmlParser.read();
                                        text2 = this.xmlParser.getText();
                                        step.setStepDistanceText(text2);
                                    }
                                }
                                leg.setStep(step);
                                continue;
                            }
                            if (this.xmlParser.startTag("start_location")) {
                                while (!this.xmlParser.endTag("start_location")) {
                                    this.xmlParser.read();
                                    if (this.xmlParser.startTag("lat")) {
                                        this.xmlParser.read();
                                        lat = this.xmlParser.getText();
                                        leg.setLegStartLatitude(lat);
                                        continue;
                                    }
                                    if (!this.xmlParser.startTag("lng")) continue;
                                    this.xmlParser.read();
                                    lng = this.xmlParser.getText();
                                    leg.setLegStartLongitude(lng);
                                }
                                continue;
                            }
                            if (this.xmlParser.startTag("end_location")) {
                                while (!this.xmlParser.endTag("end_location")) {
                                    this.xmlParser.read();
                                    if (this.xmlParser.startTag("lat")) {
                                        this.xmlParser.read();
                                        lat = this.xmlParser.getText();
                                        leg.setLegEndLatitude(lat);
                                        continue;
                                    }
                                    if (!this.xmlParser.startTag("lng")) continue;
                                    this.xmlParser.read();
                                    lng = this.xmlParser.getText();
                                    leg.setLegEndLongitude(lng);
                                }
                                continue;
                            }
                            if (this.xmlParser.startTag("duration")) {
                                while (!this.xmlParser.endTag("duration")) {
                                    this.xmlParser.read();
                                    if (this.xmlParser.startTag("value")) {
                                        this.xmlParser.read();
                                        value = this.xmlParser.getText();
                                        leg.setLegDurationValue(value);
                                        continue;
                                    }
                                    if (!this.xmlParser.startTag("text")) continue;
                                    this.xmlParser.read();
                                    text = this.xmlParser.getText();
                                    leg.setLegDurationText(text);
                                }
                                continue;
                            }
                            if (this.xmlParser.startTag("distance")) {
                                while (!this.xmlParser.endTag("distance")) {
                                    this.xmlParser.read();
                                    if (this.xmlParser.startTag("value")) {
                                        this.xmlParser.read();
                                        value = this.xmlParser.getText();
                                        leg.setLegDistanceValue(value);
                                        continue;
                                    }
                                    if (!this.xmlParser.startTag("text")) continue;
                                    this.xmlParser.read();
                                    text = this.xmlParser.getText();
                                    leg.setLegDistanceText(text);
                                }
                                continue;
                            }
                            if (this.xmlParser.startTag("start_address")) {
                                this.xmlParser.read();
                                String startAddress = this.xmlParser.getText();
                                leg.setStartAddress(startAddress);
                                continue;
                            }
                            if (!this.xmlParser.startTag("end_address")) continue;
                            this.xmlParser.read();
                            String endAddress = this.xmlParser.getText();
                            leg.setEndAddress(endAddress);
                        }
                        route.setLeg(leg);
                        continue;
                    }
                    if (!this.xmlParser.startTag("overview_polyline")) continue;
                    while (!this.xmlParser.endTag("overview_polyline")) {
                        this.xmlParser.read();
                        if (this.xmlParser.startTag("points")) {
                            this.xmlParser.read();
                            String points = this.xmlParser.getText();
                            route.setOverviewPolygonPoints(points);
                            continue;
                        }
                        if (!this.xmlParser.startTag("levels")) continue;
                        this.xmlParser.read();
                        String levels = this.xmlParser.getText();
                        route.setOverviewPolygonLevel(levels);
                    }
                }
                this.routeVector.addElement(route);
            }
            int noOfRoutes = this.routeVector.size();
            if (noOfRoutes > 0) {
                this.showRouteList();
            } else {
                Alert alert = new Alert("No Routes Found");
                alert.setString("Unable to Find routes. Try Again");
                alert.setTimeout(1500);
                this.midlet.display.setCurrent(alert, (Displayable)this);
            }
        }
        catch (Exception e) {
            Alert alert = new Alert("Error");
            alert.setString("Unable to Fetch. Try Again");
            alert.setTimeout(1500);
            this.midlet.display.setCurrent(alert, (Displayable)this);
        }
    }

    public void commandAction(Command cmd, Displayable disp) {
        if (disp == this.mapForm) {
            if (cmd == backCmd) {
                this.midlet.display.setCurrent((Displayable)this.routeDetailsForm);
                this.routeDetailsForm.setCommandListener((CommandListener)this);
            }
        } else if (disp == this.routeDetailsForm) {
            if (cmd == backCmd) {
                this.midlet.display.setCurrent((Displayable)this.routeList);
                this.routeList.setCommandListener((CommandListener)this);
            } else if (cmd == showMapCmd) {
                this.showWaitingForm();
                Route selectedRoute = (Route)this.routeVector.elementAt(this.routeList.getSelectedIndex());
                this.util.setHttpResponse(this);
                this.util.getMapFromGoogle(this.zoomLevel, this.width, this.height, selectedRoute.getSourceLocation(), selectedRoute.getDestinationLocation(), selectedRoute.getOverviewPolygonPoint());
            }
        } else if (disp == this.routeList) {
            if (cmd == backCmd) {
                this.util.setHttpResponse(null);
                this.setCommandListener(this);
                this.midlet.display.setCurrent((Displayable)this);
            } else if (cmd == selectCmd) {
                this.showRouteDetails(this.routeList.getSelectedIndex());
            }
        } else if (cmd == searchCmd) {
            String sourceString = this.sourceField.getString();
            String destinationString = this.destinationField.getString();
            if (sourceString != null && sourceString.length() > 1 && destinationString != null && destinationString.length() > 1) {
                this.showWaitingForm();
                this.util.setHttpResponse(this);
                this.util.getDirectionsXMLFromGoogle(sourceString, destinationString);
            } else {
                Alert alert = new Alert("Error");
                alert.setString("Input source and destination field");
                alert.setTimeout(1500);
                this.midlet.display.setCurrent(alert, (Displayable)this);
            }
        } else if (cmd == exitCmd) {
            this.midlet.destroyApp(true);
        }
    }
}

