/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class HttpUtil {
    private HttpResponse httpResponse;

    public void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public static String encode(String in) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == ' ') {
                sb.append("%20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void setDefaultRequestHeaders(HttpConnection c) throws IOException {
        String conf = System.getProperty("microedition.configuration");
        String prof = System.getProperty("microedition.profiles");
        String locale = System.getProperty("microedition.locale");
        String ua = "Profile/" + prof + " Configuration/" + conf;
        c.setRequestProperty("User-Agent", ua);
        c.setRequestProperty("Connection", "close");
        c.setRequestProperty("Content-Language", "en-US");
    }

    public void getMapFromGoogle(final int zoomLevel, final int width, final int height, final String sourceLocation, final String destinationLocation, final String encPolygonLines) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block47: {
                    String url = "http://maps.google.com/maps/api/staticmap?zoom=" + zoomLevel + "&size=" + width + "x" + height + "&sensor=false&maptype=roadmap&format=png&style=feature:road.local|element:labels&markers=color:blue&markers=color:red|label:" + sourceLocation + "|" + destinationLocation + "&path=color:0x0000ff|weight:5|enc:" + encPolygonLines;
                    url = HttpUtil.encode(url);
                    HttpConnection hc = null;
                    InputStream is = null;
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    byte[] data = null;
                    int status = -1;
                    try {
                        hc = (HttpConnection)Connector.open((String)url, (int)3);
                        HttpUtil.setDefaultRequestHeaders(hc);
                        status = hc.getResponseCode();
                        if (status == 200) {
                            is = hc.openInputStream();
                            long len = hc.getLength();
                            if (len != -1L) {
                                int i = 0;
                                while ((long)i < len) {
                                    int ch = is.read();
                                    if (ch != -1) {
                                        byteOut.write(ch);
                                    }
                                    ++i;
                                }
                            } else {
                                int ch;
                                while ((ch = is.read()) != -1) {
                                    byteOut.write(ch);
                                }
                            }
                            is.close();
                            data = byteOut.toByteArray();
                            if (data != null && data.length > 0) {
                                if (HttpUtil.this.httpResponse != null) {
                                    HttpUtil.this.httpResponse.recievedImage(data, "map", status);
                                }
                            } else if (HttpUtil.this.httpResponse != null) {
                                HttpUtil.this.httpResponse.recievedImage(data, "map", -1);
                            }
                            break block47;
                        }
                        if (HttpUtil.this.httpResponse != null) {
                            HttpUtil.this.httpResponse.recievedData("Unknown error occurred", "Map", -1);
                        }
                    }
                    catch (SecurityException se) {
                        if (HttpUtil.this.httpResponse != null) {
                            HttpUtil.this.httpResponse.recievedData("Select yes/allow option.", "map", -1);
                        }
                    }
                    catch (Exception ioe) {
                        if (HttpUtil.this.httpResponse != null) {
                            HttpUtil.this.httpResponse.recievedData("Unable to Connect. Exception", "map", -1);
                        }
                    }
                    finally {
                        try {
                            if (hc != null) {
                                hc.close();
                            }
                        }
                        catch (IOException ignored) {}
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException ignored) {}
                        try {
                            if (byteOut != null) {
                                byteOut.close();
                            }
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
        }).start();
    }

    public void getDirectionsXMLFromGoogle(final String sourceString, final String destinationString) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block47: {
                    String url = "http://maps.googleapis.com/maps/api/directions/xml?origin=" + sourceString + "&destination=" + destinationString + "&alternatives=true&units=metric&sensor=false";
                    url = HttpUtil.encode(url);
                    HttpConnection hc = null;
                    FilterInputStream dis = null;
                    FilterOutputStream dos = null;
                    StringBuffer messagebuffer = new StringBuffer();
                    int status = -1;
                    try {
                        hc = (HttpConnection)Connector.open((String)url, (int)3);
                        HttpUtil.setDefaultRequestHeaders(hc);
                        status = hc.getResponseCode();
                        if (status == 200) {
                            dis = new DataInputStream(hc.openInputStream());
                            long len = hc.getLength();
                            if (len != -1L) {
                                int i = 0;
                                while ((long)i < len) {
                                    int ch = dis.read();
                                    if (ch != -1) {
                                        messagebuffer.append((char)ch);
                                    }
                                    ++i;
                                }
                            } else {
                                int ch;
                                while ((ch = dis.read()) != -1) {
                                    messagebuffer.append((char)ch);
                                }
                            }
                            dis.close();
                            String responseString = messagebuffer.toString();
                            if (responseString != null) {
                                responseString = responseString.trim();
                                if (HttpUtil.this.httpResponse != null) {
                                    HttpUtil.this.httpResponse.recievedData(responseString, "directions", status);
                                }
                            } else if (HttpUtil.this.httpResponse != null) {
                                HttpUtil.this.httpResponse.recievedData(responseString, "directions", -1);
                            }
                            break block47;
                        }
                        if (HttpUtil.this.httpResponse != null) {
                            HttpUtil.this.httpResponse.recievedData("Unknown error occurred", "directions", -1);
                        }
                    }
                    catch (SecurityException se) {
                        if (HttpUtil.this.httpResponse != null) {
                            HttpUtil.this.httpResponse.recievedData("Select yes/allow option.", "directions", -1);
                        }
                    }
                    catch (Exception ioe) {
                        if (HttpUtil.this.httpResponse != null) {
                            HttpUtil.this.httpResponse.recievedData("Unable to Connect. Exception" + messagebuffer.toString(), "directions", -1);
                        }
                    }
                    finally {
                        try {
                            if (hc != null) {
                                hc.close();
                            }
                        }
                        catch (IOException ignored) {}
                        try {
                            if (dis != null) {
                                dis.close();
                            }
                        }
                        catch (IOException ignored) {}
                        try {
                            if (dos != null) {
                                dos.close();
                            }
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
        }).start();
    }
}

