/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import org.kxml.Attribute;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.XmlParser;

public class XMLParser {
    private ByteArrayInputStream bin;
    private InputStreamReader in;
    private XmlParser parser;
    private ParseEvent pe;
    private String[][] keyVal;

    public void createParser(byte[] b) throws IOException {
        this.bin = new ByteArrayInputStream(b);
        this.in = new InputStreamReader(this.bin);
        this.parser = new XmlParser(this.in);
        this.pe = new ParseEvent(1, "xyz");
    }

    public void closeParser() {
        this.bin = null;
        this.in = null;
        this.parser = null;
        this.pe = null;
    }

    public boolean startTag(String str) throws IOException {
        String s = this.pe.getName();
        return this.pe.getType() == 64 && s.compareTo(str) == 0;
    }

    public boolean endTag(String str) {
        String s = this.pe.getName();
        return this.pe.getType() == 16 && s.compareTo(str) == 0;
    }

    public String getTagName() {
        return this.pe.getName();
    }

    public String getText() {
        String s = this.pe.getText();
        return s;
    }

    public void setAttributes() {
        Vector type1 = this.pe.getAttributes();
        this.keyVal = new String[type1.size()][2];
        int i = 0;
        Enumeration e1 = type1.elements();
        while (e1.hasMoreElements()) {
            Attribute att = (Attribute)e1.nextElement();
            this.keyVal[i][0] = att.getName();
            this.keyVal[i][1] = att.getValue();
            ++i;
        }
    }

    public String[] getAttributeValues() {
        Vector type1 = this.pe.getAttributes();
        String[] Val = new String[type1.size()];
        int i = 0;
        Enumeration e1 = type1.elements();
        while (e1.hasMoreElements()) {
            Attribute att = (Attribute)e1.nextElement();
            Val[i] = att.getValue();
            ++i;
        }
        return Val;
    }

    public String[] getAttributeNames() {
        Vector type1 = this.pe.getAttributes();
        String[] key = new String[type1.size()];
        int i = 0;
        Enumeration e1 = type1.elements();
        while (e1.hasMoreElements()) {
            Attribute att = (Attribute)e1.nextElement();
            key[i] = att.getName();
            ++i;
        }
        return key;
    }

    public String getValue(String key) {
        String value = "";
        for (int i = 0; i < this.keyVal.length; ++i) {
            if (this.keyVal[i][0].compareTo(key) != 0) continue;
            value = this.keyVal[i][1];
            break;
        }
        return value;
    }

    public void read() throws IOException {
        this.pe = this.parser.read();
    }
}

