/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

public class MyGameCanvas
extends GameCanvas
implements Runnable {
    private Image charImg;
    private Image elementImg;
    private int charX;
    private int charY;
    private final int dx;
    private final int screenWidth;
    private final int screenHeight;
    private final int tileSize;
    private final int charWidth;
    private final int charHeight;
    private int charDirection;
    private int prevDirection;
    private int charState;
    private final int charWalk;
    private final int charStop;
    private final int charCollide;
    private final int charJump;
    private int[] charJumpReg_Y = new int[]{12, 14, 16, 18, 20, 18, 16, 14, 12};
    private int[] charJumpReg_X = new int[]{6, 7, 8, 9, 10, 9, 8, 7, 6};
    private int charJumpCounter;
    private final int frameDelay;
    private MyGameMidlet midlet;
    private Thread myGameThread;
    private TiledLayer backgroundLayer;
    private TiledLayer collisionLayer;
    private Sprite characterSprite;
    private LayerManager layerManager;

    public MyGameCanvas(MyGameMidlet myGameMidlet) {
        super(true);
        this.dx = 1;
        this.screenWidth = 160;
        this.screenHeight = 160;
        this.tileSize = 16;
        this.charWidth = 28;
        this.charHeight = 54;
        this.charWalk = 1;
        this.charStop = 2;
        this.charCollide = 3;
        this.charJump = 4;
        this.frameDelay = 30;
        this.midlet = myGameMidlet;
        this.loadCharImg();
        this.createBackgroundScreen();
        this.createCharacterSprite();
        this.createLayerManager();
        this.initialiseNewGame();
        this.setFullScreenMode(true);
        this.myGameThread = new Thread(this);
        this.myGameThread.start();
    }

    private void loadCharImg() {
        try {
            this.charImg = Image.createImage((String)"/man_walk.png");
            this.elementImg = Image.createImage((String)"/elements.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void createBackgroundScreen() {
        int[] nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        this.backgroundLayer = new TiledLayer(10, 10, this.elementImg, 16, 16);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i % 10;
            int n2 = (i - n) / 10;
            this.backgroundLayer.setCell(n, n2, nArray[i]);
        }
        this.backgroundLayer.setPosition(0, 0);
        int[] nArray2 = new int[]{3};
        this.collisionLayer = new TiledLayer(1, 1, this.elementImg, 16, 16);
        this.collisionLayer.setCell(0, 0, nArray2[0]);
        this.collisionLayer.setPosition(64, 80);
    }

    private void createCharacterSprite() {
        this.characterSprite = new Sprite(this.charImg, 28, 54);
        this.characterSprite.setFrame(0);
    }

    private void createLayerManager() {
        this.layerManager = new LayerManager();
        this.layerManager.append((Layer)this.characterSprite);
        this.layerManager.append((Layer)this.collisionLayer);
        this.layerManager.append((Layer)this.backgroundLayer);
    }

    private void initialiseNewGame() {
        this.charX = 0;
        this.charY = 42;
        this.charJumpCounter = 0;
        this.prevDirection = this.charDirection = 32;
        this.charState = 2;
        this.characterSprite.setTransform(0);
        this.characterSprite.setPosition(this.charX, this.charY);
    }

    public void run() {
        Graphics graphics = this.getGraphics();
        while (true) {
            this.getUserInput();
            this.checkCharCollision();
            this.renderScreen(graphics);
            try {
                Thread.sleep(30L);
            }
            catch (Exception exception) {
            }
        }
    }

    private void getUserInput() {
        int n = this.getKeyStates();
        if (this.charState != 3) {
            this.calculateCharMovement(n);
        }
    }

    private void calculateCharMovement(int n) {
        if ((n & 0x100) != 0) {
            if (this.charState != 4) {
                this.charState = 4;
                this.characterSprite.setFrame(0);
            }
        } else if ((n & 4) != 0) {
            this.charX = Math.max(0, this.charX - 1);
            this.charDirection = n;
            this.charState = 1;
        } else if ((n & 0x20) != 0) {
            this.charX = Math.min(132, this.charX + 1);
            this.charDirection = n;
            this.charState = 1;
        } else if (this.charState != 4) {
            this.charState = 2;
            this.characterSprite.setFrame(0);
        }
        if (this.charState == 1) {
            if (this.charDirection == 32) {
                if (this.prevDirection == 4) {
                    this.characterSprite.setTransform(0);
                }
                this.characterSprite.nextFrame();
            } else if (this.charDirection == 4) {
                this.characterSprite.setTransform(2);
                this.characterSprite.nextFrame();
            }
            this.characterSprite.setPosition(this.charX, this.charY);
        } else if (this.charState == 4) {
            if (this.charJumpCounter < this.charJumpReg_Y.length) {
                if (this.charDirection == 4) {
                    this.charX = Math.max(0, this.charX - this.charJumpReg_X[this.charJumpCounter]);
                } else if (this.charDirection == 32) {
                    this.charX = Math.min(132, this.charX + this.charJumpReg_X[this.charJumpCounter]);
                }
                this.characterSprite.setPosition(this.charX, this.charY - this.charJumpReg_Y[this.charJumpCounter]);
                ++this.charJumpCounter;
            } else {
                this.charJumpCounter = 0;
                this.charState = 2;
                this.characterSprite.setFrame(0);
                this.characterSprite.setPosition(this.charX, this.charY);
            }
        }
        this.prevDirection = this.charDirection;
    }

    private void checkCharCollision() {
        if (this.characterSprite.collidesWith(this.collisionLayer, true)) {
            this.charState = 3;
        }
    }

    private void renderScreen(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, 160, 160);
        this.layerManager.paint(graphics, 0, 0);
        if (this.charState == 3) {
            graphics.setColor(0xFFFF00);
            graphics.drawString("Collided.", 80, 90, 17);
            graphics.drawString("Press key 0 to restart.", 80, 100, 17);
        }
        this.flushGraphics();
    }

    protected void keyPressed(int n) {
        if (n == 48) {
            this.initialiseNewGame();
            return;
        }
    }
}

