/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.location.AddressInfo;
import javax.microedition.location.Landmark;
import javax.microedition.location.LandmarkException;
import javax.microedition.location.LandmarkStore;
import javax.microedition.location.QualifiedCoordinates;
import javax.microedition.midlet.MIDlet;

public class LandmarkMidlet
extends MIDlet
implements CommandListener,
Runnable {
    private final String OFFICE_CATEGORY;
    private LandmarkStore landmarkStore = null;
    private final int ADD_LANDMARK;
    private final int SHOW_LANDMARK;
    private final int DELETE_LANDMARK;
    private int landmarkState;
    private List landmarkList = new List("Landmark Demo", 3);
    private Command cmd_Exit = new Command("Exit", 7, 1);
    private Command cmd_showLandmark;
    private Command cmd_deleteLandmark;
    private Command cmd_addLandmark = new Command("Add Landmark", 1, 1);
    private Display display;
    private Thread landmarkThread;
    private Vector landmarkVector;

    public LandmarkMidlet() {
        this.OFFICE_CATEGORY = "OFFICE";
        this.ADD_LANDMARK = 1;
        this.SHOW_LANDMARK = 2;
        this.DELETE_LANDMARK = 3;
        this.cmd_showLandmark = new Command("show Landmark", 1, 1);
        this.cmd_deleteLandmark = new Command("delete Landmark", 1, 1);
        this.landmarkList.addCommand(this.cmd_Exit);
        this.landmarkList.addCommand(this.cmd_addLandmark);
        this.landmarkList.addCommand(this.cmd_showLandmark);
        this.landmarkList.addCommand(this.cmd_deleteLandmark);
        this.landmarkList.setCommandListener((CommandListener)this);
        this.landmarkVector = new Vector();
        this.display = Display.getDisplay((MIDlet)this);
        this.display.setCurrent((Displayable)this.landmarkList);
    }

    public void startApp() {
        this.loadLandmarks();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.notifyDestroyed();
    }

    private void exitMidlet() {
        this.destroyApp(true);
    }

    private void loadLandmarks() {
        this.landmarkStore = LandmarkStore.getInstance(null);
        this.addLandmarkCategory();
    }

    private void addLandmarkCategory() {
        try {
            Enumeration enumeration = this.landmarkStore.getCategories();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.equals("OFFICE")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.landmarkStore.addCategory("OFFICE");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (LandmarkException landmarkException) {
            landmarkException.printStackTrace();
        }
    }

    private void addLandmark() {
        QualifiedCoordinates qualifiedCoordinates = new QualifiedCoordinates(85.0, 85.0, 100.0f, 500.0f, 500.0f);
        AddressInfo addressInfo = new AddressInfo();
        addressInfo.setField(2, "OfficeStreet");
        addressInfo.setField(4, "OfficeCity");
        addressInfo.setField(3, "123456");
        addressInfo.setField(17, "1234567890");
        Landmark landmark = new Landmark("My Office", "Office Description", qualifiedCoordinates, addressInfo);
        try {
            this.landmarkStore.addLandmark(landmark, "OFFICE");
            this.showLandmark();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void showLandmark() {
        try {
            this.landmarkVector.removeAllElements();
            this.landmarkList.deleteAll();
            Enumeration enumeration = this.landmarkStore.getLandmarks();
            boolean bl = false;
            while (enumeration != null && enumeration.hasMoreElements()) {
                Landmark landmark = (Landmark)enumeration.nextElement();
                this.landmarkVector.addElement(landmark);
                this.landmarkList.append(landmark.getName(), null);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void deleteLandmark() {
        int n = this.landmarkList.getSelectedIndex();
        if (n > -1) {
            Landmark landmark = (Landmark)this.landmarkVector.elementAt(n);
            try {
                this.landmarkStore.deleteLandmark(landmark);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (LandmarkException landmarkException) {
                landmarkException.printStackTrace();
            }
            this.showLandmark();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (this.cmd_Exit == command) {
            this.exitMidlet();
        } else if (this.cmd_addLandmark == command) {
            this.landmarkState = 1;
            this.landmarkThread = new Thread(this);
            this.landmarkThread.start();
        } else if (this.cmd_showLandmark == command) {
            this.showLandmark();
        } else if (this.cmd_deleteLandmark == command) {
            this.landmarkState = 3;
            this.landmarkThread = new Thread(this);
            this.landmarkThread.start();
        }
    }

    public void run() {
        if (1 == this.landmarkState) {
            this.addLandmark();
        } else if (3 == this.landmarkState) {
            this.deleteLandmark();
        }
        this.landmarkState = -1;
    }
}

