/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.LocationProvider;
import javax.microedition.location.QualifiedCoordinates;
import javax.microedition.midlet.MIDlet;

public class LocationMidlet
extends MIDlet
implements CommandListener,
Runnable {
    private final String locate_String;
    private final String exit_String;
    private final String done_String;
    private final String locationForm_Title_String;
    private final String locationInfo_String;
    private final String exitInfo_String;
    private Display display;
    private Command cmd_Locate = new Command("Locate", 4, 1);
    private Command cmd_Exit;
    private Command cmd_Done = new Command("Done", 4, 1);
    private Form locationForm;
    private LocationProvider locationProvider = null;
    private Location location;
    private QualifiedCoordinates coordinates;
    private Thread locationThread;

    public LocationMidlet() {
        this.locate_String = "Locate";
        this.exit_String = "Exit";
        this.done_String = "Done";
        this.locationForm_Title_String = "Location Demo";
        this.locationInfo_String = "Press Locate Command to start Application Demo \n";
        this.exitInfo_String = "Press Exit Command to exit Application \n";
        this.cmd_Exit = new Command("Exit", 7, 2);
        this.locationForm = new Form("Location Demo");
        this.locationForm.append("Press Locate Command to start Application Demo \n");
        this.locationForm.append("Press Exit Command to exit Application \n");
        this.locationForm.addCommand(this.cmd_Exit);
        this.locationForm.addCommand(this.cmd_Locate);
        this.locationForm.setCommandListener((CommandListener)this);
        this.display = Display.getDisplay((MIDlet)this);
        this.locationProvider = null;
        this.createLocationProvider();
        if (this.locationProvider == null) {
            this.displayError();
        }
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.locationForm);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        this.notifyDestroyed();
    }

    private void exitMidlet() {
        this.destroyApp(true);
    }

    private void displayError() {
        this.locationForm.deleteAll();
        this.locationForm.append("Unable to create LocationProvider");
        this.locationForm.addCommand(this.cmd_Exit);
    }

    private void createLocationProvider() {
        if (this.locationProvider == null) {
            Criteria criteria = new Criteria();
            try {
                this.locationProvider = LocationProvider.getInstance((Criteria)criteria);
            }
            catch (LocationException locationException) {
                locationException.printStackTrace();
            }
        }
    }

    private void createLocation() {
        try {
            this.location = this.locationProvider.getLocation(30);
        }
        catch (LocationException locationException) {
            locationException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void getLocationResults() {
        this.coordinates = this.location.getQualifiedCoordinates();
    }

    private void displayLocationResults() {
        this.locationForm.append("Altitude:" + this.coordinates.getAltitude() + "\n");
        this.locationForm.append("Latitude:" + this.coordinates.getLatitude() + "\n");
        this.locationForm.append("Longitude:" + this.coordinates.getLongitude() + "\n");
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmd_Locate) {
            this.locationForm.deleteAll();
            this.locationForm.removeCommand(this.cmd_Exit);
            this.locationForm.removeCommand(this.cmd_Locate);
            this.locationForm.addCommand(this.cmd_Done);
            this.locationThread = new Thread(this);
            this.locationThread.start();
        } else if (command == this.cmd_Exit) {
            this.exitMidlet();
        } else if (command == this.cmd_Done) {
            this.locationForm.deleteAll();
            this.locationForm.removeCommand(this.cmd_Done);
            this.locationForm.addCommand(this.cmd_Exit);
            this.locationForm.addCommand(this.cmd_Locate);
            this.locationForm.append("Press Locate Command to start Application Demo \n");
            this.locationForm.append("Press Exit Command to exit Application \n");
        }
    }

    public void run() {
        this.createLocation();
        this.getLocationResults();
        this.displayLocationResults();
    }
}

