
import javax.microedition.midlet.*;

import javax.microedition.lcdui.*;

import java.util.*;

import javax.microedition.io.Connector;

import javax.microedition.io.PushRegistry;

public class MultiTouch extends MIDlet implements CommandListener {

    private Display display;
    private Command exitCommand = new Command("Exit", Command.EXIT, 0);

	// Application starts here
    public void startApp() {

        Canvas canvas = new CanvasPinch();

        display = Display.getDisplay(this);

        canvas.addCommand(exitCommand);

        canvas.setCommandListener(this);

        display.setCurrent(canvas);

    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

	/*
	 *Function: commandAction(Command c, Displayable d)
	 *Description: Handles command events
	 *Input: Command and Diplayable object
	 **/
	
    public void commandAction(Command c, Displayable s) {

        if (c == exitCommand) {
            

            destroyApp(true);

            notifyDestroyed();

        }

    }
}

class CanvasPinch extends Canvas {

    Object PaintLock = new Object();
    int tW, tH;
    int RED = 0xff0000, BLACK = 0x000000;
    Hashtable pointersPressed;

	/*
	 *Constructor
	 */
    CanvasPinch() {

        tW = getWidth();

        tH = getHeight();

        pointersPressed = new Hashtable();

    }

    public void paint(Graphics g) {

        synchronized (PaintLock) {

            g.setColor(BLACK);

            g.fillRect(0, 0, tW, tH);

            g.setColor(RED);

            for (Enumeration e = pointersPressed.keys(); e.hasMoreElements();) {

                Integer i = (Integer) e.nextElement();

                Point p = (Point) pointersPressed.get(i);

                g.fillArc(p.getX(), p.getY(), 126, 126, 0, 360);

            }

        }

    }

	// Called on MultiTouch Event
    protected void mTouchPressed(int x1, int y1, int index) {

        synchronized (PaintLock) {

            pointersPressed.put(new Integer(index), new Point(x1, y1));

            repaint();

        }

    }

	//Called on MultiTouch Event is moved
    protected void mTouchMove(int x1, int y1, int index) {

        synchronized (PaintLock) {

            Enumeration e;

            for (e = pointersPressed.keys(); e.hasMoreElements();) {

                Integer i = (Integer) e.nextElement();

                if (i.intValue() == index) {

                    Point p = (Point) pointersPressed.get(i);

                    p.setX(x1);

                    p.setY(y1);

                    break;

                }

            }

            repaint();

        }

    }

	//Called when MultiTouch Event is released
    protected void mTouchRelease(int x1, int y1, int index) {

        synchronized (PaintLock) {

            Enumeration e;

            for (e = pointersPressed.keys(); e.hasMoreElements();) {

                Integer i = (Integer) e.nextElement();

                if (i.intValue() == index) {

                    Point p = (Point) pointersPressed.get(i);

                    pointersPressed.remove(i);

                    break;

                }

            }

            repaint();

        }

    }

	//Called when single touch event
    protected void pointerPressed(int x, int y) {

        synchronized (PaintLock) {

            pointersPressed.put(new Integer(0), new Point(x, y));

            repaint();

        }

    }

	//Called when single touch is released
    protected void pointerReleased(int x, int y) {

        synchronized (PaintLock) {

            Enumeration e;

            for (e = pointersPressed.keys(); e.hasMoreElements();) {

                Integer i = (Integer) e.nextElement();

                if (i.intValue() == 0) {

                    Point p = (Point) pointersPressed.get(i);

                    pointersPressed.remove(i);

                    break;

                }

            }

            repaint();

        }

    }

	// Called when single touch event is dragged
    protected void pointerDragged(int x, int y) {

        synchronized (PaintLock) {

            Enumeration e;

            for (e = pointersPressed.keys(); e.hasMoreElements();) {

                Integer i = (Integer) e.nextElement();

                if (i.intValue() == 0) {

                    Point p = (Point) pointersPressed.get(i);

                    p.setX(x);

                    p.setY(y);

                    break;

                }

            }

            repaint();

        }

    }
}

class Point {

    int X, Y;

    Point(int X, int Y) {

        this.X = X;

        this.Y = Y;

    }

    int getX() {

        return this.X;

    }

    int getY() {

        return this.Y;

    }

    void setX(int X) {

        this.X = X;

    }

    void setY(int Y) {

        this.Y = Y;

    }
}
