
import javax.microedition.lcdui.Canvas;

import javax.microedition.lcdui.Display;

import javax.microedition.lcdui.Graphics;

import javax.microedition.lcdui.TextField;

import javax.microedition.midlet.MIDlet;

import javax.microedition.midlet.MIDletStateChangeException;



import com.samsung.util.OverlayEditField;

import com.samsung.util.OverlayEditFieldListener;

public class OverlayEditFieldTest extends MIDlet implements OverlayEditFieldListener {

    private static String inputStr = "Test";
    private static int currentActionType = 0;
    Display display = null;
    OverlayEditFieldCanvas overlayEditFieldCanvas = null;
    OverlayEditField overlayEditField = null;

	/*
	 *Constructor
	 */
    public OverlayEditFieldTest() {

        display = Display.getDisplay(this);

        overlayEditFieldCanvas = new OverlayEditFieldCanvas();

        overlayEditField = OverlayEditField.getInstance();

        overlayEditField.setListener(this);

    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {

        notifyDestroyed();

    }
      
	protected void pauseApp() {
    }

	//application starts here
    protected void startApp() throws MIDletStateChangeException {

        display.setCurrent(overlayEditFieldCanvas);

        Thread overlayEditFieldCanvasThread = new Thread(overlayEditFieldCanvas);

        overlayEditFieldCanvasThread.start();

    }

	//Called when EditField keypad is pressed and gives the Action Type
    public void notifyEditFieldEvent(int actionType) {

        currentActionType = actionType;



        if (actionType == overlayEditField.LSK_PRESSED) {
            overlayEditField.setString("overlayEditField.LSK_PRESSED");
        }

        if (actionType == overlayEditField.RSK_PRESSED) {
            overlayEditField.setString("overlayEditField.RSK_PRESSED");
        }    
    }

    private class OverlayEditFieldCanvas extends Canvas implements Runnable {

        private boolean showCanvas = true;
        private int i = 0;

        public OverlayEditFieldCanvas() {
        }

        protected void paint(Graphics g) {

            // clear whole screen with white

            g.setColor(0xffffff);

            g.fillRect(0, 0, getWidth(), getHeight());



            // draw a rectangle into which text can be drawn

            g.setColor(0);

            g.drawRect(10, 10, getWidth() - 20, 40);

            g.drawString((inputStr + i), 12, 12, Graphics.TOP | Graphics.LEFT);



            // draw a yellow filled box ... just for testing any overlap

            g.setColor(0xffff00);

            g.fillRect(10, getHeight() - 210, getWidth() - 20, 200);

        }

        // paint continuously with varying numbers to show
        // continuous repaint of canvas
        public void run() {

            while (showCanvas) {

                if (i > 10) {
                    i = 0;
                }
                i++;

                repaint();

                if (currentActionType == overlayEditField.LSK_PRESSED) {
                    System.out.println(" LSK_PRESSED");
                } else if (currentActionType == overlayEditField.RSK_PRESSED) {
                    System.out.println(" RSK_PRESSED");
                } else if (currentActionType == overlayEditField.CLOSED_BY_DONE) {

                    System.out.println("  INPUT_COMPLETED");

                    inputStr = overlayEditField.getString();

                }



                try {

                    Thread.sleep(100);

                } catch (InterruptedException e) {

                    e.printStackTrace();

                }

            }

        }

        protected void hideNotify() {

            showCanvas = false;

        }

        protected void showNotify() {

            showCanvas = true;

        }

		// Called when Single Touch Event is Pressed
        protected void pointerPressed(int x, int y) {

            if (x > 10 && y > 10 && x < getWidth() - 20 + 10 && y < 50) {

                overlayEditField.launchOverlayEditField(inputStr, 50, TextField.ANY, "BACK", "EXIT");

            } else {
                overlayEditField.close();
            }

        }
    }
}
