
import javax.microedition.lcdui.Canvas;

import javax.microedition.lcdui.Display;

import javax.microedition.lcdui.Graphics;

import javax.microedition.lcdui.TextField;

import javax.microedition.midlet.MIDlet;

import javax.microedition.midlet.MIDletStateChangeException;



import com.samsung.util.OverlayKeypad;

import com.samsung.util.OverlayKeypadListener;

public class OverlayKeyPadTest extends MIDlet implements OverlayKeypadListener {

    private static String inputStr = "Test";
    private static int currentActionType = 0;
    private Display display = null;
    private OverlayKeypadCanvas overlayKeyPadCanvas = null;
    private OverlayKeypad overlayKeypad = null;

	/*
	 *Constructor
	 */
    public OverlayKeyPadTest() {

        display = Display.getDisplay(this);

        overlayKeyPadCanvas = new OverlayKeypadCanvas();

        overlayKeypad = OverlayKeypad.getInstance();

        overlayKeypad.setListener(this);

    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {

        notifyDestroyed();

    }

    protected void pauseApp() {
    }

	//application starts here
    protected void startApp() throws MIDletStateChangeException {

        display.setCurrent(overlayKeyPadCanvas);

        Thread OverlayKeypadCanvasThread = new Thread(overlayKeyPadCanvas);

        OverlayKeypadCanvasThread.start();

    }

	//Called when keypad is pressed and gives the Action Type
    public void notifyKeypadEvent(int actionType) {

        currentActionType = actionType;



        if (actionType == overlayKeypad.LSK_PRESSED) {
         inputStr = "LSK PRESSED";
        }

        if (actionType == overlayKeypad.RSK_PRESSED) {
            inputStr = "RSK PRESSED";
        }
        
        if (actionType == overlayKeypad.ENTER_PRESSED) {
            inputStr = "ENTER PRESSED";
        }
        
        if (actionType == overlayKeypad.CLOSED_BY_CANCLE) {
            inputStr = "CLOSED_BY_CANCLE PRESSED";
        }
    }

    private class OverlayKeypadCanvas extends Canvas implements Runnable {

        private boolean showCanvas = true;
        private int i = 0;
		private String keyName="";

        public OverlayKeypadCanvas() {
        }

        protected void paint(Graphics g) {

            // clear whole screen with white

            g.setColor(0xffffff);

            g.fillRect(0, 0, getWidth(), getHeight());



            // draw a rectangle into which text can be drawn

            g.setColor(0);

            g.drawRect(10, 10, getWidth() - 20, 40);

            g.drawString((inputStr + i)+" "+keyName, 12, 12, Graphics.TOP | Graphics.LEFT);



            // draw a yellow filled box ... just for testing any overlap

            g.setColor(0xffff00);

            g.fillRect(10, getHeight() - 210, getWidth() - 20, 200);

        }

        // paint continuously with varying numbers to show
        // continuous repaint of canvas
        public void run() {

            while (showCanvas) {

                if (i > 10) {
                    i = 0;
                }
                i++;

                repaint();


                try {

                    Thread.sleep(100);

                } catch (InterruptedException e) {

                    e.printStackTrace();

                }

            }

        }

        protected void hideNotify() {

            showCanvas = false;

        }

        protected void showNotify() {

            showCanvas = true;

        }

		//Called when single touch event is pressed 
        protected void pointerPressed(int x, int y) {

            if (x > 10 && y > 10 && x < getWidth() - 20 + 10 && y < 50) {

                overlayKeypad.launchOverlayKeypad(OverlayKeypad.ALPHA, null, null);

            } else {
                overlayKeypad.close();
            }

        }
		
		
		//Called when keypad is pressed and returns the keycodes
		protected void keyPressed(int keycode){
		      keyName=getKeyName(keycode);
			  repaint();
		}
		
    }
}
