/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.Event;
import javax.microedition.pim.EventList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;

public class PIMExportMidlet
extends MIDlet
implements CommandListener {
    private Display display = null;
    private static final Command cmd_Exit = new Command("Exit", 7, 1);
    private static final Command cmd_Export = new Command("ExportEvent", 1, 2);
    private List event_implicitList = null;
    private Vector eventVector = null;
    private PIM pim = null;
    private EventList eventList = null;
    private final String FILE_PATH;
    private final String FILE;
    private final String exportEncoding;
    private DateField startDateField;
    private DateField endDateField;

    public PIMExportMidlet() {
        this.FILE_PATH = "file://localhost/root1/";
        this.FILE = "exportEvent.txt";
        this.exportEncoding = "UTF-8";
        if (System.getProperty("microedition.pim.version") != null) {
            this.init();
        } else {
            this.exitMidlet();
        }
    }

    public void startApp() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    PIMExportMidlet.this.pim = PIM.getInstance();
                    PIMExportMidlet.this.eventList = (EventList)PIMExportMidlet.this.pim.openPIMList(2, 3);
                    if (PIMExportMidlet.this.eventList == null) {
                        PIMExportMidlet.this.alertBox("Event List is not supported");
                    }
                    PIMExportMidlet.this.addEvent();
                    if (PIMExportMidlet.this.eventList.isSupportedField(107)) {
                        Enumeration e = PIMExportMidlet.this.eventList.items();
                        while (e.hasMoreElements()) {
                            Event event = (Event)e.nextElement();
                            PIMExportMidlet.this.eventVector.addElement(event);
                            String field_String = event.getString(107, 0);
                            PIMExportMidlet.this.event_implicitList.append(field_String, null);
                        }
                        PIMExportMidlet.this.eventList.close();
                        PIMExportMidlet.this.display.setCurrent((Displayable)PIMExportMidlet.this.event_implicitList);
                    } else {
                        PIMExportMidlet.this.alertBox("Field SUMMARY not supported");
                    }
                }
                catch (PIMException ex) {
                    ex.printStackTrace();
                }
            }
        }).start();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    private void init() {
        this.display = Display.getDisplay((MIDlet)this);
        this.eventVector = new Vector();
        this.event_implicitList = new List("Event List...", 3);
        this.event_implicitList.addCommand(cmd_Exit);
        this.event_implicitList.addCommand(cmd_Export);
        this.event_implicitList.setCommandListener((CommandListener)this);
    }

    private void alertBox(String data) {
        Alert alert = new Alert("Information", data, null, AlertType.INFO);
        alert.setTimeout(-2);
        alert.addCommand(cmd_Exit);
        alert.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)alert);
    }

    private void addEvent() {
        Event event = this.eventList.createEvent();
        if (this.eventList.isSupportedField(107)) {
            String summary = "Export Event";
            event.addString(107, 0, summary);
        }
        if (this.eventList.isSupportedField(106)) {
            this.startDateField = new DateField("Start date", 3);
            this.startDateField.setDate(new Date());
            long startDate = this.startDateField.getDate().getTime();
            event.addDate(106, 0, startDate);
        }
        if (this.eventList.isSupportedField(102)) {
            this.endDateField = new DateField("End date", 3);
            this.endDateField.setDate(new Date());
            long endDate = this.endDateField.getDate().getTime();
            event.addDate(102, 0, endDate);
        }
        try {
            event.commit();
        }
        catch (PIMException ex) {
            ex.printStackTrace();
        }
    }

    private void exportPIMEvent() {
        String[] supported_format;
        if (System.getProperty("microedition.io.file.FileConnection.version") == null) {
            this.alertBox("File Connection is not supported");
        }
        if ((supported_format = this.pim.supportedSerialFormats(2)).length > 0) {
            int eventIndex = this.event_implicitList.getSelectedIndex();
            final Event event = (Event)this.eventVector.elementAt(eventIndex);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    FileConnection fileConn = null;
                    OutputStream outPut = null;
                    try {
                        fileConn = (FileConnection)Connector.open((String)"file://localhost/root1/exportEvent.txt", (int)3);
                        if (!fileConn.exists()) {
                            fileConn.create();
                        }
                        outPut = fileConn.openOutputStream();
                        PIMExportMidlet.this.pim.toSerialFormat((PIMItem)event, outPut, "UTF-8", supported_format[0]);
                    }
                    catch (PIMException ex) {
                        ex.printStackTrace();
                    }
                    catch (UnsupportedEncodingException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        try {
                            outPut.close();
                            fileConn.close();
                            PIMExportMidlet.this.alertBox("Data successfully exported to file...");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }).start();
        }
    }

    private void exitMidlet() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void commandAction(Command cmd, Displayable dis) {
        if (cmd == cmd_Exit) {
            this.exitMidlet();
        } else {
            this.exportPIMEvent();
        }
    }
}

