/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;

public class PIMImportMidlet
extends MIDlet
implements CommandListener {
    private Display display;
    private List importContactList;
    private final Command cmd_Exit = new Command("Exit", 7, 1);
    private final Command cmd_Import = new Command("Import contact", 1, 2);
    private final String importEncoding;
    private final String FILE_PATH;
    private final String FILE;
    private FileConnection fileConn = null;
    private InputStream inPutStream = null;

    public PIMImportMidlet() {
        this.importEncoding = "UTF-8";
        this.FILE_PATH = "file://localhost/root1/";
        this.FILE = "5.vcf";
        if (System.getProperty("microedition.pim.version") == null) {
            this.exitMIDlet();
        }
        this.init();
    }

    private void init() {
        this.display = Display.getDisplay((MIDlet)this);
        this.importContactList = new List("contacts", 3);
        this.importContactList.addCommand(this.cmd_Import);
        this.importContactList.addCommand(this.cmd_Exit);
        this.importContactList.setCommandListener((CommandListener)this);
        this.addContactsToListCtrl();
    }

    private void addContactsToListCtrl() {
        try {
            ContactList contactList = (ContactList)PIM.getInstance().openPIMList(1, 3);
            if (!contactList.isSupportedField(106)) {
                this.showMsg("Info", "Contact.Name not supported");
            }
            if (!contactList.isSupportedField(100)) {
                this.showMsg("Info", "Contact.ADDR not supported");
            }
            this.importContactList.deleteAll();
            Enumeration contacts = contactList.items();
            while (contacts.hasMoreElements()) {
                Contact contact = (Contact)contacts.nextElement();
                String[] name = contact.getStringArray(106, 0);
                String[] address = contact.getStringArray(100, 0);
                String family = name[0];
                String nameGiven = name[1];
                String country = address[6];
                String locality = address[3];
                String postalCode = address[5];
                String street = address[2];
                this.importContactList.append(family, null);
                this.importContactList.append(nameGiven, null);
                this.importContactList.append(country, null);
                this.importContactList.append(locality, null);
                this.importContactList.append(postalCode, null);
                this.importContactList.append(street, null);
            }
            contactList.close();
        }
        catch (PIMException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importContact() {
        if (System.getProperty("microedition.io.file.FileConnection.version") != null) {
            return false;
        }
        try {
            this.fileConn = (FileConnection)Connector.open((String)"file://localhost/root1/5.vcf", (int)3);
            if (!this.fileConn.exists()) {
                throw new Exception("File for importing was not found.");
            }
            this.inPutStream = this.fileConn.openInputStream();
            PIMItem[] items = PIM.getInstance().fromSerialFormat(this.inPutStream, "UTF-8");
            if (items.length > 0) {
                ContactList contactList = (ContactList)PIM.getInstance().openPIMList(1, 3);
                Contact newcontact = contactList.importContact((Contact)items[0]);
                newcontact.commit();
                contactList.close();
            }
            this.showMsg("Info", "Contact was imported from file.");
        }
        catch (Exception e) {
            this.showMsg("Error", e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.inPutStream.close();
                this.fileConn.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    private void showMsg(String title, String message) {
        Alert alert = new Alert(title);
        alert.setString(message);
        alert.setTimeout(-2);
        this.display.setCurrent((Displayable)alert);
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.importContactList);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    private void exitMIDlet() {
        this.notifyDestroyed();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmd_Import) {
            if (this.importContact()) {
                new Thread(new Runnable(){

                    public void run() {
                        PIMImportMidlet.this.addContactsToListCtrl();
                    }
                }).start();
            }
        } else if (command == this.cmd_Exit) {
            this.exitMIDlet();
        }
    }
}

