/*
 * Decompiled with CFR 0.152.
 */
package com.superscape.m3g.wtksamples.pogoroo;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.AnimationController;
import javax.microedition.m3g.AnimationTrack;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.KeyframeSequence;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.World;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class PogoRooMIDlet
extends MIDlet
implements CommandListener {
    static final int POGOROO_MOVE_GROUP_TRANSFORM_ID = 554921620;
    static final int CAMERA_GROUP_TRANSFORM_ID = 769302310;
    static final int POGOROO_TRANSFORM_ID = 347178853;
    static final int ROO_BOUNCE_ID = 418071423;
    public static final int KEY_REPEATED = 0;
    public static final int KEY_PRESSED = 1;
    public static final int KEY_RELEASED = 2;
    static final int keyNone = 0;
    static final int keyForward = 1;
    static final int keyBackward = 2;
    static final int keyLeft = 3;
    static final int keyRight = 4;
    static final int MaxHops = 10;
    static final float GroundEdge = 9.0f;
    private Display myDisplay = null;
    private PogoRooCanvas myCanvas = null;
    private Timer myRefreshTimer = new Timer();
    private TimerTask myRefreshTask = null;
    private Command exitCommand = new Command("Exit", 8, 1);
    Graphics3D myGraphics3D = Graphics3D.getInstance();
    World myWorld = null;
    private AnimationController animRoo = null;
    private Group tRoo = null;
    private Group tCams = null;
    private Group acRoo = null;
    private float dirRoo = 0.0f;
    private float dirCam = 0.0f;
    private int keyMoveRoo = 0;
    private int keyTurnRoo = 0;
    private int hopCount = 0;
    private int animTime = 0;
    private int animLength = 0;
    private int animLastTime = 0;
    private boolean okToHop = false;
    private float[] posRoo = new float[3];
    private float[] posRooLast = new float[3];
    private float[] posTemp = new float[3];
    private int edgeCount = 0;
    private float turnAngle;
    private float[] hopSteps = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.05f, 0.1f, 0.2f, 0.1f, 0.05f, 0.0f};
    int viewport_x;
    int viewport_y;
    int viewport_width;
    int viewport_height;

    public PogoRooMIDlet() {
        this.myDisplay = Display.getDisplay((MIDlet)this);
        this.myCanvas = new PogoRooCanvas(this);
        this.myCanvas.setCommandListener(this);
        this.myCanvas.addCommand(this.exitCommand);
    }

    public void startApp() throws MIDletStateChangeException {
        this.myDisplay.setCurrent((Displayable)this.myCanvas);
        try {
            this.myWorld = (World)Loader.load((String)"/com/superscape/m3g/wtksamples/pogoroo/content/pogoroo.m3g")[0];
            this.getObjects();
            this.setupAspectRatio();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.myRefreshTask = new RefreshTask();
        this.myRefreshTimer.schedule(this.myRefreshTask, 0L, 50L);
    }

    void setupAspectRatio() {
        float[] fArray;
        this.viewport_x = 0;
        this.viewport_y = 0;
        this.viewport_width = this.myCanvas.getWidth();
        this.viewport_height = this.myCanvas.getHeight();
        Camera camera = this.myWorld.getActiveCamera();
        int n = camera.getProjection(fArray = new float[4]);
        if (n != 48) {
            float f = this.viewport_width / this.viewport_height;
            if (f < fArray[1]) {
                float f2 = (float)this.viewport_width / fArray[1];
                this.viewport_height = (int)f2;
                this.viewport_y = (this.myCanvas.getHeight() - this.viewport_height) / 2;
            } else {
                float f3 = (float)this.viewport_height * fArray[1];
                this.viewport_width = (int)f3;
                this.viewport_x = (this.myCanvas.getWidth() - this.viewport_width) / 2;
            }
        }
    }

    public void getObjects() {
        try {
            KeyframeSequence keyframeSequence;
            this.tRoo = (Group)this.myWorld.find(554921620);
            this.tCams = (Group)this.myWorld.find(769302310);
            this.acRoo = (Group)this.myWorld.find(347178853);
            this.animRoo = (AnimationController)this.myWorld.find(418071423);
            AnimationTrack animationTrack = this.acRoo.getAnimationTrack(0);
            this.animLength = 1000;
            if (animationTrack != null && (keyframeSequence = animationTrack.getKeyframeSequence()) != null) {
                this.animLength = keyframeSequence.getDuration();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void hopRoo() {
        if (this.animTime == 0) {
            this.hopCount = 0;
            this.okToHop = true;
        }
        if (this.okToHop) {
            switch (this.keyMoveRoo) {
                case 1: 
                case 2: {
                    int n = this.hopCount;
                    this.hopCount = this.animTime * 10 / this.animLength;
                    if (this.hopCount >= 10) {
                        this.okToHop = false;
                        this.hopCount = 9;
                    }
                    this.turnAngle = this.dirRoo * 3.14159f / 180.0f;
                    float f = 0.0f;
                    for (int i = n + 1; i <= this.hopCount; ++i) {
                        f += this.hopSteps[i];
                    }
                    float f2 = f * (float)Math.cos(this.turnAngle);
                    float f3 = f * (float)Math.sin(this.turnAngle);
                    if (this.keyMoveRoo == 1) {
                        this.tRoo.translate(-f2, -f3, 0.0f);
                        break;
                    }
                    this.tRoo.translate(f2, f3, 0.0f);
                }
            }
        }
    }

    private void checkWorldEdge() {
        this.tRoo.getTranslation(this.posRoo);
        if (this.edgeCount > 0) {
            --this.edgeCount;
        }
        try {
            if (Math.abs(this.posRoo[0]) > 9.0f || Math.abs(this.posRoo[1]) > 9.0f) {
                this.edgeCount = 10;
                this.tRoo.setTranslation(this.posRooLast[0], this.posRooLast[1], this.posRooLast[2]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void turnRoo() {
        switch (this.keyTurnRoo) {
            case 3: {
                this.dirRoo += 5.0f;
                this.dirCam -= 5.0f;
                this.tRoo.setOrientation(this.dirRoo, 0.0f, 0.0f, 1.0f);
                this.tCams.setOrientation(this.dirCam, 0.0f, 0.0f, 1.0f);
                break;
            }
            case 4: {
                this.dirRoo -= 5.0f;
                this.dirCam += 5.0f;
                this.tRoo.setOrientation(this.dirRoo, 0.0f, 0.0f, 1.0f);
                this.tCams.setOrientation(this.dirCam, 0.0f, 0.0f, 1.0f);
                break;
            }
            default: {
                this.dirCam = this.dirCam > 4.9f ? (this.dirCam -= 5.0f) : (this.dirCam < -4.9f ? (this.dirCam += 5.0f) : 0.0f);
                this.tCams.setOrientation(this.dirCam, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    private void animateRoo(int n) {
        if (this.animLastTime == 0) {
            this.animLastTime = n;
        }
        this.animTime += n - this.animLastTime;
        if (this.animTime > this.animLength) {
            this.animRoo.setActiveInterval(n, n + 2000);
            this.animRoo.setPosition(0.0f, n);
            this.animTime = 0;
        }
        this.animLastTime = n;
    }

    private void moveRoo(int n) {
        this.hopRoo();
        this.checkWorldEdge();
        this.turnRoo();
        this.animateRoo(n);
        this.tRoo.getTranslation(this.posRooLast);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) throws MIDletStateChangeException {
        this.myRefreshTimer.cancel();
        this.myRefreshTimer = null;
        this.myRefreshTask = null;
    }

    public void paint(Graphics graphics) {
        if (graphics.getClipWidth() != this.viewport_width || graphics.getClipHeight() != this.viewport_height || graphics.getClipX() != this.viewport_x || graphics.getClipY() != this.viewport_y) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.myCanvas.getWidth(), this.myCanvas.getHeight());
        }
        if (this.myGraphics3D != null && this.myWorld != null) {
            this.myGraphics3D.bindTarget((Object)graphics);
            this.myGraphics3D.setViewport(this.viewport_x, this.viewport_y, this.viewport_width, this.viewport_height);
            this.myGraphics3D.render(this.myWorld);
            this.myGraphics3D.releaseTarget();
        }
    }

    public void keyEvent(int n, int n2) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                if (this.keyMoveRoo == 0) {
                    switch (this.myCanvas.getGameAction(n2)) {
                        case 8: {
                            break;
                        }
                        case 1: {
                            this.keyMoveRoo = 1;
                            break;
                        }
                        case 6: {
                            this.keyMoveRoo = 2;
                        }
                    }
                    if (this.keyMoveRoo != 0) {
                        this.hopCount = 10;
                    }
                }
                switch (this.myCanvas.getGameAction(n2)) {
                    case 2: {
                        this.keyTurnRoo = 3;
                        break;
                    }
                    case 5: {
                        this.keyTurnRoo = 4;
                    }
                }
                break;
            }
            case 2: {
                switch (this.myCanvas.getGameAction(n2)) {
                    case 2: 
                    case 5: {
                        this.keyTurnRoo = 0;
                        break;
                    }
                    case 1: 
                    case 6: {
                        this.keyMoveRoo = 0;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            try {
                this.destroyApp(false);
                this.notifyDestroyed();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class PogoRooCanvas
    extends Canvas {
        PogoRooMIDlet myRooMIDlet;

        PogoRooCanvas(PogoRooMIDlet pogoRooMIDlet2) {
            this.myRooMIDlet = pogoRooMIDlet2;
        }

        void init() {
        }

        void destroy() {
        }

        protected void paint(Graphics graphics) {
            this.myRooMIDlet.paint(graphics);
        }

        protected void keyPressed(int n) {
            this.myRooMIDlet.keyEvent(1, n);
        }

        protected void keyReleased(int n) {
            this.myRooMIDlet.keyEvent(2, n);
        }

        protected void keyRepeated(int n) {
            this.myRooMIDlet.keyEvent(0, n);
        }

        protected void pointerDragged(int n, int n2) {
        }

        protected void pointerPressed(int n, int n2) {
        }

        protected void pointerReleased(int n, int n2) {
        }
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        public void run() {
            if (PogoRooMIDlet.this.myCanvas != null && PogoRooMIDlet.this.myGraphics3D != null && PogoRooMIDlet.this.myWorld != null) {
                int n = (int)System.currentTimeMillis();
                PogoRooMIDlet.this.moveRoo(n);
                int n2 = PogoRooMIDlet.this.myWorld.animate(n);
                PogoRooMIDlet.this.myCanvas.repaint(PogoRooMIDlet.this.viewport_x, PogoRooMIDlet.this.viewport_y, PogoRooMIDlet.this.viewport_width, PogoRooMIDlet.this.viewport_height);
            }
        }
    }
}

