/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.PushRegistry;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.midlet.MIDlet;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.TextMessage;

public class PushMidlet
extends MIDlet
implements CommandListener,
MessageListener,
Runnable {
    Display display;
    Form form;
    private String midletName = this.getClass().getName();
    Command cmdExit = new Command("Exit", 7, 1);
    Command cmdAlarm = new Command("Register Alarm", 8, 0);
    Command cmdReg = new Command("Register SMS", 8, 0);
    Command cmdUnreg = new Command("UNRegister SMS", 8, 0);
    Vector allConn = new Vector();
    Thread thread;
    String smsPort;
    boolean firstTime = true;

    public PushMidlet() {
        this.display = Display.getDisplay((MIDlet)this);
        this.smsPort = this.getAppProperty("SMS-Port");
        this.form = new Form("Event Listener");
        this.form.addCommand(this.cmdExit);
        this.form.addCommand(this.cmdAlarm);
        this.form.addCommand(this.cmdReg);
        this.form.addCommand(this.cmdUnreg);
        this.form.setCommandListener((CommandListener)this);
    }

    public void startApp() {
        this.getListConnections();
        this.display.setCurrent((Displayable)this.form);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void getListConnections() {
        String[] stringArray = PushRegistry.listConnections((boolean)true);
        if (stringArray.length != 0) {
            this.form.append("Launched using SMS Event to UN Register select UNRegister SMS");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    MessageConnection messageConnection = (MessageConnection)Connector.open((String)stringArray[i]);
                    messageConnection.setMessageListener((MessageListener)this);
                    this.allConn.addElement(messageConnection);
                    continue;
                }
                catch (SecurityException securityException) {
                    this.form.append("SecurityException=" + securityException);
                    continue;
                }
                catch (IOException iOException) {
                    this.form.append("IOException==" + iOException);
                }
            }
        } else {
            if (this.firstTime) {
                this.form.append("Manually launched");
                this.form.append("Here you can select Register and Un Register SMS also Register Alarm Dynamically");
                this.firstTime = false;
            }
            stringArray = PushRegistry.listConnections((boolean)false);
        }
    }

    private void registerAlarm(final long l) {
        new Thread(){

            public void run() {
                long l2 = System.currentTimeMillis() + l;
                try {
                    PushRegistry.registerAlarm((String)PushMidlet.this.midletName, (long)l2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    PushMidlet.this.form.append("\n ClassNotFoundException");
                }
                catch (ConnectionNotFoundException connectionNotFoundException) {
                    PushMidlet.this.form.append("\n ConnectionNotFoundException");
                }
            }
        }.start();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdExit) {
            this.exitMidlet();
        } else if (command == this.cmdAlarm) {
            this.registerAlarm(4000L);
        } else if (command == this.cmdReg) {
            this.RegisterSMSConn();
        } else if (command == this.cmdUnreg) {
            this.UnRegisterSMSConn();
        }
    }

    public void exitMidlet() {
        this.closeConnections();
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void RegisterSMSConn() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        try {
            PushRegistry.registerConnection((String)("sms://:" + this.smsPort), (String)this.midletName, (String)"*");
            this.closeConnections();
            this.getListConnections();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void UnRegisterSMSConn() {
        PushRegistry.unregisterConnection((String)("sms://:" + this.smsPort));
    }

    public void closeConnections() {
        if (this.allConn != null) {
            while (!this.allConn.isEmpty()) {
                MessageConnection messageConnection = (MessageConnection)this.allConn.firstElement();
                if (messageConnection != null) {
                    try {
                        messageConnection.setMessageListener(null);
                        messageConnection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.allConn.removeElementAt(0);
            }
        }
    }

    public void notifyIncomingMessage(MessageConnection messageConnection) {
        TextMessage textMessage = null;
        try {
            textMessage = (TextMessage)messageConnection.receive();
            String string = textMessage.getAddress();
            this.form.setTitle(string);
            String string2 = textMessage.getPayloadText();
            this.form.append(string2);
        }
        catch (IOException iOException) {
            this.form.append("Exception here" + iOException);
        }
    }
}

