/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RMSForm
extends Form
implements CommandListener {
    private Command addRecordCommand = new Command("Add Record", 8, 1);
    private Command findRecordCommand = new Command("Filter Record", 8, 1);
    private Command sortRecordCommand = new Command("Sort Record", 8, 1);
    private Command selectCommand = new Command("Select", 4, 1);
    private Command backCommand = new Command("Back", 2, 2);
    private Command exitCommand = new Command("Exit", 7, 1);
    private RMSMIDlet midlet;
    private RecordStore recordStore;
    private TextField studentNameTextField;
    private ChoiceGroup studentDepartmentChoiceGroup;
    private ChoiceGroup sortOrderChoiceGroup;
    private final String[] department = new String[]{"Science", "Arts", "Commerce"};
    public static final String[] sortOrder = new String[]{"Ascending", "Descending"};
    private final String recordStoreName;
    private boolean isFilterScreen;

    public RMSForm(RMSMIDlet midlet) {
        super("Traversing, Sorting, Searching");
        this.recordStoreName = "rmsexample";
        this.midlet = midlet;
        this.studentNameTextField = new TextField("Enter Student Name", null, 1024, 0);
        this.studentDepartmentChoiceGroup = new ChoiceGroup("Select Department", 1, this.department, null);
        this.sortOrderChoiceGroup = new ChoiceGroup("Select Order", 1, sortOrder, null);
        this.setCommandListener(this);
        this.showRecordScreen();
    }

    private void openRecordStore() {
        try {
            this.recordStore = RecordStore.openRecordStore((String)"rmsexample", (boolean)true);
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    private void closeRecordStore() {
        try {
            this.recordStore.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    private void removeAllCommands() {
        this.removeCommand(this.exitCommand);
        this.removeCommand(this.addRecordCommand);
        this.removeCommand(this.findRecordCommand);
        this.removeCommand(this.sortRecordCommand);
        this.removeCommand(this.backCommand);
        this.removeCommand(this.selectCommand);
    }

    private void showRecordScreen() {
        this.deleteAll();
        this.removeAllCommands();
        this.studentNameTextField.setString(null);
        this.addCommand(this.exitCommand);
        this.addCommand(this.addRecordCommand);
        this.addCommand(this.findRecordCommand);
        this.addCommand(this.sortRecordCommand);
        this.setTitle("Add Record");
        this.append((Item)this.studentNameTextField);
        this.append((Item)this.studentDepartmentChoiceGroup);
        this.setCommandListener(this);
    }

    private void showSortRecordScreen() {
        this.deleteAll();
        this.removeAllCommands();
        this.setTitle("Select Sort Order");
        this.append((Item)this.sortOrderChoiceGroup);
        this.addCommand(this.backCommand);
        this.addCommand(this.selectCommand);
        this.setCommandListener(this);
        this.isFilterScreen = false;
    }

    private void showFilterRecordScreen() {
        this.deleteAll();
        this.removeAllCommands();
        this.setTitle("Select Filter");
        this.append((Item)this.studentDepartmentChoiceGroup);
        this.addCommand(this.backCommand);
        this.addCommand(this.selectCommand);
        this.setCommandListener(this);
        this.isFilterScreen = true;
    }

    private void doRecordFilter(String filterString) {
        try {
            this.openRecordStore();
            if (this.recordStore.getNumRecords() > 0) {
                RMSFilter filter = new RMSFilter(filterString);
                RecordEnumeration recEnum = this.recordStore.enumerateRecords((RecordFilter)filter, null, true);
                if (recEnum.numRecords() > 0) {
                    this.deleteAll();
                    this.removeAllCommands();
                    while (recEnum.hasNextElement()) {
                        try {
                            byte[] filterRecordData = recEnum.nextRecord();
                            ByteArrayInputStream bis = new ByteArrayInputStream(filterRecordData);
                            DataInputStream dis = new DataInputStream(bis);
                            String studentName = dis.readUTF();
                            String studentDept = dis.readUTF();
                            StringItem stringItem = new StringItem("Student Information", "\nName: " + studentName + "\nDepartment: " + studentDept + "\n");
                            this.append((Item)stringItem);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        catch (InvalidRecordIDException ex) {
                            ex.printStackTrace();
                        }
                        catch (RecordStoreNotOpenException ex) {
                            ex.printStackTrace();
                        }
                        catch (RecordStoreException ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.addCommand(this.backCommand);
                    this.setCommandListener(this);
                } else {
                    Alert alert = new Alert("Error");
                    alert.setString("No Record Exists.\nPlease select another filter");
                    alert.setTimeout(-2);
                    this.midlet.display.setCurrent((Displayable)alert);
                }
            } else {
                Alert alert = new Alert("Error");
                alert.setString("No Record Exists.\nPlease Add record");
                alert.setTimeout(-2);
                this.midlet.display.setCurrent((Displayable)alert);
            }
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
    }

    private void doRecordSorting(String sortingString) {
        try {
            this.openRecordStore();
            if (this.recordStore.getNumRecords() > 0) {
                RMSComparator comparator = new RMSComparator(sortingString);
                RecordEnumeration recEnum = this.recordStore.enumerateRecords(null, (RecordComparator)comparator, true);
                if (recEnum.numRecords() > 0) {
                    this.deleteAll();
                    this.removeAllCommands();
                    while (recEnum.hasNextElement()) {
                        try {
                            byte[] filterRecordData = recEnum.nextRecord();
                            ByteArrayInputStream bis = new ByteArrayInputStream(filterRecordData);
                            DataInputStream dis = new DataInputStream(bis);
                            String studentName = dis.readUTF();
                            String studentDept = dis.readUTF();
                            StringItem stringItem = new StringItem("Student Information", "\nName: " + studentName + "\nDepartment: " + studentDept + "\n");
                            this.append((Item)stringItem);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        catch (InvalidRecordIDException ex) {
                            ex.printStackTrace();
                        }
                        catch (RecordStoreNotOpenException ex) {
                            ex.printStackTrace();
                        }
                        catch (RecordStoreException ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.addCommand(this.backCommand);
                    this.setCommandListener(this);
                } else {
                    Alert alert = new Alert("Error");
                    alert.setString("No Record Exists.\nPlease select another filter");
                    alert.setTimeout(-2);
                    this.midlet.display.setCurrent((Displayable)alert);
                }
            } else {
                Alert alert = new Alert("Error");
                alert.setString("No Record Exists.\nPlease Add record");
                alert.setTimeout(-2);
                this.midlet.display.setCurrent((Displayable)alert);
            }
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
    }

    private void addRecord(String data, int studentDeptIndex) {
        try {
            this.openRecordStore();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(data);
            dos.writeUTF(this.department[studentDeptIndex]);
            byte[] recordData = baos.toByteArray();
            int addedIndex = this.recordStore.addRecord(recordData, 0, recordData.length);
            dos.close();
            baos.close();
            this.closeRecordStore();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exitCommand) {
            this.midlet.destroyApp(true);
        } else if (c == this.addRecordCommand) {
            String data = this.studentNameTextField.getString();
            int choiceIndex = this.studentDepartmentChoiceGroup.getSelectedIndex();
            if (data == null || data.length() < 1) {
                Alert alert = new Alert("Error");
                alert.setString("Please enter data");
                alert.setTimeout(-2);
                this.midlet.display.setCurrent(alert, (Displayable)this);
            } else {
                this.addRecord(data, choiceIndex);
                this.showRecordScreen();
            }
        } else if (c == this.findRecordCommand) {
            this.showFilterRecordScreen();
        } else if (c == this.sortRecordCommand) {
            this.showSortRecordScreen();
        } else if (c == this.selectCommand) {
            if (this.isFilterScreen) {
                int filterIndex = this.studentDepartmentChoiceGroup.getSelectedIndex();
                this.doRecordFilter(this.department[filterIndex]);
            } else {
                int sortIndex = this.sortOrderChoiceGroup.getSelectedIndex();
                this.doRecordSorting(sortOrder[sortIndex]);
            }
        } else if (c == this.backCommand) {
            this.showRecordScreen();
        }
    }
}

