/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.XmlParser;

public class RSSMidlet
extends MIDlet
implements CommandListener,
Runnable {
    private List menuList;
    private Display display;
    private Form menuForm;
    private boolean xmlParsingDone = false;
    private Command selectCommand = new Command("Select", 4, 3);
    private Command backCommand = new Command("Back", 2, 1);
    private Command exitCommand = new Command("Exit", 7, 2);
    private final String[] menus = new String[]{"Device Specs", "Tools & SDKs", "Knowledge Base", "Discussion Boards", "Innov Lab", "FAQs"};
    private final String[] url = new String[]{"http://innovator.samsungmobile.com/servlet/rss/products.xml?platformId=3", "http://innovator.samsungmobile.com/servlet/rss/downloads.xml?platformId=3", "http://innovator.samsungmobile.com/servlet/rss/samsung_s60_symbian_best.xml?platformId=3", "http://innovator.samsungmobile.com/servlet/rss/discussion.xml?platformId=3", "http://innovator.samsungmobile.com/servlet/rss/innov.xml?platformId=2", "http://innovator.samsungmobile.com/servlet/rss/faq.xml?platformId=3"};

    public void startApp() {
        this.display = Display.getDisplay((MIDlet)this);
        this.menuForm = new Form("");
        this.menuForm.addCommand(this.backCommand);
        this.menuForm.setCommandListener((CommandListener)this);
        this.menuList = new List("SMI JAVA RSS MENU", 3, this.menus, null);
        this.menuList.setSelectCommand(this.selectCommand);
        this.menuList.addCommand(this.exitCommand);
        this.menuList.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.menuList);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.notifyDestroyed();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exitCommand) {
            this.destroyApp(true);
        } else if (c == this.selectCommand) {
            new Thread(this).start();
        } else if (c == this.backCommand) {
            this.xmlParsingDone = true;
            this.display.setCurrent((Displayable)this.menuList);
        }
    }

    public void run() {
        System.out.println("RUN");
        this.menuForm.deleteAll();
        this.display.setCurrent((Displayable)this.menuForm);
        int index = this.menuList.getSelectedIndex();
        this.parseXML(this.url[index]);
    }

    private void parseXML(String url) {
        try {
            this.menuForm.append("Parsing XML");
            HttpConnection hc = (HttpConnection)Connector.open((String)url);
            int responseCode = hc.getResponseCode();
            this.menuForm.append("\nResponse code is " + responseCode);
            if (responseCode == 200) {
                InputStream is = hc.openInputStream();
                InputStreamReader reader = new InputStreamReader(is);
                XmlParser parser = new XmlParser(reader);
                this.parse(parser);
                is.close();
            } else {
                StringItem str = new StringItem("\nError: Unable to connect", "\nResponse code is " + responseCode);
                this.menuForm.append((Item)str);
            }
            hc.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.menuForm.append("\nException caught at HttpConnectin " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.menuForm.append("\nException caught at parsing xml " + ex.getMessage());
        }
    }

    public void parse(XmlParser parser) throws Exception {
        this.xmlParsingDone = false;
        boolean error = false;
        String title = "";
        String description = "";
        String errorMessage = "";
        String errorType = "";
        while (!this.xmlParsingDone) {
            ParseEvent event = parser.read();
            switch (event.getType()) {
                case 64: {
                    ParseEvent pe;
                    String tagName = event.getName();
                    if ("title".equals(tagName)) {
                        pe = parser.read();
                        title = pe.getText();
                        this.menuForm.append("\nTitle:\n" + title);
                    }
                    if ("description".equals(tagName)) {
                        pe = parser.read();
                        description = pe.getText();
                        this.menuForm.append("\nDescription:\n" + description);
                    }
                    if ("error".equals(tagName)) {
                        pe = parser.read();
                        errorType = pe.getText();
                        this.menuForm.append("\nError type:\n" + errorType);
                        error = true;
                    }
                    if (!"message".equals(tagName)) break;
                    pe = parser.read();
                    errorMessage = pe.getText();
                    this.menuForm.append("\nError:\n" + errorMessage);
                    this.xmlParsingDone = true;
                    break;
                }
                case 16: {
                    String tagName = event.getName();
                    break;
                }
                case 8: {
                    this.xmlParsingDone = true;
                    break;
                }
                case 128: {
                    break;
                }
                case 256: {
                    break;
                }
            }
        }
    }
}

