/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import org.kxml2.io.KXmlParser;

public class RSSMidlet
extends MIDlet
implements CommandListener,
Runnable {
    private List menuList;
    private Display display;
    private Form menuForm;
    private boolean xmlParsingDone = false;
    private Command selectCommand = new Command("Select", 4, 3);
    private Command backCommand = new Command("Back", 2, 1);
    private Command exitCommand = new Command("Exit", 7, 2);
    private final String[] menus = new String[]{"Device Specs", "Tools & SDKs", "Knowledge Base", "Discussion Boards", "Innov Lab", "FAQs"};
    private final String[] url = new String[]{"http://innovator.samsungmobile.com/servlet/rss/products.xml?platformId=3", "http://innovator.samsungmobile.com/servlet/rss/downloads.xml?platformId=3", "http://innovator.samsungmobile.com/servlet/rss/samsung_s60_symbian_best.xml?platformId=3", "http://innovator.samsungmobile.com/servlet/rss/discussion.xml?platformId=3", "http://innovator.samsungmobile.com/servlet/rss/innov.xml?platformId=2", "http://innovator.samsungmobile.com/servlet/rss/faq.xml?platformId=3"};

    public void startApp() {
        this.display = Display.getDisplay((MIDlet)this);
        this.menuForm = new Form("");
        this.menuForm.addCommand(this.backCommand);
        this.menuForm.setCommandListener((CommandListener)this);
        this.menuList = new List("SMI JAVA RSS MENU", 3, this.menus, null);
        this.menuList.setSelectCommand(this.selectCommand);
        this.menuList.addCommand(this.exitCommand);
        this.menuList.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.menuList);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.notifyDestroyed();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exitCommand) {
            this.destroyApp(true);
        } else if (c == this.selectCommand) {
            new Thread(this).start();
        } else if (c == this.backCommand) {
            this.xmlParsingDone = true;
            this.display.setCurrent((Displayable)this.menuList);
        }
    }

    public void run() {
        System.out.println("RUN");
        this.menuForm.deleteAll();
        this.display.setCurrent((Displayable)this.menuForm);
        int index = this.menuList.getSelectedIndex();
        this.parseXML(this.url[index]);
    }

    private void parseXML(String url) {
        try {
            this.xmlParsingDone = false;
            this.menuForm.append("Parsing XML");
            HttpConnection hc = (HttpConnection)Connector.open((String)url);
            int responseCode = hc.getResponseCode();
            this.menuForm.append("\nResponse code is " + responseCode);
            if (responseCode == 200) {
                KXmlParser parser = new KXmlParser();
                InputStream rssStream = hc.openInputStream();
                InputStreamReader isr = new InputStreamReader(rssStream);
                parser.setInput(isr);
                this.parse(parser);
                isr.close();
                rssStream.close();
            } else {
                StringItem str = new StringItem("\nError: Unable to connect", "\nResponse code is " + responseCode);
                this.menuForm.append((Item)str);
            }
            hc.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.menuForm.append("\nException caught at HttpConnectin " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.menuForm.append("\nException caught at parsing xml " + ex.getMessage());
        }
    }

    public void parse(KXmlParser parser) throws Exception {
        boolean error = false;
        parser.nextTag();
        parser.require(2, null, "rss");
        parser.nextTag();
        parser.require(2, null, "channel");
        parser.nextTag();
        while (!this.xmlParsingDone) {
            int eventType = parser.getEventType();
            if (parser.getEventType() == 3) continue;
            String nodeName = parser.getName();
            if (nodeName.compareTo("item") == 0) {
                parser.nextTag();
                while (parser.getEventType() != 3) {
                    String tagName = parser.getName();
                    if (tagName.compareTo("title") == 0) {
                        String title = parser.nextText();
                        this.menuForm.append("\nTitle:\n" + title);
                    } else if (tagName.compareTo("description") == 0) {
                        String description = parser.nextText();
                        this.menuForm.append("\nDescription:\n" + description);
                    } else if (tagName.compareTo("link") == 0) {
                        String link = parser.nextText();
                    } else if (tagName.compareTo("error") == 0) {
                        String errorType = parser.nextText();
                        this.menuForm.append("\nError type:\n" + errorType);
                        error = true;
                    } else if (tagName.compareTo("message") == 0) {
                        String errorMessage = parser.nextText();
                        this.menuForm.append("\nError:\n" + errorMessage);
                        this.xmlParsingDone = true;
                    } else {
                        parser.skipSubTree();
                    }
                    parser.nextTag();
                }
            } else {
                parser.skipSubTree();
            }
            parser.nextTag();
        }
    }
}

