/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class SplashCanvas
extends Canvas
implements Runnable,
CommandListener {
    private SplashMidlet midlet;
    private int width;
    private int height;
    private boolean remSplash = false;
    private final Command cmdExit = new Command("Exit", 7, 2);
    private Font font = null;

    public SplashCanvas(SplashMidlet midlet) {
        this.midlet = midlet;
        this.font = Font.getFont((int)0, (int)0, (int)0);
        new Thread(this).start();
        this.setCommandListener(this);
    }

    public void paint(Graphics g) {
        this.width = this.getWidth();
        this.height = this.getHeight();
        g.setFont(this.font);
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(0, 0, 255);
        g.drawString("Splash Screen over", this.width / 2, this.height / 2, 65);
        if (!this.remSplash) {
            g.setColor(0, 0, 255);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(255, 255, 255);
            g.drawString("Welcome to ", this.width / 2, this.height / 2, 65);
            g.drawString("Samsung Mobile Innovator", this.width / 2, this.height / 2 + this.font.getHeight(), 65);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SplashCanvas splashCanvas = this;
        synchronized (splashCanvas) {
            try {
                this.wait(4000L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        this.exitSplash();
    }

    public void commandAction(Command cmd, Displayable disp) {
        if (cmd == this.cmdExit) {
            this.midlet.exitMidlet();
        }
    }

    public void exitSplash() {
        this.remSplash = true;
        this.addCommand(this.cmdExit);
        this.repaint();
    }

    public void keyPressed(int keycode) {
        if (!this.remSplash) {
            this.exitSplash();
        }
    }
}

